/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Enumeration;
import java.util.logging.Logger;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHostInfo;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheLogger;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.DefaultCacheLogger;
import oracle.ias.cache.NamedCache;
import oracle.ias.cache.NamedCacheAttributes;

public class Cache {
    static final String LOGGER_NAME = "oracle.ias.cache";
    static Logger s_logger = null;

    public static void open() throws CacheException {
        CacheInternal.open("javacache.properties");
    }

    public static void open(String string) throws CacheException {
        CacheInternal.open(string);
    }

    public static void init(CacheAttributes cacheAttributes) throws CacheException {
        try {
            CacheInternal.init(cacheAttributes);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.init", exception);
        }
    }

    public static void close() {
        CacheInternal.close();
    }

    public static CacheAttributes getAttributes() throws CacheNotAvailableException {
        return CacheInternal.getAttributes();
    }

    public static int getObjectCount() throws CacheNotAvailableException {
        return CacheInternal.getObjectCount();
    }

    public static long getCacheSize() throws CacheNotAvailableException {
        return CacheInternal.getCacheSize();
    }

    public static long getLocalDiskCacheSize() throws CacheNotAvailableException {
        return CacheInternal.getLocalDiskCacheSize();
    }

    public static long getDistributedDiskCacheSize() throws CacheNotAvailableException {
        return CacheInternal.getDistributedDiskCacheSize();
    }

    public static void resetAttributes(CacheAttributes cacheAttributes) throws CacheNotAvailableException {
        CacheInternal.resetAttributes(cacheAttributes);
    }

    public static void invalidate() throws CacheException {
        try {
            CacheInternal.globalInvalidate(true);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.invalidate", exception);
        }
    }

    public static void invalidate(boolean bl) throws CacheException {
        try {
            CacheInternal.globalInvalidate(!bl);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.invalidate", exception);
        }
    }

    public static void destroy() throws CacheException {
        try {
            CacheInternal.globalDestroy(true);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.destroy", exception);
        }
    }

    public static void destroy(boolean bl) throws CacheException {
        try {
            CacheInternal.globalDestroy(!bl);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.destroy", exception);
        }
    }

    public static String getVersion() {
        return CacheInternal.getVersion();
    }

    public static void dump() {
        CacheInternal.dump(null);
    }

    public static boolean isReady() {
        return CacheInternal.isReady();
    }

    public static boolean isDistributed() {
        return CacheInternal.isDistributed();
    }

    public static Enumeration listCacheObjects() {
        return CacheInternal.listCacheObjects();
    }

    public static Enumeration listCacheObjects(String string) {
        return CacheInternal.listCacheObjects(string);
    }

    public static void setLogSeverity(int n) {
        s_logger.setLevel(CacheLogger.getMappedLogLevel(n));
    }

    public static int getCacheId() {
        return CacheInternal.cacheId;
    }

    public static void updateStats() {
        CacheInternal.updateStats();
    }

    public static String getCacheAddress() {
        return CacheInternal.cacheAddress;
    }

    public static CacheAddress getCacheAddressObject() throws CacheException {
        try {
            return CacheInternal.getLocalAddressObject(null);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.getCacheAddressObject", exception);
        }
    }

    public static CacheHostInfo[] getActiveHostInfo() throws CacheException {
        return CacheInternal.getActiveHostInfo(null);
    }

    public static NamedCache[] getNamedCaches() throws CacheException {
        return CacheInternal.getNamedCaches();
    }

    public static NamedCache getNamedCache(String string) throws CacheException {
        return CacheInternal.getNamedCache(string);
    }

    public static boolean createNamedCache(String string, NamedCacheAttributes namedCacheAttributes, Attributes attributes, boolean bl) throws CacheException {
        return CacheInternal.createNamedCache(string, namedCacheAttributes, attributes, bl);
    }

    public static String getDiskCacheRootPath() throws CacheException {
        return CacheInternal.getDiskCacheRootPath();
    }

    public static String getDiskCacheRootPath(String string) throws CacheException {
        return CacheInternal.getDiskCacheRootPath(string);
    }

    public static CacheLogger getCacheLogger() {
        DefaultCacheLogger defaultCacheLogger = null;
        try {
            defaultCacheLogger = new DefaultCacheLogger(4);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        return defaultCacheLogger;
    }

    private static CacheException exceptionHandler(String string, Exception exception) {
        return CacheInternal.exceptionHandler(CacheInternal.EXP_EXCEPTIONIN + " " + string, exception);
    }

    public static int getGroupLeaderID() throws CacheException {
        return CacheInternal.getGroupLeaderID();
    }

    static {
        s_logger = Logger.getLogger(LOGGER_NAME);
    }
}

