/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Hashtable;
import oracle.ias.cache.CacheEventListener;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheLoader;
import oracle.ias.cache.CapacityPolicy;
import oracle.ias.cache.InvalidArgumentException;

public class Attributes {
    public static final long DISTRIBUTE = 1L;
    public static final long REPLY = 2L;
    public static final long SYNCHRONIZE = 4L;
    public static final long SPOOL = 8L;
    public static final long GROUP_TTL_DESTROY = 16L;
    public static final long ORIGINAL = 32L;
    public static final long SYNCHRONIZE_DEFAULT = 64L;
    public static final long ALLOWNULL = 512L;
    public static final long MEASURE = 1024L;
    public static final long TIMEINV_LOCALONLY = 2048L;
    static final long SESSION = 128L;
    static final long DISABLED = 256L;
    static final long VALID = 4095L;
    static final long ESTOBJSIZE = 256L;
    long flags = 0L;
    long ttl = -1L;
    long defaultTtl = -1L;
    long idleTime = -1L;
    long version = 0L;
    long createTime;
    long size = 256L;
    int priority = Integer.MAX_VALUE;
    int maxCount = 0;
    long maxSize = 0L;
    int maxDiskCount = 0;
    long maxDiskSize = 0L;
    String group = null;
    Hashtable userAttrs;
    boolean attrSet = false;
    boolean flagsSet = false;
    boolean versionSet = false;
    boolean prioritySet = false;
    boolean policySet = false;
    boolean sizeSet = false;
    CacheLoader loader;
    CapacityPolicy policy = null;
    CacheEventListener[] handlers;
    boolean[] handlerSet;
    boolean[] handlerDefault;
    ClassLoader userClassLoader = null;

    public void setFlags(long l) {
        this.flags = l;
        this.flagsSet = true;
        this.attrSet = true;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlagsToDefault() {
        this.flags = 0L;
        this.flagsSet = true;
        this.attrSet = true;
    }

    public void setVersion(long l) {
        this.version = l;
        this.attrSet = true;
        this.versionSet = true;
    }

    public void setTimeToLive(long l) throws InvalidArgumentException {
        if (l < 0L) {
            throw new InvalidArgumentException();
        }
        this.ttl = l;
        this.attrSet = true;
    }

    public void setDefaultTimeToLive(long l) throws InvalidArgumentException {
        if (l < 0L) {
            throw new InvalidArgumentException();
        }
        this.defaultTtl = l;
        this.attrSet = true;
    }

    public long getDefaultTimeToLive() {
        return this.defaultTtl;
    }

    public void setIdleTime(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException();
        }
        this.idleTime = n;
    }

    public void setPriority(int n) {
        this.priority = n;
        this.prioritySet = true;
        this.attrSet = true;
    }

    public void setMaxCount(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException();
        }
        this.maxCount = n;
        this.attrSet = true;
    }

    public void setMaxSize(long l) throws InvalidArgumentException {
        if (l < 0L) {
            throw new InvalidArgumentException();
        }
        this.maxSize = l;
        this.attrSet = true;
    }

    public void setMaxDiskCount(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException();
        }
        this.maxDiskCount = n;
        this.attrSet = true;
    }

    public void setMaxDiskSize(long l) throws InvalidArgumentException {
        if (l < 0L) {
            throw new InvalidArgumentException();
        }
        this.maxDiskSize = l;
        this.attrSet = true;
    }

    public void setCacheEventListener(int n, CacheEventListener cacheEventListener) throws InvalidArgumentException {
        this.setCacheEventListener(n, cacheEventListener, false);
    }

    public void setCacheEventListener(int n, CacheEventListener cacheEventListener, boolean bl) throws InvalidArgumentException {
        if (n >= 6 || n < 0) {
            throw new InvalidArgumentException(CacheInternal.EXP_NOTIMPEVENT);
        }
        if (this.handlers == null) {
            this.handlers = new CacheEventListener[6];
            this.handlerSet = new boolean[6];
            this.handlerDefault = new boolean[6];
        }
        this.handlers[n] = cacheEventListener;
        this.handlerSet[n] = true;
        this.handlerDefault[n] = bl;
        this.attrSet = true;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.userClassLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.userClassLoader;
    }

    public CacheEventListener getEventListener(int n) {
        CacheEventListener cacheEventListener = null;
        if (this.handlerSet != null && this.handlerSet[n]) {
            cacheEventListener = this.handlers[n];
        }
        return cacheEventListener;
    }

    public void setLoader(CacheLoader cacheLoader) {
        this.loader = cacheLoader;
    }

    public void setCapacityPolicy(CapacityPolicy capacityPolicy) {
        this.policy = capacityPolicy;
        this.policySet = true;
        this.attrSet = true;
    }

    public void setSize(long l) {
        this.size = l;
        this.sizeSet = true;
        this.attrSet = true;
    }

    public void setUserAttribute(Object object, Object object2) throws InvalidArgumentException {
        if (object == null) {
            throw new InvalidArgumentException();
        }
        if (this.userAttrs == null) {
            this.userAttrs = new Hashtable();
        }
        this.userAttrs.put(object, object2);
        this.attrSet = true;
    }

    public CacheLoader getLoader() {
        return this.loader;
    }

    public CapacityPolicy getCapacityPolicy() {
        return this.policy;
    }

    public boolean isSet(long l) {
        boolean bl = false;
        if ((this.flags & l) == l) {
            bl = true;
        }
        return bl;
    }

    public long getVersion() {
        return this.version;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getTimeToLive() {
        return this.ttl;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public long getPriority() {
        return this.priority;
    }

    public long getMaxCount() {
        return this.maxCount;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getMaxDiskCount() {
        return this.maxDiskCount;
    }

    public long getMaxDiskSize() {
        return this.maxDiskSize;
    }

    public long getObjectSize() {
        return this.size;
    }

    public Object getUserAttribute(Object object) {
        if (this.userAttrs == null) {
            return null;
        }
        return this.userAttrs.get(object);
    }

    public Object clone() {
        Attributes attributes = new Attributes();
        attributes.flags = this.flags;
        attributes.version = this.version;
        attributes.ttl = this.ttl;
        attributes.defaultTtl = this.defaultTtl;
        attributes.idleTime = this.idleTime;
        attributes.createTime = this.createTime;
        attributes.attrSet = this.attrSet;
        attributes.flagsSet = this.flagsSet;
        attributes.versionSet = this.versionSet;
        attributes.prioritySet = this.prioritySet;
        attributes.loader = this.loader;
        attributes.policy = this.policy;
        attributes.size = this.size;
        attributes.maxCount = this.maxCount;
        attributes.maxSize = this.maxSize;
        attributes.maxDiskCount = this.maxDiskCount;
        attributes.maxDiskSize = this.maxDiskSize;
        attributes.priority = this.priority;
        attributes.userClassLoader = this.userClassLoader;
        if (this.userAttrs != null) {
            attributes.userAttrs = (Hashtable)this.userAttrs.clone();
        }
        if (this.group != null) {
            attributes.group = new String(this.group);
        }
        if (this.handlers != null) {
            attributes.handlers = new CacheEventListener[6];
            attributes.handlerSet = new boolean[6];
            attributes.handlerDefault = new boolean[6];
            for (int i = 0; i < 6; ++i) {
                attributes.handlers[i] = this.handlers[i];
                attributes.handlerSet[i] = this.handlerSet[i];
                attributes.handlerDefault[i] = this.handlerDefault[i];
            }
        }
        return attributes;
    }

    public static long timeToSeconds(int n, int n2, int n3, int n4) throws InvalidArgumentException {
        long l = 0L;
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new InvalidArgumentException(CacheInternal.EXP_NEGATIVE);
        }
        l = n * 24;
        l = ((long)n2 + l) * 60L;
        l = ((long)n3 + l) * 60L;
        return l += (long)n4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("version=");
        stringBuffer.append(this.version);
        if (this.flags != 0L) {
            stringBuffer.append(", flags=");
            stringBuffer.append(this.flagsToString(this.flags));
        }
        stringBuffer.append(", ttl=");
        stringBuffer.append(this.ttl);
        stringBuffer.append(", idleTime=");
        stringBuffer.append(this.idleTime);
        stringBuffer.append(", defaultTtl=");
        stringBuffer.append(this.defaultTtl);
        stringBuffer.append(", size=");
        stringBuffer.append(this.size);
        stringBuffer.append(", priority=");
        stringBuffer.append(this.priority);
        stringBuffer.append(", maxCount=");
        stringBuffer.append(this.maxCount);
        stringBuffer.append(", maxSize=");
        stringBuffer.append(this.maxSize);
        stringBuffer.append(", size=");
        stringBuffer.append(this.size);
        stringBuffer.append(", ClassLoader=");
        stringBuffer.append(this.userClassLoader);
        if (this.policy != null) {
            stringBuffer.append(", policy=");
            stringBuffer.append(this.policy.toString());
        }
        if (this.userAttrs != null) {
            stringBuffer.append(", userAttributes=");
            stringBuffer.append(this.userAttrs.toString());
        }
        if (this.loader != null) {
            stringBuffer.append(", loader=");
            stringBuffer.append(this.loader.getClass().getName());
            stringBuffer.append(" at 0x");
            stringBuffer.append(Integer.toHexString(this.loader.hashCode()).toUpperCase());
        }
        if (this.handlers != null) {
            stringBuffer.append(", event listener=");
            for (int i = 0; i < this.handlers.length; ++i) {
                if (this.handlers[i] == null) continue;
                stringBuffer.append(this.handlers[i].getClass().getName());
                stringBuffer.append(" at 0x");
                stringBuffer.append(Integer.toHexString(this.handlers[i].hashCode()).toUpperCase());
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    void reset(Attributes attributes) {
        if (!attributes.attrSet) {
            return;
        }
        if (attributes.versionSet) {
            this.version = attributes.version;
        }
        if (attributes.ttl >= 0L) {
            this.ttl = attributes.ttl;
        }
        if (attributes.defaultTtl >= 0L) {
            this.defaultTtl = attributes.defaultTtl;
        }
        if (attributes.idleTime >= 0L) {
            this.idleTime = attributes.idleTime;
        }
        if (attributes.prioritySet) {
            this.priority = attributes.priority;
        }
        if (attributes.policySet) {
            this.policy = attributes.policy;
        }
        if (attributes.userAttrs != null) {
            if (this.userAttrs == null) {
                this.userAttrs = new Hashtable();
            }
            this.userAttrs.putAll(attributes.userAttrs);
        }
        if (attributes.handlers != null) {
            if (this.handlers == null) {
                this.handlers = new CacheEventListener[6];
                this.handlerSet = new boolean[6];
                this.handlerDefault = new boolean[6];
            }
            for (int i = 0; i < 6; ++i) {
                if (!attributes.handlerSet[i]) continue;
                this.handlerSet[i] = true;
                this.handlerDefault[i] = attributes.handlerDefault[i];
                this.handlers[i] = attributes.handlers[i];
            }
        }
        if (this.loader != null) {
            this.loader = null;
        }
        if (this.userClassLoader != null) {
            this.userClassLoader = null;
        }
    }

    private String flagsToString(long l) {
        long l2 = l;
        StringBuffer stringBuffer = new StringBuffer(Long.toBinaryString(l) + " ");
        String[] stringArray = new String[]{"DISTRIBUTE", "REPLY", "SYNCHRONIZE", "SPOOL", "GROUP_TTL_DESTROY", "ORIGINAL", "SYNCHRONIZE_DEFAULT", "SESSION", "DISABLED", "ALLOWNULL", "MEASURE", "TIMEINV_LOCALONLY"};
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if ((l2 & 1L) == 1L) {
                if (!bl) {
                    stringBuffer.append("|");
                } else {
                    bl = false;
                }
                stringBuffer.append(stringArray[i]);
            }
            l2 >>= 1;
        }
        return stringBuffer.toString();
    }
}

