/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import oracle.help.common.Topic;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.help.topicDisplay.print.TopicPrintJob;

public class SimpleTopicDisplayPanel
extends JPanel
implements TopicDisplay {
    private JMenuBar _menuBar;
    private JToolBar _toolBar;
    private TopicDisplay _topicDisplay;
    private JPanel _topicContainer;

    public SimpleTopicDisplayPanel(TopicDisplay topicDisplay, JMenuBar jMenuBar, JToolBar jToolBar) {
        this._menuBar = jMenuBar;
        this._topicDisplay = topicDisplay;
        this._toolBar = jToolBar;
        if (this._topicDisplay == null) {
            throw new IllegalArgumentException("SimpleTopicDisplayPanel:  passed NULL TopicDisplay to constructor");
        }
        this._topicContainer = this._topicDisplay.getDisplayContainer();
        if (this._topicContainer == null) {
            throw new IllegalArgumentException("SimpleTopicDisplayPanel:  This TopicDisplay cannot be contained in a SimpleTopicDisplayPanel");
        }
        Color color = UIManager.getColor("darkLook");
        if (color != null) {
            this.setBackground(color);
        }
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout(1, 5));
        if (this._menuBar != null || this._toolBar != null) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            if (this._menuBar != null) {
                jPanel.add((Component)this._menuBar, "North");
            }
            if (this._toolBar != null) {
                this._toolBar.setFloatable(false);
                jPanel.add((Component)this._toolBar, "Center");
            }
            this.add((Component)jPanel, "North");
        }
        this.add((Component)this._topicContainer, "Center");
    }

    public void displayTopic(Topic topic) throws TopicDisplayException {
        this._topicDisplay.displayTopic(topic);
    }

    public TopicPrintJob getTopicPrintJob() {
        return this._topicDisplay.getTopicPrintJob();
    }

    public JPanel getDisplayContainer() {
        return this;
    }

    public URL getCurrentURL() {
        return this._topicDisplay.getCurrentURL();
    }

    public void dispose() {
        this._topicDisplay.dispose();
        this._menuBar = null;
        this._toolBar = null;
        this._topicDisplay = null;
        this._topicContainer = null;
        this.removeAll();
    }

    public void clear() {
        this._topicDisplay.clear();
    }

    public void addDisplayListener(TopicDisplayListener topicDisplayListener) {
        this._topicDisplay.addDisplayListener(topicDisplayListener);
    }

    public void removeDisplayListener(TopicDisplayListener topicDisplayListener) {
        this._topicDisplay.removeDisplayListener(topicDisplayListener);
    }

    public void runFindDialog() {
        this._topicDisplay.runFindDialog();
    }

    public boolean canGoBack() {
        return this._topicDisplay.canGoBack();
    }

    public void goBack() {
        this._topicDisplay.goBack();
    }

    public boolean canGoForward() {
        return this._topicDisplay.canGoForward();
    }

    public void goForward() {
        this._topicDisplay.goForward();
    }

    public String getSelectedText() {
        return this._topicDisplay.getSelectedText();
    }

    public void increaseFontSize() {
        this._topicDisplay.increaseFontSize();
    }

    public void decreaseFontSize() {
        this._topicDisplay.decreaseFontSize();
    }

    public void selectAll() {
        this._topicDisplay.selectAll();
    }

    public String getCurrentPageTitle() {
        return this._topicDisplay.getCurrentPageTitle();
    }
}

