/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.keywordNavigator;

import java.util.ArrayList;
import java.util.List;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.navigator.keywordNavigator.KeywordIndexItem;
import oracle.help.common.navigator.keywordNavigator.TopicBaseBean;

public class KeywordUtils {
    public static List getEntriesFromKeywordListItem(KeywordIndexItem keywordIndexItem) {
        ArrayList arrayList = new ArrayList();
        if (keywordIndexItem != null) {
            int n = 0;
            while (n < keywordIndexItem.getNodeCount()) {
                TopicTreeNode topicTreeNode = keywordIndexItem.getNodeByIndex(n);
                KeywordUtils._addNodeEntries(topicTreeNode, arrayList);
                ++n;
            }
        }
        return arrayList;
    }

    private static final void _addNodeEntries(TopicTreeNode topicTreeNode, List list) {
        if (topicTreeNode != null) {
            int n;
            Object object;
            ArrayList arrayList;
            KeywordUtils._addToList(topicTreeNode, list);
            if (topicTreeNode instanceof KeywordTopicTreeNode && (arrayList = ((KeywordTopicTreeNode)(object = (KeywordTopicTreeNode)topicTreeNode)).getEntries()) != null) {
                n = 0;
                while (n < arrayList.size()) {
                    KeywordUtils._addToList((TopicTreeNode)arrayList.get(n), list);
                    ++n;
                }
            }
            if ((object = topicTreeNode.getChildren()) != null) {
                n = 0;
                while (n < ((ArrayList)object).size()) {
                    KeywordUtils._addNodeEntries((TopicTreeNode)((ArrayList)object).get(n), list);
                    ++n;
                }
            }
        }
    }

    private static final void _addToList(TopicTreeNode topicTreeNode, List list) {
        if (topicTreeNode.getTopic().getTarget() != null) {
            list.add(new TopicBean(topicTreeNode));
        }
    }

    public static class TopicBean
    implements TopicBaseBean {
        private final Topic _topic;
        private final String _source;
        private final TopicTreeNode _node;

        public TopicBean(TopicTreeNode topicTreeNode) {
            this._node = topicTreeNode;
            this._topic = topicTreeNode.getTopic();
            this._source = topicTreeNode.getView().getBook().getBookTitle();
        }

        public String getText() {
            return this._topic.getLabel();
        }

        public String getSortingText() {
            return this._topic.getLabel();
        }

        public Topic getTopic() {
            return this._topic;
        }

        public String getSource() {
            return this._source;
        }

        public TopicTreeNode getTopicTreeNode() {
            return this._node;
        }
    }
}

