/*
 * Decompiled with CFR 0.152.
 */
package tdg.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.Socket;
import java.util.StringTokenizer;
import tdg.CategoryIF;
import tdg.Perspective;
import tdg.event.TDGErrorManager;
import tdg.net.FTPFileInputStream;
import tdg.net.FTPProtocolException;
import tdg.net.ProtocolAuthorizationException;
import tdg.net.TextProtocolConnection;

public class FTPConnection
extends TextProtocolConnection {
    static final CategoryIF LOG = Perspective.getInstance("UTIL.FTPConnection");
    protected static final int FTPDATAPORT = 20;
    protected static final int FTPPORT = 21;
    protected String dirPath = null;
    protected String userName = "";
    protected String password = "";
    protected String ServerResponse;
    protected TDGErrorManager m_ErrorManager = null;

    public FTPConnection(TDGErrorManager errMgr) {
        this.m_ErrorManager = errMgr;
        this.initialize();
    }

    public FTPConnection(TDGErrorManager errMgr, String serverHost) {
        this.m_ErrorManager = errMgr;
        this.initialize();
        this.setServerHost(serverHost);
    }

    public FTPConnection(TDGErrorManager errMgr, String serverHost, String dirPath) {
        this.m_ErrorManager = errMgr;
        this.initialize();
        this.setServerHost(serverHost);
        this.dirPath = dirPath;
    }

    public synchronized void setUserName(String UserName) {
        this.state = 1;
        this.userName = UserName;
    }

    public String getUserName() {
        return this.userName;
    }

    public synchronized void setPassword(String Password) {
        this.state = 1;
        this.password = Password;
    }

    public String getPassword() {
        return this.password;
    }

    private void initialize() {
        this.serverPort = 21;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String dir) {
        this.dirPath = dir;
    }

    protected Socket connectToSocketByResponse(String ServerResponse) throws IOException, FTPProtocolException {
        String IPAddress = "";
        int PortNumber = 0;
        int PortStringStart = ServerResponse.indexOf("(");
        int PortStringEnd = ServerResponse.lastIndexOf(")");
        if (PortStringEnd <= PortStringStart || PortStringStart <= -1) {
            throw new FTPProtocolException();
        }
        String PortString = ServerResponse.substring(PortStringStart + 1, PortStringEnd);
        StringTokenizer Tokenizer = new StringTokenizer(PortString, ",");
        int i = 1;
        while (i <= 4) {
            if (!Tokenizer.hasMoreTokens()) {
                throw new FTPProtocolException();
            }
            IPAddress = IPAddress + Tokenizer.nextToken();
            IPAddress = IPAddress + (i == 4 ? "" : ".");
            ++i;
        }
        if (!Tokenizer.hasMoreTokens()) {
            throw new FTPProtocolException();
        }
        PortNumber = Integer.parseInt(Tokenizer.nextToken()) << 8;
        if (!Tokenizer.hasMoreTokens()) {
            throw new FTPProtocolException();
        }
        return new Socket(IPAddress, PortNumber += Integer.parseInt(Tokenizer.nextToken()));
    }

    public synchronized String readMultiLineResponse(String Command) {
        try {
            this.PSSocketOutput.write(Command + "\r\n");
            this.PSSocketOutput.flush();
        }
        catch (IOException e) {
            LOG.info("IOException on PSSocketOutput");
            return "";
        }
        return this.readMultiLineResponse();
    }

    public synchronized String readMultiLineResponse() {
        String completeResponse;
        boolean i = false;
        try {
            String currentLine;
            if (!this.BRSocketInput.ready()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.BRSocketInput.ready()) {
                    return "";
                }
            }
            completeResponse = this.getServerMessage() != null && this.getServerMessage().length() > 0 ? (currentLine = this.getServerMessage()) : (currentLine = this.BRSocketInput.readLine());
            if (currentLine.charAt(3) == '-') {
                String endCode = currentLine.substring(0, 3) + " ";
                while ((currentLine = this.BRSocketInput.readLine()) != null) {
                    completeResponse = completeResponse + System.getProperty("line.separator") + currentLine;
                    if (currentLine.length() <= 3 || !currentLine.substring(0, 4).equals(endCode)) continue;
                }
            }
            this.setServerMessage(completeResponse);
        }
        catch (IOException e) {
            this.dispatchServerNetworkError();
            return "";
        }
        return completeResponse;
    }

    public synchronized void getFile(String fileName, OutputStream OS, boolean binary) throws FTPProtocolException, ProtocolAuthorizationException {
        block14: {
            int bytesRead = 0;
            int totalBytes = 0;
            if (this.state == 1) {
                try {
                    this.connect();
                    this.readMultiLineResponse();
                    this.authorize(this.getUserName(), this.getPassword());
                }
                catch (StreamCorruptedException SCE) {
                    throw new FTPProtocolException();
                }
                catch (IOException IOE) {
                    this.dispatchServerNetworkError();
                    throw new FTPProtocolException();
                }
            }
            if (this.state != 1) {
                try {
                    this.setServerMessage(null);
                    String ServerResponse = this.readMultiLineResponse("PASV");
                    if (!this.ResponseCode(ServerResponse).equals("227")) break block14;
                    Socket s = this.connectToSocketByResponse(ServerResponse);
                    String path = this.getDirPath();
                    if (!path.equals("") && path != null) {
                        this.setServerMessage(null);
                        ServerResponse = this.readMultiLineResponse("CWD " + path);
                        if (!this.ResponseCode(ServerResponse).equals("250")) {
                            throw new FTPProtocolException();
                        }
                    }
                    this.setServerMessage(null);
                    ServerResponse = this.readMultiLineResponse("TYPE " + (binary ? "I" : "A"));
                    if (!this.ResponseCode(ServerResponse).equals("200")) {
                        throw new FTPProtocolException();
                    }
                    this.setServerMessage(null);
                    ServerResponse = this.readMultiLineResponse("RETR " + fileName);
                    if (!this.ResponseCode(ServerResponse).equals("150")) {
                        throw new FTPProtocolException();
                    }
                    BufferedInputStream ISDataConnectionInputStream = new BufferedInputStream(s.getInputStream());
                    do {
                        byte[] buffer;
                        if ((bytesRead = ((InputStream)ISDataConnectionInputStream).read(buffer = new byte[((InputStream)ISDataConnectionInputStream).available()])) == -1) continue;
                        OS.write(buffer);
                        totalBytes += bytesRead;
                    } while (bytesRead != -1);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ire) {
                        // empty catch block
                    }
                    OS.close();
                    s.close();
                    this.setServerMessage(null);
                    ServerResponse = this.readMultiLineResponse();
                }
                catch (IOException e) {
                    this.dispatchServerNetworkError();
                    throw new FTPProtocolException();
                }
            }
        }
    }

    public void inputDone() {
        String string = this.readMultiLineResponse();
    }

    public synchronized InputStream getFTPInputStream(String fileName, boolean binary) throws FTPProtocolException, ProtocolAuthorizationException {
        boolean bytesRead = false;
        boolean totalBytes = false;
        FTPFileInputStream ISDataConnectionInputStream = null;
        if (this.state == 1) {
            try {
                this.connect();
                this.readMultiLineResponse();
                this.authorize(this.getUserName(), this.getPassword());
            }
            catch (StreamCorruptedException SCE) {
                throw new FTPProtocolException();
            }
            catch (IOException IOE) {
                this.dispatchServerNetworkError();
                throw new FTPProtocolException();
            }
        }
        if (this.state != 1) {
            try {
                this.setServerMessage(null);
                String ServerResponse = this.readMultiLineResponse("PASV");
                if (this.ResponseCode(ServerResponse).equals("227")) {
                    Socket s = this.connectToSocketByResponse(ServerResponse);
                    String path = this.getDirPath();
                    if (!path.equals("") && path != null) {
                        this.setServerMessage(null);
                        ServerResponse = this.readMultiLineResponse("CWD " + path);
                        if (!this.ResponseCode(ServerResponse).equals("250")) {
                            throw new FTPProtocolException();
                        }
                    }
                    this.setServerMessage(null);
                    ServerResponse = this.readMultiLineResponse("TYPE " + (binary ? "I" : "A"));
                    if (!this.ResponseCode(ServerResponse).equals("200")) {
                        throw new FTPProtocolException();
                    }
                    this.setServerMessage(null);
                    ServerResponse = this.readMultiLineResponse("RETR " + fileName);
                    if (!this.ResponseCode(ServerResponse).equals("150")) {
                        throw new FTPProtocolException();
                    }
                    ISDataConnectionInputStream = new FTPFileInputStream(s.getInputStream(), this);
                }
            }
            catch (IOException e) {
                this.dispatchServerNetworkError();
                throw new FTPProtocolException();
            }
        }
        return ISDataConnectionInputStream;
    }

    public synchronized void putFile(String fileName, InputStream IS, boolean binary) throws FTPProtocolException, ProtocolAuthorizationException {
        String ServerResponse = null;
        String path = this.getDirPath();
        int bytesWritten = 0;
        try {
            if (this.state == 1) {
                this.connect();
                this.readMultiLineResponse();
                this.authorize(this.getUserName(), this.getPassword());
            }
        }
        catch (StreamCorruptedException SCE) {
            throw new FTPProtocolException(this.getServerMessage());
        }
        catch (IOException IOE) {
            this.dispatchServerNetworkError();
            throw new FTPProtocolException(this.getServerMessage());
        }
        if (this.state != 1) {
            try {
                BufferedOutputStream OSDataConnectionOutputStream;
                Socket s;
                if (path != null && !path.equals("")) {
                    this.setServerMessage(null);
                    ServerResponse = this.readMultiLineResponse("CWD " + path);
                    if (!this.ResponseCode(ServerResponse).equals("250")) {
                        this.m_ErrorManager.notifyErrorListener(this, 3970, ServerResponse, null);
                        throw new FTPProtocolException(ServerResponse);
                    }
                }
                this.setServerMessage(null);
                ServerResponse = this.readMultiLineResponse("TYPE " + (binary ? "I" : "A"));
                if (!this.ResponseCode(ServerResponse).equals("200")) {
                    this.m_ErrorManager.notifyErrorListener(this, 3970, ServerResponse, null);
                    throw new FTPProtocolException(ServerResponse);
                }
                this.setServerMessage(null);
                ServerResponse = this.readMultiLineResponse("PASV");
                if (this.ResponseCode(ServerResponse).equals("227")) {
                    s = this.connectToSocketByResponse(ServerResponse);
                    this.setServerMessage(null);
                    ServerResponse = this.readMultiLineResponse("STOR " + fileName);
                    if (this.ResponseCode(ServerResponse).equals("550")) {
                        this.m_ErrorManager.notifyErrorListener(this, 3970, "Access Denied for this directory.", null);
                        throw new FTPProtocolException(ServerResponse);
                    }
                    OSDataConnectionOutputStream = new BufferedOutputStream(s.getOutputStream());
                    try {
                        int bytesRead;
                        do {
                            byte[] buffer;
                            if ((bytesRead = IS.read(buffer = new byte[IS.available()])) == -1) continue;
                            OSDataConnectionOutputStream.write(buffer);
                            bytesWritten += bytesRead;
                        } while (bytesRead != -1);
                    }
                    catch (IOException ioe) {
                        this.dispatchServerNetworkError();
                        throw new FTPProtocolException(ioe.toString());
                    }
                    catch (Exception e) {
                        this.dispatchServerNetworkError();
                        throw new FTPProtocolException(e.toString());
                    }
                } else {
                    this.m_ErrorManager.notifyErrorListener(this, 3970, "Server doesn't understand passive mode FTP.", null);
                    throw new FTPProtocolException(ServerResponse);
                }
                OSDataConnectionOutputStream.flush();
                s.close();
                OSDataConnectionOutputStream.close();
                this.setServerMessage(null);
                ServerResponse = this.readMultiLineResponse();
                this.m_ErrorManager.notifyErrorListener(this, 3970, "Transfer Complete! Bytes written: " + bytesWritten, null);
            }
            catch (IOException e) {
                this.dispatchServerNetworkError();
                if (ServerResponse == null) {
                    throw new FTPProtocolException("FTP Protocol Exception while sending file " + fileName);
                }
                throw new FTPProtocolException(ServerResponse);
            }
        }
    }

    public synchronized void putFile(String fileName, byte[] b, boolean binary) throws FTPProtocolException, ProtocolAuthorizationException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        this.putFile(fileName, bais, binary);
    }

    protected String ResponseCode(String s) {
        if (s.length() > 2) {
            return s.substring(0, 3);
        }
        return "";
    }

    protected synchronized void connect() throws IOException {
        super.connect();
    }

    protected synchronized void authorize(String userName, String password) throws ProtocolAuthorizationException {
        this.setServerMessage(null);
        String CurrentLine = this.readMultiLineResponse("USER " + userName);
        if (this.ResponseCode(CurrentLine).equals("331")) {
            this.setServerMessage(null);
            CurrentLine = this.readMultiLineResponse("PASS " + password);
            if (!this.ResponseCode(CurrentLine).equals("230")) {
                this.dispatchServerProtocolError();
                throw new ProtocolAuthorizationException(CurrentLine);
            }
        } else {
            this.dispatchServerProtocolError();
            throw new ProtocolAuthorizationException(CurrentLine);
        }
        this.dispatchloggedIn();
    }
}

