/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import tdg.AssertionException;
import tdg.DataFormat;
import tdg.JChart_2D_BLA;
import tdg.JChart_2D_Circular;
import tdg.JChart_2D_Hilo;
import tdg.JChart_2D_Hist;
import tdg.JChart_2D_Pareto;
import tdg.JChart_2D_Pie;
import tdg.JChart_2D_PieBar;
import tdg.JChart_2D_Polar;
import tdg.JChart_2D_Radar;
import tdg.JChart_2D_Scat;
import tdg.JChart_2D_Spec;
import tdg.JChart_2D_Standard;
import tdg.JChart_3D;
import tdg.JChart_3D_Surf;
import tdg.JChart_Base;
import tdg.JGraphType;
import tdg.Perspective;
import tdg.Point2d;
import tdg.SmartText;
import tdg.TDGMouseState;
import tdg.TDGNumberFormat;
import tdg.draw.DetObj;
import tdg.draw.ObjectString;
import tdg.utilities.TDGTimer;

public class ToolTips
extends Panel {
    static final int DATA_VALUE_ABS = 3;
    static final int DATA_VALUE_FORMATTED = 4;
    static final int DATA_VALUE_OPEN = 5;
    static final int DATA_VALUE_HI = 6;
    static final int DATA_VALUE_LOW = 7;
    static final int DATA_VALUE_CLOSE = 8;
    static final int DATA_VALUE_VOLUME = 9;
    static final int DATA_VALUE_X = 10;
    static final int DATA_VALUE_Y = 11;
    static final int DATA_VALUE_Z = 12;
    static final String RETURN_MACRO = "[R]";
    static final String OBJECT_NAME_MACRO = "[ON]";
    static final String OBJECT_DESCRIPTION_MACRO = "[OD]";
    static final String OBJECT_ID_MACRO = "[OID]";
    static final String OBJECT_INSTANCE_MACRO = "[OIN]";
    static final String SERIES_LABEL_MACRO = "[SL]";
    static final String GROUP_LABEL_MACRO = "[GL]";
    static final String CUMULATIVE_STACKED_VALUE_MACRO = "[CUMSTKV]";
    static final String CUMULATIVE_PERCENTAGE_VALUE_MACRO = "[CUMPCTV]";
    static final String PIE_PERCENTAGE_VALUE_MACRO = "[PIEPCTV]";
    static final String HILO_HIGH_VALUE_MACRO = "[HV]";
    static final String HILO_LOW_VALUE_MACRO = "[LV]";
    static final String HILO_OPEN_VALUE_MACRO = "[OV]";
    static final String HILO_CLOSE_VALUE_MACRO = "[CV]";
    static final String HILO_VOLUME_VALUE_MACRO = "[VV]";
    static final String X_VALUE_MACRO = "[XV]";
    static final String Y_VALUE_MACRO = "[YV]";
    static final String Z_VALUE_MACRO = "[ZV]";
    static final String PARETO_VALUE_MACRO = "[PV]";
    static final int MIN_TOOLTIPWIDTH = 40;
    static final int MIN_TOOLTIPHEIGHT = 12;
    static final int DROPSHADOW_SIZE = 4;
    static final int WIDTH_FUDGE_FACTOR = 6;
    static final int MAXIMUM_TIP_LINES = 20;
    protected String[] m_TipStrings = new String[20];
    protected boolean m_bSeriesRelatedObject = false;
    protected boolean m_bDataRelatedObject = false;
    protected boolean m_bDrawCustomToolTip = false;
    protected boolean m_bReferenceLineRelatedObject = false;
    protected Rectangle m_RectTipShape = new Rectangle();
    protected Perspective m_Perspective;
    protected DetObj m_detObj = null;
    protected MouseEvent m_mouseEvt = null;
    protected TDGMouseState m_mouseState = null;
    protected Font m_ToolTipFont;
    protected int m_nToolTipX;
    protected int m_nToolTipY;
    protected int m_nNumToolTipLines;
    protected JChart_Base m_Chart;
    protected String m_strCustomToolTipUser = "";
    protected String m_strCustomToolTipDeveloper = "";
    protected String m_strDynamicToolTip = null;
    TDGTimer timeOutTimer;

    public ToolTips(Perspective a_context) {
        this.m_Perspective = a_context;
        this.m_ToolTipFont = new Font("SansSerif", 0, 10);
    }

    public void releaseReferences() {
        if (this.timeOutTimer != null) {
            this.timeOutTimer.stop();
            this.timeOutTimer.finalize();
            this.timeOutTimer = null;
        }
        this.m_Perspective = null;
        this.m_Chart = null;
    }

    public void setUserToolTipDefault() {
        this.m_strCustomToolTipUser = "";
    }

    public void setUserToolTip(String CustomToolTip) {
        this.m_strCustomToolTipUser = CustomToolTip;
    }

    public void setDeveloperToolTipDefault() {
        this.m_strCustomToolTipDeveloper = "";
    }

    public void setDeveloperToolTip(String CustomToolTip) {
        this.m_strCustomToolTipDeveloper = CustomToolTip;
    }

    public void setDynamicToolTip(String aToolTip) {
        this.m_strDynamicToolTip = aToolTip;
    }

    public void setDetObject(DetObj theDetObj) {
        this.m_detObj = theDetObj;
    }

    public void setToolTip(TDGMouseState mouseState, DetObj theDetObj) {
        this.m_mouseState = mouseState;
        this.m_nToolTipX = mouseState.getMouseX();
        this.m_nToolTipY = mouseState.getMouseY();
        this.m_mouseEvt = mouseState.getMouseEvent();
        this.m_detObj = theDetObj;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void clearToolTip() {
        int i = 0;
        while (i < 20) {
            this.m_TipStrings[i] = "";
            ++i;
        }
    }

    public void drawAlignedString(Graphics gos, FontMetrics fm, String strInput, int x, int y, int nAlign) {
        int nDrawX = x;
        int nDrawY = y;
        if (nAlign != 0) {
            int nStrWidth = fm.stringWidth(strInput);
            if (nAlign == 1) {
                nDrawX += (this.m_RectTipShape.width - nStrWidth) / 2;
            } else if (nAlign == 2) {
                nDrawX = nDrawX + this.m_RectTipShape.width - nStrWidth;
            }
        }
        if (nAlign == 0) {
            ++nDrawX;
        }
        if (nAlign == 2) {
            --nDrawX;
        }
        SmartText smartText = this.m_Perspective.getSmartText();
        strInput = smartText.getDisplayString(this.m_Perspective, strInput);
        gos.drawString(strInput, nDrawX, nDrawY);
    }

    /*
     * Unable to fully structure code
     */
    public int drawDescription(Graphics gos, FontMetrics fm, String strDescription, int xStart, int yStart) {
        block8: {
            nFromIndex = 0;
            pos = 0;
            text = strDescription;
            baseline = fm.getMaxAscent();
            nMaxXWidth = this.m_RectTipShape.width;
            nMaxYHeight = this.m_bDrawCustomToolTip != false ? yStart + this.m_RectTipShape.height : (this.m_Perspective.getToolTipMode() == true ? yStart + this.m_RectTipShape.height - fm.getHeight() : yStart + this.m_RectTipShape.height);
            nUpperLeftX = xStart;
            nUpperLeftY = yStart;
            break block8;
            while (++nFromIndex < text.length()) lbl-1000:
            // 2 sources

            {
                ** while (nFromIndex >= text.length() || text.charAt((int)nFromIndex) != ' ')
lbl12:
                // 1 sources

            }
lbl13:
            // 2 sources

            pos = nFromIndex;
            bestpos = -1;
            strLargest = null;
            while (pos >= nFromIndex) {
                strSub = (pos = text.indexOf(32, pos)) == -1 ? text.substring(nFromIndex) : text.substring(nFromIndex, pos);
                if (fm.stringWidth(strSub) < nMaxXWidth) {
                    strLargest = strSub;
                    bestpos = pos;
                    if (pos == -1) {
                        break;
                    }
                } else {
                    totalWidth = 0;
                    oneCharWidth = 0;
                    pos = nFromIndex;
                    while (pos < text.length()) {
                        oneCharWidth = fm.charWidth(text.charAt(pos));
                        if (totalWidth + oneCharWidth >= nMaxXWidth) break;
                        totalWidth += oneCharWidth;
                        ++pos;
                    }
                    this.drawAlignedString(gos, fm, text.substring(nFromIndex, pos), nUpperLeftX, nUpperLeftY, 0);
                    nFromIndex = pos;
                    strLargest = null;
                    break;
                }
                ++pos;
            }
            if (strLargest != null) {
                this.drawAlignedString(gos, fm, strLargest, nUpperLeftX, nUpperLeftY, 0);
                nFromIndex = bestpos;
            }
            nUpperLeftY += fm.getHeight();
        }
        if (nUpperLeftY + fm.getHeight() <= nMaxYHeight && nFromIndex != -1) ** GOTO lbl-1000
        return nUpperLeftY;
    }

    public void drawToolTip(Graphics g, FontMetrics fm, int nCornerX, int nCornerY) {
        block12: {
            block13: {
                block11: {
                    g.setColor(Color.black);
                    if (this.m_Perspective.getToolTipTimeOutEnabled()) {
                        this.timeOutTimer = new TDGTimer(5000, true);
                        this.timeOutTimer.start();
                        SymAction lSymAction = new SymAction();
                        this.timeOutTimer.addActionListener(lSymAction);
                    } else if (this.timeOutTimer != null) {
                        this.timeOutTimer.stop();
                    }
                    if (!this.m_bDrawCustomToolTip) break block11;
                    int nNextLine = nCornerY + fm.getHeight() - 2;
                    int i = 0;
                    while (i < this.m_nNumToolTipLines) {
                        if (this.m_TipStrings[i].length() > 0) {
                            nNextLine = this.drawDescription(g, fm, this.m_TipStrings[i], nCornerX + 2, nNextLine);
                        }
                        ++i;
                    }
                    break block12;
                }
                if (this.m_bSeriesRelatedObject && this.m_bDataRelatedObject) break block13;
                this.drawAlignedString(g, fm, this.m_TipStrings[0], nCornerX + 2, nCornerY + fm.getHeight() - 2, 0);
                if (this.m_TipStrings[1].length() <= 0) break block12;
                this.drawDescription(g, fm, this.m_TipStrings[1], nCornerX + 2, nCornerY + fm.getHeight() * 2 - 2);
                break block12;
            }
            if (this.m_Perspective.getToolTipMode()) {
                this.drawAlignedString(g, fm, this.m_TipStrings[0], nCornerX + 2, nCornerY + fm.getHeight() - 2, 0);
                int nNextLine = this.drawDescription(g, fm, this.m_TipStrings[1], nCornerX + 2, nCornerY + fm.getHeight() * 2 - 2);
                int n = 0;
                int i = 0;
                while (i < this.m_nNumToolTipLines) {
                    if (this.m_TipStrings[i + 2].length() > 0) {
                        this.drawAlignedString(g, fm, this.m_TipStrings[i + 2], nCornerX + 2, nNextLine + fm.getHeight() * n - 2, 1);
                        ++n;
                    }
                    ++i;
                }
            } else {
                int n = 0;
                int i = 0;
                while (i < this.m_nNumToolTipLines) {
                    if (this.m_TipStrings[i].length() > 0) {
                        this.drawAlignedString(g, fm, this.m_TipStrings[i], nCornerX + 2, nCornerY + fm.getHeight() * (n + 1) - 2, 1);
                        ++n;
                    }
                    ++i;
                }
            }
        }
    }

    public void paint(Graphics g2) {
        boolean bToolTip;
        g2.setFont(this.m_ToolTipFont);
        FontMetrics fm = g2.getFontMetrics(this.m_ToolTipFont);
        if (this.m_detObj != null && (bToolTip = this.prepareToolTip(fm))) {
            int nOutsideTopY;
            Image img = this.m_Perspective.createOffscreenImage(this.m_RectTipShape.width + 6, this.m_RectTipShape.height);
            Graphics g = img.getGraphics();
            g.setFont(this.m_ToolTipFont);
            this.m_RectTipShape.x = this.m_nToolTipX;
            this.m_RectTipShape.y = this.m_nToolTipY - this.m_RectTipShape.height;
            Rectangle rectFitWithin = this.m_Perspective.getBounds();
            int nOutsideRightX = this.m_RectTipShape.x + this.m_RectTipShape.width - rectFitWithin.width;
            if (nOutsideRightX > 0) {
                this.m_RectTipShape.x -= nOutsideRightX;
            }
            if ((nOutsideTopY = this.m_RectTipShape.y) < 0) {
                this.m_RectTipShape.y -= nOutsideTopY;
            }
            this.m_RectTipShape.width += 6;
            g.setColor(Color.black);
            g.fillRect(0, 0, this.m_RectTipShape.width, this.m_RectTipShape.height);
            this.m_RectTipShape.x -= 4;
            this.m_RectTipShape.y -= 4;
            g.setColor(Color.yellow);
            g.fillRect(0, 0, this.m_RectTipShape.width, this.m_RectTipShape.height);
            g.setColor(Color.black);
            g.drawRect(0, 0, this.m_RectTipShape.width - 1, this.m_RectTipShape.height - 1);
            this.drawToolTip(g, fm, 0, 0);
            g2.drawImage(img, this.m_RectTipShape.x, this.m_RectTipShape.y, this.m_Perspective);
            img = null;
        }
    }

    public boolean prepareToolTip(FontMetrics fm) {
        boolean bToolTip;
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        this.m_bReferenceLineRelatedObject = false;
        this.clearToolTip();
        this.m_bDataRelatedObject = this.isDataRelatedObj();
        if (!this.m_Perspective.getToolTipMode() && !this.m_bDataRelatedObject) {
            bToolTip = false;
        } else {
            bToolTip = true;
            this.m_Chart = this.m_Perspective.getGraphObject();
            JGraphType aGraphType = this.m_Perspective.getJGraphType();
            DataFormat aDataFormat = aGraphType.getDataFormat();
            int nObjID = this.m_detObj.getIdentIDRef().stripExceptional().getObjectID();
            String strObjName = ObjectString.objectName(nObjID);
            String strObjDesc = ObjectString.objectDescriptionIntl(this.m_Perspective, nObjID);
            if (this.m_Perspective.getToolTipMode()) {
                this.m_TipStrings[0] = strObjName;
                this.m_TipStrings[1] = strObjDesc;
                this.m_RectTipShape.width = fm.stringWidth(strObjName) > this.m_RectTipShape.width ? fm.stringWidth(strObjName) + 6 : this.m_RectTipShape.width;
                this.m_RectTipShape.height = fm.getHeight() + (fm.stringWidth(strObjDesc) / this.m_RectTipShape.width + 1) * fm.getHeight();
            } else {
                this.m_TipStrings[0] = strObjDesc;
                this.m_RectTipShape.width = fm.stringWidth(strObjDesc) > this.m_RectTipShape.width ? fm.stringWidth(strObjDesc) + 6 : this.m_RectTipShape.width;
                this.m_RectTipShape.height = fm.getHeight() + (fm.stringWidth(strObjDesc) / this.m_RectTipShape.width + 1) * fm.getHeight();
            }
            this.m_nNumToolTipLines = 0;
            this.m_bSeriesRelatedObject = this.isSeriesRelatedObj();
            bToolTip = this.processCustomToolTips(aDataFormat, fm);
            if (!this.m_bDrawCustomToolTip) {
                if (this.m_bDataRelatedObject && this.m_bReferenceLineRelatedObject) {
                    if (this.m_Perspective.getToolTipMode()) {
                        this.processDeveloperReferenceObjToolTip(aDataFormat, fm);
                    } else {
                        this.processUserReferenceObjToolTip(aDataFormat, fm);
                    }
                }
                if (this.m_bSeriesRelatedObject && this.m_bDataRelatedObject) {
                    if (this.m_Perspective.getToolTipMode()) {
                        this.processDeveloperSeriesObjToolTip(aDataFormat, fm);
                    } else {
                        this.processUserSeriesObjToolTip(aDataFormat, fm);
                    }
                }
            }
            this.m_RectTipShape.width = this.m_RectTipShape.width > 40 ? this.m_RectTipShape.width : 40;
            this.m_RectTipShape.height = this.m_RectTipShape.height > 12 ? this.m_RectTipShape.height : 12;
        }
        return bToolTip;
    }

    private boolean isSeriesRelatedObj() {
        boolean bSeriesRelated = this.m_detObj.getIdentIDRef().stripExceptional().isSeriesRelated();
        int nObjID = this.m_detObj.getObjectID();
        switch (nObjID) {
            case 14: 
            case 270: 
            case 310: {
                bSeriesRelated = true;
            }
        }
        return bSeriesRelated;
    }

    private boolean isDataRelatedObj() {
        boolean bDataRelated = this.m_detObj.getSeriesID() >= 0 || this.m_detObj.getGroupID() >= 0;
        int nObjID = this.m_detObj.getObjectID();
        switch (nObjID) {
            case 248: 
            case 249: 
            case 358: {
                this.m_bDataRelatedObject = true;
                this.m_bReferenceLineRelatedObject = true;
            }
        }
        return bDataRelated;
    }

    void justifyLabelsAndValues(FontMetrics fm) {
        int i = 2;
        while (i < this.m_nNumToolTipLines) {
            if (this.m_TipStrings[i].length() > 0) {
                int nFirstSpace = this.m_TipStrings[i].indexOf(" ");
                String strLeftHalf = this.m_TipStrings[i].substring(0, nFirstSpace);
                String strRightHalf = this.m_TipStrings[i].substring(nFirstSpace, this.m_TipStrings[i].length());
                nFirstSpace = 1;
                String strTest = strLeftHalf + " " + strRightHalf;
                while (fm.stringWidth(strTest) < this.m_RectTipShape.width - 6) {
                    strTest = strLeftHalf;
                    int j = 0;
                    while (j < nFirstSpace) {
                        strTest = strTest + " ";
                        ++j;
                    }
                    strTest = strTest + strRightHalf;
                    ++nFirstSpace;
                }
                this.m_TipStrings[i] = strTest;
            }
            ++i;
        }
    }

    void processDeveloperReferenceObjToolTip(DataFormat aDataFormat, FontMetrics fm) {
    }

    void processUserReferenceObjToolTip(DataFormat aDataFormat, FontMetrics fm) {
        if (this.m_detObj.getObjectID() == 249) {
            this.FmtUserReferenceLineID(fm);
        }
        if (this.m_detObj.getObjectID() == 358) {
            this.UserFmtReferenceLineGENERAL(fm);
        }
    }

    void processUserSeriesObjToolTip(DataFormat aDataFormat, FontMetrics fm) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        this.FmtUserSeriesAndGroupID(fm);
        if (aDataFormat == DataFormat.DF_GENERAL) {
            this.UserFmtGENERAL(fm);
        } else if (aDataFormat == DataFormat.DF_XY) {
            this.UserFmtXY(fm);
        } else if (aDataFormat == DataFormat.DF_XY_LBL) {
            this.UserFmtXY_LBL(fm);
        } else if (aDataFormat == DataFormat.DF_XYZ) {
            this.UserFmtXYZ(fm);
        } else if (aDataFormat != DataFormat.DF_XYZ_LBL) {
            if (aDataFormat == DataFormat.DF_GANTT) {
                this.UserFmtGANTT(fm);
            } else if (aDataFormat == DataFormat.DF_HL) {
                this.UserFmtHL(fm);
            } else if (aDataFormat == DataFormat.DF_HLC) {
                this.UserFmtHLC(fm);
            } else if (aDataFormat == DataFormat.DF_OHLC) {
                this.UserFmtOHLC(fm);
            } else if (aDataFormat == DataFormat.DF_HL_VOL) {
                this.UserFmtHL_VOL(fm);
            } else if (aDataFormat == DataFormat.DF_HLC_VOL) {
                this.UserFmtHLC_VOL(fm);
            } else if (aDataFormat == DataFormat.DF_OHLC_VOL) {
                this.UserFmtOHLC_VOL(fm);
            }
        }
        this.UserSetToolTipHeight(fm);
        this.justifyLabelsAndValues(fm);
    }

    void processDeveloperSeriesObjToolTip(DataFormat aDataFormat, FontMetrics fm) {
        if (this.m_Perspective.getJGraphType().isParetoType() && this.ParetoRelated()) {
            this.FmtDevelopersPareto(fm);
        } else {
            this.FmtDeveloperSeriesAndGroupID(fm);
        }
        if (aDataFormat == DataFormat.DF_GENERAL) {
            this.DeveloperFmtGENERAL(fm);
        } else if (aDataFormat == DataFormat.DF_XY) {
            this.DeveloperFmtXY(fm);
        } else if (aDataFormat == DataFormat.DF_XY_LBL) {
            this.DeveloperFmtXY_LBL(fm);
        } else if (aDataFormat == DataFormat.DF_XYZ) {
            this.DeveloperFmtXYZ(fm);
        } else if (aDataFormat != DataFormat.DF_XYZ_LBL && aDataFormat != DataFormat.DF_GANTT) {
            if (aDataFormat == DataFormat.DF_HL) {
                this.DeveloperFmtHL(fm);
            } else if (aDataFormat == DataFormat.DF_HLC) {
                this.DeveloperFmtHLC(fm);
            } else if (aDataFormat == DataFormat.DF_OHLC) {
                this.DeveloperFmtOHLC(fm);
            } else if (aDataFormat == DataFormat.DF_HL_VOL) {
                this.DeveloperFmtHL_VOL(fm);
            } else if (aDataFormat == DataFormat.DF_HLC_VOL) {
                this.DeveloperFmtHLC_VOL(fm);
            } else if (aDataFormat == DataFormat.DF_OHLC_VOL) {
                this.DeveloperFmtOHLC_VOL(fm);
            }
        }
        this.DeveloperSetToolTipHeight(fm, this.m_TipStrings[1], this.m_RectTipShape.width, this.m_nNumToolTipLines);
    }

    boolean processCustomToolTips(DataFormat aDataFormat, FontMetrics fm) {
        boolean bToolTip = true;
        String strCustomToolTip = "";
        if (this.m_Perspective.isToolTipCallBack()) {
            this.m_bDrawCustomToolTip = true;
            if (this.m_strDynamicToolTip != null) {
                strCustomToolTip = this.m_strDynamicToolTip;
                this.m_strDynamicToolTip = null;
            } else {
                strCustomToolTip = this.m_Perspective.getDynamicToolTip(this.m_mouseState);
            }
        } else if (!this.m_Perspective.getToolTipMode()) {
            if (this.m_strCustomToolTipUser.length() > 0) {
                this.m_bDrawCustomToolTip = true;
                strCustomToolTip = this.m_strCustomToolTipUser;
            } else {
                this.m_bDrawCustomToolTip = false;
            }
        } else if (this.m_strCustomToolTipDeveloper.length() > 0) {
            this.m_bDrawCustomToolTip = true;
            strCustomToolTip = this.m_strCustomToolTipDeveloper;
        } else {
            this.m_bDrawCustomToolTip = false;
        }
        if (this.m_bDrawCustomToolTip) {
            if (strCustomToolTip == null || strCustomToolTip.length() < 1) {
                bToolTip = false;
            } else {
                this.m_TipStrings[1] = "";
                this.m_nNumToolTipLines = this.CustomToolTipIntoLines(strCustomToolTip);
                this.CustomToolTipMacros(aDataFormat);
                this.m_RectTipShape.width = this.CustomSetToolTipWidth(fm);
                this.m_RectTipShape.height = this.CustomSetToolTipHeight(fm, this.m_RectTipShape.width);
            }
        }
        return bToolTip;
    }

    int CustomToolTipIntoLines(String strCustomToolTip) {
        int currentLine;
        block3: {
            currentLine = 0;
            String remainingString = strCustomToolTip;
            String currentString = strCustomToolTip;
            if (remainingString.indexOf(RETURN_MACRO) != -1) {
                while (true) {
                    int nPosition;
                    if ((nPosition = remainingString.indexOf(RETURN_MACRO)) == -1) {
                        this.m_TipStrings[currentLine] = remainingString;
                        ++currentLine;
                        break block3;
                    }
                    currentString = remainingString.substring(0, nPosition);
                    remainingString = remainingString.substring(nPosition + RETURN_MACRO.length(), remainingString.length());
                    this.m_TipStrings[currentLine] = currentString;
                    ++currentLine;
                }
            }
            this.m_TipStrings[currentLine] = currentString;
            ++currentLine;
        }
        return currentLine;
    }

    void CustomToolTipMacros(DataFormat aDataFormat) {
        if (this.m_detObj != null) {
            int nLine = 0;
            while (nLine < 20) {
                if (this.m_TipStrings[nLine].length() > 0) {
                    boolean bSeriesGroupValid;
                    this.CustomLabelMacros(nLine);
                    int nSeries = this.m_detObj.getSeriesID();
                    int nGroup = this.m_detObj.getGroupID();
                    boolean bl = bSeriesGroupValid = nSeries > -1 && nGroup > -1;
                    if (this.m_Chart instanceof JChart_2D_PieBar && nSeries > -1) {
                        bSeriesGroupValid = true;
                    }
                    if (this.m_Chart instanceof JChart_2D_Pareto && nGroup > -1) {
                        nSeries = this.m_Perspective.getDisplayParetoSeries();
                        bSeriesGroupValid = true;
                    }
                    if (bSeriesGroupValid) {
                        this.CustomValueMacros(aDataFormat, nLine, nSeries, nGroup);
                    }
                }
                ++nLine;
            }
        }
    }

    void CustomLabelMacros(int nLine) {
        this.m_TipStrings[nLine] = this.CustomReplaceMacro(this.m_TipStrings[nLine], OBJECT_NAME_MACRO, ObjectString.objectName(this.m_detObj.getIdentIDRef().stripExceptional().getObjectID()));
        this.m_TipStrings[nLine] = this.CustomReplaceMacro(this.m_TipStrings[nLine], OBJECT_DESCRIPTION_MACRO, ObjectString.objectDescription(this.m_detObj.getIdentIDRef().stripExceptional().getObjectID()));
        this.m_TipStrings[nLine] = this.CustomReplaceMacro(this.m_TipStrings[nLine], OBJECT_ID_MACRO, new Integer(this.m_detObj.getObjectID()).toString());
        this.m_TipStrings[nLine] = this.CustomReplaceMacro(this.m_TipStrings[nLine], OBJECT_INSTANCE_MACRO, new Integer(this.m_detObj.getIdentID().getMiscID()).toString());
        if (this.m_detObj.getSeriesID() > -1) {
            this.m_TipStrings[nLine] = this.CustomReplaceMacro(this.m_TipStrings[nLine], SERIES_LABEL_MACRO, this.m_Perspective.getSeriesLabel(this.m_detObj.getSeriesID()));
        }
        if (this.m_detObj.getGroupID() > -1) {
            this.m_TipStrings[nLine] = this.CustomReplaceMacro(this.m_TipStrings[nLine], GROUP_LABEL_MACRO, this.m_Perspective.getGroupLabel(this.m_detObj.getGroupID()));
        }
    }

    void CustomValueMacros(DataFormat aDataFormat, int nLine, int nSeries, int nGroup) {
        Point2d pt2D;
        double fZValue;
        double fYValue;
        double fXValue;
        if (this.m_Chart instanceof JChart_2D_Scat) {
            try {
                fXValue = ((JChart_2D_Scat)this.m_Chart).getXValue(nSeries, nGroup);
            }
            catch (AssertionException e) {
                fXValue = 0.0;
            }
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fXValue, this.m_TipStrings[nLine], X_VALUE_MACRO);
            try {
                fYValue = ((JChart_2D_Scat)this.m_Chart).getYValue(nSeries, nGroup);
            }
            catch (AssertionException e) {
                fYValue = 0.0;
            }
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fYValue, this.m_TipStrings[nLine], Y_VALUE_MACRO);
            try {
                fZValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(nSeries, nGroup);
            }
            catch (AssertionException e) {
                fZValue = 0.0;
            }
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fZValue, this.m_TipStrings[nLine], Z_VALUE_MACRO);
        }
        if (this.m_Chart instanceof JChart_2D_Polar) {
            try {
                fXValue = ((JChart_2D_Polar)this.m_Chart).getXValue(nSeries, nGroup);
            }
            catch (AssertionException e) {
                fXValue = 0.0;
            }
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fXValue, this.m_TipStrings[nLine], X_VALUE_MACRO);
            try {
                fYValue = ((JChart_2D_Polar)this.m_Chart).getYValue(nSeries, nGroup);
            }
            catch (AssertionException e) {
                fYValue = 0.0;
            }
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fYValue, this.m_TipStrings[nLine], Y_VALUE_MACRO);
            try {
                fZValue = ((JChart_2D_Polar)this.m_Chart).getXYZ_ZValue(nSeries, nGroup);
            }
            catch (AssertionException e) {
                fZValue = 0.0;
            }
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fZValue, this.m_TipStrings[nLine], Z_VALUE_MACRO);
        }
        if (this.m_Chart instanceof JChart_2D_Pareto) {
            try {
                fYValue = this.ParetoRelated() ? ((JChart_2D_Standard)this.m_Chart).getParetoValue(nSeries, nGroup) : this.m_Perspective.getDataAsDouble(nSeries, nGroup);
            }
            catch (AssertionException e) {
                fYValue = 0.0;
            }
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fYValue, this.m_TipStrings[nLine], Y_VALUE_MACRO);
        }
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            if (nGroup <= 0) {
                double fSeriesTotal = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(nSeries);
                this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fSeriesTotal, this.m_TipStrings[nLine], Y_VALUE_MACRO);
            }
        } else if (this.m_Chart instanceof JChart_2D_BLA || this.m_Chart instanceof JChart_2D_Circular || this.m_Chart instanceof JChart_2D_Hist || this.m_Chart instanceof JChart_2D_Pie || this.m_Chart instanceof JChart_2D_Radar || this.m_Chart instanceof JChart_2D_Spec || this.m_Chart instanceof JChart_3D || this.m_Chart instanceof JChart_3D_Surf || this.m_Chart instanceof JChart_2D_Pareto) {
            try {
                pt2D = this.m_Chart.getDataValuesXY(nSeries, nGroup);
            }
            catch (AssertionException e) {
                pt2D = new Point2d();
            }
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(pt2D.x, this.m_TipStrings[nLine], X_VALUE_MACRO);
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(pt2D.y, this.m_TipStrings[nLine], Y_VALUE_MACRO);
        }
        if (this.m_Chart instanceof JChart_2D_BLA) {
            double fTmpCumulValue = ((JChart_2D_Standard)this.m_Chart).getStackedCumulativeValue(nSeries, nGroup);
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fTmpCumulValue, this.m_TipStrings[nLine], CUMULATIVE_STACKED_VALUE_MACRO);
            double fPercentValue = ((JChart_2D_Standard)this.m_Chart).getPercentCumulativeValue(nSeries, nGroup);
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fPercentValue *= 100.0, this.m_TipStrings[nLine], CUMULATIVE_PERCENTAGE_VALUE_MACRO);
        }
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            double fSumTotal;
            if (nGroup >= 0) {
                double fGroupTotal = ((JChart_2D_Pie)this.m_Chart).getGroupTotal(nGroup);
                fSumTotal = ((JChart_2D_Pie)this.m_Chart).getSumTotal();
                double fPercentage = fGroupTotal / fSumTotal * 100.0;
                this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fPercentage, this.m_TipStrings[nLine], PIE_PERCENTAGE_VALUE_MACRO);
            } else {
                double fSeriesTotal = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(nSeries);
                fSumTotal = ((JChart_2D_PieBar)this.m_Chart).getSumTotal();
                double fPercentage = fSeriesTotal / fSumTotal * 100.0;
                this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fPercentage, this.m_TipStrings[nLine], PIE_PERCENTAGE_VALUE_MACRO);
            }
        } else if (this.m_Chart instanceof JChart_2D_Pie) {
            try {
                pt2D = this.m_Chart.getDataValuesXY(nSeries, nGroup);
            }
            catch (AssertionException e) {
                pt2D = new Point2d();
            }
            double fGroupTotal = ((JChart_2D_Pie)this.m_Chart).getGroupTotal(nGroup);
            double fPercentage = pt2D.y / fGroupTotal * 100.0;
            this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fPercentage, this.m_TipStrings[nLine], PIE_PERCENTAGE_VALUE_MACRO);
        }
        if (this.m_Chart instanceof JChart_2D_Hilo) {
            double fDataValue;
            if (((JChart_2D_Hilo)this.m_Chart).hasHighValue(aDataFormat) && this.m_detObj.getObjectID() != 310) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(nSeries, nGroup);
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                }
                this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings[nLine], HILO_HIGH_VALUE_MACRO);
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasLowValue(aDataFormat) && this.m_detObj.getObjectID() != 310) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(nSeries, nGroup);
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                }
                this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings[nLine], HILO_LOW_VALUE_MACRO);
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasOpenValue(aDataFormat) && this.m_detObj.getObjectID() != 310) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(nSeries, nGroup);
                    this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings[nLine], HILO_OPEN_VALUE_MACRO);
                }
                catch (AssertionException e) {
                    this.m_TipStrings[nLine] = !this.m_Perspective.getJGraphType().isStockCandleType() ? this.CustomReplaceValueMacro("", this.m_TipStrings[nLine], HILO_OPEN_VALUE_MACRO) : this.CustomReplaceValueMacro(0.0, this.m_TipStrings[nLine], HILO_OPEN_VALUE_MACRO);
                }
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasCloseValue(aDataFormat) && this.m_detObj.getObjectID() != 310) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(nSeries, nGroup);
                    this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings[nLine], HILO_CLOSE_VALUE_MACRO);
                }
                catch (AssertionException e) {
                    this.m_TipStrings[nLine] = !this.m_Perspective.getJGraphType().isStockCandleType() ? this.CustomReplaceValueMacro("", this.m_TipStrings[nLine], HILO_CLOSE_VALUE_MACRO) : this.CustomReplaceValueMacro(0.0, this.m_TipStrings[nLine], HILO_CLOSE_VALUE_MACRO);
                }
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasVolumeValue(aDataFormat)) {
                try {
                    nSeries = 0;
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, nGroup);
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                }
                this.m_TipStrings[nLine] = this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings[nLine], HILO_VOLUME_VALUE_MACRO);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    String CustomReplaceMacro(String strSource, String strMacro, String strReplacement) {
        int nPosition;
        String strProcessed = "";
        strProcessed = strSource;
        while ((nPosition = strProcessed.indexOf(strMacro)) != -1) {
            void var6_6;
            String strTmp = strProcessed.substring(0, (int)var6_6);
            strTmp = strTmp + strReplacement;
            nPosition = var6_6 + strMacro.length();
            strProcessed = strTmp = strTmp + strProcessed.substring(nPosition, strProcessed.length());
        }
        return strProcessed;
    }

    /*
     * WARNING - void declaration
     */
    String CustomReplaceValueMacro(double fDataValue, String strSource, String strMacro) {
        int nPosition;
        String strProcessed = "";
        strProcessed = strSource;
        while ((nPosition = strProcessed.indexOf(strMacro)) != -1) {
            void var7_6;
            String strFormattedValue = this.FmtValue(fDataValue);
            String strTmp = strProcessed.substring(0, (int)var7_6);
            strTmp = strTmp + strFormattedValue;
            nPosition = var7_6 + strMacro.length();
            strProcessed = strTmp = strTmp + strProcessed.substring(nPosition, strProcessed.length());
        }
        return strProcessed;
    }

    /*
     * WARNING - void declaration
     */
    String CustomReplaceValueMacro(String value, String strSource, String strMacro) {
        int nPosition;
        String strProcessed = "";
        strProcessed = strSource;
        while ((nPosition = strProcessed.indexOf(strMacro)) != -1) {
            void var6_6;
            String strFormattedValue = value;
            String strTmp = strProcessed.substring(0, (int)var6_6);
            strTmp = strTmp + strFormattedValue;
            nPosition = var6_6 + strMacro.length();
            strProcessed = strTmp = strTmp + strProcessed.substring(nPosition, strProcessed.length());
        }
        return strProcessed;
    }

    int CustomSetToolTipWidth(FontMetrics fm) {
        int resultWidth = 0;
        int i = 0;
        while (i < 20) {
            if (fm.stringWidth(this.m_TipStrings[i]) > resultWidth) {
                resultWidth = fm.stringWidth(this.m_TipStrings[i]);
            }
            ++i;
        }
        return resultWidth;
    }

    int CustomSetToolTipHeight(FontMetrics fm, int TipWidth) {
        int resultHeight = 0;
        int i = 0;
        while (i < 20) {
            if (this.m_TipStrings[i].length() > 0) {
                if (fm.stringWidth(this.m_TipStrings[i]) < TipWidth) {
                    resultHeight += fm.getHeight();
                } else {
                    double fFlooredQuotient;
                    double fQuotient = (double)fm.stringWidth(this.m_TipStrings[i]) / (double)TipWidth;
                    if (fQuotient - (fFlooredQuotient = Math.floor(fQuotient)) > 0.1) {
                        fFlooredQuotient += 1.0;
                    }
                    resultHeight = (int)((double)resultHeight + fFlooredQuotient * (double)fm.getHeight());
                }
            }
            ++i;
        }
        return resultHeight += 2;
    }

    String FmtValue(double fValue) {
        String strFormattedValue = "";
        if (this.m_Perspective.isNumberFormatCallBack()) {
            this.m_Perspective.getNumberFormatCallBack().setState(4, this.m_detObj.getSeriesID(), this.m_detObj.getGroupID(), -1, -3);
            strFormattedValue = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
        } else {
            strFormattedValue = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), fValue, this.m_Perspective.getDataTextFormatPattern());
        }
        return strFormattedValue;
    }

    void FmtSingleValue(FontMetrics fm, int nLineNum, String strLabel, double theValue) {
        this.m_TipStrings[nLineNum] = this.m_Perspective.PFJRes.getString(strLabel) + this.m_Perspective.PFJRes.getString("COLON") + " ";
        String strFormattedValue = this.FmtValue(theValue);
        int n = nLineNum;
        this.m_TipStrings[n] = this.m_TipStrings[n] + strFormattedValue;
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[nLineNum]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[nLineNum]) + 6 : this.m_RectTipShape.width;
    }

    void FmtDeveloperSeriesAndGroupID(FontMetrics fm) {
        int LineNo = 2;
        this.m_TipStrings[LineNo] = this.m_Perspective.PFJRes.getString("SERIES") + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n = LineNo;
        this.m_TipStrings[n] = this.m_TipStrings[n] + this.m_detObj.getSeriesID();
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
        LineNo = 3;
        this.m_TipStrings[LineNo] = this.m_Perspective.PFJRes.getString("GROUP") + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n2 = LineNo;
        this.m_TipStrings[n2] = this.m_TipStrings[n2] + this.m_detObj.getGroupID();
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
    }

    void FmtUserSeriesAndGroupID(FontMetrics fm) {
        int LineNo = 0;
        this.m_TipStrings[LineNo] = this.m_Perspective.getSeriesLabel(this.m_detObj.getSeriesID());
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
        LineNo = 1;
        this.m_TipStrings[LineNo] = this.m_Perspective.getGroupLabel(this.m_detObj.getGroupID());
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
    }

    void FmtUserReferenceLineID(FontMetrics fm) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        int LineNo = 0;
        this.m_TipStrings[LineNo] = this.m_detObj.getReferenceLabel();
        if (this.m_TipStrings[LineNo] != null) {
            this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
        }
    }

    void FmtDevelopersPareto(FontMetrics fm) {
        int LineNo = 2;
        this.m_TipStrings[LineNo] = this.m_Perspective.PFJRes.getString("SERIES") + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n = LineNo;
        this.m_TipStrings[n] = this.m_TipStrings[n] + this.m_Perspective.getDisplayParetoSeries();
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
        LineNo = 3;
        this.m_TipStrings[LineNo] = this.m_Perspective.PFJRes.getString("GROUP") + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n2 = LineNo;
        this.m_TipStrings[n2] = this.m_TipStrings[n2] + this.m_detObj.getGroupID();
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
    }

    void DeveloperSetToolTipHeight(FontMetrics fm, String Description, int TipWidth, int nRemainingSingleLines) {
        int nHeight = fm.getHeight();
        if (fm.stringWidth(Description) < TipWidth) {
            nHeight += fm.getHeight();
        } else {
            double fFlooredQuotient;
            double quotient = (double)fm.stringWidth(Description) / (double)TipWidth;
            if (quotient - (fFlooredQuotient = Math.floor(quotient)) > 0.1) {
                fFlooredQuotient += 1.0;
            }
            nHeight = (int)((double)nHeight + fFlooredQuotient * (double)fm.getHeight());
        }
        nHeight += fm.getHeight() * nRemainingSingleLines;
        this.m_RectTipShape.height = nHeight += 2;
    }

    void DeveloperFmtGENERAL(FontMetrics fm) {
        int LineNo;
        double fValue;
        block10: {
            fValue = 0.0;
            LineNo = 4;
            if (this.m_Chart instanceof JChart_2D_Pareto) {
                try {
                    int gpID = this.m_detObj.getGroupID();
                    int nSeries = this.m_Perspective.getDisplayParetoSeries();
                    if (gpID < 0) break block10;
                    if (this.ParetoRelated()) {
                        fValue = ((JChart_2D_Standard)this.m_Chart).getParetoValue(nSeries, gpID);
                        break block10;
                    }
                    fValue = this.m_Perspective.getDataAsDouble(nSeries, this.m_detObj.getGroupID());
                }
                catch (AssertionException e) {
                    fValue = 0.0;
                }
            } else if (this.m_Chart instanceof JChart_2D_PieBar) {
                if (this.m_detObj.getGroupID() <= 0) {
                    fValue = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(this.m_detObj.getSeriesID());
                }
            } else {
                try {
                    fValue = this.m_Perspective.getDataAsDouble(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
                }
                catch (AssertionException e) {
                    fValue = 0.0;
                }
            }
        }
        this.m_TipStrings[LineNo] = this.m_Perspective.PFJRes.getString("VALUE") + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n = LineNo;
        this.m_TipStrings[n] = this.m_TipStrings[n] + Double.toString(fValue);
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 3;
    }

    void DeveloperFmtXY(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        this.m_nNumToolTipLines = 4;
    }

    void DeveloperFmtXY_LBL(FontMetrics fm) {
        String strLabel;
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getLabelXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getLabelYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        LineNo = 6;
        try {
            strLabel = ((JChart_2D_Scat)this.m_Chart).getLabelValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            strLabel = "";
        }
        this.m_TipStrings[LineNo] = this.m_Perspective.PFJRes.getString("LABEL") + this.m_Perspective.PFJRes.getString("COLON") + " " + strLabel;
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtXYZ(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_XValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_YValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        LineNo = 6;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "ZVALUE", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtHL(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        this.m_nNumToolTipLines = 4;
    }

    void DeveloperFmtHLC(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 6;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtOHLC(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "OPEN", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 6;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 7;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        this.m_nNumToolTipLines = 6;
    }

    void DeveloperFmtHL_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 5;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 6;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtHLC_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 5;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 6;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        LineNo = 7;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 6;
    }

    void DeveloperFmtOHLC_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "OPEN", theValue);
        LineNo = 5;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 6;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 7;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        LineNo = 8;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 7;
    }

    void UserSetToolTipHeight(FontMetrics fm) {
        this.m_RectTipShape.height = 0;
        int nIdx = 0;
        while (nIdx < this.m_nNumToolTipLines) {
            if (this.m_TipStrings[nIdx].length() > 0) {
                this.m_RectTipShape.height += fm.getHeight();
            }
            ++nIdx;
        }
    }

    void UserFmtReferenceLineGENERAL(FontMetrics fm) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        double theValue = 0.0;
        int LineNo = 0;
        theValue = this.m_detObj.getReferenceData();
        this.FmtSingleValue(fm, LineNo, "VALUE", theValue);
        this.m_nNumToolTipLines = 1;
    }

    void UserFmtGENERAL(FontMetrics fm) {
        int nSeries = this.m_detObj.getSeriesID();
        int nGroup = this.m_detObj.getGroupID();
        int LineNo = 2;
        double theValue = 0.0;
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            if (nGroup <= 0) {
                try {
                    theValue = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(nSeries);
                    this.FmtSingleValue(fm, LineNo, "VALUE", theValue);
                }
                catch (AssertionException e) {
                    theValue = 0.0;
                }
            }
        } else if (this.m_Chart instanceof JChart_2D_Pareto) {
            nSeries = this.m_Perspective.getDisplayParetoSeries();
            try {
                theValue = this.ParetoRelated() ? ((JChart_2D_Standard)this.m_Chart).getParetoValue(nSeries, nGroup) : this.m_Perspective.getDataAsDouble(nSeries, nGroup);
            }
            catch (AssertionException e) {
                theValue = 0.0;
            }
            this.FmtSingleValue(fm, LineNo, "VALUE", theValue);
        } else {
            try {
                theValue = this.m_Perspective.getDataAsDouble(nSeries, nGroup);
                this.FmtSingleValue(fm, LineNo, "VALUE", theValue);
            }
            catch (AssertionException e) {
                theValue = 0.0;
            }
        }
        this.m_nNumToolTipLines = 3;
    }

    void UserFmtXY(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = this.m_Chart instanceof JChart_2D_Scat ? ((JChart_2D_Scat)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : (this.m_Chart instanceof JChart_2D_Polar ? ((JChart_2D_Polar)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0);
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 3;
        try {
            theValue = this.m_Chart instanceof JChart_2D_Scat ? ((JChart_2D_Scat)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : (this.m_Chart instanceof JChart_2D_Polar ? ((JChart_2D_Polar)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0);
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        this.m_nNumToolTipLines = 4;
    }

    void UserFmtXY_LBL(FontMetrics fm) {
        String strLabel;
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getLabelXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getLabelYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        LineNo = 4;
        try {
            strLabel = ((JChart_2D_Scat)this.m_Chart).getLabelValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            strLabel = "";
        }
        this.m_TipStrings[LineNo] = this.m_Perspective.PFJRes.getString("LABEL") + this.m_Perspective.PFJRes.getString("COLON") + " " + strLabel;
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtXYZ(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_XValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_YValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        LineNo = 4;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "ZVALUE", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtHL(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        this.m_nNumToolTipLines = 4;
    }

    void UserFmtHLC(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtOHLC(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "OPEN", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        this.m_nNumToolTipLines = 6;
    }

    void UserFmtHL_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 3;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 4;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtHLC_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 3;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        LineNo = 5;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 6;
    }

    void UserFmtOHLC_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "OPEN", theValue);
        LineNo = 3;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 5;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        LineNo = 6;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 7;
    }

    void UserFmtGANTT(FontMetrics fm) {
        int nSeries = this.m_detObj.getSeriesID();
        int LineNo = 0;
        this.m_TipStrings[LineNo] = this.m_Perspective.getAlertLabel(this.m_detObj.getSeriesID());
        this.m_RectTipShape.width = fm.stringWidth(this.m_TipStrings[LineNo]) > this.m_RectTipShape.width - 6 ? fm.stringWidth(this.m_TipStrings[LineNo]) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 1;
    }

    public String[] getUserTooltipStrings(DetObj obj, int nDeadZoneLocation) {
        String[] strArray = null;
        if (this.m_Perspective.isToolTipCallBack()) {
            JGraphType aGraphType = this.m_Perspective.getJGraphType();
            DataFormat aDataFormat = aGraphType.getDataFormat();
            this.m_Chart = this.m_Perspective.getGraphObject();
            this.m_detObj = obj;
            MouseEvent mouseEvent = new MouseEvent(this.m_Perspective, 0, 0L, 0, 0, 0, 0, false);
            TDGMouseState state = new TDGMouseState(mouseEvent, obj);
            state.setDeadZoneMouseLocation(nDeadZoneLocation);
            String strCustomToolTip = this.m_Perspective.getToolTipCallBack().getDynamicToolTip(state, this.m_Perspective.getToolTipMode());
            if (strCustomToolTip != null && strCustomToolTip.length() > 0) {
                this.clearToolTip();
                this.m_nNumToolTipLines = this.CustomToolTipIntoLines(strCustomToolTip);
                this.CustomToolTipMacros(aDataFormat);
                strArray = new String[this.m_nNumToolTipLines];
                int i = 0;
                while (i < this.m_nNumToolTipLines) {
                    strArray[i] = this.m_TipStrings[i];
                    ++i;
                }
            }
            this.m_detObj = null;
        }
        return strArray;
    }

    public boolean ParetoRelated() {
        return this.m_detObj.getObjectID() == 473 || this.m_detObj.getObjectID() == 474 || this.m_detObj.getObjectID() == 475 || this.m_detObj.getObjectID() == 476;
    }

    void timeOutTimer_TimerEvent(ActionEvent event) {
        this.timeOutTimer.stop();
        if (this.m_Perspective.getToolTipDisplay()) {
            this.m_Perspective.toolTipRepaint(false);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ToolTips.this.timeOutTimer) {
                ToolTips.this.timeOutTimer_TimerEvent(event);
            }
        }
    }
}

