/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class TextBox {
    public static final int ANCHOR_LEFT = 0;
    public static final int ANCHOR_CENTER = 1;
    public static final int ANCHOR_RIGHT = 2;
    public static final int ANCHOR_TOP = 0;
    public static final int ANCHOR_BOTTOM = 2;
    private Rectangle m_r;
    private int m_nHorz;
    private int m_nVert;

    public TextBox(Rectangle r, int nHorz, int nVert) {
        this.m_r = new Rectangle(r.x, r.y, r.width, r.height);
        this.setAnchor(nHorz, nVert);
    }

    public void copyIntoRect(Rectangle r) {
        r.x = this.m_r.x;
        r.y = this.m_r.y;
        r.width = this.m_r.width;
        r.height = this.m_r.height;
    }

    public Rectangle getRect() {
        return this.m_r;
    }

    public void setAnchor(int nHorz, int nVert) {
        if (nHorz < 0 || nHorz > 2) {
            nHorz = 1;
        }
        if (nVert < 0 || nVert > 2) {
            nVert = 1;
        }
        this.m_nHorz = nHorz;
        this.m_nVert = nVert;
    }

    public void setHeight(int nHeight) {
        if (nHeight < 0) {
            return;
        }
        this.m_r.y -= (nHeight - this.m_r.height) * this.m_nVert / 2;
        this.m_r.height = nHeight;
    }

    public void setOrigin(Point pt) {
        this.m_r.x = pt.x;
        this.m_r.y = pt.y;
    }

    public void setSize(Dimension dim) {
        this.setHeight(dim.height);
        this.setWidth(dim.width);
    }

    public void setWidth(int nWidth) {
        if (nWidth < 0) {
            return;
        }
        this.m_r.x -= (nWidth - this.m_r.width) * this.m_nHorz / 2;
        this.m_r.width = nWidth;
    }
}

