/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import tdg.draw.OctreeFilter;

public abstract class ImageEncoder
implements ImageConsumer {
    protected OutputStream out;
    private ImageProducer producer;
    private int width = -1;
    private int height = -1;
    private int hintflags = 0;
    private boolean started = false;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private Hashtable props = null;
    private boolean bAccumulate = false;
    private int[] accumulator;

    public ImageEncoder(ImageProducer producer, OutputStream out) throws IOException {
        this.producer = producer;
        this.out = out;
    }

    public ImageEncoder(Image img, OutputStream out) throws IOException {
        this(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(img.getSource(), new OctreeFilter(img))).getSource(), out);
    }

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    abstract void encodeDone() throws IOException;

    private void encodeFinish() throws IOException {
        if (this.bAccumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.bAccumulate = false;
        }
    }

    abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws IOException;

    private void encodePixelsWrapper(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.bAccumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.bAccumulate) {
            int row = 0;
            while (row < h) {
                System.arraycopy(rgbPixels, row * scansize + off, this.accumulator, (y + row) * this.width + x, w);
                ++row;
            }
        } else {
            this.encodePixels(x, y, w, h, rgbPixels, off, scansize);
        }
    }

    abstract void encodeStart(int var1, int var2) throws IOException;

    public void imageComplete(int status) {
        this.producer.removeConsumer(this);
        if (status == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException e) {
                this.iox = e;
            }
        }
        this.stop();
    }

    public void setColorModel(ColorModel model) {
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setHints(int hintflags) {
        this.hintflags = hintflags;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int[] rgbPixels = new int[w];
        int row = 0;
        while (row < h) {
            int rowOff = off + row * scansize;
            int col = 0;
            while (col < w) {
                rgbPixels[col] = model.getRGB(pixels[rowOff + col] & 0xFF);
                ++col;
            }
            try {
                this.encodePixelsWrapper(x, y + row, w, 1, rgbPixels, 0, w);
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
            ++row;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == rgbModel) {
            try {
                this.encodePixelsWrapper(x, y, w, h, pixels, off, scansize);
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
        }
        int[] rgbPixels = new int[w];
        int row = 0;
        while (row < h) {
            int rowOff = off + row * scansize;
            int col = 0;
            while (col < w) {
                rgbPixels[col] = model.getRGB(pixels[rowOff + col]);
                ++col;
            }
            try {
                this.encodePixelsWrapper(x, y + row, w, 1, rgbPixels, 0, w);
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
            ++row;
        }
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }
}

