/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import com.threedgraphics.math.FP;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import tdg.Assert;
import tdg.MathExt;
import tdg.Perspective;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetObj;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;

public class DetLine
extends DetObj {
    protected static final int SLOP_FACTOR = 40;
    public static final int THIN_LINE = 0;
    protected Point m_pt1;
    protected Point m_pt2;
    protected Polygon m_polyLine;
    protected int m_nLineWidth;
    protected int m_lineStyle = Perspective.SOLID;
    protected boolean m_isMarker = false;

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, int nLineWidth) {
        super(m_Detectiv, id, blackBox, clipRect, false, true, true);
        this.m_pt1 = new Point(ptx1, pty1);
        this.m_pt2 = new Point(ptx2, pty2);
        this.m_nLineWidth = nLineWidth;
        this.m_polyLine = null;
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (id.getObjectID() == 249) {
            this.m_isMarker = true;
        }
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, int nLineWidth, int nLineStyle) {
        this(m_Detectiv, id, ptx1, pty1, ptx2, pty2, blackBox, clipRect, nLineWidth);
        this.m_lineStyle = nLineStyle;
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable) {
        this(m_Detectiv, id, ptx1, pty1, ptx2, pty2, blackBox, clipRect, bMoveable, bDetectable, 0);
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, int nLineWidth) {
        super(m_Detectiv, id, blackBox, clipRect, bMoveable, bDetectable, true);
        this.m_pt1 = new Point(ptx1, pty1);
        this.m_pt2 = new Point(ptx2, pty2);
        this.m_nLineWidth = nLineWidth;
        this.m_polyLine = null;
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (id.getObjectID() == 249) {
            this.m_isMarker = true;
        }
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, int nLineWidth, int nLineStyle) {
        this(m_Detectiv, id, ptx1, pty1, ptx2, pty2, blackBox, clipRect, bMoveable, bDetectable, nLineWidth);
        this.m_lineStyle = nLineStyle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetLine)) {
            return false;
        }
        DetLine detLine = (DetLine)obj;
        return this.m_id.equals(detLine.m_id);
    }

    public Point getBeginPoint() {
        return this.m_pt1;
    }

    public Point getEndPoint() {
        return this.m_pt2;
    }

    public Rectangle getBounds() {
        return new Rectangle(Math.min(this.m_pt1.x, this.m_pt2.x), Math.min(this.m_pt1.y, this.m_pt2.y), Math.abs(this.m_pt1.x - this.m_pt2.x), Math.abs(this.m_pt1.y - this.m_pt2.y));
    }

    public void hilite(Graphics g, VC vc) {
        Point pt1 = vc.virtToDest(new Point(this.m_pt1.x, this.m_pt1.y));
        Point pt2 = vc.virtToDest(new Point(this.m_pt2.x, this.m_pt2.y));
        g.setXORMode(Color.yellow);
        g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
        g.setPaintMode();
    }

    public boolean isPointInObj(int x, int y, VC vc) {
        if (!this.m_bDetectable) {
            return false;
        }
        if (this.m_polyLine == null) {
            this.m_polyLine = this.calcLine(Math.max(this.m_nLineWidth, 5), vc, false);
        }
        return this.m_polyLine.contains(x, y);
    }

    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    public void paintIt(Graphics g, VC vc) {
        switch (this.m_nLineWidth) {
            case 0: 
            case 1: {
                if (this.m_lineStyle == Perspective.SOLID) {
                    this.m_blackBox.paint(g, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2));
                    break;
                }
                this.m_blackBox.paint(g, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), 1, this.m_lineStyle, this.m_isMarker);
                break;
            }
            default: {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), this.m_nLineWidth, this.m_lineStyle, this.m_isMarker);
            }
        }
        this.m_polyLine = null;
    }

    public void setBeginPoint(Point aPoint) {
        this.m_pt1 = aPoint;
    }

    public void setEndPoint(Point aPoint) {
        this.m_pt2 = aPoint;
    }

    public void setBounds(Rectangle rBounds) {
    }

    private Polygon calcLine(int nLineWidth, VC vc, boolean bWantEndcaps) {
        Point pt1;
        Point pt0;
        Polygon poly = new Polygon();
        if (this.m_pt1.x < this.m_pt2.x) {
            pt0 = vc.virtToDest(this.m_pt1);
            pt1 = vc.virtToDest(this.m_pt2);
        } else {
            pt1 = vc.virtToDest(this.m_pt1);
            pt0 = vc.virtToDest(this.m_pt2);
        }
        Assert.assert(pt0.x <= pt1.x);
        double dx = pt1.x - pt0.x;
        double dy = pt1.y - pt0.y;
        double fAngleDeg = Math.atan2(dy, dx) * 57.29577951308232;
        if (bWantEndcaps) {
            Point pt;
            double delta = 90.0;
            while (FP.lessThan(delta, 272.0)) {
                pt = vc.destToVirt(MathExt.polToCart(fAngleDeg + delta, nLineWidth, pt0));
                poly.addPoint(pt.x, pt.y);
                delta += 10.0;
            }
            double delta2 = -90.0;
            while (FP.lessThan(delta2, 92.0)) {
                pt = vc.destToVirt(MathExt.polToCart(fAngleDeg + delta2, nLineWidth, pt1));
                poly.addPoint(pt.x, pt.y);
                delta2 += 10.0;
            }
        } else {
            double angle = (fAngleDeg + 90.0) * (Math.PI / 180);
            int x0 = pt0.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
            int y0 = pt0.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
            poly.addPoint(x0, y0);
            angle = (fAngleDeg + 270.0) * (Math.PI / 180);
            int x1 = pt0.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
            int y1 = pt0.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
            poly.addPoint(x1, y1);
            angle = (fAngleDeg - 90.0) * (Math.PI / 180);
            int x2 = pt1.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
            int y2 = pt1.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
            poly.addPoint(x2, y2);
            angle = (fAngleDeg + 90.0) * (Math.PI / 180);
            int x3 = pt1.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
            int y3 = pt1.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
            poly.addPoint(x3, y3);
            poly.addPoint(x0, y0);
            poly = vc.destToVirt(poly);
        }
        return poly;
    }

    public Polygon getShape(VC vc) {
        return this.calcLine(Math.max(this.m_nLineWidth, 5), vc, false);
    }
}

