/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.io.Serializable;
import tdg.AssertionException;
import tdg.AxisDescriptor;
import tdg.MinMaxObj;
import tdg.OrdinalAxisFragment;

public class ZoomState
implements Serializable {
    public static final ZoomState UNZOOMED = new ZoomState();
    protected boolean m_bZoomed = false;
    protected AxisDescriptor m_AxisDescriptor;
    protected double m_fMin_X1;
    protected double m_fMax_X1;
    protected double m_fMin_Y1;
    protected double m_fMax_Y1;
    protected double m_fMin_Y2;
    protected double m_fMax_Y2;
    protected int m_nViewGroups;
    protected int m_nGroupOffset;
    protected int m_nViewSeries;
    protected int m_nSeriesOffset;

    public void ChartFrame(double fMin_X1, double fMax_X1, double fMin_Y1, double fMax_Y1, double fMin_Y2, double fMax_Y2, int nViewGroups, int nGroupOffset, int nViewSeries, int nSeriesOffset, AxisDescriptor axisDescriptor) {
        this.m_bZoomed = true;
        this.m_AxisDescriptor = axisDescriptor;
        this.m_fMin_X1 = fMin_X1;
        this.m_fMax_X1 = fMax_X1;
        this.m_fMin_Y1 = fMin_Y1;
        this.m_fMax_Y1 = fMax_Y1;
        this.m_fMin_Y2 = fMin_Y2;
        this.m_fMax_Y2 = fMax_Y2;
        this.m_nViewGroups = nViewGroups;
        this.m_nGroupOffset = nGroupOffset;
        this.m_nViewSeries = nViewSeries;
        this.m_nSeriesOffset = nSeriesOffset;
    }

    public OrdinalAxisFragment getOrdinalAxisFragment(int axisID) {
        OrdinalAxisFragment oafZoom = null;
        if (!this.m_bZoomed) {
            throw new AssertionException("UNZOOMED can't respond to getOrdinalAxisFragment");
        }
        switch (axisID) {
            case 5: {
                if (!this.m_AxisDescriptor.hasO1()) break;
                oafZoom = new OrdinalAxisFragment(this.m_nViewGroups, this.m_nGroupOffset);
                break;
            }
            case 6: {
                if (!this.m_AxisDescriptor.hasO2()) break;
                oafZoom = new OrdinalAxisFragment(this.m_nViewSeries, this.m_nSeriesOffset);
                break;
            }
            default: {
                throw new AssertionException("ZoomState.getOrdinalAxisFragment: Unknown axis ID = " + axisID);
            }
        }
        return oafZoom;
    }

    public MinMaxObj getScaleMinMax(int axisID) {
        MinMaxObj mmZoom = null;
        if (!this.m_bZoomed) {
            throw new AssertionException("UNZOOMED can't respond to getScaleMin");
        }
        switch (axisID) {
            case 7: {
                if (!this.m_AxisDescriptor.hasX1()) break;
                mmZoom = new MinMaxObj(this.m_fMin_X1, this.m_fMax_X1);
                break;
            }
            case 0: {
                if (!this.m_AxisDescriptor.hasY1()) break;
                mmZoom = new MinMaxObj(this.m_fMin_Y1, this.m_fMax_Y1);
                break;
            }
            case 1: {
                if (!this.m_AxisDescriptor.hasY2()) break;
                mmZoom = new MinMaxObj(this.m_fMin_Y2, this.m_fMax_Y2);
                break;
            }
            default: {
                throw new AssertionException("ZoomState.getScaleMin: Unknown axis ID = " + axisID);
            }
        }
        if (mmZoom != null) {
            mmZoom.setDataDerived(false);
        }
        return mmZoom;
    }

    public boolean isZoomed() {
        return this.m_bZoomed;
    }

    public String toString() {
        if (this.m_bZoomed) {
            return "[X1: (" + this.m_fMin_X1 + ", " + this.m_fMax_X1 + "), Y1: (" + this.m_fMin_Y1 + ", " + this.m_fMax_Y1 + ")]";
        }
        return "UNZOOMED state";
    }
}

