/*
 * Decompiled with CFR 0.152.
 */
package tdg;

public class TDGToken {
    public static final int NEW = 1;
    public static final int BOOLEAN = 2;
    public static final int METHOD_NAME = 3;
    public static final int OPEN_PARENTHESES = 4;
    public static final int CLOSE_PARENTHESES = 5;
    public static final int SEMI_COLON = 6;
    public static final int COMMA = 7;
    public static final int STRING = 8;
    public static final int NUMBER = 9;
    public static final int NULL_PARAM = 10;
    private int m_nTokenType;
    private Object m_Object;

    public TDGToken(int nType) {
        this.m_nTokenType = nType;
        this.m_Object = null;
    }

    public TDGToken(int nType, Object obj) {
        this.m_nTokenType = nType;
        this.m_Object = obj;
    }

    public String toString() {
        String szToken = "Token Type = ";
        switch (this.m_nTokenType) {
            case 1: {
                szToken = szToken + "NEW";
                break;
            }
            case 2: {
                szToken = szToken + "BOOLEAN";
                break;
            }
            case 3: {
                szToken = szToken + "METHOD NAME";
                break;
            }
            case 4: {
                szToken = szToken + "(";
                break;
            }
            case 5: {
                szToken = szToken + ")";
                break;
            }
            case 6: {
                szToken = szToken + ";";
                break;
            }
            case 7: {
                szToken = szToken + ",";
                break;
            }
            case 8: {
                szToken = szToken + "STRING";
                break;
            }
            case 9: {
                szToken = szToken + "NUMBER";
                break;
            }
            case 10: {
                szToken = szToken + "NULL_PARAM";
            }
        }
        szToken = szToken + "\t Parameter = " + (this.m_Object != null ? this.m_Object.toString() : "null");
        return szToken;
    }

    public int getType() {
        return this.m_nTokenType;
    }

    public Object getObject() {
        return this.m_Object;
    }

    public boolean isNewParameter() {
        return this.m_nTokenType == 1 || this.m_nTokenType == 2 || this.m_nTokenType == 3 || this.m_nTokenType == 8 || this.m_nTokenType == 9 || this.m_nTokenType == 10;
    }
}

