/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Vector;
import tdg.AssertionException;
import tdg.MarkerTemplate;
import tdg.MarkerTemplateArray;
import tdg.Perspective;
import tdg.QSortPoly;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetImage;
import tdg.draw.DetLine;
import tdg.draw.DetOval;
import tdg.draw.DetPolygon;
import tdg.draw.DetRect;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;

public class MarkerObj {
    protected IdentObj m_id;
    protected MarkerTemplate m_template;
    protected Point m_center;
    protected int m_markerSizeX;
    protected int m_markerSizeY;
    protected BlackBoxIF m_bb;
    protected Rectangle m_rClip;
    protected Detectiv m_Detectiv;
    protected Perspective m_Perspective;
    protected String m_szRefLabel;
    protected double m_nData;
    protected boolean m_threed = false;
    protected int m_nXDepth = 0;
    protected int m_nYDepth = 0;
    protected int m_nDepthAngle = 0;

    public MarkerObj(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize) {
        this(a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, false, 0, 0, 0);
    }

    public MarkerObj(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize, boolean threed, int nXDepth, int nYDepth, int nDepthAngle) {
        this.m_threed = threed;
        this.m_nXDepth = nXDepth;
        this.m_nYDepth = nYDepth;
        this.m_nDepthAngle = nDepthAngle;
        if (center == null) {
            center = new Point(0, 0);
        }
        if (template == MarkerTemplateArray.PRESET_BUBBLE) {
            if (markerSizeX < 0) {
                throw new AssertionException(0, Integer.MAX_VALUE, markerSizeX);
            }
            if (markerSizeY < 0) {
                throw new AssertionException(0, Integer.MAX_VALUE, markerSizeY);
            }
        } else {
            if (markerSizeX < 0 || bLimitSize && markerSizeX > 100) {
                throw new AssertionException(0, 100, markerSizeX);
            }
            if (markerSizeY < 0 || bLimitSize && markerSizeY > 100) {
                throw new AssertionException(0, 100, markerSizeY);
            }
        }
        this.m_id = id;
        this.m_template = template;
        this.m_center = center;
        this.m_markerSizeX = markerSizeX;
        this.m_markerSizeY = markerSizeY;
        this.m_bb = blackBox;
        this.m_rClip = rClip;
        this.m_Detectiv = a_Detectiv;
        this.m_Perspective = this.m_Detectiv.getPerspective();
        this.calc();
    }

    public MarkerObj(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox) {
        this(a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, null, true);
    }

    public void calc() {
        switch (this.m_template.m_markerType) {
            case 0: {
                break;
            }
            case 1: {
                this.calcRect();
                break;
            }
            case 2: {
                this.calcOval();
                break;
            }
            case 9: {
                this.calcBubble();
                break;
            }
            case 4: {
                this.calcLine();
                break;
            }
            case 3: {
                this.calcDiamond();
                break;
            }
            case 5: {
                this.calcPlus();
                break;
            }
            case 6: {
                this.calcTriangleDn();
                break;
            }
            case 7: {
                this.calcTriangleUp();
                break;
            }
            case 8: {
                this.calcDrillUp();
                break;
            }
            default: {
                throw new AssertionException("MarkerObj - unknown markerType = " + this.m_template.m_markerType);
            }
        }
    }

    public void calcBubble() {
        int minWidth;
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_markerSizeX);
        if (width < (height = vc.virtToDestHeight(this.m_markerSizeY))) {
            width = height;
        }
        if (width < (minWidth = 3)) {
            width = minWidth;
        }
        height = width;
        this._calcOval(height, width, scaledPolygon, vc);
    }

    public void calcOval() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (!this.m_Perspective.getJGraphType().isBubble()) {
            if (width < 5) {
                width = 5;
            }
            if (width % 2 == 0) {
                ++width;
            }
        } else if (width < 3) {
            width = 3;
        }
        height = width;
        this._calcOval(height, width, scaledPolygon, vc);
    }

    private void _calcOval(int height, int width, Polygon scaledPolygon, VC vc) {
        int cx = vc.virtToDestX(this.m_center.x);
        int cy = vc.virtToDestY(this.m_center.y);
        int x = cx - height / 2;
        int y = cy - height / 2;
        Rectangle scaledRect = new Rectangle(x, y, width - 1, height - 1);
        if (height > 26 && !this.m_threed) {
            new DetOval(this.m_Detectiv, this.m_id, scaledRect, this.m_bb, true, null, this.m_rClip);
            return;
        }
        switch (height) {
            case 3: {
                scaledPolygon.addPoint(x + 1, y);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x, y + 1);
                scaledPolygon.addPoint(x + 1, y);
                break;
            }
            case 4: {
                scaledPolygon.addPoint(x + 1, y);
                scaledPolygon.addPoint(x + 2, y);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x, y + 2);
                scaledPolygon.addPoint(x, y + 1);
                scaledPolygon.addPoint(x + 1, y);
                break;
            }
            case 5: {
                scaledPolygon.addPoint(x + 1, y);
                scaledPolygon.addPoint(x + 3, y);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x, y + 3);
                scaledPolygon.addPoint(x, y + 1);
                scaledPolygon.addPoint(x + 1, y);
                break;
            }
            case 6: {
                scaledPolygon.addPoint(x + 2, y);
                scaledPolygon.addPoint(x + 3, y);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 5, y + 3);
                scaledPolygon.addPoint(x + 4, y + 4);
                scaledPolygon.addPoint(x + 3, y + 5);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x, y + 3);
                scaledPolygon.addPoint(x, y + 2);
                scaledPolygon.addPoint(x + 1, y + 1);
                scaledPolygon.addPoint(x + 2, y);
                break;
            }
            case 7: {
                scaledPolygon.addPoint(x + 2, y);
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 6, y + 4);
                scaledPolygon.addPoint(x + 5, y + 5);
                scaledPolygon.addPoint(x + 4, y + 6);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x, y + 2);
                scaledPolygon.addPoint(x + 1, y + 1);
                scaledPolygon.addPoint(x + 2, y);
                break;
            }
            case 8: {
                scaledPolygon.addPoint(x + 3, y);
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 7, y + 3);
                scaledPolygon.addPoint(x + 7, y + 4);
                scaledPolygon.addPoint(x + 6, y + 5);
                scaledPolygon.addPoint(x + 6, y + 6);
                scaledPolygon.addPoint(x + 5, y + 6);
                scaledPolygon.addPoint(x + 4, y + 7);
                scaledPolygon.addPoint(x + 3, y + 7);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x, y + 3);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 1, y + 1);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 3, y);
                break;
            }
            case 9: {
                scaledPolygon.addPoint(x + 3, y);
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 7, y + 2);
                scaledPolygon.addPoint(x + 8, y + 3);
                scaledPolygon.addPoint(x + 8, y + 5);
                scaledPolygon.addPoint(x + 7, y + 6);
                scaledPolygon.addPoint(x + 7, y + 7);
                scaledPolygon.addPoint(x + 6, y + 7);
                scaledPolygon.addPoint(x + 5, y + 8);
                scaledPolygon.addPoint(x + 3, y + 8);
                scaledPolygon.addPoint(x + 2, y + 7);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x, y + 3);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 1, y + 1);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 3, y);
                break;
            }
            case 10: {
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y + 2);
                scaledPolygon.addPoint(x + 8, y + 3);
                scaledPolygon.addPoint(x + 9, y + 4);
                scaledPolygon.addPoint(x + 9, y + 5);
                scaledPolygon.addPoint(x + 8, y + 6);
                scaledPolygon.addPoint(x + 8, y + 7);
                scaledPolygon.addPoint(x + 7, y + 8);
                scaledPolygon.addPoint(x + 6, y + 8);
                scaledPolygon.addPoint(x + 5, y + 9);
                scaledPolygon.addPoint(x + 4, y + 9);
                scaledPolygon.addPoint(x + 3, y + 8);
                scaledPolygon.addPoint(x + 2, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y);
                break;
            }
            case 11: {
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 6, y);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y + 1);
                scaledPolygon.addPoint(x + 9, y + 2);
                scaledPolygon.addPoint(x + 9, y + 3);
                scaledPolygon.addPoint(x + 10, y + 4);
                scaledPolygon.addPoint(x + 10, y + 6);
                scaledPolygon.addPoint(x + 9, y + 7);
                scaledPolygon.addPoint(x + 9, y + 8);
                scaledPolygon.addPoint(x + 8, y + 9);
                scaledPolygon.addPoint(x + 7, y + 9);
                scaledPolygon.addPoint(x + 6, y + 10);
                scaledPolygon.addPoint(x + 4, y + 10);
                scaledPolygon.addPoint(x + 3, y + 9);
                scaledPolygon.addPoint(x + 2, y + 9);
                scaledPolygon.addPoint(x + 1, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x, y + 6);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y);
                break;
            }
            case 12: {
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 6, y);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 9, y + 1);
                scaledPolygon.addPoint(x + 10, y + 2);
                scaledPolygon.addPoint(x + 10, y + 4);
                scaledPolygon.addPoint(x + 11, y + 5);
                scaledPolygon.addPoint(x + 11, y + 6);
                scaledPolygon.addPoint(x + 10, y + 7);
                scaledPolygon.addPoint(x + 10, y + 9);
                scaledPolygon.addPoint(x + 9, y + 10);
                scaledPolygon.addPoint(x + 7, y + 10);
                scaledPolygon.addPoint(x + 6, y + 11);
                scaledPolygon.addPoint(x + 5, y + 11);
                scaledPolygon.addPoint(x + 4, y + 10);
                scaledPolygon.addPoint(x + 2, y + 10);
                scaledPolygon.addPoint(x + 1, y + 9);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x, y + 6);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y);
                break;
            }
            case 13: {
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 7, y);
                scaledPolygon.addPoint(x + 8, y + 1);
                scaledPolygon.addPoint(x + 9, y + 1);
                scaledPolygon.addPoint(x + 10, y + 2);
                scaledPolygon.addPoint(x + 11, y + 3);
                scaledPolygon.addPoint(x + 11, y + 4);
                scaledPolygon.addPoint(x + 12, y + 5);
                scaledPolygon.addPoint(x + 12, y + 7);
                scaledPolygon.addPoint(x + 11, y + 8);
                scaledPolygon.addPoint(x + 11, y + 9);
                scaledPolygon.addPoint(x + 10, y + 10);
                scaledPolygon.addPoint(x + 9, y + 11);
                scaledPolygon.addPoint(x + 8, y + 11);
                scaledPolygon.addPoint(x + 7, y + 12);
                scaledPolygon.addPoint(x + 5, y + 12);
                scaledPolygon.addPoint(x + 4, y + 11);
                scaledPolygon.addPoint(x + 3, y + 11);
                scaledPolygon.addPoint(x + 2, y + 10);
                scaledPolygon.addPoint(x + 1, y + 9);
                scaledPolygon.addPoint(x + 1, y + 8);
                scaledPolygon.addPoint(x, y + 7);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 2, y + 2);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y);
                break;
            }
            case 14: {
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 9, y);
                scaledPolygon.addPoint(x + 10, y + 1);
                scaledPolygon.addPoint(x + 11, y + 2);
                scaledPolygon.addPoint(x + 12, y + 3);
                scaledPolygon.addPoint(x + 12, y + 4);
                scaledPolygon.addPoint(x + 13, y + 5);
                scaledPolygon.addPoint(x + 13, y + 8);
                scaledPolygon.addPoint(x + 12, y + 9);
                scaledPolygon.addPoint(x + 12, y + 10);
                scaledPolygon.addPoint(x + 11, y + 11);
                scaledPolygon.addPoint(x + 10, y + 12);
                scaledPolygon.addPoint(x + 9, y + 13);
                scaledPolygon.addPoint(x + 4, y + 13);
                scaledPolygon.addPoint(x + 3, y + 12);
                scaledPolygon.addPoint(x + 2, y + 11);
                scaledPolygon.addPoint(x + 1, y + 10);
                scaledPolygon.addPoint(x, y + 9);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 2, y + 2);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y);
                break;
            }
            case 15: {
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 9, y);
                scaledPolygon.addPoint(x + 10, y + 1);
                scaledPolygon.addPoint(x + 11, y + 1);
                scaledPolygon.addPoint(x + 12, y + 2);
                scaledPolygon.addPoint(x + 13, y + 3);
                scaledPolygon.addPoint(x + 13, y + 4);
                scaledPolygon.addPoint(x + 14, y + 5);
                scaledPolygon.addPoint(x + 14, y + 9);
                scaledPolygon.addPoint(x + 13, y + 10);
                scaledPolygon.addPoint(x + 13, y + 11);
                scaledPolygon.addPoint(x + 12, y + 12);
                scaledPolygon.addPoint(x + 11, y + 13);
                scaledPolygon.addPoint(x + 10, y + 13);
                scaledPolygon.addPoint(x + 9, y + 14);
                scaledPolygon.addPoint(x + 5, y + 14);
                scaledPolygon.addPoint(x + 4, y + 13);
                scaledPolygon.addPoint(x + 3, y + 13);
                scaledPolygon.addPoint(x + 2, y + 12);
                scaledPolygon.addPoint(x + 1, y + 11);
                scaledPolygon.addPoint(x + 1, y + 10);
                scaledPolygon.addPoint(x, y + 9);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 2, y + 2);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y);
                break;
            }
            case 16: {
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 11, y + 1);
                scaledPolygon.addPoint(x + 12, y + 2);
                scaledPolygon.addPoint(x + 13, y + 2);
                scaledPolygon.addPoint(x + 13, y + 3);
                scaledPolygon.addPoint(x + 14, y + 4);
                scaledPolygon.addPoint(x + 15, y + 5);
                scaledPolygon.addPoint(x + 15, y + 10);
                scaledPolygon.addPoint(x + 14, y + 11);
                scaledPolygon.addPoint(x + 13, y + 12);
                scaledPolygon.addPoint(x + 13, y + 13);
                scaledPolygon.addPoint(x + 12, y + 13);
                scaledPolygon.addPoint(x + 11, y + 14);
                scaledPolygon.addPoint(x + 10, y + 15);
                scaledPolygon.addPoint(x + 5, y + 15);
                scaledPolygon.addPoint(x + 4, y + 14);
                scaledPolygon.addPoint(x + 3, y + 13);
                scaledPolygon.addPoint(x + 2, y + 13);
                scaledPolygon.addPoint(x + 2, y + 12);
                scaledPolygon.addPoint(x + 1, y + 11);
                scaledPolygon.addPoint(x, y + 10);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 2, y + 2);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y);
                break;
            }
            case 17: {
                scaledPolygon.addPoint(x + 6, y);
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 11, y + 1);
                scaledPolygon.addPoint(x + 12, y + 1);
                scaledPolygon.addPoint(x + 13, y + 2);
                scaledPolygon.addPoint(x + 14, y + 3);
                scaledPolygon.addPoint(x + 15, y + 4);
                scaledPolygon.addPoint(x + 15, y + 5);
                scaledPolygon.addPoint(x + 16, y + 6);
                scaledPolygon.addPoint(x + 16, y + 10);
                scaledPolygon.addPoint(x + 15, y + 11);
                scaledPolygon.addPoint(x + 15, y + 12);
                scaledPolygon.addPoint(x + 14, y + 13);
                scaledPolygon.addPoint(x + 13, y + 14);
                scaledPolygon.addPoint(x + 12, y + 15);
                scaledPolygon.addPoint(x + 11, y + 15);
                scaledPolygon.addPoint(x + 10, y + 16);
                scaledPolygon.addPoint(x + 6, y + 16);
                scaledPolygon.addPoint(x + 5, y + 15);
                scaledPolygon.addPoint(x + 4, y + 15);
                scaledPolygon.addPoint(x + 3, y + 14);
                scaledPolygon.addPoint(x + 2, y + 13);
                scaledPolygon.addPoint(x + 1, y + 12);
                scaledPolygon.addPoint(x + 1, y + 11);
                scaledPolygon.addPoint(x, y + 10);
                scaledPolygon.addPoint(x, y + 6);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 6, y);
                break;
            }
            case 18: {
                scaledPolygon.addPoint(x + 7, y);
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 11, y + 1);
                scaledPolygon.addPoint(x + 13, y + 1);
                scaledPolygon.addPoint(x + 14, y + 2);
                scaledPolygon.addPoint(x + 15, y + 3);
                scaledPolygon.addPoint(x + 16, y + 4);
                scaledPolygon.addPoint(x + 16, y + 6);
                scaledPolygon.addPoint(x + 17, y + 7);
                scaledPolygon.addPoint(x + 17, y + 10);
                scaledPolygon.addPoint(x + 16, y + 11);
                scaledPolygon.addPoint(x + 16, y + 13);
                scaledPolygon.addPoint(x + 15, y + 14);
                scaledPolygon.addPoint(x + 14, y + 15);
                scaledPolygon.addPoint(x + 13, y + 16);
                scaledPolygon.addPoint(x + 11, y + 16);
                scaledPolygon.addPoint(x + 10, y + 17);
                scaledPolygon.addPoint(x + 7, y + 17);
                scaledPolygon.addPoint(x + 6, y + 16);
                scaledPolygon.addPoint(x + 4, y + 16);
                scaledPolygon.addPoint(x + 3, y + 15);
                scaledPolygon.addPoint(x + 2, y + 14);
                scaledPolygon.addPoint(x + 1, y + 13);
                scaledPolygon.addPoint(x + 1, y + 11);
                scaledPolygon.addPoint(x, y + 10);
                scaledPolygon.addPoint(x, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y);
                break;
            }
            case 19: {
                scaledPolygon.addPoint(x + 7, y);
                scaledPolygon.addPoint(x + 11, y);
                scaledPolygon.addPoint(x + 12, y + 1);
                scaledPolygon.addPoint(x + 13, y + 1);
                scaledPolygon.addPoint(x + 14, y + 2);
                scaledPolygon.addPoint(x + 15, y + 2);
                scaledPolygon.addPoint(x + 16, y + 3);
                scaledPolygon.addPoint(x + 16, y + 4);
                scaledPolygon.addPoint(x + 17, y + 5);
                scaledPolygon.addPoint(x + 17, y + 6);
                scaledPolygon.addPoint(x + 18, y + 7);
                scaledPolygon.addPoint(x + 18, y + 11);
                scaledPolygon.addPoint(x + 17, y + 12);
                scaledPolygon.addPoint(x + 17, y + 13);
                scaledPolygon.addPoint(x + 16, y + 14);
                scaledPolygon.addPoint(x + 16, y + 15);
                scaledPolygon.addPoint(x + 15, y + 16);
                scaledPolygon.addPoint(x + 14, y + 16);
                scaledPolygon.addPoint(x + 13, y + 17);
                scaledPolygon.addPoint(x + 12, y + 17);
                scaledPolygon.addPoint(x + 11, y + 18);
                scaledPolygon.addPoint(x + 7, y + 18);
                scaledPolygon.addPoint(x + 6, y + 17);
                scaledPolygon.addPoint(x + 5, y + 17);
                scaledPolygon.addPoint(x + 4, y + 16);
                scaledPolygon.addPoint(x + 3, y + 16);
                scaledPolygon.addPoint(x + 2, y + 15);
                scaledPolygon.addPoint(x + 2, y + 14);
                scaledPolygon.addPoint(x + 1, y + 13);
                scaledPolygon.addPoint(x + 1, y + 12);
                scaledPolygon.addPoint(x, y + 11);
                scaledPolygon.addPoint(x, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x + 2, y + 4);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 4, y + 2);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y);
                break;
            }
            case 20: {
                scaledPolygon.addPoint(x + 8, y);
                scaledPolygon.addPoint(x + 11, y);
                scaledPolygon.addPoint(x + 12, y + 1);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 15, y + 2);
                scaledPolygon.addPoint(x + 16, y + 3);
                scaledPolygon.addPoint(x + 17, y + 4);
                scaledPolygon.addPoint(x + 18, y + 5);
                scaledPolygon.addPoint(x + 18, y + 7);
                scaledPolygon.addPoint(x + 19, y + 8);
                scaledPolygon.addPoint(x + 19, y + 11);
                scaledPolygon.addPoint(x + 18, y + 12);
                scaledPolygon.addPoint(x + 18, y + 14);
                scaledPolygon.addPoint(x + 17, y + 15);
                scaledPolygon.addPoint(x + 16, y + 16);
                scaledPolygon.addPoint(x + 15, y + 17);
                scaledPolygon.addPoint(x + 14, y + 18);
                scaledPolygon.addPoint(x + 12, y + 18);
                scaledPolygon.addPoint(x + 11, y + 19);
                scaledPolygon.addPoint(x + 8, y + 19);
                scaledPolygon.addPoint(x + 7, y + 18);
                scaledPolygon.addPoint(x + 5, y + 18);
                scaledPolygon.addPoint(x + 4, y + 17);
                scaledPolygon.addPoint(x + 3, y + 16);
                scaledPolygon.addPoint(x + 2, y + 15);
                scaledPolygon.addPoint(x + 1, y + 14);
                scaledPolygon.addPoint(x + 1, y + 12);
                scaledPolygon.addPoint(x, y + 11);
                scaledPolygon.addPoint(x, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x + 2, y + 4);
                scaledPolygon.addPoint(x + 3, y + 3);
                scaledPolygon.addPoint(x + 4, y + 2);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y);
                break;
            }
            case 21: {
                scaledPolygon.addPoint(x + 8, y);
                scaledPolygon.addPoint(x + 12, y);
                scaledPolygon.addPoint(x + 13, y + 1);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 15, y + 2);
                scaledPolygon.addPoint(x + 16, y + 2);
                scaledPolygon.addPoint(x + 17, y + 3);
                scaledPolygon.addPoint(x + 18, y + 4);
                scaledPolygon.addPoint(x + 18, y + 5);
                scaledPolygon.addPoint(x + 19, y + 6);
                scaledPolygon.addPoint(x + 19, y + 7);
                scaledPolygon.addPoint(x + 20, y + 8);
                scaledPolygon.addPoint(x + 20, y + 12);
                scaledPolygon.addPoint(x + 19, y + 13);
                scaledPolygon.addPoint(x + 19, y + 14);
                scaledPolygon.addPoint(x + 18, y + 15);
                scaledPolygon.addPoint(x + 18, y + 16);
                scaledPolygon.addPoint(x + 17, y + 17);
                scaledPolygon.addPoint(x + 16, y + 18);
                scaledPolygon.addPoint(x + 15, y + 18);
                scaledPolygon.addPoint(x + 14, y + 19);
                scaledPolygon.addPoint(x + 13, y + 19);
                scaledPolygon.addPoint(x + 12, y + 20);
                scaledPolygon.addPoint(x + 8, y + 20);
                scaledPolygon.addPoint(x + 7, y + 19);
                scaledPolygon.addPoint(x + 6, y + 19);
                scaledPolygon.addPoint(x + 5, y + 18);
                scaledPolygon.addPoint(x + 4, y + 18);
                scaledPolygon.addPoint(x + 3, y + 17);
                scaledPolygon.addPoint(x + 2, y + 16);
                scaledPolygon.addPoint(x + 2, y + 15);
                scaledPolygon.addPoint(x + 1, y + 14);
                scaledPolygon.addPoint(x + 1, y + 13);
                scaledPolygon.addPoint(x, y + 12);
                scaledPolygon.addPoint(x, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 2, y + 4);
                scaledPolygon.addPoint(x + 3, y + 3);
                scaledPolygon.addPoint(x + 4, y + 2);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y);
                break;
            }
            case 22: {
                scaledPolygon.addPoint(x + 8, y);
                scaledPolygon.addPoint(x + 13, y);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 15, y + 1);
                scaledPolygon.addPoint(x + 16, y + 2);
                scaledPolygon.addPoint(x + 17, y + 2);
                scaledPolygon.addPoint(x + 18, y + 3);
                scaledPolygon.addPoint(x + 19, y + 4);
                scaledPolygon.addPoint(x + 19, y + 5);
                scaledPolygon.addPoint(x + 20, y + 6);
                scaledPolygon.addPoint(x + 20, y + 8);
                scaledPolygon.addPoint(x + 21, y + 9);
                scaledPolygon.addPoint(x + 21, y + 12);
                scaledPolygon.addPoint(x + 20, y + 13);
                scaledPolygon.addPoint(x + 20, y + 15);
                scaledPolygon.addPoint(x + 19, y + 16);
                scaledPolygon.addPoint(x + 19, y + 17);
                scaledPolygon.addPoint(x + 18, y + 18);
                scaledPolygon.addPoint(x + 17, y + 19);
                scaledPolygon.addPoint(x + 16, y + 19);
                scaledPolygon.addPoint(x + 15, y + 20);
                scaledPolygon.addPoint(x + 13, y + 20);
                scaledPolygon.addPoint(x + 12, y + 21);
                scaledPolygon.addPoint(x + 9, y + 21);
                scaledPolygon.addPoint(x + 8, y + 20);
                scaledPolygon.addPoint(x + 6, y + 20);
                scaledPolygon.addPoint(x + 5, y + 19);
                scaledPolygon.addPoint(x + 4, y + 19);
                scaledPolygon.addPoint(x + 3, y + 18);
                scaledPolygon.addPoint(x + 2, y + 17);
                scaledPolygon.addPoint(x + 2, y + 16);
                scaledPolygon.addPoint(x + 1, y + 15);
                scaledPolygon.addPoint(x + 1, y + 14);
                scaledPolygon.addPoint(x, y + 13);
                scaledPolygon.addPoint(x, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 2, y + 4);
                scaledPolygon.addPoint(x + 3, y + 3);
                scaledPolygon.addPoint(x + 4, y + 2);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y);
                break;
            }
            case 23: {
                scaledPolygon.addPoint(x + 9, y);
                scaledPolygon.addPoint(x + 13, y);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 16, y + 1);
                scaledPolygon.addPoint(x + 17, y + 2);
                scaledPolygon.addPoint(x + 18, y + 3);
                scaledPolygon.addPoint(x + 19, y + 3);
                scaledPolygon.addPoint(x + 19, y + 4);
                scaledPolygon.addPoint(x + 20, y + 5);
                scaledPolygon.addPoint(x + 21, y + 6);
                scaledPolygon.addPoint(x + 21, y + 8);
                scaledPolygon.addPoint(x + 22, y + 9);
                scaledPolygon.addPoint(x + 22, y + 13);
                scaledPolygon.addPoint(x + 21, y + 14);
                scaledPolygon.addPoint(x + 21, y + 16);
                scaledPolygon.addPoint(x + 20, y + 17);
                scaledPolygon.addPoint(x + 19, y + 18);
                scaledPolygon.addPoint(x + 19, y + 19);
                scaledPolygon.addPoint(x + 18, y + 19);
                scaledPolygon.addPoint(x + 17, y + 20);
                scaledPolygon.addPoint(x + 16, y + 21);
                scaledPolygon.addPoint(x + 14, y + 21);
                scaledPolygon.addPoint(x + 13, y + 22);
                scaledPolygon.addPoint(x + 9, y + 22);
                scaledPolygon.addPoint(x + 8, y + 21);
                scaledPolygon.addPoint(x + 6, y + 21);
                scaledPolygon.addPoint(x + 5, y + 20);
                scaledPolygon.addPoint(x + 4, y + 19);
                scaledPolygon.addPoint(x + 3, y + 19);
                scaledPolygon.addPoint(x + 3, y + 18);
                scaledPolygon.addPoint(x + 2, y + 17);
                scaledPolygon.addPoint(x + 1, y + 16);
                scaledPolygon.addPoint(x + 1, y + 14);
                scaledPolygon.addPoint(x, y + 13);
                scaledPolygon.addPoint(x, y + 9);
                scaledPolygon.addPoint(x + 1, y + 8);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 3, y + 3);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 8, y + 1);
                scaledPolygon.addPoint(x + 9, y);
                break;
            }
            case 24: {
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 13, y);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 16, y + 1);
                scaledPolygon.addPoint(x + 17, y + 2);
                scaledPolygon.addPoint(x + 18, y + 2);
                scaledPolygon.addPoint(x + 19, y + 3);
                scaledPolygon.addPoint(x + 20, y + 4);
                scaledPolygon.addPoint(x + 21, y + 5);
                scaledPolygon.addPoint(x + 21, y + 6);
                scaledPolygon.addPoint(x + 22, y + 7);
                scaledPolygon.addPoint(x + 22, y + 8);
                scaledPolygon.addPoint(x + 23, y + 9);
                scaledPolygon.addPoint(x + 23, y + 14);
                scaledPolygon.addPoint(x + 22, y + 15);
                scaledPolygon.addPoint(x + 22, y + 16);
                scaledPolygon.addPoint(x + 21, y + 17);
                scaledPolygon.addPoint(x + 21, y + 18);
                scaledPolygon.addPoint(x + 20, y + 19);
                scaledPolygon.addPoint(x + 19, y + 20);
                scaledPolygon.addPoint(x + 18, y + 21);
                scaledPolygon.addPoint(x + 17, y + 21);
                scaledPolygon.addPoint(x + 16, y + 22);
                scaledPolygon.addPoint(x + 14, y + 22);
                scaledPolygon.addPoint(x + 13, y + 23);
                scaledPolygon.addPoint(x + 10, y + 23);
                scaledPolygon.addPoint(x + 9, y + 22);
                scaledPolygon.addPoint(x + 7, y + 22);
                scaledPolygon.addPoint(x + 6, y + 21);
                scaledPolygon.addPoint(x + 5, y + 21);
                scaledPolygon.addPoint(x + 4, y + 20);
                scaledPolygon.addPoint(x + 3, y + 19);
                scaledPolygon.addPoint(x + 2, y + 18);
                scaledPolygon.addPoint(x + 2, y + 17);
                scaledPolygon.addPoint(x + 1, y + 16);
                scaledPolygon.addPoint(x + 1, y + 15);
                scaledPolygon.addPoint(x, y + 14);
                scaledPolygon.addPoint(x, y + 9);
                scaledPolygon.addPoint(x + 1, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 9, y + 1);
                scaledPolygon.addPoint(x + 10, y);
                break;
            }
            case 25: {
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 14, y);
                scaledPolygon.addPoint(x + 15, y + 1);
                scaledPolygon.addPoint(x + 17, y + 1);
                scaledPolygon.addPoint(x + 18, y + 2);
                scaledPolygon.addPoint(x + 19, y + 2);
                scaledPolygon.addPoint(x + 20, y + 3);
                scaledPolygon.addPoint(x + 21, y + 4);
                scaledPolygon.addPoint(x + 22, y + 5);
                scaledPolygon.addPoint(x + 22, y + 6);
                scaledPolygon.addPoint(x + 23, y + 7);
                scaledPolygon.addPoint(x + 23, y + 9);
                scaledPolygon.addPoint(x + 24, y + 10);
                scaledPolygon.addPoint(x + 24, y + 14);
                scaledPolygon.addPoint(x + 23, y + 15);
                scaledPolygon.addPoint(x + 23, y + 17);
                scaledPolygon.addPoint(x + 22, y + 18);
                scaledPolygon.addPoint(x + 22, y + 19);
                scaledPolygon.addPoint(x + 21, y + 20);
                scaledPolygon.addPoint(x + 20, y + 21);
                scaledPolygon.addPoint(x + 19, y + 22);
                scaledPolygon.addPoint(x + 18, y + 22);
                scaledPolygon.addPoint(x + 17, y + 23);
                scaledPolygon.addPoint(x + 15, y + 23);
                scaledPolygon.addPoint(x + 14, y + 24);
                scaledPolygon.addPoint(x + 10, y + 24);
                scaledPolygon.addPoint(x + 9, y + 23);
                scaledPolygon.addPoint(x + 7, y + 23);
                scaledPolygon.addPoint(x + 6, y + 22);
                scaledPolygon.addPoint(x + 5, y + 22);
                scaledPolygon.addPoint(x + 4, y + 21);
                scaledPolygon.addPoint(x + 3, y + 20);
                scaledPolygon.addPoint(x + 2, y + 19);
                scaledPolygon.addPoint(x + 2, y + 18);
                scaledPolygon.addPoint(x + 1, y + 17);
                scaledPolygon.addPoint(x + 1, y + 15);
                scaledPolygon.addPoint(x, y + 14);
                scaledPolygon.addPoint(x, y + 10);
                scaledPolygon.addPoint(x + 1, y + 9);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 9, y + 1);
                scaledPolygon.addPoint(x + 10, y);
                break;
            }
            case 26: {
                scaledPolygon.addPoint(x + 11, y);
                scaledPolygon.addPoint(x + 14, y);
                scaledPolygon.addPoint(x + 15, y + 1);
                scaledPolygon.addPoint(x + 18, y + 1);
                scaledPolygon.addPoint(x + 19, y + 2);
                scaledPolygon.addPoint(x + 20, y + 3);
                scaledPolygon.addPoint(x + 21, y + 3);
                scaledPolygon.addPoint(x + 22, y + 4);
                scaledPolygon.addPoint(x + 22, y + 5);
                scaledPolygon.addPoint(x + 23, y + 6);
                scaledPolygon.addPoint(x + 24, y + 7);
                scaledPolygon.addPoint(x + 24, y + 10);
                scaledPolygon.addPoint(x + 25, y + 11);
                scaledPolygon.addPoint(x + 25, y + 14);
                scaledPolygon.addPoint(x + 24, y + 15);
                scaledPolygon.addPoint(x + 24, y + 18);
                scaledPolygon.addPoint(x + 23, y + 19);
                scaledPolygon.addPoint(x + 22, y + 20);
                scaledPolygon.addPoint(x + 22, y + 21);
                scaledPolygon.addPoint(x + 21, y + 22);
                scaledPolygon.addPoint(x + 20, y + 22);
                scaledPolygon.addPoint(x + 19, y + 23);
                scaledPolygon.addPoint(x + 18, y + 24);
                scaledPolygon.addPoint(x + 15, y + 24);
                scaledPolygon.addPoint(x + 14, y + 25);
                scaledPolygon.addPoint(x + 11, y + 25);
                scaledPolygon.addPoint(x + 10, y + 24);
                scaledPolygon.addPoint(x + 7, y + 24);
                scaledPolygon.addPoint(x + 6, y + 23);
                scaledPolygon.addPoint(x + 5, y + 22);
                scaledPolygon.addPoint(x + 4, y + 22);
                scaledPolygon.addPoint(x + 3, y + 21);
                scaledPolygon.addPoint(x + 3, y + 20);
                scaledPolygon.addPoint(x + 2, y + 19);
                scaledPolygon.addPoint(x + 1, y + 18);
                scaledPolygon.addPoint(x + 1, y + 15);
                scaledPolygon.addPoint(x, y + 14);
                scaledPolygon.addPoint(x, y + 11);
                scaledPolygon.addPoint(x + 1, y + 10);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 3, y + 5);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 5, y + 3);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 10, y + 1);
                scaledPolygon.addPoint(x + 11, y);
            }
        }
        if (!this.m_threed) {
            new DetOval(this.m_Detectiv, this.m_id, scaledRect, this.m_bb, true, scaledPolygon, this.m_rClip);
            return;
        }
        if (this.m_threed) {
            int k;
            int i;
            int i2;
            if (height > 26) {
                scaledPolygon = new Polygon();
                int angle = 240;
                i2 = 0;
                while (i2 < 12) {
                    int x3 = (int)((double)(height / 2) * Math.cos((double)angle * (Math.PI / 180)));
                    int y3 = (int)((double)(height / 2) * Math.sin((double)angle * (Math.PI / 180)));
                    if (angle == 360) {
                        angle = 0;
                    }
                    angle += 30;
                    scaledPolygon.addPoint(x3 + cx, y3 + cy);
                    ++i2;
                }
            }
            this.m_nXDepth = (int)((double)this.m_nXDepth / 2.5);
            this.m_nYDepth = (int)((double)this.m_nYDepth / 2.5);
            Polygon poly = new Polygon();
            i2 = 0;
            while (i2 < scaledPolygon.npoints) {
                poly.addPoint(scaledPolygon.xpoints[i2] + vc.virtToDestWidth(this.m_nXDepth), scaledPolygon.ypoints[i2] - vc.virtToDestHeight(this.m_nYDepth));
                ++i2;
            }
            int start = 0;
            int end = 0;
            double dist = 0.0;
            double leftMostX = 20000.0;
            double rightMostX = 0.0;
            double topMostY = 30000.0;
            if (this.m_nDepthAngle <= 135 && this.m_nDepthAngle >= 45) {
                i = 0;
                while (i < scaledPolygon.npoints) {
                    if (scaledPolygon.ypoints[i] <= cy) {
                        double centerX1 = ((double)scaledPolygon.xpoints[i] + (double)poly.xpoints[i]) / 2.0;
                        if (centerX1 < leftMostX && this.m_nDepthAngle <= 90) {
                            leftMostX = centerX1;
                            start = i;
                        } else if (centerX1 > rightMostX && this.m_nDepthAngle > 90) {
                            rightMostX = centerX1;
                            start = i;
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < scaledPolygon.npoints) {
                    double centerY1;
                    if (scaledPolygon.ypoints[i] <= cy && (centerY1 = ((double)scaledPolygon.ypoints[i] + (double)poly.ypoints[i]) / 2.0) <= topMostY) {
                        topMostY = centerY1;
                        start = i;
                    }
                    ++i;
                }
            }
            dist = 0.0;
            double centerX1 = scaledPolygon.xpoints[start];
            double centerY1 = scaledPolygon.ypoints[start];
            int j = 0;
            while (j < scaledPolygon.npoints) {
                double centerX2 = scaledPolygon.xpoints[j];
                double centerY2 = scaledPolygon.ypoints[j];
                double newDist = Point2D.distance(centerX1, centerY1, centerX2, centerY2);
                if (newDist >= dist) {
                    end = j;
                    dist = newDist;
                }
                ++j;
            }
            Polygon p = new Polygon();
            if (this.m_nDepthAngle <= 90) {
                k = end;
                boolean done = false;
                while (!done) {
                    if (k == start) {
                        done = true;
                    }
                    p.addPoint(poly.xpoints[k], poly.ypoints[k]);
                    if (--k != -1) continue;
                    k = poly.npoints - 1;
                }
                done = false;
                k = start;
                while (!done) {
                    if (k == end) {
                        done = true;
                    }
                    p.addPoint(scaledPolygon.xpoints[k], scaledPolygon.ypoints[k]);
                    if (++k != scaledPolygon.npoints) continue;
                    k = 0;
                }
                p.addPoint(poly.xpoints[end], poly.ypoints[end]);
            }
            if (this.m_nDepthAngle > 90) {
                k = end;
                boolean done = false;
                while (!done) {
                    if (k == start) {
                        done = true;
                    }
                    p.addPoint(poly.xpoints[k], poly.ypoints[k]);
                    if (++k != poly.npoints) continue;
                    k = 0;
                }
                done = false;
                k = start;
                while (!done) {
                    if (k == end) {
                        done = true;
                    }
                    p.addPoint(scaledPolygon.xpoints[k], scaledPolygon.ypoints[k]);
                    if (--k != -1) continue;
                    k = scaledPolygon.npoints - 1;
                }
            }
            new DetOval(this.m_Detectiv, this.m_id, null, this.m_bb, true, p, this.m_rClip);
            IdentObj obj = new IdentObj(this.m_id);
            obj.setMiscID(1);
            new DetOval(this.m_Detectiv, obj, null, this.m_bb, true, scaledPolygon, this.m_rClip);
        }
    }

    public void calcTriangleUp() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        scaledPolygon.addPoint(x, y - height / 2);
        scaledPolygon.addPoint(x + width / 2, y + height / 2);
        scaledPolygon.addPoint(x - width / 2, y + height / 2);
        scaledPolygon.addPoint(x, y - height / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, scaledPolygon, this.m_bb);
        }
        if (this.m_threed) {
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void calcTriangleDn() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        scaledPolygon.addPoint(x, y + height / 2);
        scaledPolygon.addPoint(x + width / 2, y - height / 2);
        scaledPolygon.addPoint(x - height / 2, y - height / 2);
        scaledPolygon.addPoint(x, y + height / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, scaledPolygon, this.m_bb);
        }
        if (this.m_threed) {
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void calcDiamond() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        scaledPolygon.addPoint(x + width / 2, y);
        scaledPolygon.addPoint(x, y - height / 2);
        scaledPolygon.addPoint(x - width / 2, y);
        scaledPolygon.addPoint(x, y + height / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, scaledPolygon, this.m_bb);
        }
        if (this.m_threed) {
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void threedPolygons(Polygon scaledPolygon, VC vc) {
        Vector<Polygon> vectorPolyMarker = new Vector<Polygon>();
        this.m_nXDepth /= 3;
        this.m_nYDepth /= 3;
        int nFace = 0;
        while (nFace < scaledPolygon.npoints) {
            int nSide = (nFace + 1) % scaledPolygon.npoints;
            Polygon polyMarkerSide = new Polygon();
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nFace], scaledPolygon.ypoints[nFace]);
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nSide], scaledPolygon.ypoints[nSide]);
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nSide] + vc.virtToDestWidth(this.m_nXDepth), scaledPolygon.ypoints[nSide] - vc.virtToDestHeight(this.m_nYDepth));
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nFace] + vc.virtToDestWidth(this.m_nXDepth), scaledPolygon.ypoints[nFace] - vc.virtToDestHeight(this.m_nYDepth));
            vectorPolyMarker.addElement(polyMarkerSide);
            ++nFace;
        }
        int nSortType = this.m_nDepthAngle > 90 ? 1 : 0;
        QSortPoly.quickSortPoly(vectorPolyMarker, 0, vectorPolyMarker.size() - 1, nSortType);
        vectorPolyMarker.addElement(scaledPolygon);
        int nPoly = 0;
        while (nPoly < vectorPolyMarker.size()) {
            Polygon p = (Polygon)vectorPolyMarker.elementAt(nPoly);
            IdentObj obj = new IdentObj(this.m_id);
            obj.setMiscID(nPoly);
            new DetPolygon(this.m_Detectiv, obj, p, this.m_bb);
            ++nPoly;
        }
    }

    public void calcPlus() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        int depth = 1;
        boolean done = false;
        while (!done) {
            if (width >= (depth += 2) * 3 + 2) continue;
            done = true;
            depth -= 2;
        }
        int halfDepth = (depth + 1) / 2;
        scaledPolygon.addPoint(x - halfDepth, y - height / 2);
        scaledPolygon.addPoint(x + halfDepth, y - height / 2);
        scaledPolygon.addPoint(x + halfDepth, y - halfDepth);
        scaledPolygon.addPoint(x + height / 2, y - halfDepth);
        scaledPolygon.addPoint(x + height / 2, y + halfDepth);
        scaledPolygon.addPoint(x + halfDepth, y + halfDepth);
        scaledPolygon.addPoint(x + halfDepth, y + height / 2);
        scaledPolygon.addPoint(x - halfDepth, y + height / 2);
        scaledPolygon.addPoint(x - halfDepth, y + halfDepth);
        scaledPolygon.addPoint(x - height / 2, y + halfDepth);
        scaledPolygon.addPoint(x - height / 2, y - halfDepth);
        scaledPolygon.addPoint(x - halfDepth, y - halfDepth);
        scaledPolygon.addPoint(x - halfDepth, y - height / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, scaledPolygon, this.m_bb);
        }
        if (this.m_threed) {
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void calcRect() {
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        int height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        Rectangle scaledRect = new Rectangle(x - width / 2, y - height / 2, width - 1, height - 1);
        if (!this.m_threed) {
            new DetRect(this.m_Detectiv, this.m_id, scaledRect, this.m_bb);
        }
        if (this.m_threed) {
            Polygon scaledPolygon = new Polygon();
            scaledPolygon.addPoint(x - width / 2, y - height / 2);
            scaledPolygon.addPoint(x + width / 2, y - height / 2);
            scaledPolygon.addPoint(x + width / 2, y + height / 2);
            scaledPolygon.addPoint(x - width / 2, y + height / 2);
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void calcLine() {
        int nLineWidth = this.m_template.getLineWidth();
        int nLineStyle = this.m_template.getLineStyle();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        int height = nLineWidth;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        x = vc.destToVirtX(x - width / 2);
        new DetLine(this.m_Detectiv, this.m_id, x, this.m_center.y, x + vc.destToVirtWidth(width - 1), this.m_center.y, this.m_bb, null, nLineWidth, nLineStyle);
    }

    public void calcDrillUp() {
        int width;
        VC vc = this.m_Perspective.getVC();
        int height = width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        Rectangle scaledRect = new Rectangle(x - width / 2, y - height / 2, width - 1, height - 1);
        new DetImage(this.m_Detectiv, this.m_id, this.m_bb, this.m_rClip, false, scaledRect);
    }

    public Point getCenter() {
        return this.m_center;
    }

    public int getMarkerType() {
        return this.m_template.m_markerType;
    }

    public Dimension getSize() {
        return new Dimension(this.m_template.m_rect.width * this.m_markerSizeX / 100, this.m_template.m_rect.height * this.m_markerSizeY / 100);
    }

    public void setReferenceLabel(String str) {
        this.m_szRefLabel = str;
    }

    public double getReferenceData() {
        return this.m_nData;
    }

    public String getReferenceLabel() {
        return this.m_szRefLabel;
    }
}

