/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import tdg.Access;
import tdg.Assert;
import tdg.DataScroller;
import tdg.JChart_Base;
import tdg.LegendMarkersLabels;
import tdg.LegendScroller;
import tdg.Perspective;
import tdg.RelativeAxisObj;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetRect;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;

public class LegendObj
implements Serializable {
    public static final int LAYOUT_VERT = 0;
    public static final int LAYOUT_HORZ = 1;
    public static final int LAYOUT_AUTO = 2;
    public int BOX_MARGIN_HT;
    public int DOUBLE_BOX_MARGIN_HT;
    public int BOX_MARGIN_W;
    public int DOUBLE_BOX_MARGIN_W;
    protected Perspective m_Perspective;
    protected Detectiv m_Detectiv;
    protected IdentObj m_id;
    protected Access m_Access;
    protected JChart_Base m_Chart;
    protected boolean m_bLegendReverse;
    protected boolean m_nBiDirectionalText;
    protected Rectangle m_rVirtLegendBoxCell;
    protected Rectangle m_rLegendBox;
    protected Dimension m_dimCell;
    protected int m_nLayoutOrient;
    protected boolean m_bAutomatic;
    protected DataScroller m_ScrollerSeries;
    protected LegendScroller m_ScrollerLegend;
    protected boolean m_bDataScrollerActive;
    protected int m_nNumberCol;
    protected LegendMarkersLabels m_MarkersLabels;
    protected boolean m_bSpectralLegend;

    public LegendObj(Perspective perspective, Access access, JChart_Base chart, boolean bSpectralLegend) {
        this.m_Perspective = perspective;
        this.m_id = new IdentObj(12);
        this.m_Access = access;
        this.m_Chart = chart;
        this.m_Detectiv = this.m_Perspective.getDetectiv();
        this.m_bSpectralLegend = bSpectralLegend;
        this.BOX_MARGIN_W = this.m_Perspective.getVC().destToVirtWidth(4);
        this.DOUBLE_BOX_MARGIN_W = 2 * this.BOX_MARGIN_W;
        this.BOX_MARGIN_HT = this.m_Perspective.getVC().destToVirtHeight(2);
        this.DOUBLE_BOX_MARGIN_HT = 2 * this.BOX_MARGIN_HT;
        this.m_MarkersLabels = new LegendMarkersLabels(perspective, access, chart, this);
    }

    public void init() {
        this.m_rLegendBox = this.m_Perspective.getLegendRect();
        this.m_rVirtLegendBoxCell = new Rectangle(this.m_rLegendBox.x, this.m_rLegendBox.y, this.m_rLegendBox.width, this.m_rLegendBox.height);
        this.m_nBiDirectionalText = this.m_Perspective.getBiDirectional();
        this.m_bAutomatic = this.m_Perspective.getLegendAutomatic();
        this.m_bLegendReverse = this.m_Perspective.getLegendReverse();
        this.m_nLayoutOrient = this.m_Perspective.getLegendOrient();
        if (this.m_nLayoutOrient == 2) {
            int n = this.m_nLayoutOrient = this.m_rVirtLegendBoxCell.width > this.m_rVirtLegendBoxCell.height ? 1 : 0;
        }
        if (this.m_nBiDirectionalText && this.m_nLayoutOrient == 1) {
            this.m_bLegendReverse = !this.m_bLegendReverse;
        }
        this.m_MarkersLabels.init();
        this.m_MarkersLabels.loadDrillMarker();
        if (this.m_bSpectralLegend) {
            this.m_MarkersLabels.loadSpectralVectors();
        } else {
            this.m_MarkersLabels.loadSeriesVectors();
        }
        this.m_MarkersLabels.loadReferenceLineVectors();
        if (this.m_bAutomatic) {
            double fHeightWidthRatio = (double)this.m_rVirtLegendBoxCell.height / (double)this.m_rVirtLegendBoxCell.width;
            int nNumLabels = this.getSeriesCount();
            this.m_nNumberCol = this.getNumColByNumSeriesAndAspectRatio(nNumLabels, fHeightWidthRatio);
        } else {
            this.m_nNumberCol = this.m_Perspective.getLegendMarkersPerRow();
        }
        if (this.m_nNumberCol <= 0) {
            switch (this.m_nLayoutOrient) {
                case 0: {
                    this.m_nNumberCol = 1;
                    break;
                }
                default: {
                    this.m_nNumberCol = this.getSeriesCount();
                }
            }
        }
        boolean bVertical = this.m_nLayoutOrient == 0;
        this.m_ScrollerSeries = new DataScroller(this.m_Perspective, this.m_rLegendBox, bVertical, false);
        this.m_ScrollerLegend = new LegendScroller(this.m_Perspective, this, this.m_rLegendBox, bVertical);
    }

    protected int getNumColByNumSeriesAndAspectRatio(int nNumSeries, double fHeightWidthRatio) {
        double fMarkerPerCol;
        double fSquareRootNumSeries = Math.sqrt(nNumSeries);
        if (fHeightWidthRatio < 1.0) {
            double fAdjust = 1.0 - fHeightWidthRatio;
            fMarkerPerCol = fSquareRootNumSeries + fAdjust * fSquareRootNumSeries;
        } else {
            double fAdjust = fHeightWidthRatio - 1.0;
            fMarkerPerCol = fSquareRootNumSeries - fAdjust * fSquareRootNumSeries;
            if (fMarkerPerCol <= 1.0) {
                fMarkerPerCol = 1.0;
            }
        }
        int nMarkersPerCol = (int)fMarkerPerCol;
        return nMarkersPerCol;
    }

    public void calc() {
        this.init();
        if (this.m_MarkersLabels.getNumLabels() > 0) {
            this.layoutCells();
            this.m_MarkersLabels.calcMarkerSize();
            this.m_MarkersLabels.calcLabelSize();
            this.calcLegendBox();
            this.m_MarkersLabels.calcMarkers();
            this.m_MarkersLabels.calcLabels();
            if (this.m_bDataScrollerActive) {
                this.m_ScrollerSeries.calc();
            }
            if (this.canScrollLegend()) {
                this.m_ScrollerLegend.calc();
            }
        }
    }

    public boolean canScrollLegend() {
        boolean bLegendScroll = this.m_Perspective.getLegendScroll() == 1 && this.m_Perspective.getLegendSeriesCount() != 0;
        boolean bl = bLegendScroll = bLegendScroll || this.m_Perspective.getLegendScroll() == 2;
        if (this.m_Perspective.getLegendScroll() == 1) {
            bLegendScroll = bLegendScroll && this.m_Perspective.getLegendSeriesCount() < this.getNumItemsInLegend();
        }
        bLegendScroll = bLegendScroll && !this.m_ScrollerSeries.isPresent();
        return bLegendScroll;
    }

    private Dimension cellDimFromCols(Dimension dimStartCell, int nNumColumns) {
        Assert.assert(nNumColumns > 0);
        Assert.assert(this.m_MarkersLabels.getNumLabels() > 0);
        int nNumRows = this.getNumOfRows(nNumColumns);
        int nWidth = dimStartCell.width / nNumColumns;
        int nHeight = dimStartCell.height / nNumRows;
        Dimension cellDim = new Dimension(nWidth, nHeight);
        return cellDim;
    }

    public int getNumOfRows(int nNumColumns) {
        int nNumLabels = this.getSeriesCount();
        int nNumRows = nNumLabels / nNumColumns;
        int nMod = nNumLabels % nNumColumns;
        if (nMod != 0) {
            ++nNumRows;
        }
        return nNumRows;
    }

    public int getNumOfCols() {
        return this.m_nNumberCol;
    }

    public Rectangle getCellRect(int nSeriesRel) {
        int nYGridOffset;
        int nXGridOffset;
        int nTop = this.m_rVirtLegendBoxCell.y + this.m_rVirtLegendBoxCell.height;
        switch (this.m_nLayoutOrient) {
            default: {
                nXGridOffset = nSeriesRel % this.m_nNumberCol;
                nYGridOffset = nSeriesRel / this.m_nNumberCol;
                break;
            }
            case 0: {
                int nNumRows = this.getNumOfRows(this.m_nNumberCol);
                nXGridOffset = nSeriesRel / nNumRows;
                nYGridOffset = nSeriesRel % nNumRows;
            }
        }
        int nX = this.m_rVirtLegendBoxCell.x + this.BOX_MARGIN_W;
        int nY = nTop - this.BOX_MARGIN_HT - this.m_dimCell.height;
        Rectangle rCellTrans = new Rectangle(this.m_dimCell);
        rCellTrans.translate(nX += nXGridOffset * this.m_dimCell.width, nY -= nYGridOffset * this.m_dimCell.height);
        return rCellTrans;
    }

    public void calcLegendBox() {
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_id);
        new DetRect(this.m_Detectiv, this.m_id, this.m_rLegendBox.x, this.m_rLegendBox.y, this.m_rLegendBox.width, this.m_rLegendBox.height, blackBox, true, true);
    }

    public boolean isHorz() {
        return this.m_nLayoutOrient == 0;
    }

    public void layoutCells() {
        Dimension dimStartCell = new Dimension(this.m_rVirtLegendBoxCell.width, this.m_rVirtLegendBoxCell.height);
        dimStartCell.width -= this.DOUBLE_BOX_MARGIN_W;
        dimStartCell.height -= this.DOUBLE_BOX_MARGIN_HT;
        this.adjustForDataScroller(dimStartCell);
        this.adjustForLegendScroller(dimStartCell);
        this.m_dimCell = this.cellDimFromCols(dimStartCell, this.m_nNumberCol);
    }

    protected void adjustForDataScroller(Dimension startCell) {
        boolean bScrollerPresent = this.m_ScrollerSeries.isPresent();
        this.m_bDataScrollerActive = false;
        if (bScrollerPresent) {
            if (this.m_nLayoutOrient == 0) {
                int nScrollerWidth = this.m_ScrollerSeries.getScrollerWidthVC();
                if (nScrollerWidth < this.m_rVirtLegendBoxCell.width / 3) {
                    this.m_bDataScrollerActive = true;
                    startCell.width -= nScrollerWidth;
                    this.m_rVirtLegendBoxCell.x += nScrollerWidth;
                    this.m_rVirtLegendBoxCell.width -= nScrollerWidth;
                }
            } else {
                int nScrollerHeight = this.m_ScrollerSeries.getScrollerHeightVC();
                if (nScrollerHeight < this.m_rVirtLegendBoxCell.height / 3) {
                    this.m_bDataScrollerActive = true;
                    startCell.height -= nScrollerHeight;
                    this.m_rVirtLegendBoxCell.y += nScrollerHeight;
                    this.m_rVirtLegendBoxCell.height -= nScrollerHeight;
                }
            }
        }
    }

    protected void adjustForLegendScroller(Dimension startCell) {
        if (this.canScrollLegend()) {
            if (this.m_nLayoutOrient == 0) {
                int nScrollerWidth = this.m_ScrollerLegend.getScrollerWidthVC();
                if (nScrollerWidth < this.m_rVirtLegendBoxCell.width / 3) {
                    startCell.width -= nScrollerWidth;
                    this.m_rVirtLegendBoxCell.x += nScrollerWidth;
                    this.m_rVirtLegendBoxCell.width -= nScrollerWidth;
                }
            } else {
                int nScrollerHeight = this.m_ScrollerLegend.getScrollerHeightVC();
                if (nScrollerHeight < this.m_rVirtLegendBoxCell.height / 3) {
                    startCell.height -= nScrollerHeight;
                    this.m_rVirtLegendBoxCell.y += nScrollerHeight;
                    this.m_rVirtLegendBoxCell.height -= nScrollerHeight;
                }
            }
        }
    }

    public int getSeriesStart() {
        int nSeriesStart = 0;
        int nCount = this.m_Perspective.getLegendSeriesCount();
        boolean bDataScrolling = this.dataScrolling();
        if (nCount != 0 && !this.m_bDataScrollerActive && !bDataScrolling) {
            int nNumItems;
            int nMinSeriesStart;
            nSeriesStart = this.m_Perspective.getLegendSeriesStart();
            if (nSeriesStart > (nMinSeriesStart = (nNumItems = this.getNumItemsInLegend()) - nCount)) {
                nSeriesStart = nMinSeriesStart;
            }
            if (nSeriesStart < 0) {
                nSeriesStart = 0;
            }
            if (nSeriesStart >= nNumItems) {
                nSeriesStart = 0;
            }
        }
        return nSeriesStart;
    }

    private boolean dataScrolling() {
        int nViewableSeries = this.m_Perspective.getViewableSeries();
        boolean bDataScrolling = nViewableSeries > 0 && nViewableSeries < this.getNumItemsInLegend();
        return bDataScrolling;
    }

    public int getNumItemsInLegend() {
        int nNumLabels = this.m_MarkersLabels.getNumLabels();
        return nNumLabels;
    }

    public int getSeriesCount() {
        int nSeriesCount = 0;
        int nSeriesStart = this.getSeriesStart();
        int nNumItems = this.getNumItemsInLegend();
        boolean bDataScrolling = this.dataScrolling();
        if (this.m_Perspective.getLegendSeriesCount() == 0 || this.m_bDataScrollerActive || bDataScrolling) {
            nSeriesCount = nNumItems;
        } else {
            nSeriesCount = this.m_Perspective.getLegendSeriesCount();
            int nSeriesRange = this.getSeriesStart() + nSeriesCount;
            if (nSeriesRange >= nNumItems) {
                nSeriesCount = nNumItems - nSeriesStart;
            }
        }
        return nSeriesCount;
    }

    public int getSeriesRange() {
        int nNumItems;
        int nSeriesStart = this.getSeriesStart();
        int nSeriesRange = nSeriesStart + this.getSeriesCount();
        if (nSeriesRange > (nNumItems = this.getNumItemsInLegend())) {
            nSeriesRange = nNumItems;
        }
        return nSeriesRange;
    }

    public LegendMarkersLabels getMarkersLabels() {
        return this.m_MarkersLabels;
    }

    public boolean getLegendReverse() {
        return this.m_bLegendReverse;
    }

    public int getLayoutOrient() {
        return this.m_nLayoutOrient;
    }

    public Dimension getDimCell() {
        return this.m_dimCell;
    }

    public boolean isSpectralLegend() {
        return this.m_bSpectralLegend;
    }

    public boolean isDataScrollerActive() {
        return this.m_bDataScrollerActive;
    }

    public void setY1Axis(RelativeAxisObj Y1Axis) {
        this.m_MarkersLabels.setY1Axis(Y1Axis);
    }

    public void releaseReferences() {
        this.m_ScrollerSeries.releaseReferences();
        this.m_ScrollerLegend.releaseReferences();
        this.m_MarkersLabels.releaseReferences();
        this.m_Perspective = null;
    }
}

