/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;
import tdg.Assert;
import tdg.DataRange;
import tdg.DatumObj;
import tdg.GroupsEnumerator;
import tdg.JChart_2D;
import tdg.MinMaxObj;
import tdg.PieFrameObj;
import tdg.PieSliceObj;
import tdg.SeriesEnumerator;
import tdg.TDGNumberFormat;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLabel;
import tdg.draw.DetLine;
import tdg.draw.DetPolygon;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;
import tdg.event.TDGErrorManager;

public class JChart_2D_Pie
extends JChart_2D {
    public static final boolean DEBUG_2D_PIE = false;
    double m_fRingPct;
    double m_fPieTilt;
    double m_fThickness;
    int m_nPiesPerRow;
    int m_bPieLabelDisplay;
    int m_nFeelerTextFormat;
    String m_strFeelerTextFormatPattern;
    int m_nPieFeelerTextDisplay;
    boolean m_bGTHasRing;
    boolean m_bGTProportional;
    boolean m_bGTMultiple;
    boolean m_bShowPieTotal;
    boolean m_bReverseGroups;
    int m_nKissingFeelers;
    int m_nThickOffset;
    int m_nRadius;
    int m_nSaveRadius;
    int m_temp;
    double m_fPieTotal;
    double m_fHighestGroupTotal;
    Rectangle m_rPieFrame;
    PieSliceObj[] m_slices;
    int m_nSliceCount;
    int m_nLabelHeight;
    int m_nXCenter;
    int m_nYCenter;
    Vector m_vectStrLabels;
    Dimension m_labelDimVC;
    int m_nLineWidthFeeler;
    Rectangle m_rOPI_PieFrame;
    int m_nPieBarSlice;
    Point m_ptTopSlice;
    Point m_ptBottomSlice;
    TextStyleObj m_textStyleFeelers;
    boolean[][] m_bSeriesPartOfOther;
    boolean[][] m_bSeriesDrawn;
    boolean m_bOtherPercentage;
    Area m_area;
    double m_xRadius;
    double m_yRadius;
    public static final double SLIGHTLY_SHADED = 0.8;
    public static final double MORE_SHADED = 0.6;
    public static final double MOST_SHADED = 0.4;
    public static final double UNKNOWN_ANGLE = -7.0;
    public static final int TYPE_TOP = 1000;
    public static final int TYPE_LEFT = 2000;
    public static final int TYPE_RIGHT = 3000;
    public static final int TYPE_CRUST = 4000;
    public static final int TYPE_RING = 5000;
    public static final int RADIAL_FEELER = 100;
    public static final int PIVOT_FEELER = 200;
    public static final int PPR_AUTOMATIC = 0;
    public static final int MAX_PIELABELHEIGHT = 2500;
    public static final int LABEL_COMPENSATION = 2;
    public static final int AVG_PIELABEL_SIZE = 4;

    public void calc() {
        super.calc();
        this.calcHighestGroupTotal();
        boolean bOtherSeries = this.m_Perspective.getOtherSeries();
        if (bOtherSeries) {
            this.createSeriesPartOfOther(this.m_nTotalSeries, this.m_nTotalGroups);
            this.createSeriesDrawn(this.m_nTotalSeries, this.m_nTotalGroups);
        }
        this.m_bOtherPercentage = false;
        if (this.m_bGTMultiple) {
            this.calcMultiplePies();
        } else {
            this.calcSinglePie();
        }
        this.fireInapropriateDataEvent();
    }

    public void calcDataScrollers() {
    }

    public void calcHighestGroupTotal() {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_fHighestGroupTotal = 0.0;
        if (this.m_bGTProportional) {
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                double fThisTotal = this.getGroupTotal(g);
                if (!(fThisTotal > this.m_fHighestGroupTotal)) continue;
                this.m_fHighestGroupTotal = fThisTotal;
            }
        }
    }

    public void calcMultiplePies() {
        int nNumPiesLeftOver;
        int nNumRowsY;
        double fSumTotal = 0.0;
        int nNumColsX = this.m_nPiesPerRow;
        if (nNumColsX == 0) {
            nNumColsX = (int)Math.sqrt(this.m_nGroups);
            if (this.m_rOPI_PieFrame.width < (int)((double)this.m_rOPI_PieFrame.height * 0.2) && nNumColsX > 1) {
                --nNumColsX;
            }
            if (this.m_rOPI_PieFrame.width < (int)((double)this.m_rOPI_PieFrame.height * 0.4) && nNumColsX > 1) {
                --nNumColsX;
            }
            if (this.m_rOPI_PieFrame.width > (int)((double)this.m_rOPI_PieFrame.height * 1.3)) {
                ++nNumColsX;
            }
            if (this.m_rOPI_PieFrame.width > (int)((double)this.m_rOPI_PieFrame.height * 2.3)) {
                ++nNumColsX;
            }
            if (nNumColsX < 1) {
                nNumColsX = 1;
            }
        }
        if (nNumColsX > this.m_nGroups) {
            TDGErrorManager errMgr = this.m_Perspective.getErrorManager();
            errMgr.notifyErrorListener(this, 3973, "WARNING: Attempted using PiesPerRow greater than number of groups.", null);
            nNumRowsY = 1;
            nNumColsX = this.m_nGroups;
            nNumPiesLeftOver = 0;
        } else {
            nNumRowsY = (this.m_nGroups - 1) / nNumColsX + 1;
            nNumPiesLeftOver = this.m_nGroups % nNumColsX;
        }
        Rectangle rectSubPie = new Rectangle(this.m_rOPI_PieFrame.x, this.m_rOPI_PieFrame.y, this.m_rOPI_PieFrame.width / nNumColsX, this.m_rOPI_PieFrame.height / nNumRowsY);
        double kLABELSIZINGFACTOR = 0.25;
        this.m_nLabelHeight = (int)((double)rectSubPie.height * kLABELSIZINGFACTOR);
        double kVERTICALEMPTYSPACEFACTOR = 0.1;
        this.m_nRadius = (int)(((double)(rectSubPie.height - this.m_nLabelHeight) - kVERTICALEMPTYSPACEFACTOR * (double)rectSubPie.height) / 2.0);
        double kRADIUSEXTREMEFACTOR = 0.8;
        if ((double)(2 * this.m_nRadius) > (double)rectSubPie.width * kRADIUSEXTREMEFACTOR) {
            double kHORIZONTALEMPTYSPACEFACTOR = 0.2;
            this.m_nRadius = (int)(((double)rectSubPie.width - kHORIZONTALEMPTYSPACEFACTOR * (double)rectSubPie.width) / 2.0);
        }
        this.m_nSaveRadius = this.m_nRadius;
        int nTopX = this.m_rOPI_PieFrame.x;
        int nTopY = this.m_rOPI_PieFrame.y + this.m_rOPI_PieFrame.height - rectSubPie.height;
        nTopY -= this.m_nLabelHeight / 2;
        int nCurrentGroup = 0;
        int nRowY = 0;
        while (nRowY < nNumRowsY) {
            int nCenterLeftOverPieXOffset = this.m_nGroups < nCurrentGroup + nNumColsX ? this.m_rOPI_PieFrame.width / 2 - nNumPiesLeftOver * rectSubPie.width / 2 : 0;
            int nColX = 0;
            while (nColX < nNumColsX) {
                if (nCurrentGroup < this.m_nGroups) {
                    rectSubPie.x = nTopX + nColX * rectSubPie.width + nCenterLeftOverPieXOffset;
                    rectSubPie.y = nTopY - nRowY * rectSubPie.height;
                    rectSubPie.y += this.m_nLabelHeight;
                    this.m_rPieFrame = rectSubPie;
                    double total = this.drawPie(rectSubPie, nCurrentGroup++);
                    fSumTotal += total;
                }
                ++nColX;
            }
            ++nRowY;
        }
    }

    public void calcSinglePie() {
        this.m_rPieFrame = this.m_rOPI_PieFrame;
        this.m_nLabelHeight = Math.min(2000, this.m_rOPI_PieFrame.height / 4);
        this.m_nRadius = this.m_rOPI_PieFrame.height < this.m_rOPI_PieFrame.width ? (int)((double)this.m_rOPI_PieFrame.height / 3.0) : (int)((double)this.m_rOPI_PieFrame.width / 3.5);
        this.m_nSaveRadius = this.m_nRadius;
        double d = this.drawPie(this.m_rOPI_PieFrame, 0);
    }

    public void createFrame() {
        this.m_Frame = new PieFrameObj(this.m_Perspective);
    }

    protected void calcFeelerLabels() {
        double fMaxStrLength = 1.0;
        this.m_vectStrLabels = new Vector(this.m_nSliceCount);
        int idx = 0;
        while (idx < this.m_nSliceCount) {
            String str;
            int s = this.m_slices[idx].m_nSeriesID;
            int g = this.m_slices[idx].m_nGroupID;
            switch (this.m_bPieLabelDisplay) {
                case 0: {
                    if (this.m_Perspective.isNumberFormatCallBack()) {
                        this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                        str = this.m_Perspective.getNumberFormatCallBack().toString(this.m_slices[idx].m_fSliceValue);
                        break;
                    }
                    str = TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, this.m_slices[idx].m_fSliceValue, this.m_strFeelerTextFormatPattern);
                    break;
                }
                case 1: {
                    if (this.m_Perspective.isNumberFormatCallBack()) {
                        this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                        str = this.m_Perspective.getNumberFormatCallBack().toString(this.m_slices[idx].m_fPiePct);
                        break;
                    }
                    str = TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, this.m_slices[idx].m_fPiePct, this.m_strFeelerTextFormatPattern);
                    break;
                }
                case 2: {
                    if (s == -1) {
                        str = this.m_Perspective.PFJRes.getString("OTHER");
                        break;
                    }
                    str = this.m_Perspective.getSeriesLabel(s);
                    break;
                }
                case 3: {
                    str = s == -1 ? this.m_Perspective.PFJRes.getString("OTHER") : this.m_Perspective.getSeriesLabel(s);
                    if (this.m_Perspective.isNumberFormatCallBack()) {
                        this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                        str = str + this.m_Perspective.getNumberFormatCallBack().toString(this.m_slices[idx].m_fPiePct);
                        break;
                    }
                    str = str + " (" + TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, this.m_slices[idx].m_fPiePct, this.m_strFeelerTextFormatPattern) + ")";
                    break;
                }
                default: {
                    str = "!";
                }
            }
            this.m_vectStrLabels.insertElementAt(str, idx);
            if ((double)str.length() > fMaxStrLength) {
                fMaxStrLength = str.length();
            }
            ++idx;
        }
        int nLabelSpace = this.m_gt.isPieBarType() && this.isPieBarSliceOK() ? (int)((double)((this.m_rPieFrame.width - this.m_nRadius * 2) / 2) * 0.4) : (int)((double)((this.m_rPieFrame.width - this.m_nRadius * 2) / 2) * 0.6);
        double fIncreaseFactor = ((fMaxStrLength *= 6.0) - 4.0) / 3.0;
        nLabelSpace = (int)(fIncreaseFactor * (double)nLabelSpace) + nLabelSpace;
        this.m_labelDimVC = new Dimension(nLabelSpace, this.m_nLabelHeight);
        this.setFeelerTextStyle();
    }

    protected void setFeelerTextStyle() {
        IdentObj idFeeler = this.m_Perspective.getPieSliceLabel();
        this.m_textStyleFeelers = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idFeeler), this.m_Perspective.getFontStyle(idFeeler), this.m_Perspective.getFontSizeAbsolute(idFeeler), this.m_Perspective.getFontSize(idFeeler), this.m_Perspective.getFontSizeVC(idFeeler), this.m_Perspective.getTextRotation(idFeeler), this.m_Perspective.getTextJustHoriz(idFeeler), this.m_Perspective.getTextJustVert(idFeeler), false, false, this.m_Perspective.getTextWrap(idFeeler));
        int nFontSizeVC = this.m_Perspective.getFontSizeAbsolute(idFeeler) ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(idFeeler)) : this.m_Perspective.getFontSizeVC(idFeeler);
        Graphics gx = this.m_Perspective.getGraphicsContext();
        this.m_textStyleFeelers.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(idFeeler), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, this.m_vectStrLabels, this.m_labelDimVC, this.m_Perspective.m_VC);
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bGTHasRing = this.m_gt.toString().equals("PIE_RING") || this.m_gt.toString().equals("PIE_RINGMULT") || this.m_gt.toString().equals("PIE_RINGMULTPROP") || this.m_gt.toString().equals("PIE_BAR_RING");
        this.m_bGTProportional = this.m_gt.toString().equals("PIE_MULTPROP") || this.m_gt.toString().equals("PIE_RINGMULTPROP");
        boolean bl = this.m_bGTMultiple = this.m_bGTProportional || this.m_gt.toString().equals("PIE_MULT") || this.m_gt.toString().equals("PIE_RINGMULT");
        if (!this.m_bSmallDataSet && !this.m_bGTMultiple) {
            this.m_bSmallDataSet = this.m_nSeries < 899;
        }
        this.m_nKissingFeelers = 1;
        this.m_fThickness = (double)this.m_Perspective.getPieDepth() / 100.0;
        this.m_bShowPieTotal = this.m_Perspective.getPieRingTotalDisplay();
        this.m_nPiesPerRow = this.m_Perspective.getPiesPerRow();
        this.m_fPieTilt = (double)this.m_Perspective.getPieTilt() / 100.0;
        this.m_nPieFeelerTextDisplay = this.m_Perspective.getPieFeelerTextDisplay();
        this.m_bPieLabelDisplay = this.m_Perspective.getPieLabelDisplay();
        this.m_bReverseGroups = this.m_Perspective.getReverseGroups();
        this.m_nFeelerTextFormat = this.m_Perspective.getPieFeelerTextFormat();
        this.m_strFeelerTextFormatPattern = this.m_Perspective.getPieFeelerTextFormatPattern();
        this.m_fRingPct = this.m_bGTHasRing ? (double)this.m_Perspective.getPieRingSize() / 100.0 : 0.0;
        this.m_nLineWidthFeeler = this.m_Perspective.getLineWidth(this.m_Perspective.getPieFeelerLine());
        this.m_rOPI_PieFrame = this.m_Perspective.getRect(new IdentObj(302));
        this.m_nPieBarSlice = this.m_Perspective.getPieBarSeries();
        Assert.assert(this.m_nPieBarSlice >= 0);
        if (this.m_nPieBarSlice >= this.m_nTotalSeries) {
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            this.m_nPieBarSlice = sEnum.getFirstSeries();
            this.m_Perspective.setPieBarSeries(this.m_nPieBarSlice);
        }
    }

    protected Polygon createTopPoly(PieSliceObj theSlice) {
        double diff;
        Polygon poly = new Polygon();
        int nPoints = theSlice.m_polyCrust.npoints;
        poly.addPoint(theSlice.m_ptRingLeft.x, theSlice.m_ptRingLeft.y);
        int i = 0;
        while (i < nPoints) {
            poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
            ++i;
        }
        if (theSlice.m_nSeriesID == this.m_nPieBarSlice) {
            this.m_ptTopSlice = new Point(theSlice.m_polyCrust.xpoints[0], theSlice.m_polyCrust.ypoints[0]);
            this.m_ptBottomSlice = new Point(theSlice.m_polyCrust.xpoints[nPoints - 1], theSlice.m_polyCrust.ypoints[nPoints - 1]);
        }
        poly.addPoint(theSlice.m_ptRingRight.x, theSlice.m_ptRingRight.y);
        if (theSlice.m_polyRing != null) {
            i = nPoints - 2;
            while (i >= 0) {
                poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i]);
                --i;
            }
            return poly;
        }
        Point pt = this.m_Perspective.getVC().virtToDest(theSlice.m_ptTip);
        Arc2D.Double arc = new Arc2D.Double();
        double startAngle = 360.0 - theSlice.m_fAngleEnd * 360.0 + 90.0;
        if (startAngle > 360.0) {
            startAngle -= 360.0;
        }
        if (theSlice.m_fAngleEnd == 0.0) {
            diff = 360.0 - theSlice.m_fAngleStart * 360.0;
        }
        diff = theSlice.m_fAngleEnd > theSlice.m_fAngleStart ? theSlice.m_fAngleEnd * 360.0 - theSlice.m_fAngleStart * 360.0 : 360.0 - theSlice.m_fAngleStart * 360.0 + theSlice.m_fAngleEnd * 360.0;
        double cornerX = (double)pt.x - this.m_xRadius;
        double cornerY = (double)pt.y - this.m_yRadius;
        double width = this.m_xRadius * 2.0;
        double height = this.m_yRadius * 2.0;
        ((Arc2D)arc).setArc(cornerX, cornerY, width, height, startAngle, diff, 2);
        this.m_area = new Area(arc);
        return poly;
    }

    protected Polygon createCrustPoly(PieSliceObj theSlice) {
        double diff;
        Polygon poly = new Polygon();
        int nPoints = theSlice.m_polyCrust.npoints;
        int i = 0;
        while (i < nPoints) {
            if (theSlice.m_bSliceSplit) {
                if (theSlice.m_ptCenter.y < theSlice.m_ptTip.y) {
                    poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
                } else {
                    poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
                }
            } else {
                poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
            }
            ++i;
        }
        i = nPoints - 1;
        while (i >= 0) {
            poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i] - this.m_nThickOffset);
            --i;
        }
        poly.addPoint(theSlice.m_polyCrust.xpoints[0], theSlice.m_polyCrust.ypoints[0]);
        if (theSlice.m_polyRing != null) {
            return poly;
        }
        Point pt = this.m_Perspective.getVC().virtToDest(theSlice.m_ptTip);
        Arc2D.Double arc = new Arc2D.Double();
        double startAngle = 360.0 - theSlice.m_fAngleEnd * 360.0 + 90.0;
        if (startAngle > 360.0) {
            startAngle -= 360.0;
        }
        if (theSlice.m_fAngleEnd == 0.0) {
            diff = 360.0 - theSlice.m_fAngleStart * 360.0;
        }
        diff = theSlice.m_fAngleEnd > theSlice.m_fAngleStart ? theSlice.m_fAngleEnd * 360.0 - theSlice.m_fAngleStart * 360.0 : 360.0 - theSlice.m_fAngleStart * 360.0 + theSlice.m_fAngleEnd * 360.0;
        double cornerX = (double)pt.x - this.m_xRadius;
        double cornerY = (double)pt.y - this.m_yRadius;
        double width = this.m_xRadius * 2.0;
        double height = this.m_yRadius * 2.0;
        ((Arc2D)arc).setArc(cornerX, cornerY, width, height, startAngle, diff, 2);
        Arc2D.Double arc3D = new Arc2D.Double();
        ((Arc2D)arc3D).setArc(cornerX, cornerY + (double)this.m_Perspective.getVC().virtToDestHeight(this.m_nThickOffset), width, height, startAngle, diff, 2);
        GeneralPath path = new GeneralPath();
        Point2D startOrig = arc.getStartPoint();
        Point2D endOrig = arc.getEndPoint();
        Point2D start3D = arc3D.getStartPoint();
        Point2D end3D = arc3D.getEndPoint();
        path.moveTo((float)startOrig.getX(), (float)startOrig.getY());
        path.lineTo((float)endOrig.getX(), (float)endOrig.getY());
        path.lineTo((float)end3D.getX(), (float)end3D.getY());
        path.lineTo((float)start3D.getX(), (float)start3D.getY());
        path.lineTo((float)startOrig.getX(), (float)startOrig.getY());
        Area area = new Area(arc);
        Area area3D = new Area(arc3D);
        area3D.add(new Area(path));
        area.exclusiveOr(area3D);
        area.intersect(area3D);
        if (startAngle > 270.0 && startAngle < 360.0) {
            GeneralPath leftSideBot = new GeneralPath();
            leftSideBot.moveTo(pt.x, pt.y);
            leftSideBot.lineTo(pt.x, (float)pt.y + (float)this.m_Perspective.getVC().virtToDestHeight(this.m_nThickOffset));
            leftSideBot.lineTo((float)start3D.getX(), (float)start3D.getY());
            leftSideBot.lineTo((float)startOrig.getX(), (float)startOrig.getY());
            leftSideBot.lineTo(pt.x, pt.y);
            area.subtract(new Area(leftSideBot));
        }
        if (startAngle + diff < 270.0 && startAngle + diff > 180.0) {
            GeneralPath rightSideBot = new GeneralPath();
            rightSideBot.moveTo(pt.x, pt.y);
            rightSideBot.lineTo(pt.x, (float)pt.y + (float)this.m_Perspective.getVC().virtToDestHeight(this.m_nThickOffset));
            rightSideBot.lineTo((float)end3D.getX(), (float)end3D.getY());
            rightSideBot.lineTo((float)endOrig.getX(), (float)endOrig.getY());
            rightSideBot.lineTo(pt.x, pt.y);
            area.subtract(new Area(rightSideBot));
        }
        if (startAngle > 0.0 && startAngle < 90.0) {
            GeneralPath rightSideTop = new GeneralPath();
            rightSideTop.moveTo(pt.x, pt.y);
            rightSideTop.lineTo(pt.x, (float)pt.y + (float)this.m_Perspective.getVC().virtToDestHeight(this.m_nThickOffset));
            rightSideTop.lineTo((float)start3D.getX(), (float)start3D.getY());
            rightSideTop.lineTo((float)startOrig.getX(), (float)startOrig.getY());
            rightSideTop.lineTo(pt.x, pt.y);
            area.subtract(new Area(rightSideTop));
        }
        if (startAngle + diff > 90.0 && startAngle + diff < 180.0) {
            GeneralPath leftSideTop = new GeneralPath();
            leftSideTop.moveTo(pt.x, pt.y);
            leftSideTop.lineTo(pt.x, (float)pt.y + (float)this.m_Perspective.getVC().virtToDestHeight(this.m_nThickOffset));
            leftSideTop.lineTo((float)end3D.getX(), (float)end3D.getY());
            leftSideTop.lineTo((float)endOrig.getX(), (float)endOrig.getY());
            leftSideTop.lineTo(pt.x, pt.y);
            area.subtract(new Area(leftSideTop));
        }
        this.m_area = area;
        return poly;
    }

    protected Polygon createLeftPoly(PieSliceObj theSlice) {
        Polygon poly = new Polygon();
        poly.addPoint(theSlice.m_ptCrustLeft.x, theSlice.m_ptCrustLeft.y);
        poly.addPoint(theSlice.m_ptRingLeft.x, theSlice.m_ptRingLeft.y);
        poly.addPoint(theSlice.m_ptRingLeft.x, theSlice.m_ptRingLeft.y - this.m_nThickOffset);
        poly.addPoint(theSlice.m_ptCrustLeft.x, theSlice.m_ptCrustLeft.y - this.m_nThickOffset);
        poly.addPoint(theSlice.m_ptCrustLeft.x, theSlice.m_ptCrustLeft.y);
        return poly;
    }

    protected Polygon createRightPoly(PieSliceObj theSlice) {
        Polygon poly = new Polygon();
        poly.addPoint(theSlice.m_ptRingRight.x, theSlice.m_ptRingRight.y);
        poly.addPoint(theSlice.m_ptCrustRight.x, theSlice.m_ptCrustRight.y);
        poly.addPoint(theSlice.m_ptCrustRight.x, theSlice.m_ptCrustRight.y - this.m_nThickOffset);
        poly.addPoint(theSlice.m_ptRingRight.x, theSlice.m_ptRingRight.y - this.m_nThickOffset);
        return poly;
    }

    protected Polygon createRingPoly(PieSliceObj theSlice) {
        Polygon poly = new Polygon();
        int nPoints = theSlice.m_polyRing.npoints;
        int i = 0;
        while (i < nPoints) {
            if (theSlice.m_bSliceSplit) {
                if (theSlice.m_ptCenter.y < theSlice.m_ptTip.y) {
                    poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i] - 100);
                } else {
                    poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i] + 100);
                }
            } else {
                poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i]);
            }
            ++i;
        }
        i = nPoints - 1;
        while (i >= 0) {
            poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i] - this.m_nThickOffset);
            --i;
        }
        poly.addPoint(theSlice.m_polyRing.xpoints[0], theSlice.m_polyRing.ypoints[0]);
        return poly;
    }

    protected PieSliceObj createSliceObj(int nCenterX, int nCenterY, int nRadius, double fStart, double fEnd, int nDetatch, double fAngleDet, double fTilt, double fRing) {
        double fAngle;
        PieSliceObj theSlice = new PieSliceObj();
        double fXSquashRatio = 1.0;
        MinMaxObj m_minmax_y = new MinMaxObj();
        Rectangle destRect = this.m_Perspective.m_VC.getDestCoords();
        double fYSquashRatio = Math.abs((double)destRect.width) / (double)destRect.height;
        if ((fYSquashRatio -= fYSquashRatio * fTilt) > 1.0) {
            fXSquashRatio = 1.0 / fYSquashRatio;
            fYSquashRatio = 1.0;
        }
        this.m_xRadius = this.m_Perspective.getVC().virtToDestWidth((double)nRadius * fXSquashRatio);
        this.m_yRadius = this.m_Perspective.getVC().virtToDestHeight((double)nRadius * fYSquashRatio);
        if (fStart == 0.125) {
            fStart += 1.0E-12;
        }
        if (fStart == 0.375) {
            fStart -= 1.0E-12;
        }
        if (fStart == 0.625) {
            fStart -= 1.0E-12;
        }
        if (fStart == 0.875) {
            fStart -= 1.0E-12;
        }
        int nTipX = nCenterX;
        int nTipY = nCenterY;
        double fDist = fEnd - fStart;
        double f12OClock = -1.5707963267948966;
        theSlice.m_bSliceSplit = false;
        theSlice.m_fAngleStart = fStart - Math.floor(fStart);
        theSlice.m_fAngleEnd = fEnd - Math.floor(fEnd);
        theSlice.m_fAngleAvg = fStart + fDist / 2.0;
        theSlice.m_fAngleAvg -= Math.floor(theSlice.m_fAngleAvg);
        this.calcSlicePositionAndOrient(theSlice);
        theSlice.m_nDetatch = nDetatch;
        if (nDetatch > 0) {
            fAngle = fAngleDet == -7.0 ? f12OClock + (fStart + fDist / 2.0) * (Math.PI * 2) : fAngleDet;
            theSlice.m_fAngleDet = fAngle;
            nTipX = nCenterX + (int)(Math.cos(fAngle) * fXSquashRatio * (double)nDetatch);
            nTipY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * (double)nDetatch);
        }
        theSlice.m_polyCrust = new Polygon();
        theSlice.m_polyRing = fRing > 0.0 ? new Polygon() : null;
        theSlice.m_ptTip = new Point(nTipX, nTipY);
        m_minmax_y.testRawValue(nTipY);
        fAngle = f12OClock + theSlice.m_fAngleAvg * (Math.PI * 2);
        this.calcFeelerPoints(theSlice, m_minmax_y, nTipX, nTipY, nRadius, fAngle, fRing, fXSquashRatio, fYSquashRatio);
        this.calcArcPoints(theSlice, m_minmax_y, nTipX, nTipY, f12OClock, fStart, fEnd, nRadius, fRing, fXSquashRatio, fYSquashRatio);
        theSlice.m_fHighestY = m_minmax_y.getRawMax();
        theSlice.m_fLowestY = m_minmax_y.getRawMin();
        return theSlice;
    }

    protected void calcArcPoints(PieSliceObj theSlice, MinMaxObj m_minmax_y, int nCenterX, int nCenterY, double f12OClock, double fStart, double fEnd, double fRadius, double fRing, double fXSquashRatio, double fYSquashRatio) {
        int nPosY;
        int nPosX;
        double fAngle;
        double fArcLength = fEnd - fStart;
        double fNumPixelsInArc = this.getNumPixelsInArc(nCenterX, nCenterY, f12OClock, fStart, fEnd, fRadius);
        double fNumPixelsPerArcSegment = 1.0 / this.m_Perspective.getNumPieArcSegmentsPerPixel();
        double fSegmentArcInc = fNumPixelsPerArcSegment / fNumPixelsInArc * fArcLength;
        double fPos = fStart;
        while (fPos < fEnd) {
            fAngle = f12OClock + fPos * (Math.PI * 2);
            nPosX = nCenterX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius);
            nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
            theSlice.m_polyCrust.addPoint(nPosX, nPosY);
            m_minmax_y.testRawValue(nPosY);
            if (fRing > 0.0) {
                nPosX = nCenterX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * (fRadius * fRing));
                nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * (fRadius * fRing));
                theSlice.m_polyRing.addPoint(nPosX, nPosY);
                m_minmax_y.testRawValue(nPosY);
            }
            fPos += fSegmentArcInc;
        }
        fAngle = f12OClock + fEnd * (Math.PI * 2);
        nPosX = nCenterX + (int)(Math.cos(fAngle) * fXSquashRatio * fRadius);
        nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
        theSlice.m_polyCrust.addPoint(nPosX, nPosY);
        m_minmax_y.testRawValue(nPosY);
        if (fRing > 0.0) {
            nPosX = nCenterX + (int)(Math.cos(fAngle) * fXSquashRatio * (fRadius * fRing));
            nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * (fRadius * fRing));
            theSlice.m_polyRing.addPoint(nPosX, nPosY);
            m_minmax_y.testRawValue(nPosY);
        }
        int nLastPoint = theSlice.m_polyCrust.npoints - 1;
        theSlice.m_ptCrustLeft = new Point(theSlice.m_polyCrust.xpoints[0], theSlice.m_polyCrust.ypoints[0]);
        theSlice.m_ptCrustRight = new Point(theSlice.m_polyCrust.xpoints[nLastPoint], theSlice.m_polyCrust.ypoints[nLastPoint]);
        if (fRing > 0.0) {
            theSlice.m_ptRingLeft = new Point(theSlice.m_polyRing.xpoints[0], theSlice.m_polyRing.ypoints[0]);
            theSlice.m_ptRingRight = new Point(theSlice.m_polyRing.xpoints[nLastPoint], theSlice.m_polyRing.ypoints[nLastPoint]);
        } else {
            theSlice.m_ptRingLeft = new Point(nCenterX, nCenterY);
            theSlice.m_ptRingRight = new Point(nCenterX, nCenterY);
        }
    }

    public double getNumPixelsInArc(int nCenterX, int nCenterY, double f12OClock, double fStart, double fEnd, double fRadius) {
        double fAngleStart = f12OClock + fStart * (Math.PI * 2);
        double fAngleEnd = f12OClock + fEnd * (Math.PI * 2);
        double fRadianPieSliceAngle = fAngleEnd - fAngleStart;
        double fXSquashRatio = 1.0;
        Rectangle destRect = this.m_Perspective.m_VC.getDestCoords();
        double fYSquashRatio = Math.abs((double)destRect.width) / (double)destRect.height;
        if (fYSquashRatio > 1.0) {
            fXSquashRatio = 1.0 / fYSquashRatio;
            fYSquashRatio = 1.0;
        }
        double fAngle = f12OClock + fStart * (Math.PI * 2);
        int nStartArcPosX = nCenterX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius);
        int nStartArcPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
        int nDestCenterX = this.m_Perspective.m_VC.virtToDestX(nCenterX);
        int nDestCenterY = this.m_Perspective.m_VC.virtToDestX(nCenterY);
        int nDestStartArcPosX = this.m_Perspective.m_VC.virtToDestX(nStartArcPosX);
        int nDestStartArcPosY = this.m_Perspective.m_VC.virtToDestX(nStartArcPosY);
        double fXSquared = Math.pow(nDestStartArcPosX - nDestCenterX, 2.0);
        double fYSquared = Math.pow(nDestStartArcPosY - nDestCenterY, 2.0);
        double fDestRadius = Math.sqrt(fXSquared + fYSquared);
        double fNumPixelsInArc = fDestRadius * fRadianPieSliceAngle;
        return fNumPixelsInArc;
    }

    protected void calcFeelerPoints(PieSliceObj theSlice, MinMaxObj m_minmax_y, int nTipX, int nTipY, double fRadius, double fAngle, double fRing, double fXSquashRatio, double fYSquashRatio) {
        double fAttach;
        int nPosY;
        int nPosX;
        if (this.m_nKissingFeelers == 1) {
            nPosX = nTipX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius);
            nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
            theSlice.m_ptCenter = new Point(nPosX, nPosY);
        } else {
            fAttach = fRadius * (fRing + (1.0 - fRing) / 1.5);
            nPosX = nTipX + (int)(Math.cos(fAngle) * fXSquashRatio * fAttach);
            nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fAttach);
            theSlice.m_ptCenter = new Point(nPosX, nPosY);
            m_minmax_y.testRawValue(nPosY);
        }
        double fBloom = 0.25 - Math.abs(0.5 - theSlice.m_fAngleAvg);
        if (fBloom < 0.0) {
            fBloom = 0.0;
        }
        fAttach = fRadius * (1.2 + (fBloom *= 4.0) * (0.3 * this.m_fThickness + 0.5 * this.m_fPieTilt));
        nPosX = nTipX + (int)(Math.cos(fAngle) * fXSquashRatio * fAttach);
        nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fAttach);
        theSlice.m_ptFeelerJoint = new Point(nPosX, nPosY);
        m_minmax_y.testRawValue(nPosY);
    }

    protected void calcSlicePositionAndOrient(PieSliceObj theSlice) {
        if ((theSlice.m_fAngleStart >= 0.75 || theSlice.m_fAngleStart <= 0.25) && (theSlice.m_fAngleEnd >= 0.75 || theSlice.m_fAngleEnd <= 0.25)) {
            theSlice.m_nSliceType = 10;
        } else if (theSlice.m_fAngleStart >= 0.25 && theSlice.m_fAngleStart <= 0.75 && theSlice.m_fAngleEnd >= 0.25 && theSlice.m_fAngleEnd <= 0.75) {
            theSlice.m_nSliceType = 20;
            if (theSlice.m_fAngleStart == 0.25 || theSlice.m_fAngleEnd == 0.75) {
                theSlice.m_nSliceType = 21;
            }
        } else {
            theSlice.m_nSliceType = theSlice.m_fAngleStart < 0.5 ? 1 : 2;
        }
        if (theSlice.m_fAngleEnd < theSlice.m_fAngleStart && theSlice.m_fAngleStart < 0.75) {
            theSlice.m_nSliceType = 3;
        }
        if (theSlice.m_fAngleEnd > theSlice.m_fAngleStart && theSlice.m_fAngleEnd - theSlice.m_fAngleStart > 0.5) {
            theSlice.m_nSliceType = 3;
        }
        if (theSlice.m_nSliceType != 1 && theSlice.m_nSliceType != 2 && theSlice.m_nSliceType != 3 && theSlice.m_fAngleStart < 0.5 && theSlice.m_fAngleEnd >= 0.5) {
            theSlice.m_nSliceType = 22;
        }
        theSlice.m_nSliceSide = theSlice.m_fAngleAvg > 0.0 && theSlice.m_fAngleAvg <= 0.5 ? 1 : 0;
    }

    protected double drawPie(Rectangle rcPieFrame, int nPieGroupRel) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        GroupsEnumerator gEnumRev = this.getResetGroupsEnumerator(false);
        int g = gEnum.getAbsoluteGroup(nPieGroupRel);
        this.m_nXCenter = this.m_rPieFrame.x + this.m_rPieFrame.width / 2;
        this.m_nYCenter = this.m_rPieFrame.y + this.m_rPieFrame.height / 2;
        if (this.m_gt.isPieBarType() && this.isPieBarSliceOK()) {
            this.m_nXCenter = this.m_rPieFrame.x + this.m_rPieFrame.width * 9 / 20;
        }
        this.m_nThickOffset = (int)(this.m_fThickness * (double)(this.m_rPieFrame.height / 10));
        this.m_slices = new PieSliceObj[this.m_nTotalSeries + 5];
        if (this.m_gt.isPieBarType()) {
            this.m_fHighestGroupTotal = this.m_fPieTotal = this.getSumTotal();
        } else {
            this.m_fPieTotal = this.getGroupTotal(g);
        }
        if (this.m_fPieTotal > 0.0) {
            if (this.m_bGTProportional && this.m_fHighestGroupTotal > 0.0) {
                double fPct = this.m_fPieTotal / this.m_fHighestGroupTotal;
                this.m_nRadius = (int)((double)this.m_nSaveRadius * fPct);
            }
            this.createSliceObjects(g);
            if (this.m_nPieFeelerTextDisplay > 0) {
                this.calcFeelerLabels();
            }
            this.splitSpanningSlices();
            this.sortSlicesBackToFront();
            if (this.m_nThickOffset == 0) {
                this.drawAllSliceTops();
            } else {
                this.drawBackFacingSlices();
                this.drawThresholdSlices();
                this.drawFrontFacingSlices();
                this.drawFrontMostSlice();
                this.drawAllSliceTops();
            }
            this.drawAllSliceLabels();
            int gReverse = this.m_bReverseGroups ? gEnumRev.getAbsoluteGroup(nPieGroupRel) : g;
            if (this.m_bShowPieTotal && this.m_bGTHasRing) {
                this.drawRingLabel(gReverse);
            }
            if (this.m_Perspective.getDisplay(296)) {
                this.drawPieGroupLabel(gReverse);
            }
        }
        return this.m_fPieTotal;
    }

    protected void createSliceObjects(int g) {
        double fSliceEnd;
        double fSlicePct;
        int nDetach;
        double fDetach;
        double fValue;
        int s;
        double fOtherPct = 0.0;
        boolean bOtherSeries = this.m_Perspective.getOtherSeries();
        boolean nTotalSeriesCount = false;
        double fOtherPercentage = this.m_Perspective.getOtherPercentage() / 100.0;
        double fCurrAngle = this.getPieRotation();
        this.m_nSliceCount = 0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            fValue = this.m_gt.isPieBarType() ? this.getSeriesTotal(s) : this.getDataValue((int)s, (int)g).m_fValue;
            if (fValue > 0.0) {
                fDetach = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0 : 0.0;
                nDetach = (int)(fDetach * 1500.0);
                fSlicePct = fValue / this.m_fPieTotal;
                if (bOtherSeries && fSlicePct < fOtherPercentage) {
                    fOtherPct += fSlicePct;
                    this.setSeriesPartOfOther(s, g, true);
                    continue;
                }
                fSliceEnd = fCurrAngle + fSlicePct;
                this.m_slices[this.m_nSliceCount] = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurrAngle, fSliceEnd, nDetach, -7.0, this.m_fPieTilt, this.m_fRingPct);
                this.m_slices[this.m_nSliceCount].m_nSeriesID = s;
                this.m_slices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
                this.m_slices[this.m_nSliceCount].m_nGroupID = g;
                this.m_slices[this.m_nSliceCount].m_fPiePct = fSlicePct;
                this.m_slices[this.m_nSliceCount].m_fSliceValue = fValue;
                this.m_slices[this.m_nSliceCount].m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false;
                fCurrAngle = fSliceEnd;
                ++this.m_nSliceCount;
                if (!bOtherSeries) continue;
                this.setSeriesDrawn(s, g, true);
                continue;
            }
            if (fValue == 0.0) {
                if (!bOtherSeries) continue;
                this.setSeriesDrawn(s, g, false);
                continue;
            }
            if (!bOtherSeries) continue;
            this.setSeriesDrawn(s, g, false);
        }
        if (fOtherPct > 0.0) {
            s = -1;
            fValue = fOtherPct * this.m_fPieTotal;
            fDetach = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0 : 0.0;
            nDetach = (int)(fDetach * 1500.0);
            fSlicePct = fOtherPct;
            fSliceEnd = fCurrAngle + fSlicePct;
            this.m_slices[this.m_nSliceCount] = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurrAngle, fSliceEnd, nDetach, -7.0, this.m_fPieTilt, this.m_fRingPct);
            this.m_slices[this.m_nSliceCount].m_nSeriesID = s;
            this.m_slices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
            this.m_slices[this.m_nSliceCount].m_nGroupID = g;
            this.m_slices[this.m_nSliceCount].m_fPiePct = fSlicePct;
            this.m_slices[this.m_nSliceCount].m_fSliceValue = fValue;
            this.m_slices[this.m_nSliceCount].m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false;
            fCurrAngle = fSliceEnd;
            ++this.m_nSliceCount;
        }
    }

    protected void splitSpanningSlices() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            double fStart = this.m_slices[sRel].m_fAngleStart;
            double fEnd = this.m_slices[sRel].m_fAngleEnd;
            double fCurr = fStart;
            double fNext = 2.25;
            if (fEnd < fStart) {
                fEnd += 1.0;
            }
            if (this.m_slices[sRel].m_nSliceType == 1 || this.m_slices[sRel].m_nSliceType == 2 || this.m_slices[sRel].m_nSliceType == 3) {
                while (fCurr < fEnd) {
                    if (fCurr < 1.75) {
                        fNext = 1.75;
                    }
                    if (fCurr < 1.25) {
                        fNext = 1.25;
                    }
                    if (fCurr < 0.75) {
                        fNext = 0.75;
                    }
                    if (fCurr < 0.25) {
                        fNext = 0.25;
                    }
                    if (fNext > fEnd) {
                        fNext = fEnd;
                    }
                    if (Math.abs(fNext - fCurr) < 1.0E-5) {
                        fCurr = fEnd;
                        continue;
                    }
                    this.m_slices[this.m_nSliceCount] = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurr, fNext, this.m_slices[sRel].m_nDetatch, this.m_slices[sRel].m_fAngleDet, this.m_fPieTilt, this.m_fRingPct);
                    this.m_slices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
                    this.m_slices[this.m_nSliceCount].m_nSeriesID = this.m_slices[sRel].m_nSeriesID;
                    this.m_slices[this.m_nSliceCount].m_nGroupID = this.m_slices[sRel].m_nGroupID;
                    this.m_slices[this.m_nSliceCount].m_fPiePct = this.m_slices[sRel].m_fPiePct;
                    this.m_slices[this.m_nSliceCount].m_fSliceValue = this.m_slices[sRel].m_fSliceValue;
                    this.m_slices[this.m_nSliceCount].m_bSliceDeleted = this.m_slices[sRel].m_bSliceDeleted;
                    this.m_slices[this.m_nSliceCount].m_bSliceSplit = true;
                    ++this.m_nSliceCount;
                    fCurr = fNext;
                }
                this.m_slices[sRel].m_nSliceType = 4;
            }
            ++sRel;
        }
    }

    protected void sortSlicesBackToFront() {
        int nStartElement = 0;
        int nEndElement = nStartElement + this.m_nSliceCount - 1;
        int i = nStartElement;
        while (i < nEndElement) {
            int j = i + 1;
            while (j <= nEndElement) {
                boolean nResult;
                if (this.m_slices[j].m_ptCenter.y > this.m_nYCenter) {
                    nResult = this.m_slices[i].m_fHighestY < this.m_slices[j].m_fHighestY;
                } else {
                    boolean bl = nResult = this.m_slices[i].m_fLowestY < this.m_slices[j].m_fLowestY;
                }
                if (nResult) {
                    PieSliceObj tempObj = this.m_slices[i];
                    this.m_slices[i] = this.m_slices[j];
                    this.m_slices[j] = tempObj;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void drawAllSliceTops() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && !this.m_slices[sRel].m_bSliceSplit) {
                this.drawSliceTop(this.m_slices[sRel]);
            }
            ++sRel;
        }
    }

    protected void drawBackFacingSlices() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!(this.m_slices[sRel].m_bSliceDeleted || this.m_slices[sRel].m_nDetatch == 0 && this.m_fRingPct <= 0.0 || this.m_slices[sRel].m_nSliceType != 10)) {
                this.drawSliceCrust(this.m_slices[sRel]);
                if (this.m_bSmallDataSet) {
                    if (this.m_slices[sRel].m_nSliceSide == 1) {
                        this.drawSliceLeftEdge(this.m_slices[sRel]);
                        this.drawSliceRightEdge(this.m_slices[sRel]);
                    } else {
                        this.drawSliceRightEdge(this.m_slices[sRel]);
                        this.drawSliceLeftEdge(this.m_slices[sRel]);
                    }
                }
                this.drawSliceRing(this.m_slices[sRel]);
            }
            ++sRel;
        }
    }

    protected void drawThresholdSlices() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && this.m_slices[sRel].m_nSliceType == 21) {
                this.drawSliceRing(this.m_slices[sRel]);
                if (this.m_bSmallDataSet) {
                    if (this.m_slices[sRel].m_nSliceSide == 1) {
                        this.drawSliceLeftEdge(this.m_slices[sRel]);
                        this.drawSliceRightEdge(this.m_slices[sRel]);
                    } else {
                        this.drawSliceRightEdge(this.m_slices[sRel]);
                        this.drawSliceLeftEdge(this.m_slices[sRel]);
                    }
                }
                this.drawSliceCrust(this.m_slices[sRel]);
            }
            ++sRel;
        }
    }

    protected void drawFrontFacingSlices() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && this.m_slices[sRel].m_nSliceType == 20) {
                this.drawSliceRing(this.m_slices[sRel]);
                if (this.m_bSmallDataSet) {
                    if (this.m_slices[sRel].m_nSliceSide == 1) {
                        this.drawSliceLeftEdge(this.m_slices[sRel]);
                        this.drawSliceRightEdge(this.m_slices[sRel]);
                    } else {
                        this.drawSliceRightEdge(this.m_slices[sRel]);
                        this.drawSliceLeftEdge(this.m_slices[sRel]);
                    }
                }
                this.drawSliceCrust(this.m_slices[sRel]);
            }
            ++sRel;
        }
    }

    protected void drawFrontMostSlice() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && this.m_slices[sRel].m_nSliceType == 22) {
                this.drawSliceRing(this.m_slices[sRel]);
                if (this.m_bSmallDataSet) {
                    this.drawSliceLeftEdge(this.m_slices[sRel]);
                    this.drawSliceRightEdge(this.m_slices[sRel]);
                }
                this.drawSliceCrust(this.m_slices[sRel]);
            }
            ++sRel;
        }
    }

    protected void drawPieGroupLabel(int nPieGroup) {
        IdentObj id;
        DataRange drViewSG = this.m_Perspective.getViewableDataRangeSG();
        int nViewGroupStart = drViewSG.getColStart();
        int nViewGroupStop = drViewSG.getColStop();
        int nLowestY = this.m_bGTMultiple ? this.m_rPieFrame.y - this.m_nLabelHeight / 2 : this.m_rPieFrame.y;
        int nLabelSize = (int)((double)this.m_rPieFrame.width / 1.2);
        Rectangle rGroupLabel = new Rectangle(this.m_nXCenter - nLabelSize / 2, nLowestY, nLabelSize, this.m_nLabelHeight);
        String szPieLabel = this.m_gt.isPieBarType() ? (this.m_Perspective.getPieBarLabelDisplay() ? this.m_Perspective.getPieBarLabelString() : "") : this.m_Perspective.getGroupLabel(nPieGroup);
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(296);
            id.setMiscID(nPieGroup);
        } else {
            id = new IdentObj(296, -3, nPieGroup);
        }
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        boolean bPieGroupLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bPieGroupLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), this.m_Perspective.getAutofit(id), false, this.m_Perspective.getTextWrap(id));
        new DetLabel(this.m_Detectiv, id, szPieLabel, rGroupLabel, textStyleObj, blackBoxLabel, false);
    }

    protected void drawRingLabel(int nPieGroup) {
        String str;
        double fDataTextValue;
        String szFormatPattern = this.m_Perspective.getPieRingTotalFormatPattern();
        int nFormat = this.m_Perspective.getPieRingTotalFormat();
        double fLabelSize = (double)this.m_nRadius * 1.5;
        int nLabelSize = (int)fLabelSize;
        Dimension labelDim = new Dimension(nLabelSize, nLabelSize);
        double d = fDataTextValue = TDGNumberFormat.isPercentFormat(nFormat) ? 1.0 : this.m_fPieTotal;
        if (this.m_Perspective.isNumberFormatCallBack()) {
            this.m_Perspective.getNumberFormatCallBack().setState(2, -3, -3, -1, -3);
            str = this.m_Perspective.getNumberFormatCallBack().toString(fDataTextValue);
        } else {
            str = TDGNumberFormat.toString(this.m_Perspective, nFormat, fDataTextValue, szFormatPattern);
        }
        IdentObj id = this.m_Perspective.getPieRingLabel();
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        boolean bPieRingLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bPieRingLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), 1, 1, false, false, this.m_Perspective.getTextWrap(id));
        Graphics gx = this.m_Perspective.getGraphicsContext();
        Vector<String> vStrRingLabels = new Vector<String>();
        vStrRingLabels.addElement(str);
        int nFontSizeVC = bPieRingLabelFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyleObj.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(id), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vStrRingLabels, labelDim, this.m_Perspective.m_VC);
        Rectangle rRingLabel = new Rectangle(this.m_nXCenter - labelDim.width / 2, this.m_nYCenter - labelDim.height / 2, labelDim.width, labelDim.height);
        id = new IdentObj(id.getObjectID(), -3, nPieGroup);
        new DetLabel(this.m_Detectiv, id, str, rRingLabel, textStyleObj, blackBoxLabel, false);
    }

    protected void drawAllSliceLabels() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && !this.m_slices[sRel].m_bSliceSplit && this.m_nPieFeelerTextDisplay > 0) {
                this.drawSliceLabel(this.m_slices[sRel]);
            }
            ++sRel;
        }
        if (this.m_nPieFeelerTextDisplay == 1) {
            this.repositionSliceLabels();
            this.repositionFeelerLines();
        }
    }

    protected void repositionFeelerLines() {
        Point ptStartOfRadialLine = null;
        Point ptEndOfRadialLine = null;
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && !this.m_slices[sRel].m_bSliceSplit) {
                Rectangle rLabelPos;
                Rectangle LabelBackgroundPosition = rLabelPos = this.m_slices[sRel].getLabel().getBounds();
                this.m_slices[sRel].getLabelBackground().setBounds(LabelBackgroundPosition);
                DetLine LabelPivotLine = this.m_slices[sRel].getPivotLine();
                DetLine LabelRadialLine = this.m_slices[sRel].getRadialLine();
                Point ptEndOfPivotLine = LabelPivotLine.getEndPoint();
                ptEndOfPivotLine.y = rLabelPos.y + rLabelPos.height / 2;
                ptEndOfPivotLine.x = this.m_slices[sRel].m_nSliceSide == 0 ? rLabelPos.x + rLabelPos.width + 300 : rLabelPos.x - 300;
                Point ptStartOfPivotLine = LabelPivotLine.getBeginPoint();
                ptStartOfPivotLine.y = ptEndOfPivotLine.y;
                ptEndOfRadialLine = LabelRadialLine.getEndPoint();
                ptStartOfRadialLine = LabelRadialLine.getBeginPoint();
                ptStartOfPivotLine.x = ptEndOfRadialLine.x;
                LabelPivotLine.setBeginPoint(ptStartOfPivotLine);
                LabelPivotLine.setEndPoint(ptEndOfPivotLine);
                if (this.m_slices[sRel].m_nSliceSide == 0) {
                    if (ptStartOfPivotLine.x < ptEndOfRadialLine.x) {
                        ptEndOfRadialLine.x = ptStartOfPivotLine.x;
                    } else {
                        ptStartOfPivotLine.x = ptEndOfRadialLine.x;
                    }
                    ptEndOfRadialLine.y = ptStartOfPivotLine.y;
                    if (ptStartOfPivotLine.x < ptEndOfPivotLine.x) {
                        this.m_Detectiv.removeDetNode(LabelPivotLine);
                    }
                    if (ptEndOfRadialLine.x < rLabelPos.x + rLabelPos.width + 300) {
                        ptEndOfRadialLine.x = rLabelPos.x + rLabelPos.width + 150;
                    }
                    if (ptEndOfRadialLine.x > ptStartOfRadialLine.x) {
                        ptEndOfRadialLine.x = ptStartOfRadialLine.x;
                    }
                } else {
                    if (ptStartOfPivotLine.x > ptEndOfRadialLine.x) {
                        ptEndOfRadialLine.x = ptStartOfPivotLine.x;
                    } else {
                        ptStartOfPivotLine.x = ptEndOfRadialLine.x;
                    }
                    ptEndOfRadialLine.y = ptStartOfPivotLine.y;
                    if (ptStartOfPivotLine.x > ptEndOfPivotLine.x) {
                        this.m_Detectiv.removeDetNode(LabelPivotLine);
                    }
                    if (ptEndOfRadialLine.x > rLabelPos.x - 300) {
                        ptEndOfRadialLine.x = rLabelPos.x - 150;
                    }
                    if (ptEndOfRadialLine.x < ptStartOfRadialLine.x) {
                        ptEndOfRadialLine.x = ptStartOfRadialLine.x;
                    }
                }
                LabelRadialLine.setBeginPoint(ptStartOfRadialLine);
                LabelRadialLine.setEndPoint(ptEndOfRadialLine);
                LabelPivotLine.setBeginPoint(ptStartOfPivotLine);
            }
            ++sRel;
        }
    }

    PieSliceObj nextSliceOnSide(int SeriesOrdinal) {
        PieSliceObj anotherSliceObj = null;
        int aSide = this.m_slices[SeriesOrdinal].m_nSliceSide;
        int sRel = SeriesOrdinal + 1;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && !this.m_slices[sRel].m_bSliceSplit && this.m_slices[sRel].m_nSliceSide == aSide) {
                anotherSliceObj = this.m_slices[sRel];
                break;
            }
            ++sRel;
        }
        return anotherSliceObj;
    }

    protected void repositionSliceLabels() {
        Rectangle rAnotherLabelPos;
        int s;
        boolean bAnyCollisions = false;
        boolean bIntersectingLabels = true;
        boolean bDoSortOnLabels = true;
        Rectangle rLabelPos = null;
        PieSliceObj TopLabelSlice = null;
        PieSliceObj MiddleLabelSlice = null;
        PieSliceObj BottomLabelSlice = null;
        PieSliceObj NextSlice = null;
        int counter = 0;
        while (bIntersectingLabels) {
            bIntersectingLabels = false;
            if (counter == 2) break;
            s = 0;
            while (s < this.m_nSliceCount) {
                if (!this.m_slices[s].m_bSliceDeleted && !this.m_slices[s].m_bSliceSplit) {
                    if (s == 0) {
                        ++counter;
                    }
                    rLabelPos = this.m_slices[s].getLabel().getBounds();
                    int s1 = 0;
                    while (s1 < this.m_nSliceCount) {
                        if (!this.m_slices[s1].m_bSliceDeleted && !this.m_slices[s1].m_bSliceSplit && s1 != s && rLabelPos.intersects(rAnotherLabelPos = this.m_slices[s1].getLabel().getBounds())) {
                            bAnyCollisions = true;
                            bIntersectingLabels = true;
                            rAnotherLabelPos.y = this.m_slices[s1].m_nSliceSide == 1 ? (this.m_slices[s].m_fAngleAvg > this.m_slices[s1].m_fAngleAvg ? rLabelPos.y + rLabelPos.height + 50 : rLabelPos.y - rLabelPos.height - 50) : (this.m_slices[s].m_fAngleAvg < this.m_slices[s1].m_fAngleAvg ? rLabelPos.y + rLabelPos.height + 50 : rLabelPos.y - rLabelPos.height - 50);
                            this.m_slices[s1].getLabel().setBounds(rAnotherLabelPos);
                            this.m_slices[s1].getLabelBackground().setBounds(rAnotherLabelPos);
                        }
                        ++s1;
                    }
                }
                ++s;
            }
        }
        while (bDoSortOnLabels) {
            bDoSortOnLabels = false;
            s = 0;
            while (s < this.m_nSliceCount) {
                if (!this.m_slices[s].m_bSliceDeleted && !this.m_slices[s].m_bSliceSplit && (NextSlice = this.nextSliceOnSide(s)) != null) {
                    if (this.m_slices[s].m_nSliceSide == 1) {
                        if (NextSlice.getLabel().getBounds().y < this.m_slices[s].getLabel().getBounds().y && NextSlice.m_fAngleAvg < this.m_slices[s].m_fAngleAvg || NextSlice.getLabel().getBounds().y > this.m_slices[s].getLabel().getBounds().y && NextSlice.m_fAngleAvg > this.m_slices[s].m_fAngleAvg) {
                            bDoSortOnLabels = true;
                            rLabelPos = this.m_slices[s].getLabel().getBounds();
                            rAnotherLabelPos = NextSlice.getLabel().getBounds();
                            this.m_slices[s].getLabel().setBounds(rAnotherLabelPos);
                            this.m_slices[s].getLabelBackground().setBounds(rAnotherLabelPos);
                            NextSlice.getLabel().setBounds(rLabelPos);
                            NextSlice.getLabelBackground().setBounds(rLabelPos);
                        }
                    } else if (NextSlice.getLabel().getBounds().y < this.m_slices[s].getLabel().getBounds().y && NextSlice.m_fAngleAvg > this.m_slices[s].m_fAngleAvg || NextSlice.getLabel().getBounds().y > this.m_slices[s].getLabel().getBounds().y && NextSlice.m_fAngleAvg < this.m_slices[s].m_fAngleAvg) {
                        bDoSortOnLabels = true;
                        rLabelPos = this.m_slices[s].getLabel().getBounds();
                        rAnotherLabelPos = NextSlice.getLabel().getBounds();
                        this.m_slices[s].getLabel().setBounds(rAnotherLabelPos);
                        this.m_slices[s].getLabelBackground().setBounds(rAnotherLabelPos);
                        NextSlice.getLabel().setBounds(rLabelPos);
                        NextSlice.getLabelBackground().setBounds(rLabelPos);
                    }
                }
                ++s;
            }
        }
        if (bAnyCollisions) {
            TopLabelSlice = null;
            MiddleLabelSlice = null;
            BottomLabelSlice = null;
            s = 0;
            while (s < this.m_nSliceCount) {
                if (!this.m_slices[s].m_bSliceDeleted && !this.m_slices[s].m_bSliceSplit && this.m_slices[s].m_nSliceSide == 0) {
                    if (TopLabelSlice == null) {
                        TopLabelSlice = this.m_slices[s];
                    }
                    if (BottomLabelSlice == null) {
                        BottomLabelSlice = this.m_slices[s];
                    }
                    if (MiddleLabelSlice == null) {
                        MiddleLabelSlice = this.m_slices[s];
                    }
                    if (this.m_slices[s].m_fAngleAvg > TopLabelSlice.m_fAngleAvg) {
                        TopLabelSlice = this.m_slices[s];
                    }
                    if (this.m_slices[s].m_fAngleAvg < BottomLabelSlice.m_fAngleAvg) {
                        BottomLabelSlice = this.m_slices[s];
                    }
                    if (Math.abs(this.m_slices[s].m_fAngleAvg - 0.75) < Math.abs(MiddleLabelSlice.m_fAngleAvg - 0.75)) {
                        MiddleLabelSlice = this.m_slices[s];
                    }
                }
                ++s;
            }
            int ShiftValue = this.m_rPieFrame.y + this.m_rPieFrame.height / 2;
            ShiftValue -= BottomLabelSlice.getLabel().getBounds().y + (TopLabelSlice.getLabel().getBounds().y - BottomLabelSlice.getLabel().getBounds().y) / 2;
            int s2 = 0;
            while (s2 < this.m_nSliceCount) {
                if (!this.m_slices[s2].m_bSliceDeleted && !this.m_slices[s2].m_bSliceSplit && this.m_slices[s2].m_nSliceSide == 0) {
                    rLabelPos = this.m_slices[s2].getLabel().getBounds();
                    rLabelPos.y += ShiftValue;
                    this.m_slices[s2].getLabel().setBounds(rLabelPos);
                    this.m_slices[s2].getLabelBackground().setBounds(rLabelPos);
                }
                ++s2;
            }
            ShiftValue = MiddleLabelSlice.getRadialLine().getEndPoint().y;
            ShiftValue -= MiddleLabelSlice.getLabel().getBounds().y;
            int s3 = 0;
            while (s3 < this.m_nSliceCount) {
                if (!this.m_slices[s3].m_bSliceDeleted && !this.m_slices[s3].m_bSliceSplit && this.m_slices[s3].m_nSliceSide == 0 && this.m_slices[s3].m_fAngleAvg >= MiddleLabelSlice.m_fAngleAvg) {
                    rLabelPos = this.m_slices[s3].getLabel().getBounds();
                    rLabelPos.y += ShiftValue;
                    this.m_slices[s3].getLabel().setBounds(rLabelPos);
                    this.m_slices[s3].getLabelBackground().setBounds(rLabelPos);
                }
                ++s3;
            }
            NextSlice = BottomLabelSlice;
            int s4 = 0;
            while (s4 < this.m_nSliceCount) {
                if (!this.m_slices[s4].m_bSliceDeleted && !this.m_slices[s4].m_bSliceSplit && this.m_slices[s4].m_nSliceSide == 0 && this.m_slices[s4].m_fAngleAvg < MiddleLabelSlice.m_fAngleAvg && this.m_slices[s4].m_fAngleAvg > NextSlice.m_fAngleAvg) {
                    NextSlice = this.m_slices[s4];
                }
                ++s4;
            }
            ShiftValue = NextSlice.getRadialLine().getEndPoint().y;
            ShiftValue -= NextSlice.getLabel().getBounds().y;
            int s5 = 0;
            while (s5 < this.m_nSliceCount) {
                if (!this.m_slices[s5].m_bSliceDeleted && !this.m_slices[s5].m_bSliceSplit && this.m_slices[s5].m_nSliceSide == 0 && this.m_slices[s5].m_fAngleAvg <= NextSlice.m_fAngleAvg) {
                    rLabelPos = this.m_slices[s5].getLabel().getBounds();
                    rLabelPos.y += ShiftValue;
                    this.m_slices[s5].getLabel().setBounds(rLabelPos);
                    this.m_slices[s5].getLabelBackground().setBounds(rLabelPos);
                }
                ++s5;
            }
            TopLabelSlice = null;
            MiddleLabelSlice = null;
            BottomLabelSlice = null;
            int s6 = 0;
            while (s6 < this.m_nSliceCount) {
                if (!this.m_slices[s6].m_bSliceDeleted && !this.m_slices[s6].m_bSliceSplit && this.m_slices[s6].m_nSliceSide == 1) {
                    if (TopLabelSlice == null) {
                        TopLabelSlice = this.m_slices[s6];
                    }
                    if (BottomLabelSlice == null) {
                        BottomLabelSlice = this.m_slices[s6];
                    }
                    if (MiddleLabelSlice == null) {
                        MiddleLabelSlice = this.m_slices[s6];
                    }
                    if (this.m_slices[s6].m_fAngleAvg < TopLabelSlice.m_fAngleAvg) {
                        TopLabelSlice = this.m_slices[s6];
                    }
                    if (this.m_slices[s6].m_fAngleAvg > BottomLabelSlice.m_fAngleAvg) {
                        BottomLabelSlice = this.m_slices[s6];
                    }
                    if (Math.abs(this.m_slices[s6].m_fAngleAvg - 0.25) < Math.abs(MiddleLabelSlice.m_fAngleAvg - 0.25)) {
                        MiddleLabelSlice = this.m_slices[s6];
                    }
                }
                ++s6;
            }
            ShiftValue = this.m_rPieFrame.y + this.m_rPieFrame.height / 2;
            ShiftValue -= BottomLabelSlice.getLabel().getBounds().y + (TopLabelSlice.getLabel().getBounds().y - BottomLabelSlice.getLabel().getBounds().y) / 2;
            int s7 = 0;
            while (s7 < this.m_nSliceCount) {
                if (!this.m_slices[s7].m_bSliceDeleted && !this.m_slices[s7].m_bSliceSplit && this.m_slices[s7].m_nSliceSide == 1) {
                    rLabelPos = this.m_slices[s7].getLabel().getBounds();
                    rLabelPos.y += ShiftValue;
                    this.m_slices[s7].getLabel().setBounds(rLabelPos);
                    this.m_slices[s7].getLabelBackground().setBounds(rLabelPos);
                }
                ++s7;
            }
            ShiftValue = MiddleLabelSlice.getRadialLine().getEndPoint().y;
            ShiftValue -= MiddleLabelSlice.getLabel().getBounds().y;
            int s8 = 0;
            while (s8 < this.m_nSliceCount) {
                if (!this.m_slices[s8].m_bSliceDeleted && !this.m_slices[s8].m_bSliceSplit && this.m_slices[s8].m_nSliceSide == 1 && this.m_slices[s8].m_fAngleAvg <= MiddleLabelSlice.m_fAngleAvg) {
                    rLabelPos = this.m_slices[s8].getLabel().getBounds();
                    rLabelPos.y += ShiftValue;
                    this.m_slices[s8].getLabel().setBounds(rLabelPos);
                    this.m_slices[s8].getLabelBackground().setBounds(rLabelPos);
                }
                ++s8;
            }
            NextSlice = BottomLabelSlice;
            int s9 = 0;
            while (s9 < this.m_nSliceCount) {
                if (!this.m_slices[s9].m_bSliceDeleted && !this.m_slices[s9].m_bSliceSplit && this.m_slices[s9].m_nSliceSide == 1 && this.m_slices[s9].m_fAngleAvg > MiddleLabelSlice.m_fAngleAvg && this.m_slices[s9].m_fAngleAvg < NextSlice.m_fAngleAvg) {
                    NextSlice = this.m_slices[s9];
                }
                ++s9;
            }
            ShiftValue = NextSlice.getRadialLine().getEndPoint().y;
            ShiftValue -= NextSlice.getLabel().getBounds().y;
            int s10 = 0;
            while (s10 < this.m_nSliceCount) {
                if (!this.m_slices[s10].m_bSliceDeleted && !this.m_slices[s10].m_bSliceSplit && this.m_slices[s10].m_nSliceSide == 1 && this.m_slices[s10].m_fAngleAvg >= NextSlice.m_fAngleAvg) {
                    rLabelPos = this.m_slices[s10].getLabel().getBounds();
                    rLabelPos.y += ShiftValue;
                    this.m_slices[s10].getLabel().setBounds(rLabelPos);
                    this.m_slices[s10].getLabelBackground().setBounds(rLabelPos);
                }
                ++s10;
            }
        }
    }

    protected void drawSliceLabel(PieSliceObj theSlice) {
        IdentObj idBackground;
        IdentObj id;
        Point[] ptPolyline = new Point[4];
        Rectangle rLabel = null;
        Graphics gx = this.m_Perspective.getGraphicsContext();
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(295, theSlice.m_nSeriesID);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(295, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        BlackBoxObj rBlackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        rBlackBoxLabel.setTransparentFillColor(true);
        rBlackBoxLabel.setTransparentBorderColor(true);
        IdentObj idColor = new IdentObj(294);
        switch (this.m_nPieFeelerTextDisplay) {
            case 0: {
                return;
            }
            case 1: {
                BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idColor);
                if (theSlice.m_nSliceSide == 0) {
                    rLabel = this.LeftSiderLabelPos(theSlice, blackBox);
                    break;
                }
                rLabel = this.RightSiderLabelPos(theSlice, blackBox);
                break;
            }
            case 2: {
                if (theSlice.m_nSliceSide == 0) {
                    rLabel = new Rectangle(theSlice.m_ptFeelerJoint.x - this.m_labelDimVC.width / 2 - this.m_labelDimVC.width / 4, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_labelDimVC.width, this.m_labelDimVC.height);
                    break;
                }
                rLabel = new Rectangle(theSlice.m_ptFeelerJoint.x - this.m_labelDimVC.width / 2 + this.m_labelDimVC.width / 4, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_labelDimVC.width, this.m_labelDimVC.height);
                break;
            }
            default: {
                double position = 0.6666666666666666;
                IdentObj idFeeler = this.m_Perspective.getPieSliceLabel();
                int nFontSizeVC = this.m_Perspective.getFontSizeAbsolute(idFeeler) ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(idFeeler)) : this.m_Perspective.getFontSizeVC(idFeeler);
                int centerX = 0;
                int centerY = 0;
                if (this.m_nSliceCount < 20) {
                    int nPoints = theSlice.m_polyCrust.npoints;
                    Polygon poly = new Polygon();
                    poly.addPoint(theSlice.m_ptRingLeft.x, theSlice.m_ptRingLeft.y);
                    int i = 0;
                    while (i < nPoints) {
                        poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
                        ++i;
                    }
                    poly.addPoint(theSlice.m_ptRingRight.x, theSlice.m_ptRingRight.y);
                    if (theSlice.m_polyRing != null) {
                        int i2 = nPoints - 2;
                        while (i2 >= 0) {
                            poly.addPoint(theSlice.m_polyRing.xpoints[i2], theSlice.m_polyRing.ypoints[i2]);
                            --i2;
                        }
                    }
                    int tipX = 0;
                    int tipY = 0;
                    if (theSlice.m_polyRing != null) {
                        tipX = theSlice.m_polyRing.xpoints[theSlice.m_polyRing.npoints / 2];
                        tipY = theSlice.m_polyRing.ypoints[theSlice.m_polyRing.npoints / 2];
                    } else {
                        tipX = theSlice.m_ptRingRight.x;
                        tipY = theSlice.m_ptRingRight.y;
                    }
                    boolean done = false;
                    while (!done) {
                        int diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                        int diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                        centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                        centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
                        Dimension dim = new Dimension(32000, 32000);
                        Vector vector = new Vector();
                        vector.add(this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx));
                        this.m_textStyleFeelers.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(idFeeler), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vector, dim, this.m_Perspective.m_VC);
                        int x = centerX - dim.width / 2;
                        int y = centerY - dim.height / 2;
                        int x2 = x + dim.width;
                        int y2 = y + dim.height;
                        if (!(poly.contains(x, y) && poly.contains(x2, y) && poly.contains(x, y2) && poly.contains(x2, y2))) {
                            done = false;
                            if (position == 0.6666666666666666) {
                                position = 0.5;
                                continue;
                            }
                            if (position != 0.5) continue;
                            done = true;
                            position = 0.6666666666666666;
                            diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                            diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                            centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                            centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
                            continue;
                        }
                        done = true;
                    }
                } else {
                    int tipX = 0;
                    int tipY = 0;
                    if (theSlice.m_polyRing != null) {
                        tipX = theSlice.m_polyRing.xpoints[theSlice.m_polyRing.npoints / 2];
                        tipY = theSlice.m_polyRing.ypoints[theSlice.m_polyRing.npoints / 2];
                    } else {
                        tipX = theSlice.m_ptRingRight.x;
                        tipY = theSlice.m_ptRingRight.y;
                    }
                    int diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                    int diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                    centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                    centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
                }
                rLabel = new Rectangle(centerX - this.m_labelDimVC.width / 2, centerY - this.m_labelDimVC.height / 2, this.m_labelDimVC.width, this.m_labelDimVC.height);
            }
        }
        if (this.m_gt.isPieBarType()) {
            idBackground = new IdentObj(388, theSlice.m_nSeriesID);
            idBackground.setMiscID(theSlice.m_nGroupID);
        } else {
            idBackground = new IdentObj(388, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        theSlice.setLabelBackground(new DetRect(this.m_Detectiv, idBackground, rLabel.x, rLabel.y, rLabel.width, rLabel.height, rBlackBoxLabel, false, false));
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        theSlice.setLabel(new DetLabel(this.m_Detectiv, id, (String)this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx), rLabel, this.m_textStyleFeelers, blackBoxLabel, false));
    }

    protected Rectangle LeftSiderLabelPos(PieSliceObj theSlice, BlackBoxObj blackBox) {
        IdentObj idFeeler;
        Point[] ptPolyline = new Point[4];
        if (this.m_gt.isPieBarType()) {
            idFeeler = new IdentObj(294, theSlice.m_nSeriesID);
            idFeeler.setMiscID(theSlice.m_nGroupID);
        } else {
            idFeeler = new IdentObj(294, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        Rectangle rLeftSiderLabel = new Rectangle(this.m_rPieFrame.x + 300, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_labelDimVC.width, this.m_labelDimVC.height);
        ptPolyline[0] = new Point(theSlice.m_ptCenter.x, theSlice.m_ptCenter.y);
        ptPolyline[1] = new Point(theSlice.m_ptFeelerJoint.x, theSlice.m_ptFeelerJoint.y);
        ptPolyline[2] = new Point(this.m_rPieFrame.x + (this.m_labelDimVC.width + 400), theSlice.m_ptFeelerJoint.y);
        IdentObj newID = new IdentObj(idFeeler);
        newID.setMiscID(100);
        theSlice.setRadialLine(new DetLine(this.m_Detectiv, newID, ptPolyline[0].x, ptPolyline[0].y, ptPolyline[1].x, ptPolyline[1].y, blackBox, null, this.m_nLineWidthFeeler));
        newID = new IdentObj(idFeeler);
        newID.setMiscID(200);
        theSlice.setPivotLine(new DetLine(this.m_Detectiv, newID, ptPolyline[1].x, ptPolyline[1].y, ptPolyline[2].x, ptPolyline[2].y, blackBox, null, this.m_nLineWidthFeeler));
        return rLeftSiderLabel;
    }

    protected Rectangle RightSiderLabelPos(PieSliceObj theSlice, BlackBoxObj blackBox) {
        Point[] ptPolyline = new Point[4];
        int nBarThick = this.getBarThickness();
        IdentObj idFeeler = new IdentObj(294, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        Rectangle rRightSiderLabel = new Rectangle(this.m_rPieFrame.x + this.m_rPieFrame.width - nBarThick - (300 + this.m_labelDimVC.width), theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_labelDimVC.width, this.m_labelDimVC.height);
        ptPolyline[0] = new Point(theSlice.m_ptCenter.x, theSlice.m_ptCenter.y);
        ptPolyline[1] = new Point(theSlice.m_ptFeelerJoint.x, theSlice.m_ptFeelerJoint.y);
        ptPolyline[2] = new Point(this.m_rPieFrame.x + this.m_rPieFrame.width - nBarThick - (this.m_labelDimVC.width + 600), theSlice.m_ptFeelerJoint.y);
        IdentObj newID = new IdentObj(idFeeler);
        newID.setMiscID(100);
        theSlice.setRadialLine(new DetLine(this.m_Detectiv, newID, ptPolyline[0].x, ptPolyline[0].y, ptPolyline[1].x, ptPolyline[1].y, blackBox, null, this.m_nLineWidthFeeler));
        newID = new IdentObj(idFeeler);
        newID.setMiscID(200);
        theSlice.setPivotLine(new DetLine(this.m_Detectiv, newID, ptPolyline[1].x, ptPolyline[1].y, ptPolyline[2].x, ptPolyline[2].y, blackBox, null, this.m_nLineWidthFeeler));
        return rRightSiderLabel;
    }

    protected void drawSliceCrust(PieSliceObj theSlice) {
        IdentObj id;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        Polygon polygon = this.createCrustPoly(theSlice);
        id.setMiscID(4000 + theSlice.m_nSliceIdx);
        double fIntensity = 0.6;
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, fIntensity, false, this.m_area);
        }
    }

    protected void drawSliceLeftEdge(PieSliceObj theSlice) {
        IdentObj id;
        if (theSlice.m_nDetatch == 0) {
            return;
        }
        double fIntensity = 0.8;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        Polygon polygon = this.createLeftPoly(theSlice);
        id.setMiscID(2000 + theSlice.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, fIntensity, false);
        }
    }

    protected void drawSliceRightEdge(PieSliceObj theSlice) {
        IdentObj id;
        if (theSlice.m_nDetatch == 0) {
            return;
        }
        double fIntensity = 0.4;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        Polygon polygon = this.createRightPoly(theSlice);
        id.setMiscID(3000 + theSlice.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, fIntensity, false);
        }
    }

    protected void drawSliceRing(PieSliceObj theSlice) {
        IdentObj id;
        if (this.m_fRingPct <= 0.0) {
            return;
        }
        double fIntensity = 0.6;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        Polygon polygon = this.createRingPoly(theSlice);
        id.setMiscID(5000 + theSlice.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, fIntensity, false);
        }
    }

    protected void drawSliceTop(PieSliceObj theSlice) {
        IdentObj id;
        int nObjectID = this.getSliceObjectID(298);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        Polygon polygon = this.createTopPoly(theSlice);
        id.setMiscID(1000);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, 1.0, true, this.m_area);
        }
    }

    public double getGroupTotal(int g) {
        double fPosSum = 0.0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            DatumObj dobj = this.getDataValue(s, g);
            double fValue = dobj.m_fValue;
            if (fValue > 0.0) {
                fPosSum += fValue;
                this.m_positiveVal = true;
                continue;
            }
            if (fValue == 0.0 && dobj.m_bOK) {
                this.m_zeroVal = true;
                continue;
            }
            if (!(fValue < 0.0)) continue;
            this.m_negativeVal = true;
        }
        return fPosSum;
    }

    public double getSeriesTotal(int s) {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fPosSum = 0.0;
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            DatumObj dobj = this.getDataValue(s, g);
            double fValue = dobj.m_fValue;
            if (fValue > 0.0) {
                fPosSum += fValue;
                this.m_positiveVal = true;
                continue;
            }
            if (fValue == 0.0 && dobj.m_bOK) {
                this.m_zeroVal = true;
                continue;
            }
            if (!(fValue < 0.0)) continue;
            this.m_negativeVal = true;
        }
        return fPosSum;
    }

    public double getSumTotal() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fPosSum = 0.0;
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                double fValue = this.getDataValue((int)s, (int)g).m_fValue;
                if (!(fValue > 0.0)) continue;
                fPosSum += fValue;
            }
        }
        return fPosSum;
    }

    private void createSeriesPartOfOther(int nNumSeries, int nNumGroups) {
        this.m_bSeriesPartOfOther = new boolean[nNumSeries][nNumGroups];
        int nSeries = 0;
        while (nSeries < nNumSeries) {
            int nGroup = 0;
            while (nGroup < nNumGroups) {
                this.m_bSeriesPartOfOther[nSeries][nGroup] = false;
                ++nGroup;
            }
            ++nSeries;
        }
    }

    private void createSeriesDrawn(int nNumSeries, int nNumGroups) {
        this.m_bSeriesDrawn = new boolean[nNumSeries][nNumGroups];
        int nSeries = 0;
        while (nSeries < nNumSeries) {
            int nGroup = 0;
            while (nGroup < nNumGroups) {
                this.m_bSeriesDrawn[nSeries][nGroup] = false;
                ++nGroup;
            }
            ++nSeries;
        }
    }

    private void setSeriesPartOfOther(int nSeries, int nGroup, boolean bValue) {
        if (this.m_bSeriesPartOfOther != null) {
            this.m_bSeriesPartOfOther[nSeries][nGroup] = bValue;
        }
        if (bValue) {
            this.m_bOtherPercentage = true;
        }
    }

    private void setSeriesDrawn(int nSeries, int nGroup, boolean bValue) {
        if (this.m_bSeriesDrawn != null) {
            this.m_bSeriesDrawn[nSeries][nGroup] = bValue;
        }
    }

    protected boolean isSeriesPartOfOther(int nSeries) {
        boolean bSeriesIsPartOfOther = false;
        if (this.m_Perspective.getOtherSeries() && this.m_bSeriesDrawn != null && this.m_bSeriesPartOfOther != null) {
            int nGraphType = this.m_Perspective.getGraphType();
            switch (nGraphType) {
                default: {
                    return bSeriesIsPartOfOther;
                }
                case 55: 
                case 56: 
                case 93: 
                case 94: {
                    bSeriesIsPartOfOther = this.m_bSeriesPartOfOther[nSeries][0];
                    break;
                }
                case 57: 
                case 58: 
                case 59: 
                case 60: {
                    int nNumSeriesAssignedToOther = this.getNumSeriesAssignedToOther(nSeries);
                    if (nNumSeriesAssignedToOther != this.m_nTotalGroups) break;
                    bSeriesIsPartOfOther = true;
                }
            }
            int nNumSeriesDrawn = this.getNumSeriesDrawn(nSeries);
            bSeriesIsPartOfOther = nNumSeriesDrawn <= 0;
        }
        return bSeriesIsPartOfOther;
    }

    private int getNumSeriesAssignedToOther(int nSeries) {
        int nNumSeriesAssignedToOther = 0;
        int nGroup = 0;
        while (nGroup < this.m_nTotalGroups) {
            boolean bOther = this.m_bSeriesPartOfOther[nSeries][nGroup];
            if (bOther) {
                ++nNumSeriesAssignedToOther;
            }
            ++nGroup;
        }
        return nNumSeriesAssignedToOther;
    }

    private int getNumSeriesDrawn(int nSeries) {
        int nGroup = 0;
        int nNumSeriesDrawn = 0;
        while (nGroup < this.m_nTotalGroups) {
            boolean bDrawn = this.m_bSeriesDrawn[nSeries][nGroup];
            if (bDrawn) {
                ++nNumSeriesDrawn;
            }
            ++nGroup;
        }
        return nNumSeriesDrawn;
    }

    protected boolean getOtherPercentageFlag() {
        return this.m_bOtherPercentage;
    }

    public int getBarThickness() {
        return 0;
    }

    protected double getPieRotation() {
        double fPieRotAngle = (double)this.m_Perspective.getPieRotate() / 360.0;
        return fPieRotAngle;
    }

    protected int getSliceObjectID(int nDefaultID) {
        return nDefaultID;
    }

    protected boolean isPieBarSliceOK() {
        return false;
    }
}

