/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import tdg.Assert;
import tdg.AssertionException;
import tdg.AxisDescriptor;
import tdg.AxisTemplate;
import tdg.CircularAxisObj;
import tdg.CircularFrameObj;
import tdg.DataFormat;
import tdg.DataItem;
import tdg.DatumObj;
import tdg.GroupsEnumerator;
import tdg.JChart_2D_Standard;
import tdg.MinMaxObj;
import tdg.RelativeAxisObj;
import tdg.SeriesEnumerator;
import tdg.TDGNumberFormat;
import tdg.draw.DetPolygon;
import tdg.draw.IdentObj;

public abstract class JChart_2D_Circular
extends JChart_2D_Standard {
    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        double fValue = 0.0;
        boolean bUseXAxis = axisDescriptor.hasX1();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        Point ptCoord = new Point(0, 0);
        double fRadius = 0.0;
        double fAngle = 0.0;
        boolean bUseLabels = false;
        String[] dataItemStringArray = new String[nItems];
        String sDataTextTemplate = "";
        boolean bPolar = this.m_gt.isPolar();
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_numXCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        bUseLabels = this.m_bDataTextDisplay;
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bUseLabels) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        if (this.m_bDataTextDisplay && bPolar && bPolar) {
            sDataTextTemplate = this.m_Perspective.getDataTextTemplateScatter();
        }
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                this.m_dataOK[s][g] = true;
                boolean bGotAngle = false;
                int i = 0;
                while (i < nItems) {
                    DataItem item = df.getDataItem(i);
                    RelativeAxisObj axisObj = this.whichAxisForSeries(s, item);
                    if (axisObj != null) {
                        block19: {
                            try {
                                DatumObj dObj = this.getDataValue(s, g, item);
                                fValue = dObj.m_fValue;
                                if (!dObj.m_bOK) {
                                    this.m_dataOK[s][g] = dObj.m_bOK;
                                }
                                if (bUseLabels) {
                                    if (bPolar) {
                                        dataItemStringArray[i] = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), fValue, this.m_Perspective.getDataTextFormatPattern());
                                        this.m_DataLabel[s][g] = this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate);
                                    } else {
                                        this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), fValue, this.m_Perspective.getDataTextFormatPattern());
                                    }
                                }
                                if (this.isBadValueInLogscale(axisObj, fValue)) {
                                    this.m_dataOK[s][g] = false;
                                }
                                if (this.isIgnoredOffScale(axisObj, fValue)) {
                                    this.m_dataOK[s][g] = false;
                                }
                            }
                            catch (AssertionException e) {
                                if (!item.isRequired()) break block19;
                                this.m_dataOK[s][g] = false;
                            }
                        }
                        if (!item.isLabel()) {
                            if (item.getAssocAxis() == 0 || item.getAssocAxis() == 1) {
                                fRadius = axisObj.getValueCoord(fValue);
                            } else {
                                fAngle = axisObj.getValueCoord(fValue);
                            }
                        }
                    }
                    ++i;
                }
                if (!bGotAngle && nItems == 1) {
                    fAngle = this.m_O1Axis.getCenterCoord(g);
                }
                Rectangle rFrame = this.m_Perspective.getFrameRect(true);
                Dimension frameDim = new Dimension(rFrame.width, rFrame.height);
                Point frameCenter = new Point(rFrame.x + rFrame.width / 2, rFrame.y + rFrame.height / 2);
                if (!this.m_dataOK[s][g] && this.m_gt.equals(68)) {
                    fRadius = 0.0;
                }
                CircularAxisObj.polarToCartesian(ptCoord, fAngle, fRadius, frameDim, frameCenter, this.m_Perspective.m_VC);
                this.m_numXCoords[s][g] = ptCoord.x;
                this.m_numYCoords[s][g] = ptCoord.y;
            }
        }
    }

    public void createFrame() {
        this.m_Frame = new CircularFrameObj(this.m_Perspective);
    }

    protected void createOrdinalAxis(int ordType, boolean bVerticalAxis, boolean bAscending) {
        this.m_O1Axis = new CircularAxisObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, bAscending, 0, 100, false);
    }

    protected void createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        boolean bMustIncludeZero = this.m_Perspective.getX1MustIncludeZero();
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, bMustIncludeZero, null);
        this.m_X1Axis = new CircularAxisObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bAscending, false, 0, 100, false);
    }

    protected void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        MinMaxObj y1MinMaxObj = this.findLimits(0, this.m_scaling, bMustIncludeZero, null);
        this.m_Y1Axis = new CircularAxisObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bAscending, false, nOffset, nSize, true);
    }

    protected void createY2Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero();
        MinMaxObj y2MinMaxObj = this.findLimits(1, this.m_scaling, bMustIncludeZero, null);
        this.m_Y2Axis = new CircularAxisObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxObj, bAscending, true, nOffset, nSize, true);
    }

    /*
     * Unable to fully structure code
     */
    protected void drawRisers() {
        sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, false);
        gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        x0 = 0;
        y0 = 0;
        baseCoord = (int)this.m_Y1Axis.getBaseCoord();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            polygon = new Polygon();
            bFirst = true;
            gEnum.reset();
            if (gEnum.hasMoreElements()) ** GOTO lbl23
            continue;
lbl-1000:
            // 1 sources

            {
                g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                x = this.m_numXCoords[s][g];
                y = this.m_numYCoords[s][g];
                polygon.addPoint(x, y);
                if (!bFirst) continue;
                x0 = x;
                y0 = y;
                bFirst = false;
lbl23:
                // 3 sources

                ** while (gEnum.hasMoreElements())
            }
lbl24:
            // 1 sources

            polygon.addPoint(x0, y0);
            blackBox = this.assignSeriesColor(s, 0);
            new DetPolygon(this.m_Detectiv, new IdentObj(256, s), polygon, blackBox, this.m_rClip);
        }
    }

    protected Point getCoords(int s, int g) {
        return new Point(this.m_numXCoords[s][g], this.m_numYCoords[s][g]);
    }
}

