/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import tdg.Assert;
import tdg.AssertionException;
import tdg.Axis2DObj;
import tdg.DataItem;
import tdg.DatumObj;
import tdg.GroupsEnumerator;
import tdg.JChart_2D_Standard;
import tdg.RelativeAxisObj;
import tdg.SeriesEnumerator;
import tdg.TDGNumberFormat;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLine;
import tdg.draw.DetPolygon;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;

public class JChart_2D_BLA
extends JChart_2D_Standard {
    public static final double DEPTH_FACTOR = 12.0;
    public static final double UNSHADED = 1.0;
    public static final double SHADING_FRONT = 1.0;
    public static final double SHADING_TOP = 0.8;
    public static final double SHADING_SIDE = 0.6;
    public static final double SHADING_BOTTOM = 0.4;
    public static final boolean DRAW_NEG_SERIES = true;
    public static final boolean DRAW_POS_SERIES = false;
    boolean m_bFromZero;
    boolean m_bBipolar;
    boolean m_bDualY;
    boolean m_bBarAsPictograph;
    int m_nLineThick;
    Point[] m_seriesBackOffsets;
    Point[] m_seriesFrontOffsets;
    boolean m_bTransparentMarkers = false;
    boolean m_bNonZeroBaseline = false;
    int m_baseLineYCoord = 0;
    private static final int INVISIBLE_RECT_SIZE = 3;

    public void calc() {
        this.m_bTransparentMarkers = this.m_Perspective.getTransparentMarkers();
        this.m_baseLineYCoord = 0;
        super.calc();
        this.calcFrontBackOffsets();
        if (this.m_gt.isRiserBar() && this.isComboWithBar()) {
            this.calcBarOrdinalCoords();
        } else {
            this.calcOrdinalCoords();
        }
        if (this.m_bBipolar && this.wantDepthEffect()) {
            this.calcBiPolarTwoHalfD();
        } else {
            if (this.m_bBipolar) {
                this.drawDualAxisLine();
            }
            this.drawAreaRisers();
            this.drawBarRisers();
            this.drawLineRisers();
        }
        if (this.m_gt.isWaterfall()) {
            this.drawWaterfallLines();
        }
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
        if (this.m_bAbsolute) {
            this.drawFitLines();
        }
    }

    private void calcBiPolarTwoHalfD() {
        boolean bY1first = this.m_bHorz && this.m_nDepthAngle > 90;
        this.drawDualAxisLine();
        this.drawAxisAreaRisersDepth(bY1first, !bY1first);
        this.drawAxisBarRisers(bY1first, !bY1first);
        if (bY1first) {
            this.drawAxisLineRisers(0);
        } else {
            this.drawAxisLineRisers(1);
        }
        this.drawAxisAreaRisersDepth(!bY1first, bY1first);
        this.drawAxisBarRisers(!bY1first, bY1first);
        if (!bY1first) {
            this.drawAxisLineRisers(0);
        } else {
            this.drawAxisLineRisers(1);
        }
    }

    private void calcFrontBackOffsets() {
        if (this.wantDepthEffect()) {
            this.m_seriesBackOffsets = new Point[this.m_nTotalSeries];
            this.m_seriesFrontOffsets = new Point[this.m_nTotalSeries];
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                this.m_seriesBackOffsets[s] = this.calcSeriesOffset(s, false);
                this.m_seriesFrontOffsets[s] = this.calcSeriesOffset(s, true);
            }
        }
    }

    private void drawDualAxisLine() {
        if (this.m_Perspective.getFrameDisplay() && this.m_Perspective.getDualAxisLineDisplay()) {
            double fSplit = (double)this.m_Perspective.getDualAxisSplitPosition() / 100.0;
            this.m_Frame.drawSeparator(this.m_bHorz, fSplit);
        }
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fValue = 0.0;
        int nSeriesPerPixel = this.calcRisersPerPixel();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        String szFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                this.m_dataOK[s][g] = true;
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                if (axisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.m_fValue;
                if (!dObj.m_bOK) {
                    this.m_dataOK[s][g] = false;
                }
                if (fValue <= 0.0 && axisObj.isLogScale()) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                if (this.isIgnoredOffScale(axisObj, fValue)) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                if (!this.m_bDataTextDisplay) continue;
                if (bNumberFormatCallBackActive) {
                    int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                    this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                    this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                    continue;
                }
                this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
            }
        }
        this.calcOverdrawEliminate(nSeriesPerPixel);
    }

    private void calcOverdrawEliminate(int nSeriesPerPixel) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        if (this.m_Perspective.getOverdrawSkip() && nSeriesPerPixel > 4) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                int nBunchEnd = this.m_nSeries / nSeriesPerPixel - 1;
                int iBunch = 1;
                while (iBunch < nBunchEnd) {
                    int s;
                    int sRelStart = iBunch * nSeriesPerPixel;
                    int sRelBound = sRelStart + nSeriesPerPixel;
                    Assert.assert(sRelBound <= this.m_nSeries);
                    int sForMin = -1;
                    int sForMax = -1;
                    int nMinCoord = Integer.MAX_VALUE;
                    int nMaxCoord = -2147483647;
                    int sRel = sRelStart;
                    while (sRel < sRelBound) {
                        s = sEnum.seriesAt(sRel);
                        Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                        if (this.m_dataOK[s][g]) {
                            int nCoord = this.m_numYCoords[s][g];
                            if (nCoord < nMinCoord) {
                                nMinCoord = nCoord;
                                sForMin = s;
                            }
                            if (nCoord > nMaxCoord) {
                                nMaxCoord = nCoord;
                                sForMax = s;
                            }
                        }
                        ++sRel;
                    }
                    if (sForMin != -1) {
                        sRel = sRelStart;
                        while (sRel < sRelBound) {
                            s = sEnum.seriesAt(sRel);
                            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                            if (s != sForMin && s != sForMax) {
                                this.m_dataOK[s][g] = false;
                            }
                            ++sRel;
                        }
                    }
                    ++iBunch;
                }
            }
        }
    }

    public Point calcSeriesOffset(int s, boolean bFront) {
        Point pt;
        if (bFront) {
            double fFront = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fFront);
        } else {
            double fBack = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fBack);
        }
        return pt;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bFromZero = this.m_gt.isWaterfall() ? false : this.m_Perspective.getScaleFromZero();
        this.m_bBipolar = this.m_gt.isBipolar();
        this.m_bDualY = this.m_gt.isDualY();
        this.m_bBarAsPictograph = this.m_nDepthRadius > 0 ? false : this.m_Perspective.getDisplayBarAsPictograph();
        this.m_nLineThick = this.m_Perspective.getDataLineThickness();
    }

    private void drawAreaRisers() {
        if (this.m_nGroups >= 2) {
            if (this.wantDepthEffect()) {
                if (this.m_bBipolar) {
                    this.drawAxisAreaRisersDepth(false, true);
                }
                this.drawAxisAreaRisersDepth(true, false);
            } else {
                this.drawAreaRisersFlat();
            }
        }
    }

    private void drawAreaRisersFlat() {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int g = 0;
        boolean bReverseSeries = !this.m_bAbsolute;
        boolean bForwardSeries = !bReverseSeries;
        boolean bNegNZValue = false;
        boolean bNegData = false;
        double fBaseline = 0.0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        while (sEnum.hasMoreElements()) {
            RelativeAxisObj yAxisObj;
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 3 || (yAxisObj = this.whichAxisForSeries(s, null)) == null) continue;
            int baseCoord = (int)yAxisObj.getBaseCoord();
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            IdentObj id = yAxisObj.getAxisIdentObj();
            this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id);
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                if (yAxisObj.isLogScale() && fBaseline <= 0.0) {
                    this.m_bNonZeroBaseline = false;
                }
            }
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                bNegNZValue = fBaseline < 0.0;
                this.m_baseLineYCoord = fBaseline <= yAxisObj.getMaxValue() ? (int)yAxisObj.getValueCoord(fBaseline) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMax());
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                bNegData = dObj.m_fValue < 0.0;
            }
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int x;
                int y;
                g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                int gNext = gEnum.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis()) {
                    if (this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                        while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                            gNext = gEnum.nextGroup();
                            gNext = gEnum.peekAtNextGroup();
                        }
                    }
                }
                Assert.assert(gNext >= 0 && gNext < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) continue;
                BlackBoxIF blackBox = this.assignSeriesColor(s, g);
                Polygon polygon = new Polygon();
                Point p0 = this.getCoords(s, g);
                int x0 = p0.x;
                int y0 = p0.y;
                polygon.addPoint(x0, y0);
                Point p = this.getCoords(s, gNext);
                polygon.addPoint(p.x, p.y);
                int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegData);
                if (this.m_bHorz) {
                    y = p.y;
                    int x2 = 0;
                    if (this.m_bAbsolute || sPrev == -2) {
                        x = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                        x2 = x;
                    } else {
                        x = this.m_numYCoords[sPrev][g];
                        x2 = this.m_numYCoords[sPrev][gNext];
                    }
                    polygon.addPoint(x2, y);
                    polygon.addPoint(x, y0);
                } else {
                    int y2 = 0;
                    x = p.x;
                    if (this.m_bAbsolute || sPrev == -2) {
                        y = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                        y2 = y;
                    } else {
                        y = this.m_numYCoords[sPrev][g];
                        y2 = this.m_numYCoords[sPrev][gNext];
                    }
                    polygon.addPoint(x, y2);
                    polygon.addPoint(x0, y);
                }
                polygon.addPoint(x0, y0);
                new DetPolygon(this.m_Detectiv, new IdentObj(256, s, g), polygon, blackBox, this.m_rClip);
            }
        }
        if (!this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
            this.drawTransparentMarkers(3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawAxisAreaRisersDepth(boolean bDrawY1, boolean bDrawY2) {
        bRightToLeft = this.m_nDepthAngle > 90;
        v0 = bReverseGroups = this.m_bHorz != false || bRightToLeft != false;
        if (bDrawY1 && bDrawY2) {
            throw new AssertionException("bDrawY1 and bDrawY2 cannot both be true for Area charts.");
        }
        bDescending = bDrawY1 != false ? this.m_Y1Axis.isDescending() : this.m_Y2Axis.isDescending();
        if (this.m_bAbsolute) ** GOTO lbl-1000
        v1 = this.m_bHorz ? bDescending != bRightToLeft : bDescending;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        bReverseSeries = v2;
        bForwardSeries = bReverseSeries == false;
        bForwardGroups = bReverseGroups == false;
        sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        if (this.m_bAbsolute) {
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                if (this.m_seriesTypes[s] != 3 || (yAxisObj = this.whichAxisForSeries(s, null)) == null) continue;
                axisID = yAxisObj.getAxisObjID();
                if (bDrawY1 != false ? axisID != 0 && this.m_bBipolar != false : bDrawY2 != false && axisID != 1 && this.m_bBipolar != false) continue;
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                    if (!bForwardGroups && g == gEnum.getFirstGroup()) continue;
                    this.drawOneAreaRiser(s, g, gEnum);
                    if (this.m_bMarkerDisplay || !this.m_bTransparentMarkers) continue;
                    this.drawTransparentMarkersWithDepth(s, 3);
                }
            }
        } else {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                if (!bForwardGroups && g == gEnum.getFirstGroup()) continue;
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                    if (this.m_seriesTypes[s] != 3 || (yAxisObj = this.whichAxisForSeries(s, null)) == null) continue;
                    axisID = yAxisObj.getAxisObjID();
                    if (bDrawY1 != false ? axisID != 0 : bDrawY2 != false && axisID != 1) continue;
                    this.drawOneAreaRiser(s, g, gEnum);
                    if (this.m_bMarkerDisplay || !this.m_bTransparentMarkers) continue;
                    this.drawTransparentMarkersWithDepth(s, 3);
                }
            }
        }
    }

    private void drawAxisBarRisers(boolean bDrawY1, boolean bDrawY2) {
        if (this.m_bAbsolute) {
            this.drawAxisBarRisersAbsolute(bDrawY1, bDrawY2);
        } else if (this.m_bDualY && !this.m_bBipolar) {
            this.drawAxisBarRisersStackedDualY(bDrawY1, bDrawY2);
        } else {
            this.drawAxisBarRisersStacked(bDrawY1, bDrawY2);
        }
    }

    private void drawAxisBarRisersAbsolute(boolean bDrawY1, boolean bDrawY2) {
        boolean bReverseSeries;
        boolean bReverseGroups;
        boolean bRightToLeft;
        boolean bl = bRightToLeft = this.m_nDepthAngle > 90;
        if (this.m_bHorz) {
            bReverseGroups = true;
            bReverseSeries = true;
        } else {
            bReverseGroups = bRightToLeft;
            bReverseSeries = bRightToLeft;
        }
        boolean bForwardSeries = !bReverseSeries;
        boolean bForwardGroups = !bReverseGroups;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        int gFirst = gEnum.getFirstGroup();
        while (gEnum.hasMoreElements()) {
            int axisID;
            RelativeAxisObj yAxisObj;
            int s;
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            if (bDrawY1) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                    if (this.m_seriesTypes[s] != 1 || (yAxisObj = this.whichAxisForSeries(s, null)) == null || (axisID = yAxisObj.getAxisObjID()) != 0 && this.m_bBipolar) continue;
                    this.drawOneBarRiser(s, g, sEnum, gEnum);
                }
            }
            if (!bDrawY2 || !this.m_bBipolar) continue;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                yAxisObj = this.whichAxisForSeries(s, null);
                if (yAxisObj == null || (axisID = yAxisObj.getAxisObjID()) != 1 && this.m_bBipolar) continue;
                this.drawOneBarRiser(s, g, sEnum, gEnum);
            }
        }
    }

    private void drawAxisBarRisersStacked(boolean bDrawY1, boolean bDrawY2) {
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        boolean bDescending = bDrawY1 ? this.m_Y1Axis.isDescending() : this.m_Y2Axis.isDescending();
        boolean bReverseSeries = this.m_bHorz ? bDescending != bRightToLeft : bDescending;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            if (bReverseSeries) {
                this.drawBarGroup(g, bDrawY1, bDrawY2, true, false, gEnum);
                this.drawBarGroup(g, bDrawY1, bDrawY2, false, true, gEnum);
                continue;
            }
            this.drawBarGroup(g, bDrawY1, bDrawY2, true, true, gEnum);
            this.drawBarGroup(g, bDrawY1, bDrawY2, false, false, gEnum);
        }
    }

    private void drawAxisBarRisersStackedDualY(boolean bDrawY1, boolean bDrawY2) {
        boolean bY1ReverseSeries;
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        boolean bReverseSeries = false;
        boolean bY2first = this.m_bHorz || bRightToLeft;
        boolean bY1Descending = this.m_Y1Axis.isDescending();
        boolean bY2Descending = this.m_Y2Axis.isDescending();
        boolean bl = this.m_bHorz ? bY1Descending != bRightToLeft : (bY1ReverseSeries = bY1Descending);
        boolean bY2ReverseSeries = this.m_bHorz ? bY2Descending != bRightToLeft : bY2Descending;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            if (bY2first) {
                if (bY2ReverseSeries) {
                    this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, false, gEnum);
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries, true, gEnum);
                } else {
                    this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, true, gEnum);
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries, false, gEnum);
                }
                if (bY1ReverseSeries) {
                    this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, false, gEnum);
                    this.drawBarGroup(g, bDrawY1, false, bReverseSeries, true, gEnum);
                    continue;
                }
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, true, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, false, gEnum);
                continue;
            }
            if (bY1ReverseSeries) {
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, false, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, true, gEnum);
            } else {
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, true, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, false, gEnum);
            }
            if (bY2ReverseSeries) {
                this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, false, gEnum);
                this.drawBarGroup(g, false, bDrawY2, bReverseSeries, true, gEnum);
                continue;
            }
            this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, true, gEnum);
            this.drawBarGroup(g, false, bDrawY2, bReverseSeries, false, gEnum);
        }
    }

    private void drawAxisLineRisers(int nAxis) {
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        boolean bForwardSeries = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        while (sEnum.hasMoreElements()) {
            int axisID;
            RelativeAxisObj yAxisObj;
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 2 || (yAxisObj = this.whichAxisForSeries(s, null)) == null || (axisID = yAxisObj.getAxisObjID()) != nAxis && (!this.m_bAbsolute || this.m_bBipolar)) continue;
            if (this.m_Perspective.getConnectLineMarkers()) {
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    int g = gEnum.nextGroup();
                    Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                    if (!bForwardGroups && g == gEnum.getFirstGroup()) continue;
                    this.drawOneLineRiser(s, g, gEnum);
                }
            }
            if (this.m_nDepthRadius <= 0) continue;
            this.drawMarkersWithDepth(s);
            if (this.m_bMarkerDisplay || !this.m_bTransparentMarkers) continue;
            this.drawTransparentMarkersWithDepth(s, 2);
        }
    }

    private void drawBarAsPictograph(Axis2DObj yAxisObj, Rectangle rVirt, IdentObj id, BlackBoxIF blackBox) {
        Rectangle rPicto = new Rectangle(rVirt);
        int nGridlines = yAxisObj.getNumMajorGrids();
        int top = rVirt.y + rVirt.height;
        int bottom = rVirt.y;
        int left = rVirt.x;
        int right = rVirt.x + rVirt.width;
        double fPrevGridPosVC = yAxisObj.getBaseCoord();
        int iGrid = 0;
        while (iGrid <= nGridlines) {
            Rectangle rClip;
            double fGridPosRel = yAxisObj.getMajorGridPos(iGrid);
            double fGridPosVC = yAxisObj.scaleToVC(fGridPosRel);
            double gap = fGridPosVC - fPrevGridPosVC;
            if (this.m_bHorz) {
                if (yAxisObj.isAscending()) {
                    if (fPrevGridPosVC > (double)left) {
                        left = (int)fPrevGridPosVC;
                    }
                    if (fGridPosVC >= (double)(rVirt.x + rVirt.width)) {
                        right = rVirt.x + rVirt.width;
                        rPicto.x = left;
                        rPicto.width = (int)gap;
                        rClip = new Rectangle(this.m_rClip);
                        if (right < rClip.x + rClip.width) {
                            rClip.width = right - rClip.x;
                        }
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    } else if (fGridPosVC > (double)left + gap / 10.0) {
                        right = (int)fGridPosVC;
                        rPicto.x = left;
                        rPicto.width = right - left;
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                        fPrevGridPosVC = fGridPosVC;
                    }
                } else {
                    if (fPrevGridPosVC < (double)right) {
                        right = (int)fPrevGridPosVC;
                    }
                    if (fGridPosVC < (double)rVirt.x) {
                        rPicto.x = left = rVirt.x;
                        rPicto.width = right - left;
                        rClip = new Rectangle(this.m_rClip);
                        if (left > rClip.x) {
                            rClip.x = left;
                        }
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    } else if (fGridPosVC < (double)right - gap / 10.0) {
                        rPicto.x = left = (int)fGridPosVC;
                        rPicto.width = right - left;
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                        fPrevGridPosVC = fGridPosVC;
                    }
                }
            } else if (yAxisObj.isAscending()) {
                if (fPrevGridPosVC > (double)bottom) {
                    bottom = (int)fPrevGridPosVC;
                }
                if (fGridPosVC >= (double)(rVirt.y + rVirt.height)) {
                    top = rVirt.y + rVirt.height;
                    rPicto.y = bottom;
                    rPicto.height = (int)gap;
                    rClip = new Rectangle(this.m_rClip);
                    if (top < rClip.y + rClip.height) {
                        rClip.height = top - rClip.y;
                    }
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    break;
                }
                if (fGridPosVC > (double)bottom + gap / 10.0) {
                    top = (int)fGridPosVC;
                    rPicto.y = bottom;
                    rPicto.height = top - bottom;
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                    fPrevGridPosVC = fGridPosVC;
                }
            } else {
                if (fPrevGridPosVC < (double)top) {
                    top = (int)fPrevGridPosVC;
                }
                if (fGridPosVC <= (double)rVirt.y) {
                    rPicto.y = bottom = rVirt.y;
                    rPicto.height = top - bottom;
                    rClip = new Rectangle(this.m_rClip);
                    if (bottom > rClip.y) {
                        rClip.y = bottom;
                    }
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    break;
                }
                if (fGridPosVC < (double)top - gap / 10.0) {
                    rPicto.y = bottom = (int)fGridPosVC;
                    rPicto.height = top - bottom;
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                    fPrevGridPosVC = fGridPosVC;
                }
            }
            ++iGrid;
        }
    }

    private void drawBarGroup(int g, boolean bDrawY1, boolean bDrawY2, boolean bReverseSeries, boolean bNegative, GroupsEnumerator gEnum) {
        boolean bForwardSeries = !bReverseSeries;
        int gFirst = gEnum.getFirstGroup();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        while (sEnum.hasMoreElements()) {
            boolean bNegValue;
            RelativeAxisObj yAxisObj;
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 1 || (yAxisObj = this.whichAxisForSeries(s, null)) == null) continue;
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            boolean bl = bDescending ? this.m_numYCoords[s][g] > nZeroCoord : (bNegValue = this.m_numYCoords[s][g] < nZeroCoord);
            if (bNegValue != bNegative) continue;
            int axisID = yAxisObj.getAxisObjID();
            if (!bDrawY1 && axisID == 0 || !bDrawY2 && axisID == 1) continue;
            this.drawOneBarRiser(s, g, sEnum, gEnum);
        }
    }

    private void drawBarRisers() {
        if (this.m_bBipolar) {
            this.drawAxisBarRisers(false, true);
            this.drawAxisBarRisers(true, false);
        } else if (this.m_bDualY) {
            this.drawAxisBarRisers(true, true);
        } else {
            this.drawAxisBarRisers(true, false);
        }
    }

    private void drawLineRisers() {
        if (this.wantDepthEffect()) {
            this.drawLinesWithDepth();
        } else {
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawLines(false);
            }
            this.drawMarkers();
            if (!this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
                this.drawTransparentMarkers(2);
            }
        }
    }

    protected void drawLinesWithDepth() {
        if (this.m_bBipolar) {
            this.drawAxisLineRisers(1);
            this.drawAxisLineRisers(0);
        } else if (this.m_bDualY) {
            this.drawAxisLineRisers(0);
            this.drawAxisLineRisers(1);
        } else {
            this.drawAxisLineRisers(0);
        }
    }

    private void drawOneAreaRiser(int s, int g, GroupsEnumerator gEnum) {
        RelativeAxisObj yAxisObj;
        double fIntensity = 1.0;
        double fIntensityTop = 1.0;
        double fIntensitySide = 1.0;
        double fIntensityBottom = 1.0;
        int nValueCoord = this.m_numYCoords[s][g];
        int gFirst = gEnum.getFirstGroup();
        int gLast = gEnum.getLastGroup();
        int gPrev = gEnum.peekAtGroupBefore(g);
        int gNext = gEnum.peekAtGroupAfter(g);
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bDrawSidePolygon = false;
        boolean bForwardGroups = gFirst <= gLast;
        double fBaseline = 0.0;
        Assert.assert(gFirst >= 0 && gLast >= 0 && g >= 0 && g < this.m_nTotalGroups);
        if (bForwardGroups) {
            if (gNext == -1) {
                return;
            }
            if (this.m_Perspective.isTimeAxis()) {
                if (this.m_Perspective.getDateFrequency() == 3 && this.m_dataOK[s][g] && !this.m_dataOK[s][gNext]) {
                    while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                        int next = gEnum.nextGroup();
                        gNext = gEnum.peekAtGroupAfter(next);
                        gPrev = gEnum.peekAtGroupBefore(next);
                    }
                }
            }
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) {
                return;
            }
        } else {
            if (gPrev == -1) {
                return;
            }
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gPrev]) {
                return;
            }
        }
        if (this.wantDepthEffect()) {
            Assert.assert(this.m_Frame != null, "Can't draw 2.5D areas without m_Frame");
        }
        if ((yAxisObj = this.whichAxisForSeries(s, null)) != null) {
            boolean bPointsUpwards;
            int x2;
            int x3;
            int y3;
            int y2;
            int dy;
            int dx;
            Point frontOffset;
            IdentObj id = yAxisObj.getAxisIdentObj();
            this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id);
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                if (yAxisObj.isLogScale() && fBaseline <= 0.0) {
                    this.m_bNonZeroBaseline = false;
                }
            }
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                this.m_baseLineYCoord = fBaseline <= yAxisObj.getMaxValue() ? (int)yAxisObj.getValueCoord(fBaseline) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMax());
            }
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            BlackBoxIF blackBox = this.assignSeriesColor(s, g);
            BlackBoxIF blackBoxNew = this.getMissingDataBlackBox(s, g);
            if (blackBoxNew == null) {
                blackBoxNew = blackBox;
            }
            boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
            int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
            boolean bFromZero = this.wantRisersFromZero(yAxisObj);
            int nBaseCoord = this.m_bAbsolute || sPrev == -2 ? (this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (bFromZero ? nZeroCoord : (int)yAxisObj.getBaseCoord())) : this.m_numYCoords[sPrev][g];
            if (this.wantDepthEffect()) {
                Point backOffset = this.m_seriesBackOffsets[s];
                frontOffset = this.m_seriesFrontOffsets[s];
                dx = frontOffset.x - backOffset.x;
                dy = frontOffset.y - backOffset.y;
            } else {
                frontOffset = new Point();
                dx = 0;
                dy = 0;
            }
            Polygon polyFront = new Polygon();
            Point p0 = this.getCoords(s, g);
            int x0 = p0.x - frontOffset.x;
            int y0 = p0.y - frontOffset.y;
            polyFront.addPoint(x0, y0);
            int g2 = bForwardGroups ? gNext : gPrev;
            Point p1 = this.getCoords(s, g2);
            int x1 = p1.x - frontOffset.x;
            int y1 = p1.y - frontOffset.y;
            polyFront.addPoint(x1, y1);
            if (this.m_bHorz) {
                y2 = y1;
                y3 = y0;
                if (this.m_bAbsolute || sPrev == -2) {
                    x2 = x3 = nBaseCoord - frontOffset.x;
                } else {
                    x2 = this.m_numYCoords[sPrev][g2] - frontOffset.x;
                    x3 = this.m_numYCoords[sPrev][g] - frontOffset.x;
                }
            } else {
                x2 = x1;
                x3 = x0;
                if (this.m_bAbsolute || sPrev == -2) {
                    y2 = y3 = nBaseCoord - frontOffset.y;
                } else {
                    y2 = this.m_numYCoords[sPrev][g2] - frontOffset.y;
                    y3 = this.m_numYCoords[sPrev][g] - frontOffset.y;
                }
            }
            polyFront.addPoint(x2, y2);
            polyFront.addPoint(x3, y3);
            polyFront.addPoint(x0, y0);
            double fAngle = Math.atan2(y1 - y0, x1 - x0) * 57.29577951308232;
            if (this.m_bHorz) {
                bPointsUpwards = bFromZero ? (bRightToLeft ? bDescending != bNegValue : bDescending == bNegValue) : (bRightToLeft ? bDescending : !bDescending);
            } else {
                boolean bl = bFromZero ? bDescending == bNegValue : (bPointsUpwards = !bDescending);
            }
            if (bPointsUpwards) {
                boolean bShowLeftSide;
                Polygon polyTop;
                boolean bDrawUnderside = false;
                boolean bDrawTopside = true;
                if (this.m_bHorz) {
                    if (bRightToLeft) {
                        if (fAngle + 180.0 > (double)this.m_nDepthAngle) {
                            bDrawTopside = false;
                        }
                    } else if (fAngle < (double)(this.m_nDepthAngle - 180)) {
                        bDrawTopside = false;
                    }
                } else if (bRightToLeft) {
                    if (fAngle + 180.0 < (double)this.m_nDepthAngle) {
                        bDrawTopside = false;
                    }
                } else if (fAngle > (double)this.m_nDepthAngle) {
                    bDrawTopside = false;
                }
                if ((this.m_bAbsolute || this.isTopStackedArea(s)) && bDrawTopside) {
                    polyTop = new Polygon();
                    polyTop.addPoint(x0, y0);
                    polyTop.addPoint(x1, y1);
                    polyTop.addPoint(x1 + dx, y1 + dy);
                    polyTop.addPoint(x0 + dx, y0 + dy);
                    polyTop.addPoint(x0, y0);
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensityTop = this.m_bHorz ? 0.6 : 0.8;
                    }
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, s, g), polyTop, blackBoxNew, fIntensityTop);
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    polyTop = new Polygon();
                    polyTop.addPoint(x0, y0);
                    polyTop.addPoint(x1, y1);
                    polyTop.addPoint(x1 + dx, y1 + dy);
                    polyTop.addPoint(x0 + dx, y0 + dy);
                    polyTop.addPoint(x0, y0);
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, s, g), polyTop, blackBoxNew, fIntensityTop);
                }
                if (this.m_bColorAutoshadeRisers) {
                    fIntensity = 1.0;
                }
                new DetPolygon(this.m_Detectiv, new IdentObj(256, s, g), polyFront, blackBoxNew, fIntensity);
                boolean bl = bShowLeftSide = bRightToLeft || this.m_bHorz;
                if (bForwardGroups) {
                    bDrawSidePolygon = bShowLeftSide ? g == gFirst : gNext == gLast;
                } else if (bShowLeftSide) {
                    bDrawSidePolygon = g == gLast;
                } else {
                    boolean bl2 = bDrawSidePolygon = gPrev == gFirst;
                }
                if (bDrawSidePolygon) {
                    Polygon polySide = new Polygon();
                    if (bShowLeftSide) {
                        polySide.addPoint(x0, y0);
                        polySide.addPoint(x3, y3);
                        polySide.addPoint(x3 + dx, y3 + dy);
                        polySide.addPoint(x0 + dx, y0 + dy);
                        polySide.addPoint(x0, y0);
                    } else {
                        polySide.addPoint(x1, y1);
                        polySide.addPoint(x2, y2);
                        polySide.addPoint(x2 + dx, y2 + dy);
                        polySide.addPoint(x1 + dx, y1 + dy);
                        polySide.addPoint(x1, y1);
                    }
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensitySide = this.m_bHorz ? 0.8 : 0.6;
                    }
                    new DetPolygon(this.m_Detectiv, new IdentObj(315, s, g), polySide, blackBoxNew, fIntensitySide);
                }
            } else {
                boolean bShowLeftSide;
                boolean bDrawUnderside = true;
                boolean bDrawTopside = false;
                if (this.m_bHorz) {
                    if (bRightToLeft) {
                        if (fAngle > (double)(this.m_nDepthAngle - 180)) {
                            bDrawTopside = true;
                        }
                    } else if (fAngle < (double)(this.m_nDepthAngle - 180)) {
                        bDrawTopside = true;
                    }
                } else if (bRightToLeft) {
                    if (fAngle + 180.0 < (double)this.m_nDepthAngle) {
                        bDrawTopside = true;
                    }
                } else if (fAngle > (double)this.m_nDepthAngle) {
                    bDrawTopside = true;
                }
                if (bDrawTopside && (this.m_bAbsolute || this.isTopStackedArea(s))) {
                    Polygon polyTop = new Polygon();
                    polyTop.addPoint(x0, y0);
                    polyTop.addPoint(x1, y1);
                    polyTop.addPoint(x1 + dx, y1 + dy);
                    polyTop.addPoint(x0 + dx, y0 + dy);
                    polyTop.addPoint(x0, y0);
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensityTop = 0.4;
                    }
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, s, g), polyTop, blackBoxNew, fIntensityTop);
                }
                if (bDrawUnderside && (this.m_bAbsolute || this.isBottomStackedArea(s))) {
                    Polygon polyBottom = new Polygon();
                    polyBottom.addPoint(x2, y2);
                    polyBottom.addPoint(x3, y3);
                    polyBottom.addPoint(x3 + dx, y3 + dy);
                    polyBottom.addPoint(x2 + dx, y2 + dy);
                    polyBottom.addPoint(x2, y2);
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensityBottom = this.m_bHorz ? 0.6 : 0.8;
                    }
                    new DetPolygon(this.m_Detectiv, new IdentObj(316, s, g), polyBottom, blackBoxNew, fIntensityBottom);
                }
                if (this.m_bColorAutoshadeRisers) {
                    fIntensity = 1.0;
                }
                new DetPolygon(this.m_Detectiv, new IdentObj(256, s, g), polyFront, blackBoxNew, fIntensity);
                boolean bl = bShowLeftSide = bRightToLeft || this.m_bHorz;
                if (bForwardGroups) {
                    bDrawSidePolygon = bShowLeftSide ? g == gFirst : gNext == gLast;
                } else if (bShowLeftSide) {
                    bDrawSidePolygon = g == gLast;
                } else {
                    boolean bl3 = bDrawSidePolygon = gPrev == gFirst;
                }
                if (bDrawSidePolygon) {
                    Polygon polySide = new Polygon();
                    if (bShowLeftSide) {
                        polySide.addPoint(x0, y0);
                        polySide.addPoint(x3, y3);
                        polySide.addPoint(x3 + dx, y3 + dy);
                        polySide.addPoint(x0 + dx, y0 + dy);
                        polySide.addPoint(x0, y0);
                    } else {
                        polySide.addPoint(x1, y1);
                        polySide.addPoint(x2, y2);
                        polySide.addPoint(x2 + dx, y2 + dy);
                        polySide.addPoint(x1 + dx, y1 + dy);
                        polySide.addPoint(x1, y1);
                    }
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensitySide = this.m_bHorz ? 0.8 : 0.6;
                    }
                    new DetPolygon(this.m_Detectiv, new IdentObj(315, s, g), polySide, blackBoxNew, fIntensitySide);
                }
            }
        }
    }

    private void drawOneBarRiser(int s, int g, SeriesEnumerator sEnum, GroupsEnumerator gEnum) {
        int left = 0;
        int nValueCoord = this.m_numYCoords[s][g];
        double fBaseline = 0.0;
        boolean bNegNZValue = false;
        boolean bNegData = false;
        if (this.m_dataOK[s][g] && this.m_seriesTypes[s] == 1) {
            Axis2DObj yAxisObj;
            int sFirst = sEnum.getFirstSeries();
            int sLast = sEnum.getLastSeries();
            int gFirst = gEnum.getFirstGroup();
            int gLast = gEnum.getLastGroup();
            if (this.m_gt.isWaterfall()) {
                int nTemp;
                if (sLast < sFirst) {
                    nTemp = sLast;
                    sLast = sFirst;
                    sFirst = nTemp;
                }
                if (gLast < gFirst) {
                    nTemp = gLast;
                    gLast = gFirst;
                    gFirst = nTemp;
                }
            }
            if ((yAxisObj = (Axis2DObj)this.whichAxisForSeries(s, null)) != null) {
                int top;
                int bottom;
                int right;
                int nHigh;
                int nLow;
                int sPrev;
                boolean bNegValue;
                int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
                boolean bDescending = yAxisObj.isDescending();
                boolean bDrawingPictograph = this.m_bBarAsPictograph && yAxisObj.getNumMajorGrids() > 1;
                BlackBoxIF blackBox = this.assignSeriesColor(s, g);
                BlackBoxIF blackBoxNew = this.getMissingDataBlackBox(s, g);
                if (blackBoxNew == null) {
                    blackBoxNew = blackBox;
                }
                if (this.m_gt.isWaterfall()) {
                    DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                    bNegValue = dObj.m_bOK && dObj.m_fValue < 0.0;
                    sPrev = this.prevSeriesForAxis(s, yAxisObj);
                } else {
                    bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
                    sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
                }
                boolean bFromZero = this.wantRisersFromZero(yAxisObj);
                int nBaseCoord = this.m_bAbsolute || sPrev == -2 ? (bFromZero ? nZeroCoord : (int)yAxisObj.getBaseCoord()) : this.m_numYCoords[sPrev][g];
                if (bFromZero) {
                    nLow = bDescending != bNegValue ? nValueCoord : nBaseCoord;
                    nHigh = bDescending != bNegValue ? nBaseCoord : nValueCoord;
                } else {
                    nLow = bDescending ? nValueCoord : nBaseCoord;
                    int n = nHigh = bDescending ? nBaseCoord : nValueCoord;
                }
                if (this.m_gt.isWaterfall()) {
                    if (g != gFirst && s == sFirst) {
                        int gPrev = g - 1;
                        if (bDescending) {
                            nHigh = this.m_numYCoords[sLast][gPrev];
                        } else {
                            nLow = this.m_numYCoords[sLast][gPrev];
                        }
                    }
                    if (nHigh < nLow) {
                        int nTemp = nHigh;
                        nHigh = nLow;
                        nLow = nTemp;
                    }
                }
                if (this.m_bHorz) {
                    left = nLow;
                    right = nHigh;
                    bottom = !this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] - this.m_barThickCoord / 2 : this.m_ordCoords[s][g];
                    top = bottom + this.m_barThickCoord;
                } else {
                    bottom = nLow;
                    top = nHigh;
                    left = !this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] - this.m_barThickCoord / 2 : this.m_ordCoords[s][g];
                    right = left + this.m_barThickCoord;
                }
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                IdentObj id = axisObj.getAxisIdentObj();
                this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id);
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                    if (yAxisObj.isLogScale() && fBaseline <= 0.0) {
                        this.m_bNonZeroBaseline = false;
                    }
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    boolean bl = bNegNZValue = fBaseline < 0.0;
                    this.m_baseLineYCoord = bNegNZValue ? (fBaseline >= axisObj.getMinValue() ? (int)axisObj.getValueCoord(fBaseline) : (int)axisObj.getValueCoord(axisObj.getBaseMin())) : (fBaseline <= axisObj.getMaxValue() ? (int)axisObj.getValueCoord(fBaseline) : (int)axisObj.getValueCoord(axisObj.getBaseMax()));
                    DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                    boolean bl2 = bNegData = dObj.m_fValue < 0.0;
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    if (this.m_bHorz) {
                        if (!bNegNZValue) {
                            if (bNegData) {
                                if (nHigh <= this.m_baseLineYCoord) {
                                    right = this.m_baseLineYCoord;
                                } else if (nHigh > this.m_baseLineYCoord) {
                                    left = this.m_baseLineYCoord;
                                }
                            } else if (nHigh >= this.m_baseLineYCoord) {
                                left = this.m_baseLineYCoord;
                            } else if (nHigh < this.m_baseLineYCoord) {
                                left = right;
                                right = this.m_baseLineYCoord;
                            }
                        } else if (bNegData) {
                            if (nHigh <= this.m_baseLineYCoord) {
                                right = this.m_baseLineYCoord;
                            } else if (nHigh > this.m_baseLineYCoord) {
                                right = this.m_baseLineYCoord;
                            }
                        } else if (nHigh >= this.m_baseLineYCoord) {
                            left = this.m_baseLineYCoord;
                        } else if (nHigh < this.m_baseLineYCoord) {
                            left = right;
                            right = this.m_baseLineYCoord;
                        }
                    } else if (!bNegNZValue) {
                        if (bNegData) {
                            if (nHigh <= this.m_baseLineYCoord) {
                                top = this.m_baseLineYCoord;
                            } else if (nHigh > this.m_baseLineYCoord) {
                                bottom = this.m_baseLineYCoord;
                            }
                        } else if (nHigh >= this.m_baseLineYCoord) {
                            bottom = this.m_baseLineYCoord;
                        } else if (nHigh < this.m_baseLineYCoord) {
                            bottom = top;
                            top = this.m_baseLineYCoord;
                        }
                    } else if (bNegData) {
                        if (nLow >= this.m_baseLineYCoord) {
                            top = bottom;
                            bottom = this.m_baseLineYCoord;
                        } else if (nLow < this.m_baseLineYCoord) {
                            top = this.m_baseLineYCoord;
                        }
                    } else if (nHigh >= this.m_baseLineYCoord) {
                        bottom = this.m_baseLineYCoord;
                    } else if (nHigh < this.m_baseLineYCoord) {
                        bottom = top;
                        top = this.m_baseLineYCoord;
                    }
                }
                Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
                if (this.wantDepthEffect() && this.m_Frame != null) {
                    this.drawTwoHalfDBarRiser(s, g, rVirt, blackBoxNew);
                } else {
                    IdentObj idFront = new IdentObj(277, s, g);
                    if (bDrawingPictograph) {
                        this.drawBarAsPictograph(yAxisObj, rVirt, idFront, blackBoxNew);
                    } else {
                        int drawType = 0;
                        VC vc = this.m_Perspective.getVC();
                        if (this.m_bAbsolute && !this.m_bHorz && (rVirt.height == 0 || vc.virtToDestHeight(rVirt.height) == 0)) {
                            double min = axisObj.getMinValue();
                            double max = axisObj.getMaxValue();
                            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                            if (fValue >= min && fValue <= max) {
                                if (this.m_bNonZeroBaseline && fValue < fBaseline || !this.m_bNonZeroBaseline && fValue < 0.0) {
                                    rVirt.y -= vc.destToVirtHeight(3);
                                    rVirt.height = vc.destToVirtHeight(3);
                                } else {
                                    rVirt.height = vc.destToVirtHeight(3);
                                }
                                drawType = 1;
                            }
                        } else if (this.m_bAbsolute && this.m_bHorz && (rVirt.width == 0 || vc.virtToDestWidth(rVirt.width) == 0)) {
                            double min = axisObj.getMinValue();
                            double max = axisObj.getMaxValue();
                            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                            if (fValue >= min && fValue <= max) {
                                if (this.m_bNonZeroBaseline && fValue < fBaseline || !this.m_bNonZeroBaseline && fValue < 0.0) {
                                    rVirt.x -= vc.destToVirtWidth(3);
                                    rVirt.width = vc.destToVirtWidth(3);
                                } else {
                                    rVirt.width = vc.destToVirtWidth(3);
                                }
                                drawType = 1;
                            }
                        }
                        new DetRect(this.m_Detectiv, idFront, rVirt, blackBoxNew, this.m_rClip, drawType);
                    }
                }
            }
        }
    }

    private void drawTwoHalfDBarRiser(int s, int g, Rectangle rVirt, BlackBoxIF blackBox) {
        double fIntensity;
        Polygon polyVC;
        Point ptBackOffset = this.m_seriesBackOffsets[s];
        Point ptFrontOffset = this.m_seriesFrontOffsets[s];
        rVirt.x -= ptFrontOffset.x;
        rVirt.y -= ptFrontOffset.y;
        if (this.m_nDepthAngle != 90) {
            int nXFrame = this.m_nDepthAngle > 90 ? rVirt.x : rVirt.x + rVirt.width;
            polyVC = new Polygon();
            polyVC.addPoint(nXFrame, rVirt.y);
            polyVC.addPoint(nXFrame, rVirt.y + rVirt.height);
            polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(nXFrame, rVirt.y);
            fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
            IdentObj idSide = new IdentObj(312, s, g);
            new DetPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
        }
        if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
            polyVC = new Polygon();
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(rVirt.x + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            fIntensity = 0.8;
            IdentObj idSide = new IdentObj(313, s, g);
            new DetPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
        }
        IdentObj idFront = new IdentObj(277, s, g);
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = 1.0;
            polyVC = new Polygon();
            polyVC.addPoint(rVirt.x, rVirt.y);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x, rVirt.y);
            new DetPolygon(this.m_Detectiv, idFront, polyVC, blackBox, fIntensity);
        } else {
            new DetRect(this.m_Detectiv, idFront, rVirt, blackBox, null);
        }
    }

    private void drawOneLineRiser(int s, int g, GroupsEnumerator gEnum) {
        boolean bDrawSidePolygon;
        boolean bShowLeftSide;
        Polygon polyTop;
        int y3;
        int x3;
        int y2;
        int x2;
        boolean bDrawUnderside;
        int dy;
        int dx;
        Point ptFrontOffset;
        boolean bNegValue;
        double fIntensity = 1.0;
        int nValueCoord = this.m_numYCoords[s][g];
        int gFirst = gEnum.getFirstGroup();
        int gLast = gEnum.getLastGroup();
        int gPrev = gEnum.peekAtGroupBefore(g);
        int gNext = gEnum.peekAtGroupAfter(g);
        int gAfterNext = gEnum.peekAtGroupAfter(gNext);
        int gBeforePrev = gEnum.peekAtGroupBefore(gPrev);
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bForwardGroups = gFirst <= gLast;
        Assert.assert(gFirst >= 0 && gLast >= 0 && g >= 0 && g < this.m_nTotalGroups);
        if (bForwardGroups) {
            if (gNext == -1) {
                return;
            }
            if (this.m_Perspective.isTimeAxis()) {
                if (this.m_Perspective.getDateFrequency() == 3 && this.m_dataOK[s][g] && !this.m_dataOK[s][gNext]) {
                    while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                        int next = gEnum.nextGroup();
                        gNext = gEnum.peekAtGroupAfter(next);
                        gPrev = gEnum.peekAtGroupBefore(next);
                        gAfterNext = gEnum.peekAtGroupAfter(next);
                        gBeforePrev = gEnum.peekAtGroupBefore(next);
                    }
                }
            }
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) {
                return;
            }
        } else {
            if (gPrev == -1) {
                return;
            }
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gPrev]) {
                return;
            }
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D lines without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D lines without m_Frame");
        }
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        if (rFrame == null) {
            throw new AssertionException("Can't draw 2.5D lines when m_Frame has no bounding rect");
        }
        double fThickMax = this.m_bHorz ? (double)rFrame.width / 12.0 : (double)rFrame.height / 12.0;
        int nOffset = (int)(fThickMax * (double)this.m_nLineThick / 100.0);
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
        boolean bDescending = yAxisObj.isDescending();
        BlackBoxIF blackBox = this.assignSeriesColor(s, g);
        BlackBoxIF blackBoxNew = this.getMissingDataBlackBox(s, g);
        if (blackBoxNew == null) {
            blackBoxNew = blackBox;
        }
        boolean bl = bDescending ? nValueCoord > nZeroCoord : (bNegValue = nValueCoord < nZeroCoord);
        if (this.wantDepthEffect()) {
            Point ptBackOffset = this.m_seriesBackOffsets[s];
            ptFrontOffset = this.m_seriesFrontOffsets[s];
            dx = ptFrontOffset.x - ptBackOffset.x;
            dy = ptFrontOffset.y - ptBackOffset.y;
        } else {
            ptFrontOffset = new Point();
            dx = 0;
            dy = 0;
        }
        Polygon polyFront = new Polygon();
        Point p0 = this.getCoords(s, g);
        int x0 = p0.x - ptFrontOffset.x;
        int y0 = p0.y - ptFrontOffset.y;
        polyFront.addPoint(x0, y0);
        Point p1 = bForwardGroups ? this.getCoords(s, gNext) : this.getCoords(s, gPrev);
        int x1 = p1.x - ptFrontOffset.x;
        int y1 = p1.y - ptFrontOffset.y;
        polyFront.addPoint(x1, y1);
        double fAngleRad = Math.atan2(y1 - y0, x1 - x0);
        double fAngleDeg = fAngleRad * 57.29577951308232;
        if (this.m_nDepthAngle <= 90) {
            bDrawUnderside = this.m_bHorz ? fAngleDeg < (double)(this.m_nDepthAngle - 180) : fAngleDeg > (double)this.m_nDepthAngle;
        } else {
            boolean bl2 = bDrawUnderside = fAngleDeg + 180.0 < (double)this.m_nDepthAngle;
        }
        if (this.m_bHorz) {
            x2 = x1 - nOffset;
            y2 = y1;
            x3 = x0 - nOffset;
            y3 = y0;
        } else {
            x2 = x1;
            y2 = y1 - nOffset;
            x3 = x0;
            y3 = y0 - nOffset;
        }
        polyFront.addPoint(x2, y2);
        polyFront.addPoint(x3, y3);
        polyFront.addPoint(x0, y0);
        if (bDrawUnderside) {
            polyTop = new Polygon();
            polyTop.addPoint(x2, y2);
            polyTop.addPoint(x3, y3);
            polyTop.addPoint(x3 + dx, y3 + dy);
            polyTop.addPoint(x2 + dx, y2 + dy);
            polyTop.addPoint(x2, y2);
        } else {
            polyTop = new Polygon();
            polyTop.addPoint(x0, y0);
            polyTop.addPoint(x1, y1);
            polyTop.addPoint(x1 + dx, y1 + dy);
            polyTop.addPoint(x0 + dx, y0 + dy);
            polyTop.addPoint(x0, y0);
        }
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = this.m_bHorz ? 0.6 : (bDrawUnderside ? 0.4 : 0.8);
        }
        new DetPolygon(this.m_Detectiv, new IdentObj(318, s, g), polyTop, blackBoxNew, fIntensity);
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = 1.0;
        }
        new DetPolygon(this.m_Detectiv, new IdentObj(258, s, g), polyFront, blackBoxNew, fIntensity);
        boolean bl3 = bShowLeftSide = bRightToLeft || this.m_bHorz;
        if (bForwardGroups) {
            bDrawSidePolygon = bShowLeftSide ? g == gFirst || gPrev != -1 && !this.m_dataOK[s][gPrev] : gNext == gLast || gAfterNext != -1 && !this.m_dataOK[s][gAfterNext];
        } else if (bShowLeftSide) {
            bDrawSidePolygon = g == gLast || gNext != -1 && !this.m_dataOK[s][gNext];
        } else {
            boolean bl4 = bDrawSidePolygon = gPrev == gFirst || gBeforePrev != -1 && !this.m_dataOK[s][gBeforePrev];
        }
        if (bDrawSidePolygon) {
            Polygon polySide = new Polygon();
            if (bShowLeftSide) {
                polySide.addPoint(x0, y0);
                polySide.addPoint(x3, y3);
                polySide.addPoint(x3 + dx, y3 + dy);
                polySide.addPoint(x0 + dx, y0 + dy);
                polySide.addPoint(x0, y0);
            } else {
                polySide.addPoint(x1, y1);
                polySide.addPoint(x2, y2);
                polySide.addPoint(x2 + dx, y2 + dy);
                polySide.addPoint(x1 + dx, y1 + dy);
                polySide.addPoint(x1, y1);
            }
            if (this.m_bColorAutoshadeRisers) {
                fIntensity = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(317, s, g), polySide, blackBoxNew, fIntensity);
        }
    }

    protected void drawWaterfallLines() {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int sLast = sEnum.getLastSeries();
        IdentObj id = this.m_Perspective.getWaterfallLine();
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
        int nLineWidth = this.m_Perspective.getLineWidth(id);
        int nLineStyle = this.m_Perspective.getLineStyle(id);
        while (gEnum.hasMoreElements()) {
            int x2;
            int x1;
            int y2;
            int y1;
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            int gPrev = gEnum.peekAtGroupBefore(g);
            if (gPrev == -1) continue;
            if (this.m_bHorz) {
                y1 = this.m_ordCoords[sLast][gPrev] + this.m_barThickCoord;
                y2 = this.m_ordCoords[sLast][g];
                x2 = x1 = this.m_numYCoords[sLast][gPrev];
            } else {
                x1 = this.m_ordCoords[sLast][gPrev];
                x2 = this.m_ordCoords[sLast][g] + this.m_barThickCoord;
                y2 = y1 = this.m_numYCoords[sLast][gPrev];
            }
            new DetLine(this.m_Detectiv, id, x1, y1, x2, y2, (BlackBoxIF)bb, null, nLineWidth, nLineStyle);
        }
    }

    protected Point getCoords(int s, int g) {
        int nCenterOrd = !this.m_bIsThisAComboWithBar && this.m_bExtendToFrameEdge ? this.m_ordCoords[s][g] : (this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] + this.m_barThickCoord / 2 : this.m_ordCoords[s][g]);
        Point ptCenter = this.m_bHorz ? new Point(this.m_numYCoords[s][g], nCenterOrd) : new Point(nCenterOrd, this.m_numYCoords[s][g]);
        return ptCenter;
    }

    protected Point getVCPositionsXY(int s, double x, double y) throws AssertionException {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        int sFirst = sEnum.getFirstSeries();
        Axis2DObj xAxis = (Axis2DObj)this.m_O1Axis;
        Axis2DObj yAxis = (Axis2DObj)this.whichAxisForSeries(s, null);
        int xCoordLow = (int)xAxis.getLowCoord((double)(s - sFirst), x);
        int xCoord = xCoordLow + this.m_barThickCoord / 2;
        int yCoord = (int)yAxis.getValueCoord(y);
        if (this.wantDepthEffect()) {
            Point frontOffset = this.m_seriesFrontOffsets[s];
            xCoord -= frontOffset.x;
            yCoord -= frontOffset.y;
        }
        if (this.m_bHorz) {
            return new Point(yCoord, xCoord);
        }
        return new Point(xCoord, yCoord);
    }

    public boolean isBottomStackedArea(int s) {
        return this.isVisibleStackedArea(s, false);
    }

    public boolean isTopStackedArea(int s) {
        return this.isVisibleStackedArea(s, true);
    }

    public boolean isVisibleStackedArea(int sCurrent, boolean bTopFace) {
        int axisCurrent = this.getAxisAssignment(sCurrent);
        boolean bForward = !bTopFace;
        boolean bIsTop = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForward);
        while (bIsTop && sEnum.hasMoreElements()) {
            boolean bDone;
            int s = sEnum.nextSeries();
            boolean bl = bForward ? s >= sCurrent : (bDone = s <= sCurrent);
            if (bDone) break;
            if (this.m_seriesTypes[s] != 3 || this.getAxisAssignment(s) != axisCurrent) continue;
            bIsTop = false;
        }
        return bIsTop;
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        return ResultString;
    }

    protected boolean wantDepthEffect() {
        return this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect();
    }

    protected boolean wantRisersFromZero(RelativeAxisObj yAxisObj) {
        boolean bFromZero;
        if (this.m_gt.isWaterfall()) {
            bFromZero = false;
        } else {
            bFromZero = this.m_bFromZero;
            if (!bFromZero) {
                bFromZero = yAxisObj.hasNegData() && !this.m_bAbsolute && !yAxisObj.isLogScale();
            }
        }
        return bFromZero;
    }
}

