/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import tdg.MarkerTemplate;
import tdg.QSortPoly;

public class DepthMarker {
    private DepthMarker() {
    }

    static Vector createDepthMarker(MarkerTemplate markerTemplate, int nXDepth, int nYDepth, int nDepthAngle) {
        Vector<Polygon> vectorPolyMarker = null;
        Polygon polyMarkerFace = DepthMarker.getDepthMarkerFace(markerTemplate);
        if (polyMarkerFace != null) {
            vectorPolyMarker = new Vector<Polygon>();
            int nFace = 0;
            while (nFace < polyMarkerFace.npoints) {
                int nSide = (nFace + 1) % polyMarkerFace.npoints;
                Polygon polyMarkerSide = new Polygon();
                polyMarkerSide.addPoint(polyMarkerFace.xpoints[nFace], polyMarkerFace.ypoints[nFace]);
                polyMarkerSide.addPoint(polyMarkerFace.xpoints[nSide], polyMarkerFace.ypoints[nSide]);
                polyMarkerSide.addPoint(polyMarkerFace.xpoints[nSide] + nXDepth, polyMarkerFace.ypoints[nSide] + nYDepth);
                polyMarkerSide.addPoint(polyMarkerFace.xpoints[nFace] + nXDepth, polyMarkerFace.ypoints[nFace] + nYDepth);
                vectorPolyMarker.addElement(polyMarkerSide);
                ++nFace;
            }
            int nSortType = nDepthAngle > 90 ? 1 : 0;
            QSortPoly.quickSortPoly(vectorPolyMarker, 0, vectorPolyMarker.size() - 1, nSortType);
            vectorPolyMarker.addElement(polyMarkerFace);
        }
        return vectorPolyMarker;
    }

    protected static Polygon getDepthMarkerFace(MarkerTemplate markerTemplate) {
        Polygon polyMarkerFace = null;
        if (markerTemplate.m_markerType != 0) {
            if (markerTemplate.m_polygon == null) {
                Rectangle rectTemplate = markerTemplate.m_rect;
                polyMarkerFace = new Polygon();
                polyMarkerFace.addPoint(rectTemplate.x, rectTemplate.y);
                polyMarkerFace.addPoint(rectTemplate.x + rectTemplate.width, rectTemplate.y);
                polyMarkerFace.addPoint(rectTemplate.x + rectTemplate.width, rectTemplate.y + rectTemplate.height);
                polyMarkerFace.addPoint(rectTemplate.x, rectTemplate.y + rectTemplate.height);
            } else {
                polyMarkerFace = new Polygon(markerTemplate.m_polygon.xpoints, markerTemplate.m_polygon.ypoints, markerTemplate.m_polygon.npoints);
            }
        }
        return polyMarkerFace;
    }
}

