/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import tdg.Access;
import tdg.Assert;
import tdg.Axis2DObj;
import tdg.AxisTemplate;
import tdg.CategoryIF;
import tdg.JGraphType;
import tdg.ObjClassID;
import tdg.Perspective;
import tdg.SmartAxisBase;
import tdg.TDGNestedLabel;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLabel;
import tdg.draw.DetLine;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;
import tdg.draw.SimpleBlackBoxObj;
import tdg.draw.TextStyleObj;
import tdg.event.TDGEventManager;

public abstract class AxisObj
implements Serializable {
    static final CategoryIF LOG = Perspective.getInstance("AXIS.AxisObj");
    protected static final int kNOSKIP = 0;
    protected static final int kAUTOSKIP = 1;
    protected static final int kMANUALSKIP = 2;
    protected static final int GRID_TICK_NORMAL = 0;
    protected static final int GRID_TICK_NORMAL_WITH_TICK = 1;
    protected static final int GRID_TICK_INSIDE = 2;
    protected static final int GRID_TICK_OUTSIDE = 3;
    protected static final int GRID_TICK_SPANNING = 4;
    protected static final int MAX_TITLE_HEIGHT = 2300;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_TOPLEFT = 2;
    public static final int ALIGN_TOP = 3;
    public static final int ALIGN_TOPRIGHT = 4;
    public static final int ALIGN_RIGHT = 5;
    public static final int ALIGN_BOTTOMRIGHT = 6;
    public static final int ALIGN_BOTTOM = 7;
    public static final int ALIGN_BOTTOMLEFT = 8;
    protected static final int AXISSIDE_LEFT = 0;
    protected static final int AXISSIDE_RIGHT = 1;
    protected static final int AXISSIDE_BOTH = 2;
    protected static final int CENTER_LINE_MISC_OFFSET = 1000;
    protected static final int NEXTLEVEL_LINE_MISC_OFFSET = 2000;
    protected static final int LEVEL_MISC_OFFSET = 1000;
    protected Perspective m_Perspective;
    protected Access m_Access;
    protected AxisTemplate m_template;
    protected boolean m_bAscending;
    protected int m_numSeries;
    protected int m_numGroups;
    protected int m_numTotalSeries;
    protected int m_numTotalGroups;
    protected boolean m_bReverseGroups;
    protected boolean m_bReverseSeries;
    protected int m_nAxisObjectID;
    protected boolean m_bDelayGridCalc;
    protected boolean m_bDrawGrids;
    protected double m_fAxisLengthRel;
    protected double m_fAxisPositionRel;
    protected boolean m_bDelayCalcLabels;
    protected int m_nAutoSkip;
    protected int m_nLabelBegin;
    protected int m_nSkipFactor = 0;
    protected boolean m_bSkippedLabels;
    protected int m_axisLabelTextSizeVC;
    protected int m_nOrdinalAxisType;
    protected int m_nNestingLevel;
    protected int m_nTopNestingLevel;
    protected boolean m_bNestedLabelBrackets;
    protected TDGNestedLabel m_cbO1Labels;
    protected SmartAxisBase m_SmartAxis;
    JGraphType m_gt;

    public AxisObj(Perspective perspective, Access access, AxisTemplate template, boolean ascending, int nAxisOffset, int nAxisSize) {
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
        this.m_Access = access;
        this.m_template = template;
        this.m_bAscending = ascending;
        this.m_numSeries = access.getNumNonIgnoredSeries();
        this.m_numGroups = access.getNumGroups();
        this.m_numTotalSeries = access.getNumTotalSeries();
        this.m_numTotalGroups = access.getNumTotalGroups();
        this.m_bReverseGroups = this.m_Perspective.getReverseGroups();
        this.m_bReverseSeries = this.m_Perspective.getReverseSeries();
        this.m_nAxisObjectID = this.m_template.getAxis().getObjectID();
        this.m_fAxisLengthRel = (double)nAxisSize / 100.0;
        this.m_fAxisPositionRel = (double)nAxisOffset / 100.0;
        this.m_bDelayCalcLabels = false;
        this.m_bDrawGrids = true;
        this.m_axisLabelTextSizeVC = this.m_Perspective.getAxisTextAutofitMin();
        if (this.m_axisLabelTextSizeVC <= 10) {
            this.m_axisLabelTextSizeVC = 10;
        }
        this.m_nNestingLevel = 0;
        this.m_cbO1Labels = this.m_Perspective.getO1LabelCallBack();
        this.m_nTopNestingLevel = this.isO1WithNestedLabels() ? this.m_cbO1Labels.getNumLevels() - 1 : 0;
        this.m_bNestedLabelBrackets = this.m_Perspective.getDisplay(this.m_Perspective.getNestedO1LabelLine());
        this.m_SmartAxis = new SmartAxisBase();
    }

    public void calc() {
        boolean bGridsDrawn;
        this.m_SmartAxis.preCalc(this, this.m_Perspective);
        if (!this.m_bDelayCalcLabels) {
            try {
                this.calcLabels();
            }
            catch (Throwable e) {
                LOG.warn("Exception during label draw, id = " + this.m_template.getLabel());
            }
        }
        if (this.m_bDrawGrids && !(bGridsDrawn = this.m_SmartAxis.calcGrids())) {
            this.calcGrids();
        }
    }

    protected void calcGrids() {
        SimpleBlackBoxObj blackbox;
        int nMajorGridLines = this.getNumMajorGrids();
        if (!this.m_bDrawGrids) {
            return;
        }
        if (this.getMinorGridDisplay(this.m_template)) {
            blackbox = new SimpleBlackBoxObj(this.m_Perspective, this.m_template.getMinor(), true);
            int nMisc = -3;
            double fPos = 0.0;
            int nMinorGridLines = this.getNumMinorGrids();
            IdentObj id = new IdentObj(this.m_template.getMinor());
            int nMajor = -1;
            while (nMajor <= nMajorGridLines) {
                int nMinor = 0;
                while (nMinor < nMinorGridLines) {
                    IdentObj newID = new IdentObj(id);
                    newID.setMiscID(nMisc++);
                    fPos = this.getMinorGridPos(nMajor, nMinor);
                    if (fPos > 0.0 && fPos < 1.0) {
                        this.calcMinorGridLine(newID, fPos, blackbox);
                    }
                    ++nMinor;
                }
                ++nMajor;
            }
        }
        if (this.getMajorGridDisplay(this.m_template)) {
            blackbox = new SimpleBlackBoxObj(this.m_Perspective, this.m_template.getMajor(), true);
            IdentObj id = new IdentObj(this.m_template.getMajor());
            boolean startSkip = false;
            boolean SkipCount = false;
            int i = 0;
            while (i < nMajorGridLines) {
                boolean bIgnoreGridSkip;
                boolean bExpressGrid = true;
                if ((this.m_nAutoSkip == 1 || this.m_nAutoSkip == 2) && this.m_bSkippedLabels) {
                    bExpressGrid = i >= this.m_nLabelBegin && (i - this.m_nLabelBegin) % (this.m_nSkipFactor + 1) == 0;
                }
                boolean bl = bIgnoreGridSkip = this.m_Perspective.getIgnoreGridSkip() || this.m_template.isNumeric();
                if (bIgnoreGridSkip) {
                    bExpressGrid = true;
                }
                if (this.isO1WithNestedLabels()) {
                    Vector v;
                    bExpressGrid = false;
                    if (this.m_cbO1Labels.getNumLevels() > 1 && (v = this.m_cbO1Labels.getAllLabels(1)).size() > 1) {
                        int j = 1;
                        while (j < v.size()) {
                            if (this.m_cbO1Labels.getParentIndex(j, 1) == i) {
                                bExpressGrid = true;
                            }
                            ++j;
                        }
                    }
                }
                if (bExpressGrid) {
                    IdentObj newID = new IdentObj(id);
                    newID.setMiscID(i - 3);
                    this.calcMajorGridLine(newID, this.getMajorGridPos(i), blackbox);
                }
                ++i;
            }
        }
    }

    protected void calcLabels() {
        if (!this.m_Perspective.getDisplay(this.m_template.getLabel())) {
            return;
        }
        int nNumLabels = this.getNumLabels();
        if (nNumLabels <= 0) {
            return;
        }
        Graphics gx = this.m_Perspective.getGraphicsContext();
        int nSide = this.getAxisSide();
        IdentObj idLabel = this.m_template.getLabel();
        boolean bAutofit = this.m_Perspective.getAutofit(idLabel);
        int nAutoSkip = this.m_Perspective.getAutoSkip(idLabel);
        if (this.isO1WithNestedLabels()) {
            this.drawNestedO1Labels(gx, nSide);
            return;
        }
        Vector rVectLabels = new Vector(nNumLabels);
        Vector strVectLabels = this.getLabels();
        Assert.assert(strVectLabels.size() == nNumLabels);
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        boolean bLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(idLabel);
        int nFontSizeVC = bLabelFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(idLabel)) : this.m_Perspective.getFontSizeVC(idLabel);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idLabel), this.m_Perspective.getFontStyle(idLabel), bLabelFontSizeAbsolute, this.m_Perspective.getFontSize(idLabel), nFontSizeVC, this.m_Perspective.getTextRotation(idLabel), this.m_Perspective.getTextJustHoriz(idLabel), this.m_Perspective.getTextJustVert(idLabel), false, false, this.m_Perspective.getTextWrap(idLabel));
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLabel);
        Vector nVectRelLabelPos = this.getRelLabelPos(nNumLabels);
        int nO1LabelAutoAngle = this.m_Perspective.getO1LabelAutoAngle();
        if (nO1LabelAutoAngle != 0 && !this.isVertical()) {
            nAutoSkip = this.O1LabelAutoRotate(gx, 0, nNumLabels, rVectLabels, nVectRelLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, strVectLabels);
        }
        switch (nAutoSkip) {
            case 2: {
                this.m_bSkippedLabels = true;
                this.calcLabelsManualSkip(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
                break;
            }
            case 1: {
                this.m_bSkippedLabels = this.calcLabelsAutoSkip(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
                break;
            }
            default: {
                this.m_bSkippedLabels = false;
                this.calcLabelsNoSkip(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox, rVectLabels, strVectLabels);
            }
        }
    }

    private void calcLabelsNoSkip(int nSide, int nNumLabels, Vector nVectRelLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox, Vector rVectLabels, Vector strVectLabels) {
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        Vector nVectIdents = this.getLabelIdents();
        if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
            this.calcLabelsOneSide(gx, 0, nNumLabels, rVectLabels, nVectRelLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, strVectLabels, nVectIdents);
        }
        if (this.m_SmartAxis.isInQALabelMode()) {
            nNumLabels = strVectLabels.size();
        }
        if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
            this.calcLabelsOneSide(gx, 1, nNumLabels, rVectLabels, nVectRelLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, strVectLabels, nVectIdents);
        }
    }

    private boolean calcLabelsAutoSkip(int nSide, int nNumLabels, Vector nVectRelLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        if (this.m_template.isNumeric() || !(this instanceof Axis2DObj) || !this.isO1Axis()) {
            bSkippedLabels = this.calcLabelsAutoSkip3D(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
        } else {
            if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
                bSkippedLabels = this.isVertical() ? this.calcLabelsAutoSkipFrameHeight(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox) : this.calcLabelsAutoSkipFrameWidth(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
            }
            if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
                bSkippedLabels = this.isVertical() ? this.calcLabelsAutoSkipFrameHeight(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox) : this.calcLabelsAutoSkipFrameWidth(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
            }
        }
        return bSkippedLabels;
    }

    private boolean calcLabelsAutoSkip3D(int nSide, int nNumLabels, Vector nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        Vector rVectLabels = new Vector(nNumLabels);
        Vector sVectLabels = this.getLabels();
        Vector nVectIdents = this.getLabelIdents();
        Vector sVectSkipLabels = new Vector(nNumLabels);
        Vector sVectSkipIdents = null;
        if (!this.m_template.isNumeric()) {
            sVectSkipIdents = new Vector(nNumLabels);
        }
        Vector nVectSkipLabelPos = new Vector(nNumLabels);
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        int nSkipLabels = 0;
        int nTextLargerThanBox = 0;
        int nAutoSkipMax = 25;
        boolean bOldTestLabelCalc = this.m_Perspective.getTestLabelCalc();
        this.m_Perspective.setTestLabelCalc(true);
        int nStopLoop = 0;
        while (nStopLoop < nAutoSkipMax) {
            boolean bLabelRotated;
            ++nStopLoop;
            sVectSkipLabels.removeAllElements();
            if (sVectSkipIdents != null) {
                sVectSkipIdents.removeAllElements();
            }
            nVectSkipLabelPos.removeAllElements();
            nSkipLabels = 0;
            int j = 0;
            while (j < nNumLabels) {
                sVectSkipLabels.addElement(sVectLabels.elementAt(j));
                if (sVectSkipIdents != null) {
                    sVectSkipIdents.addElement(nVectIdents.elementAt(j));
                }
                nVectSkipLabelPos.addElement(nVectLabelPos.elementAt(j));
                ++nSkipLabels;
                ++j;
            }
            nTextLargerThanBox = this.calcLabelsOneSide(gx, nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, sVectSkipIdents);
            if (nTextLargerThanBox != 0) {
                nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
                if (nLabelBegin < 0) {
                    nLabelBegin = 0;
                }
                if (nLabelBegin > nNumLabels - 1) {
                    nLabelBegin = nNumLabels - 1;
                }
                if (nSkipFactor == 0) {
                    nLabelBegin = 0;
                }
                if (nLabelBegin > nSkipFactor) {
                    nLabelBegin = 0;
                }
                bSkippedLabels = true;
                sVectSkipLabels.removeAllElements();
                if (sVectSkipIdents != null) {
                    sVectSkipIdents.removeAllElements();
                }
                nVectSkipLabelPos.removeAllElements();
                nSkipLabels = 0;
                int j2 = 0;
                while (j2 < nNumLabels) {
                    if (j2 >= nLabelBegin && (j2 - nLabelBegin) % (nSkipFactor + 1) == 0) {
                        sVectSkipLabels.addElement(sVectLabels.elementAt(j2));
                        if (sVectSkipIdents != null) {
                            sVectSkipIdents.addElement(nVectIdents.elementAt(j2));
                        }
                        nVectSkipLabelPos.addElement(nVectLabelPos.elementAt(j2));
                        ++nSkipLabels;
                    }
                    ++j2;
                }
                nTextLargerThanBox = this.calcLabelsOneSide(gx, nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, sVectSkipIdents);
            }
            boolean bl = bLabelRotated = textStyle.getRotationAngle() != 0;
            if (this.isVertical() ? (bLabelRotated ? nTextLargerThanBox != 2 && nTextLargerThanBox != 3 : nTextLargerThanBox != 1 && nTextLargerThanBox != 3) : (bLabelRotated ? nTextLargerThanBox != 1 && nTextLargerThanBox != 3 : nTextLargerThanBox != 2 && nTextLargerThanBox != 3)) break;
            ++nSkipFactor;
        }
        this.m_Perspective.setTestLabelCalc(bOldTestLabelCalc);
        this.calcLabelsOneSide(gx, nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, sVectSkipIdents);
        return bSkippedLabels;
    }

    private int O1LabelAutoRotate(Graphics gx, int nSide, int nNumLabels, Vector rVectLabels, Vector nVectLabelPos, BlackBoxObj blackBox, boolean bAutofit, int nAutoSkip, int nLabelBegin, int nSkipFactor, int nFontSizeVC, TextStyleObj textStyle, Vector sVectLabels) {
        if ((this.m_gt.isBLAType() || this.m_gt.isStockType()) && !this.m_gt.isOrientHorz() && this.isO1Axis()) {
            int nTextLargerThanBox = this.labelsOverlap(gx, 0, nNumLabels, rVectLabels, nVectLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectLabels);
            Dimension dimLargestOverlapLabel = textStyle.getDimLargeTextVC(this.m_Perspective.m_VC);
            TDGEventManager evtMgr = this.m_Perspective.getEventManager();
            switch (nTextLargerThanBox) {
                case 0: {
                    if (nAutoSkip != 1) break;
                    nAutoSkip = 0;
                    break;
                }
                case 1: {
                    dimLargestOverlapLabel.width = 0;
                    evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimLargestOverlapLabel);
                    break;
                }
                case 2: 
                case 3: {
                    evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimLargestOverlapLabel);
                    int nO1LabelAutoAngle = this.m_Perspective.getO1LabelAutoAngle();
                    textStyle.setRotationAngle(nO1LabelAutoAngle);
                }
            }
            rVectLabels = new Vector(nNumLabels);
        }
        return nAutoSkip;
    }

    private int labelsOverlap(Graphics gx, int nSide, int nNumLabels, Vector rVectLabels, Vector nVectLabelPos, BlackBoxObj blackBox, boolean bAutofit, int nAutoSkip, int nLabelBegin, int nSkipFactor, int nFontSizeVC, TextStyleObj textStyleLabel, Vector sVectLabels) {
        Rectangle rTitle = null;
        Vector nVectAlign = new Vector(nNumLabels);
        IdentObj title = this.getTitle();
        boolean bTitleRectAssigned = false;
        boolean bMovableAxisTitles = this.m_Perspective.getMoveAxisTitles();
        Rectangle rTitleInLook = null;
        if (this.m_Perspective.getDisplay(title)) {
            if (bMovableAxisTitles) {
                rTitleInLook = this.m_Perspective.getRect(title);
                if (rTitleInLook == null) {
                    bTitleRectAssigned = false;
                    rTitle = new Rectangle(0, 0, 0, 0);
                } else if (rTitleInLook.width == 0 && rTitleInLook.height == 0) {
                    bTitleRectAssigned = false;
                    rTitle = new Rectangle(0, 0, 0, 0);
                } else {
                    bTitleRectAssigned = true;
                }
            } else {
                rTitle = new Rectangle(0, 0, 0, 0);
            }
        }
        boolean bLabelRotated = textStyleLabel.getRotationAngle() != 0;
        this.getLabelAndTitlePos(nSide, nNumLabels, rVectLabels, nVectLabelPos, nVectAlign, rTitle, bLabelRotated, nAutoSkip, nLabelBegin, nSkipFactor, textStyleLabel);
        if (bMovableAxisTitles && bTitleRectAssigned) {
            rTitleInLook = this.m_Perspective.getRect(title);
            rTitle = new Rectangle(rTitleInLook);
        }
        Dimension dimSmallestLabel = this.getSmallestLabel(rVectLabels, nNumLabels);
        int nAutofitMin = this.getAutofitMinConstrained(bAutofit);
        int nAutofitMax = this.getAutofitMaxConstrained(bAutofit);
        int nTextLargerThanBox = textStyleLabel.formatAndAutofit(gx, this.m_Perspective, bAutofit, nAutofitMin, nAutofitMax, nFontSizeVC, sVectLabels, dimSmallestLabel, this.m_Perspective.m_VC);
        return nTextLargerThanBox;
    }

    private boolean calcLabelsAutoSkipFrameWidth(int nSide, int nNumLabels, Vector nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        Rectangle rFrame = ((Axis2DObj)this).getFrameRect();
        boolean bLabelRotated = textStyle.getRotationAngle() != 0;
        Dimension dimMaxVC = new Dimension(rFrame.width / nNumLabels, rFrame.height);
        Dimension dimMaxDC = this.m_Perspective.m_VC.virtToDest(dimMaxVC);
        Vector strVectLabels = this.getLabels();
        Dimension dimLabelDC = this.findLargestLabelFastest(gx, nNumLabels, dimMaxDC, strVectLabels, nFontSizeVC, textStyle, bLabelRotated);
        int nLabelSizeDC = bLabelRotated ? dimLabelDC.height : dimLabelDC.width;
        int nLabelSpaceTotalDC = nLabelSizeDC * nNumLabels;
        int nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        int nTotalSpaceAvail = this.m_Perspective.m_VC.virtToDestWidth(rFrame.width);
        int nSkipFactor = this.calcSkipFactor(nLabelSizeDC, nNumLabels, nLabelBegin, nLabelSpaceTotalDC, nTotalSpaceAvail);
        this.skipAndDrawLabels(nSide, nNumLabels, nVectLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox, strVectLabels, nLabelBegin, nSkipFactor);
        if (nSkipFactor > 0) {
            bSkippedLabels = true;
        }
        return bSkippedLabels;
    }

    private boolean calcLabelsAutoSkipFrameHeight(int nSide, int nNumLabels, Vector nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        Rectangle rFrame = ((Axis2DObj)this).getFrameRect();
        boolean bLabelRotated = textStyle.getRotationAngle() != 0;
        Dimension dimMax = new Dimension(rFrame.height / nNumLabels, rFrame.width);
        dimMax = this.m_Perspective.m_VC.virtToDest(dimMax);
        Vector strVectLabels = this.getLabels();
        Dimension dimLabelDC = this.findLargestLabelFastest(gx, nNumLabels, dimMax, strVectLabels, nFontSizeVC, textStyle, bLabelRotated);
        int nLabelSizeDC = bLabelRotated ? dimLabelDC.width : dimLabelDC.height;
        int nLabelSpaceTotalDC = nLabelSizeDC * nNumLabels;
        int nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        int nTotalSpaceAvail = this.m_Perspective.m_VC.virtToDestWidth(rFrame.height);
        int nSkipFactor = this.calcSkipFactor(nLabelSizeDC, nNumLabels, nLabelBegin, nLabelSpaceTotalDC, nTotalSpaceAvail);
        this.skipAndDrawLabels(nSide, nNumLabels, nVectLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox, strVectLabels, nLabelBegin, nSkipFactor);
        if (nSkipFactor > 0) {
            bSkippedLabels = true;
        }
        return bSkippedLabels;
    }

    private int calcSkipFactor(int nLabelSize, int nNumLabels, int nLabelBegin, int nLabelSpaceTotal, int nTotalSpaceAvail) {
        int nSkipFactor = 0;
        if (nLabelSpaceTotal > nTotalSpaceAvail) {
            if (nLabelSize >= nTotalSpaceAvail) {
                nSkipFactor = nNumLabels - nLabelBegin;
            } else {
                int nNumLabelsShown;
                nSkipFactor = 0;
                do {
                    nLabelSpaceTotal = 0;
                    nNumLabelsShown = (nNumLabels + ++nSkipFactor) / (nSkipFactor + 1);
                    int i = 0;
                    while (i < nNumLabels) {
                        int nSpace = i >= nLabelBegin && (i - nLabelBegin) % (nSkipFactor + 1) == 0 ? nLabelSize : 0;
                        nLabelSpaceTotal += nSpace;
                        ++i;
                    }
                } while (nLabelSpaceTotal > nTotalSpaceAvail && nNumLabelsShown >= 2);
            }
        }
        return nSkipFactor;
    }

    private void skipAndDrawLabels(int nSide, int nNumLabels, Vector nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox, Vector strVectLabels, int nLabelBegin, int nSkipFactor) {
        int nSkipLabels = 0;
        Vector nVectIdents = this.getLabelIdents();
        Vector rVectLabels = new Vector(nNumLabels);
        Vector nVectSkipLabelPos = new Vector(nNumLabels);
        Vector sVectSkipLabels = new Vector(nNumLabels);
        Vector sVectSkipIdents = new Vector(nNumLabels);
        int j = 0;
        while (j < nNumLabels) {
            if (j >= nLabelBegin && (j - nLabelBegin) % (nSkipFactor + 1) == 0) {
                sVectSkipLabels.addElement(strVectLabels.elementAt(j));
                sVectSkipIdents.addElement(nVectIdents.elementAt(j));
                nVectSkipLabelPos.addElement(nVectLabelPos.elementAt(j));
                ++nSkipLabels;
            }
            ++j;
        }
        this.calcLabelsOneSide(gx, nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, sVectSkipIdents);
    }

    private void calcLabelsManualSkip(int nSide, int nNumLabels, Vector nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        Vector rVectLabels = new Vector(nNumLabels);
        Vector sVectLabels = this.getLabels();
        Vector nVectIndents = this.getLabelIdents();
        Vector sVectSkipLabels = new Vector(nNumLabels);
        Vector nVectSkipIdents = null;
        Vector nVectSkipLabelPos = new Vector(nNumLabels);
        if (!this.m_template.isNumeric()) {
            nVectSkipIdents = new Vector(nNumLabels);
        }
        int nSkipLabels = 0;
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        nSkipFactor = this.m_Perspective.getSkipCount(this.m_template.getLabel());
        nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        if (nLabelBegin < 0) {
            nLabelBegin = 0;
        }
        if (nLabelBegin > nNumLabels - 1) {
            nLabelBegin = nNumLabels - 1;
        }
        if (nSkipFactor < 0) {
            nSkipFactor = 0;
        }
        if (nSkipFactor == 0) {
            nLabelBegin = 0;
        }
        if (nLabelBegin > nSkipFactor) {
            nLabelBegin = 0;
        }
        int nMod = nSkipFactor + 1;
        int j = 0;
        while (j < nNumLabels) {
            if (j >= nLabelBegin && (j - nLabelBegin) % nMod == 0) {
                sVectSkipLabels.addElement(sVectLabels.elementAt(j));
                nVectSkipLabelPos.addElement(nVectLabelPos.elementAt(j));
                ++nSkipLabels;
                if (!this.m_template.isNumeric()) {
                    nVectSkipIdents.addElement(nVectIndents.elementAt(j));
                }
            }
            ++j;
        }
        if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
            this.calcLabelsOneSide(gx, 0, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, nVectSkipIdents);
        }
        if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
            this.calcLabelsOneSide(gx, 1, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, nVectSkipIdents);
        }
    }

    private void drawNestedO1Labels(Graphics gx, int nSide) {
        IdentObj idLabel = this.m_template.getLabel();
        boolean bAutofit = this.m_Perspective.getAutofit(idLabel);
        if (this.m_cbO1Labels == null) {
            return;
        }
        boolean bNestedLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(idLabel);
        int nFontSizeVC = bNestedLabelFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(idLabel)) : this.m_Perspective.getFontSizeVC(idLabel);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idLabel), this.m_Perspective.getFontStyle(idLabel), bNestedLabelFontSizeAbsolute, this.m_Perspective.getFontSize(idLabel), nFontSizeVC, this.m_Perspective.getTextRotation(idLabel), this.m_Perspective.getTextJustHoriz(idLabel), this.m_Perspective.getTextJustVert(idLabel), false, false, this.m_Perspective.getTextWrap(idLabel));
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLabel);
        int nLevels = this.m_cbO1Labels.getNumLevels();
        int iLevel = 0;
        while (iLevel < nLevels) {
            this.m_nNestingLevel = iLevel;
            int nObjectID = ObjClassID.getObjectFromLevel(iLevel);
            this.calcOrdinalScale();
            int nNumLabels = this.m_cbO1Labels.getNumLabelsOnLevel(this.m_nNestingLevel);
            Vector rLabels = new Vector(nNumLabels);
            Vector szLabels = this.getLabels();
            Vector nVectLabelPos = this.getRelLabelPos(nNumLabels);
            int skipCount = this.m_Perspective.getNestedSkipCount(this.m_nNestingLevel);
            Vector nVectIndents = this.getLabelIdents();
            Vector sVectSkipLabels = null;
            Vector nVectSkipIdents = null;
            Vector nVectSkipLabelPos = null;
            if (skipCount > 0) {
                sVectSkipLabels = new Vector(nNumLabels);
                nVectSkipLabelPos = new Vector(nNumLabels);
                int nLabelBegin = 0;
                nVectSkipIdents = new Vector(nNumLabels);
                int nSkipLabels = 0;
                int nSkipFactor = skipCount;
                int nMod = nSkipFactor + 1;
                boolean bIrregularSkipping = this.m_Perspective.isTimeAxis() && this.isO1WithNestedLabels() && this.m_Perspective.isIrregularO1Skipping() && this.m_nNestingLevel == 0;
                int relIndex = -1;
                int j = 0;
                while (j < nNumLabels) {
                    boolean bIncludeLabel = j >= nLabelBegin && (j - nLabelBegin) % nMod == 0;
                    Object label = szLabels.elementAt(j);
                    if (bIrregularSkipping) {
                        if (label == null || ((String)label).length() < 1) {
                            bIncludeLabel = false;
                        } else {
                            boolean bl = bIncludeLabel = j >= nLabelBegin && ++relIndex % nMod == 0;
                        }
                    }
                    if (bIncludeLabel) {
                        sVectSkipLabels.addElement(szLabels.elementAt(j));
                        nVectSkipLabelPos.addElement(nVectLabelPos.elementAt(j));
                        ++nSkipLabels;
                        nVectSkipIdents.addElement(nVectIndents.elementAt(j));
                    }
                    ++j;
                }
                nVectIndents = nVectSkipIdents;
                szLabels = sVectSkipLabels;
                nVectLabelPos = nVectSkipLabelPos;
                nNumLabels = nSkipLabels;
            }
            if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
                this.calcLabelsOneSide(gx, 0, nNumLabels, rLabels, nVectLabelPos, blackBox, bAutofit, 0, 0, skipCount, nFontSizeVC, textStyle, szLabels, nVectIndents);
            }
            if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
                this.calcLabelsOneSide(gx, 1, nNumLabels, rLabels, nVectLabelPos, blackBox, bAutofit, 0, 0, skipCount, nFontSizeVC, textStyle, szLabels, nVectIndents);
            }
            ++iLevel;
        }
        this.m_nNestingLevel = 0;
        this.calcOrdinalScale();
    }

    private int getAutofitMinConstrained(boolean bAutofit) {
        int nAutofitMin = this.m_Perspective.getAxisTextAutofitMin();
        if (bAutofit) {
            switch (this.m_Perspective.getAxisTextAutofitMode()) {
                case 1: {
                    nAutofitMin = this.m_Perspective.getMinimumAxisTextSizeVC();
                    break;
                }
                case 2: {
                    double newAutofitPivotPoint = this.m_Perspective.getMinimumAxisTextSizeVC();
                    nAutofitMin = (int)(newAutofitPivotPoint - newAutofitPivotPoint * ((double)this.m_Perspective.getAxisTextAutofitPercent() / 100.0));
                }
            }
            if (nAutofitMin < this.m_Perspective.getAxisTextAutofitMin()) {
                nAutofitMin = this.m_Perspective.getAxisTextAutofitMin();
            }
        }
        return nAutofitMin;
    }

    private int getAutofitMaxConstrained(boolean bAutofit) {
        int nAutofitMax = this.m_Perspective.getAxisTextAutofitMax();
        if (bAutofit) {
            switch (this.m_Perspective.getAxisTextAutofitMode()) {
                case 1: {
                    nAutofitMax = this.m_Perspective.getMinimumAxisTextSizeVC();
                    break;
                }
                case 2: {
                    double newAutofitPivotPoint = this.m_Perspective.getMinimumAxisTextSizeVC();
                    nAutofitMax = (int)(newAutofitPivotPoint + newAutofitPivotPoint * ((double)this.m_Perspective.getAxisTextAutofitPercent() / 100.0));
                }
            }
            if (nAutofitMax > this.m_Perspective.getAxisTextAutofitMax()) {
                nAutofitMax = this.m_Perspective.getAxisTextAutofitMax();
            }
        }
        return nAutofitMax;
    }

    private Dimension getSmallestLabel(Vector rVectLabels, int nNumLabels) {
        Dimension dimSmallestLabel = new Dimension(1000000, 1000000);
        int i = 0;
        while (i < nNumLabels) {
            Rectangle r = (Rectangle)rVectLabels.elementAt(i);
            dimSmallestLabel.width = Math.min(dimSmallestLabel.width, r.width);
            dimSmallestLabel.height = Math.min(dimSmallestLabel.height, r.height);
            ++i;
        }
        return dimSmallestLabel;
    }

    private int calcLabelsOneSide(Graphics gx, int nSide, int nNumLabels, Vector rVectLabels, Vector nVectLabelPos, BlackBoxObj blackBox, boolean bAutofit, int nAutoSkip, int nLabelBegin, int nSkipFactor, int nFontSizeVC, TextStyleObj textStyle, Vector sVectLabels, Vector vectIDObj) {
        boolean bLabelRotated = textStyle.getRotationAngle() != 0;
        boolean bWordWrap = textStyle.getWordWrap();
        Rectangle rTitle = null;
        Vector nVectAlign = new Vector(nNumLabels);
        IdentObj title = this.getTitle();
        boolean bTitleRectAssigned = false;
        boolean bMovableAxisTitles = this.m_Perspective.getMoveAxisTitles();
        Rectangle rTitleInLook = null;
        if (this.m_Perspective.getDisplay(title)) {
            if (bMovableAxisTitles) {
                rTitleInLook = this.m_Perspective.getRect(title);
                if (rTitleInLook == null) {
                    bTitleRectAssigned = false;
                    rTitle = new Rectangle(0, 0, 0, 0);
                } else if (rTitleInLook.width == 0 && rTitleInLook.height == 0) {
                    bTitleRectAssigned = false;
                    rTitle = new Rectangle(0, 0, 0, 0);
                } else {
                    bTitleRectAssigned = true;
                }
            } else {
                rTitle = new Rectangle(0, 0, 0, 0);
            }
        }
        this.getLabelAndTitlePos(nSide, nNumLabels, rVectLabels, nVectLabelPos, nVectAlign, rTitle, bLabelRotated, nAutoSkip, nLabelBegin, nSkipFactor, textStyle);
        if (bMovableAxisTitles && bTitleRectAssigned) {
            rTitleInLook = this.m_Perspective.getRect(title);
            rTitle = new Rectangle(rTitleInLook);
        }
        Dimension dimSmallestLabel = this.getSmallestLabel(rVectLabels, nNumLabels);
        int nAutofitMin = this.getAutofitMinConstrained(bAutofit);
        int nAutofitMax = this.getAutofitMaxConstrained(bAutofit);
        int nTextLargerThanBox = 0;
        if (bAutofit || this.m_gt.is3DType() || this.m_template.isNumeric()) {
            nTextLargerThanBox = textStyle.formatAndAutofit(gx, this.m_Perspective, bAutofit, nAutofitMin, nAutofitMax, nFontSizeVC, sVectLabels, dimSmallestLabel, this.m_Perspective.m_VC);
        }
        if (nAutoSkip == 1 || nAutoSkip == 2) {
            this.m_nAutoSkip = nAutoSkip;
            this.m_nLabelBegin = nLabelBegin;
            if (nSkipFactor > this.m_nSkipFactor) {
                this.m_nSkipFactor = nSkipFactor;
            }
        }
        if (this.m_SmartAxis.isInQALabelMode() && nNumLabels > 2) {
            Object rFirst = rVectLabels.elementAt(0);
            Object rLast = rVectLabels.elementAt(nNumLabels - 1);
            rVectLabels.removeAllElements();
            rVectLabels.addElement(rFirst);
            rVectLabels.addElement(rLast);
            Object szFirst = sVectLabels.elementAt(0);
            Object szLast = sVectLabels.elementAt(nNumLabels - 1);
            sVectLabels.removeAllElements();
            sVectLabels.addElement(szFirst);
            sVectLabels.addElement(szLast);
            Object aFirst = nVectAlign.elementAt(0);
            Object aLast = nVectAlign.elementAt(nNumLabels - 1);
            nVectAlign.removeAllElements();
            nVectAlign.addElement(aFirst);
            nVectAlign.addElement(aLast);
            vectIDObj = null;
            nNumLabels = 2;
        }
        Dimension dimLargestLabel = this.alignLabelsOneSide(nSide, nNumLabels, dimSmallestLabel, rVectLabels, sVectLabels, nVectAlign, vectIDObj, nFontSizeVC, textStyle, gx, bLabelRotated, bAutofit, blackBox);
        if (rTitle != null && !rTitle.isEmpty() && this.m_nNestingLevel == this.m_nTopNestingLevel) {
            this.drawAxisTitle(nSide, bTitleRectAssigned, rTitle, rVectLabels, gx);
        }
        this.drawAxisLabels(nNumLabels, rVectLabels, sVectLabels, vectIDObj, textStyle, blackBox);
        if (this.isO1WithNestedLabels() && !this.m_Perspective.getTestLabelCalc() && this.m_bNestedLabelBrackets && this.m_nNestingLevel < this.m_nTopNestingLevel) {
            this.drawNestedLabelBrackets(nNumLabels, rVectLabels);
        }
        return nTextLargerThanBox;
    }

    protected TextStyleObj getTitleTextStyle(int nSide) {
        IdentObj title = this.getTitle();
        boolean bAutofit = this.m_Perspective.getAutofit(title);
        int nTitleFontSizeVC = this.getTitleFontSizeVC();
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(title);
        nTitleFontSizeVC = bTitleFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(title)) : this.m_Perspective.getFontSizeVC(title);
        TextStyleObj titleTextStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(title), this.m_Perspective.getFontStyle(title), bTitleFontSizeAbsolute, this.m_Perspective.getFontSize(title), nTitleFontSizeVC, this.getTitleRotation(this.m_template, nSide), this.m_Perspective.getTextJustHoriz(title), this.m_Perspective.getTextJustVert(title), bAutofit, false, this.m_Perspective.getTextWrap(title));
        if (title.getObjectID() == 232 || title.getObjectID() == 233) {
            titleTextStyle.setDisplayDrillIcon(true);
        }
        return titleTextStyle;
    }

    protected int getTitleFontSizeVC() {
        IdentObj title = this.getTitle();
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(title);
        int nTitleFontSizeVC = bTitleFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(title)) : this.m_Perspective.getFontSizeVC(title);
        return nTitleFontSizeVC;
    }

    private void drawAxisTitle(int nSide, boolean bTitleRectAssigned, Rectangle rTitle, Vector rLabels, Graphics gx) {
        IdentObj title = this.getTitle();
        boolean bAutofit = this.m_Perspective.getAutofit(title);
        if (!bTitleRectAssigned) {
            this.adjustTitlePosPass1(nSide, rLabels, rTitle);
        }
        TextStyleObj titleTextStyle = this.getTitleTextStyle(nSide);
        int nTitleFontSizeVC = this.getTitleFontSizeVC();
        Dimension dimTitle = new Dimension(rTitle.width, rTitle.height);
        Vector<String> vectStrTitle = new Vector<String>();
        vectStrTitle.addElement(this.m_Perspective.getTextString(title));
        if (bAutofit || this.m_gt.is3DType() || this.m_gt.isPolar() || this.m_gt.isRadarType()) {
            titleTextStyle.formatAndAutofit(gx, this.m_Perspective, bAutofit, this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nTitleFontSizeVC, vectStrTitle, dimTitle, this.m_Perspective.m_VC);
        }
        if (!bTitleRectAssigned) {
            this.adjustTitlePosPass2(title, nSide, rTitle, dimTitle);
        }
        BlackBoxObj titleBlackBox = new BlackBoxObj(this.m_Perspective, title);
        if (!this.m_Perspective.getTestLabelCalc() && this.doDisplayOnCalc()) {
            IdentObj idBox = this.getTitleBox();
            BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, idBox);
            if (this.m_Perspective.getDisplay(idBox)) {
                new DetRect(this.m_Perspective.getDetectiv(), idBox, rTitle.x, rTitle.y, rTitle.width, rTitle.height, bbBox, null, false, true, true);
            }
            String titleText = this.m_Perspective.getTextString(title);
            int fontSize = !this.m_Perspective.getFontSizeAbsolute(title) ? (this.isVertical() ? this.m_Perspective.getVC().virtToDestWidth(this.m_Perspective.getFontSizeVC(title)) : this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC(title))) : this.m_Perspective.getFontSize(title);
            int fontStyle = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(title));
            String fontName = this.m_Perspective.getFontName(title);
            Graphics g = this.m_Perspective.getGraphicsContext();
            Font font = new Font(fontName, fontStyle, fontSize);
            FontMetrics fm = g.getFontMetrics(font);
            int rectLength = this.isVertical() ? this.m_Perspective.getVC().virtToDestHeight(rTitle.height) : this.m_Perspective.getVC().virtToDestWidth(rTitle.width);
            if (!this.m_Perspective.getTextWrap(title) && rectLength < fm.stringWidth(titleText)) {
                titleText = TextStyleObj.truncateText(titleText, fm, 2, rectLength);
                this.m_Perspective.setAxisTitleTruncated(true, this.m_template.getAxisObjID(), title);
            }
            new DetLabel(this.m_Perspective.getDetectiv(), title, titleText, rTitle, titleTextStyle, titleBlackBox, this.m_Perspective.getMoveAxisTitles());
        }
    }

    private void drawNestedLabelBrackets(int nNumLabels, Vector rLabels) {
        int x1Ctr = 0;
        int y1Ctr = 0;
        IdentObj idBracket = this.m_Perspective.getNestedO1LabelLine();
        BlackBoxObj bbBracket = new BlackBoxObj(this.m_Perspective, idBracket);
        int nLWBracket = this.m_Perspective.getLineWidth(this.m_Perspective.getNestedO1LabelLine());
        boolean bVertScale = this.isVertical();
        int nOffset = this.m_Perspective.getEffectiveGroupOffset();
        int iBracket = 0;
        int i = 0;
        while (i < nNumLabels) {
            int nNumInBracket = this.m_cbO1Labels.getLabelGrouping(i + nOffset, this.m_nNestingLevel);
            Rectangle rLabel = (Rectangle)rLabels.elementAt(i);
            if (rLabel != null && !rLabel.isEmpty()) {
                int y2;
                int y1;
                int x2;
                int x1;
                if (bVertScale) {
                    x1 = rLabel.x;
                    x2 = rLabel.x - rLabel.width / 4;
                    y2 = y1 = rLabel.y + rLabel.height / 2;
                } else {
                    x2 = x1 = rLabel.x + rLabel.width / 2;
                    y1 = rLabel.y;
                    y2 = rLabel.y - rLabel.height / 4;
                }
                IdentObj newId = new IdentObj(idBracket);
                newId.setMiscID(i);
                new DetLine(this.m_Perspective.getDetectiv(), newId, x1, y1, x2, y2, bbBracket, null, nLWBracket);
                if (iBracket == 0) {
                    x1Ctr = x2;
                    y1Ctr = y2;
                }
                if (iBracket == nNumInBracket - 1) {
                    int y2Next;
                    int y1Next;
                    int x2Next;
                    int x1Next;
                    int x2Ctr = x2;
                    int y2Ctr = y2;
                    newId = new IdentObj(idBracket);
                    newId.setMiscID(i + 1000);
                    new DetLine(this.m_Perspective.getDetectiv(), newId, x1Ctr, y1Ctr, x2Ctr, y2Ctr, bbBracket, null, nLWBracket);
                    if (bVertScale) {
                        x1Next = x1Ctr;
                        x2Next = x1Ctr - rLabel.width / 4;
                        y2Next = y1Next = (y1Ctr + y2Ctr) / 2;
                    } else {
                        x2Next = x1Next = (x1Ctr + x2Ctr) / 2;
                        y1Next = (y1Ctr + y2Ctr) / 2;
                        y2Next = y1Next - rLabel.height / 4;
                    }
                    newId = new IdentObj(idBracket);
                    newId.setMiscID(i + 2000);
                    new DetLine(this.m_Perspective.getDetectiv(), newId, x1Next, y1Next, x2Next, y2Next, bbBracket, null, nLWBracket);
                    iBracket = 0;
                } else {
                    ++iBracket;
                }
            }
            ++i;
        }
    }

    private Dimension alignLabelsOneSide(int nSide, int nNumLabels, Dimension dimSmallestLabel, Vector rVectLabels, Vector sVectLabels, Vector nVectAlign, Vector nVectIdents, int nFontSizeVC, TextStyleObj textStyle, Graphics g, boolean bLabelRotated, boolean bAutofit, BlackBoxObj blackBox) {
        Dimension dimHorizLargestLabel = new Dimension(0, 0);
        Dimension dimLargestLabelDC = this.findLargestLabelFastest(g, nNumLabels, dimSmallestLabel, sVectLabels, nFontSizeVC, textStyle, bLabelRotated);
        if (bLabelRotated) {
            int nHeight = dimLargestLabelDC.height;
            dimLargestLabelDC.height = dimLargestLabelDC.width;
            dimLargestLabelDC.width = nHeight;
        }
        Dimension dimLargestLabelVC = this.m_Perspective.m_VC.destToVirt(dimLargestLabelDC);
        int i = 0;
        while (i < nNumLabels) {
            boolean bSkipLabel = this.skipFirstOrLastLabel(i, nNumLabels);
            if (!bSkipLabel) {
                Rectangle rLabel = (Rectangle)rVectLabels.elementAt(i);
                switch ((Integer)nVectAlign.elementAt(i)) {
                    case 1: {
                        rLabel.y += (rLabel.height - dimLargestLabelVC.height) / 2;
                        break;
                    }
                    case 2: {
                        rLabel.y = rLabel.y + rLabel.height - dimLargestLabelVC.height;
                        break;
                    }
                    case 3: {
                        if (this.m_nNestingLevel != 1) {
                            rLabel.x += (rLabel.width - dimLargestLabelVC.width) / 2;
                        }
                        rLabel.y = rLabel.y + rLabel.height - dimLargestLabelVC.height;
                        break;
                    }
                    case 4: {
                        rLabel.x = rLabel.x + rLabel.width - dimLargestLabelVC.width;
                        rLabel.y = rLabel.y + rLabel.height - dimLargestLabelVC.height;
                        break;
                    }
                    case 5: {
                        rLabel.x = rLabel.x + rLabel.width - dimLargestLabelVC.width;
                        rLabel.y += (rLabel.height - dimLargestLabelVC.height) / 2;
                        break;
                    }
                    case 6: {
                        rLabel.x = rLabel.x + rLabel.width - dimLargestLabelVC.width;
                        break;
                    }
                    case 7: {
                        rLabel.x += (rLabel.width - dimLargestLabelVC.width) / 2;
                        break;
                    }
                }
                rLabel.width = dimLargestLabelVC.width;
                rLabel.height = dimLargestLabelVC.height;
                this.adjustLabelPos(nSide, nNumLabels, rVectLabels);
                this.m_axisLabelTextSizeVC = textStyle.getFontSizeVC(this.m_Perspective.m_VC);
                dimHorizLargestLabel.width = Math.max(dimHorizLargestLabel.width, rLabel.width);
                dimHorizLargestLabel.height = Math.max(dimHorizLargestLabel.height, rLabel.height);
            }
            ++i;
        }
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (this.isO1Axis() && gt.isOrientHorz()) {
            TDGEventManager evtMgr = this.m_Perspective.getEventManager();
            evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimHorizLargestLabel);
        }
        return dimLargestLabelVC;
    }

    private void drawAxisLabels(int nNumLabels, Vector rVectLabels, Vector sVectLabels, Vector vectIDObj, TextStyleObj textStyle, BlackBoxObj blackBox) {
        int i = 0;
        while (i < nNumLabels) {
            boolean bSkipLabel = this.skipFirstOrLastLabel(i, nNumLabels);
            if (!bSkipLabel) {
                Object label = sVectLabels.elementAt(i);
                if (!this.m_Perspective.isTimeAxis() || !this.isO1WithNestedLabels() || !this.m_Perspective.isIrregularO1Skipping() || label != null && ((String)label).length() >= 1) {
                    Rectangle rLegend;
                    IdentObj idLegend;
                    Rectangle rBounds;
                    Rectangle rLabel = (Rectangle)rVectLabels.elementAt(i);
                    if (!this.m_template.isNumeric() || i != 0 && i != nNumLabels - 1 || (rBounds = this.m_Perspective.getVC().getVirtCoords()).contains(rLabel) && (!this.m_Perspective.getDisplay(idLegend = this.m_Perspective.getLegendArea()) || !rLabel.intersects(rLegend = this.m_Perspective.getRect(idLegend)))) {
                        IdentObj newID;
                        if (vectIDObj != null && vectIDObj.elementAt(i) != null) {
                            IdentObj idFromVector = (IdentObj)vectIDObj.elementAt(i);
                            int s = idFromVector.getSeriesID();
                            int gg = idFromVector.getGroupID();
                            if (this.m_nNestingLevel > 0) {
                                gg = this.m_cbO1Labels.getParentIndex(gg, this.m_nNestingLevel);
                            }
                            newID = new IdentObj(this.m_template.getLabel().getObjectID(), s, gg);
                            if (s == -3 && gg == -3) {
                                newID.setMiscID(i + 1000 * this.m_nNestingLevel);
                            }
                            if (this.isO1WithNestedLabels()) {
                                newID.setMiscID(this.m_nTopNestingLevel - this.m_nNestingLevel);
                            }
                        } else {
                            newID = new IdentObj(this.m_template.getLabel());
                            newID.setMiscID(i + 1000 * this.m_nNestingLevel);
                        }
                        if (this.m_nNestingLevel == 1) {
                            textStyle.setHorizAlign(0);
                        }
                        if (!this.m_Perspective.getTestLabelCalc() && this.doDisplayOnCalc()) {
                            new DetLabel(this.m_Perspective.getDetectiv(), newID, (String)sVectLabels.elementAt(i), rLabel, textStyle, blackBox, false);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private boolean skipFirstOrLastLabel(int i, int nNumLabels) {
        boolean bSkip = false;
        if (i == 0 && this.m_Perspective.getExcludeMinLabel(this.m_template.getLabel())) {
            bSkip = true;
        }
        if (i == nNumLabels - 1 && this.m_Perspective.getExcludeMaxLabel(this.m_template.getLabel())) {
            bSkip = true;
        }
        return bSkip;
    }

    private Vector getRelLabelPos(int nNumLabels) {
        Vector<Double> nVectLabelPos = new Vector<Double>(nNumLabels);
        int nAxisID = this.m_nAxisObjectID;
        int nAxisO1ID = 2001;
        int nAxisO2ID = 2002;
        boolean bReverse = false;
        if (this.m_gt.is3DType() && !this.m_gt.is3DSurface()) {
            if (nAxisID == nAxisO1ID && !this.m_bReverseGroups) {
                bReverse = true;
            }
            if (nAxisID == nAxisO2ID && this.m_bReverseSeries) {
                bReverse = true;
            }
        } else {
            if (nAxisID == nAxisO1ID && this.m_bReverseGroups) {
                bReverse = true;
            }
            if (nAxisID == nAxisO2ID && this.m_bReverseSeries) {
                bReverse = true;
            }
        }
        int i = 0;
        while (i < nNumLabels) {
            int nIdx = bReverse ? nNumLabels - i - 1 : i;
            nVectLabelPos.addElement(new Double(this.getLabelRelPos(nIdx)));
            ++i;
        }
        return nVectLabelPos;
    }

    public int getAxisTextLabelSizeVC() {
        return this.m_axisLabelTextSizeVC;
    }

    public int getAxisObjID() {
        return this.m_template.getAxisObjID();
    }

    public AxisTemplate getAxisTemplate() {
        return this.m_template;
    }

    public IdentObj getAxisIdentObj() {
        return this.m_template.getAxis();
    }

    public double getAutoLowerSplitValue() {
        return this.m_SmartAxis.getAutoLowerSplitValue();
    }

    public double getAutoHigherSplitValue() {
        return this.m_SmartAxis.getAutoHigherSplitValue();
    }

    public boolean isAscending() {
        return this.m_bAscending;
    }

    public boolean isDescending() {
        return !this.m_bAscending;
    }

    public boolean isO1WithNestedLabels() {
        if (this.m_cbO1Labels == null) {
            return false;
        }
        if (!this.m_Perspective.getNestedLabels()) {
            return false;
        }
        boolean bO1Axis = this.isO1Axis();
        return bO1Axis;
    }

    public boolean isO1Axis() {
        boolean bO1Axis = this.m_nAxisObjectID == 2001;
        return bO1Axis;
    }

    public boolean isY2Axis() {
        boolean bY2Axis = this.m_nAxisObjectID == 2005;
        return bY2Axis;
    }

    public boolean isY3Axis() {
        boolean bY3Axis = this.m_nAxisObjectID == 2012;
        return bY3Axis;
    }

    public boolean isY4Axis() {
        boolean bY4Axis = this.m_nAxisObjectID == 2013;
        return bY4Axis;
    }

    public boolean isY5Axis() {
        boolean bY5Axis = this.m_nAxisObjectID == 2014;
        return bY5Axis;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setDrawGrids(boolean bDrawGrids) {
        this.m_bDrawGrids = bDrawGrids;
    }

    protected IdentObj getTitle() {
        block5: {
            block4: {
                if (this.m_template.getAxisObjID() == 5) break block4;
                if (this.m_template.getAxisObjID() != 6) break block5;
            }
            if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_template.getDrillLabel()) != null && this.m_Perspective.getDisplay(this.m_template.getDrillLabel())) {
                return this.m_template.getDrillLabel();
            }
        }
        return this.m_template.getTitle();
    }

    protected IdentObj getTitleBox() {
        block5: {
            block4: {
                if (this.m_template.getAxisObjID() == 5) break block4;
                if (this.m_template.getAxisObjID() != 6) break block5;
            }
            if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_template.getDrillLabel()) != null && this.m_Perspective.getDisplay(this.m_template.getDrillLabel())) {
                return this.m_template.getDrillLabelBox();
            }
        }
        return this.m_template.getTitleBox();
    }

    private Dimension findLargestLabelFastest(Graphics g, int nNumLabels, Dimension dimLabelMaxVC, Vector sVectLabels, int nFontSizeVC, TextStyleObj textStyle, boolean bRotated) {
        Dimension dimLargestLabelDC = new Dimension(0, 0);
        int nFontSizeDC = this.m_Perspective.m_VC.virtToDestHeight(nFontSizeVC);
        Dimension dimLabelMaxDC = this.m_Perspective.m_VC.virtToDest(dimLabelMaxVC);
        if (bRotated) {
            int nSaveWidth = dimLabelMaxDC.width;
            dimLabelMaxDC.width = dimLabelMaxDC.height;
            dimLabelMaxDC.height = nSaveWidth;
        }
        int i = 0;
        while (i < nNumLabels) {
            boolean bSkipLabel = this.skipFirstOrLastLabel(i, nNumLabels);
            if (!bSkipLabel) {
                String strLabel = (String)sVectLabels.elementAt(i);
                Dimension dimLabel = textStyle.getTextSizeDC(g, strLabel, nFontSizeDC, this.m_Perspective.m_VC, dimLabelMaxDC, null);
                if (dimLabel.width > dimLargestLabelDC.width) {
                    dimLargestLabelDC.width = dimLabel.width;
                }
                if (dimLabel.height > dimLargestLabelDC.height) {
                    dimLargestLabelDC.height = dimLabel.height;
                }
            }
            ++i;
        }
        return dimLargestLabelDC;
    }

    protected abstract boolean isVertical();

    protected abstract void adjustTitlePosPass1(int var1, Vector var2, Rectangle var3);

    protected abstract void adjustTitlePosPass2(IdentObj var1, int var2, Rectangle var3, Dimension var4);

    protected abstract void adjustLabelPos(int var1, int var2, Vector var3);

    protected abstract boolean isAxisLabelVisible(int var1);

    protected abstract boolean doDisplayOnCalc();

    protected abstract void calcMajorGridLine(IdentObj var1, double var2, BlackBoxIF var4);

    protected abstract void calcMinorGridLine(IdentObj var1, double var2, BlackBoxIF var4);

    protected abstract int getAxisSide();

    protected abstract void getLabelAndTitlePos(int var1, int var2, Vector var3, Vector var4, Vector var5, Rectangle var6, boolean var7, int var8, int var9, int var10, TextStyleObj var11);

    protected abstract double getLabelRelPos(int var1);

    protected abstract Vector getLabels();

    protected abstract Vector getLabelIdents();

    protected abstract boolean getMajorGridDisplay(AxisTemplate var1);

    protected abstract double getMajorGridPos(int var1);

    protected abstract boolean getMinorGridDisplay(AxisTemplate var1);

    protected abstract double getMinorGridPos(int var1, int var2);

    public abstract double getMaxValue();

    public abstract double getMinValue();

    protected abstract void calcOrdinalScale();

    protected abstract int getNumLabels();

    protected abstract int getNumMajorGrids();

    protected abstract int getNumMinorGrids();

    protected abstract int getTitleRotation(AxisTemplate var1, int var2);

    protected abstract boolean isLogScale();

    protected abstract boolean isPolarAxis();

    protected abstract int getTitleJustVert(IdentObj var1, int var2);

    protected abstract int getTitleJustHoriz(IdentObj var1, int var2);

    public abstract String getNonZeroBaselineLabel();

    protected abstract double getValueCoord(double var1);
}

