/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.png;

import com.threedgraphics.png.PNGChunk;
import com.threedgraphics.png.PNGInfo;

class PNGTextChunk
extends PNGChunk {
    private static final String keyWord = "TDG_INFO";

    PNGTextChunk() {
    }

    int getDataLength() {
        PNGInfo info = this.getPNGInfo();
        String text = info.getImageText();
        int len = keyWord.length() + 1;
        if (text != null) {
            len += text.length();
        }
        return len;
    }

    String getChunkType() {
        return "tEXt";
    }

    byte[] getData() {
        PNGInfo info = this.getPNGInfo();
        String text = info.getImageText();
        if (text == null) {
            text = "";
        }
        byte[] keyWord_ascii = this.toAsciiArray(keyWord);
        int keyWordLen = keyWord_ascii.length;
        byte[] text_ascii = this.toAsciiArray(text);
        int textLen = text_ascii.length;
        byte[] data = new byte[keyWordLen + textLen + 1];
        System.arraycopy(keyWord_ascii, 0, data, 0, keyWordLen);
        data[keyWordLen] = 0;
        System.arraycopy(text_ascii, 0, data, keyWordLen + 1, textLen);
        return data;
    }

    boolean isCriticalChunk() {
        return false;
    }
}

