/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.png;

import com.threedgraphics.png.PNGChunk;
import com.threedgraphics.png.PNGDataWriter;
import com.threedgraphics.png.PNGException;
import com.threedgraphics.png.PNGInfo;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class PNGDataChunk
extends PNGChunk {
    private byte[] compressedData;

    PNGDataChunk() {
    }

    int getDataLength() throws PNGException {
        this.compressData();
        return this.compressedData.length;
    }

    String getChunkType() {
        return "IDAT";
    }

    byte[] getData() throws PNGException {
        if (this.compressedData == null) {
            this.compressData();
        }
        return this.compressedData;
    }

    boolean isCriticalChunk() {
        return true;
    }

    private void compressData() throws PNGException {
        PNGInfo info = this.getPNGInfo();
        if (info.getFilterType() != 0) {
            throw new PNGException(this, 6, "compressData()", "unknown PNG filter type specified");
        }
        if (info.getCompressionType() != 0) {
            throw new PNGException(this, 6, "compressData()", "unknown PNG compression type specified");
        }
        if (info.getColorType() != 6 && info.getColorType() != 2) {
            throw new PNGException(this, 6, "compressData()", "color type specified is not standard java color type: 8 bps RGB with alpha channel");
        }
        if (info.getInterlaceType() != 0) {
            throw new PNGException(this, 6, "compressData()", "interlacing value other than NO_INTERLACING specified; this encoder does not interlace image data");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(20480);
        Image image = info.getImage();
        DeflaterOutputStream deflater_stream = new DeflaterOutputStream((OutputStream)stream, new Deflater(), 1024);
        try {
            PNGDataWriter helper = new PNGDataWriter(image, deflater_stream, info.getColorType());
            helper.encode();
            deflater_stream.finish();
        }
        catch (IOException err) {
            System.err.println("IO exception occured in PNGDataChunk.java");
        }
        this.compressedData = stream.toByteArray();
    }
}

