/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.math;

import com.threedgraphics.math.CurveFitIF;
import com.threedgraphics.math.FP;
import tdg.Assert;
import tdg.AssertionException;

public class FitRational
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= NUM_COEFFS + 1);
        double y = x / (a[2] + a[1] * x);
        if (Double.isNaN(y)) {
            throw new AssertionException();
        }
        return y;
    }

    public void eval(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= NUM_COEFFS + 1);
        Assert.assert(FP.nonzero(x));
        a[1] = 1.0;
        a[2] = 1.0 / x;
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double y) throws AssertionException {
        Assert.assert(FP.nonzero(y));
        return 1.0 / y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        Assert.assert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[2];
        String strTerm2 = strCoeffs[1] + " * x";
        if (bHighOrderFirst) {
            return "y = x / (" + strTerm2 + " + " + strTerm1 + ")";
        }
        return "y = x / (" + strTerm1 + " + " + strTerm2 + ")";
    }
}

