/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.math;

import com.threedgraphics.math.CurveFitIF;
import tdg.Assert;
import tdg.AssertionException;

public class FitPolynomial
implements CurveFitIF {
    private static final int MAX_ORDER = 10;
    private int m_nOrder;

    public FitPolynomial(int nOrder) throws AssertionException {
        Assert.assert(nOrder >= 1 && nOrder <= 10);
        this.m_nOrder = nOrder;
    }

    public double compute(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= this.m_nOrder + 1 + 1);
        double y = a[1];
        int i = 1;
        while (i <= this.m_nOrder) {
            y += a[i + 1] * Math.pow(x, i);
            ++i;
        }
        return y;
    }

    public void eval(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= this.m_nOrder + 1 + 1);
        double product = 1.0;
        int i = 1;
        while (i <= this.m_nOrder + 1) {
            a[i] = product;
            product *= x;
            ++i;
        }
    }

    public int numCoeffs() {
        return this.m_nOrder + 1;
    }

    public double transformY(double y) {
        return y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        String strEquation;
        Assert.assert(strCoeffs.length >= this.m_nOrder + 1 + 1);
        if (bHighOrderFirst) {
            strEquation = strCoeffs[2] + " * x" + " + " + strCoeffs[1];
            int i = 3;
            while (i <= this.m_nOrder + 1) {
                strEquation = strCoeffs[i] + " * x^" + (i - 1) + " + " + strEquation;
                ++i;
            }
        } else {
            strEquation = strCoeffs[1] + " + " + strCoeffs[2] + " * x";
            int i = 3;
            while (i <= this.m_nOrder + 1) {
                strEquation = strEquation + " + " + strCoeffs[i] + " * x^" + (i - 1);
                ++i;
            }
        }
        return strEquation;
    }
}

