<?xml version='1.0' encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java" extension-element-prefixes="barcode"
	xmlns:cal="xalan://java.util.GregorianCalendar">

	<xsl:output method="xml" encoding="ISO-8859-1" indent="yes" />

	<xsl:decimal-format decimal-separator=","
		grouping-separator="." />

	<!-- Variveis de ambiente de execuo -->
	<xsl:param name="PATH_IMAGENS" select="'imagens/'" />
	<xsl:param name="PATH_REMESSA" select="'remessa/'" />

	<!-- ######### Styles para os textos do documento ######### -->
	<xsl:attribute-set name="bordas">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>

		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<!-- xsl:attribute name="border-top-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute -->
	</xsl:attribute-set>

	<xsl:attribute-set name="bordas2">
		<xsl:attribute name="border-after-width">0pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordas3">
		<xsl:attribute name="border-after-width">0pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasUltColuna">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasDireita1pt">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">1pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoLeftCourier">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoRightCourier">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoLeft">
		<xsl:attribute name="font-size">9.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoRight">
		<xsl:attribute name="font-size">9.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titFCinza">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titFCinzaEscuro">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">silver</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegrito">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoMed">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titMed">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoItalico">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">silver</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="total">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="totalLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalho">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoCenter">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftShort">
		<xsl:attribute name="font-size">7.4pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftShort2">
		<xsl:attribute name="font-size">7.2pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftBigCur">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtCenter">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtCenterBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtRightShort">
		<xsl:attribute name="font-size">7.4pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtRightBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="linhaTotal">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtQuadroTce">
		<xsl:attribute name="font-size">7.0pt</xsl:attribute>
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<!-- ******* Define a configurao da pgina (Folha) ******* -->
				<fo:simple-page-master master-name="default-master"
					page-height="29.6cm" page-width="21cm" margin-top="15pt"
					margin-left="20pt" margin-right="20pt" margin-bottom="15pt">

					<!-- ******* Parte central da pgina (Margens) ******* -->
					<fo:region-body column-count="1" margin-top="1.45in"
						margin-bottom="0.5in" />

					<!-- ******* Cabealho (Margens) ******* -->
					<fo:region-before border-after-style="solid"
						extent="1.45in" margin-bottom="0.2in" />

					<!-- ******* Rodap (Margens) ******* -->
					<fo:region-after border-before-style="solid"
						extent="0.2in" margin-bottom="0.2in" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<!-- Body page -->
			<!-- ******* Corpo da pgina (Contedo) ******* -->
			<fo:page-sequence master-reference="default-master">

				<!-- ******* Definindo o contedo do cabealho ******* -->
				<fo:static-content flow-name="xsl-region-before">
					<xsl:apply-templates select="rdi/Cabecalho" />
				</fo:static-content>

				<!-- ******* Definindo o contedo do rodap ******* -->
				<fo:static-content flow-name="xsl-region-after">

					<!-- ******* Variveis locais ******* -->
					<!-- variveis para obter a data e hora atual -->
					<xsl:variable name="timeZone1"
						select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')" />
					<xsl:variable name="tmp" select="cal:new()" />
					<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)" />
					<!-- ******* ******* -->

					<fo:table text-align="center" width="556pt" table-layout="fixed">
						<fo:table-column column-width="115pt" />
						<fo:table-column column-width="126pt" />
						<fo:table-column column-width="115pt" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3"
									border-bottom-style="solid" border-bottom-width="1pt">
									<fo:block />

								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="txtLeft">
										<xsl:value-of
											select="java:format(java:java.text.SimpleDateFormat.new('dd/MM/yyyy'), java:java.util.Date.new())" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="10pt">
									<fo:block xsl:use-attribute-sets="txtCenter">
										P&#225;gina <fo:page-number/> de <fo:page-number-citation ref-id="last-page"/>
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="timeZone1" select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')"/>
								<xsl:variable name="tmp" select="cal:new()"/>
								<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)"/>

								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="txtRight">
										<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('HH:mm:ss'), cal:getTime())"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

	  <!-- ******* Definindo o contedo do corpo da pgina ******* -->
		<fo:flow flow-name="xsl-region-body">
		<fo:block font-size="7.0pt" font-family="serif">
		
		<xsl:variable name="tipoRelatorio">
			<xsl:value-of select="rdi/Cabecalho/CabecalhoRow/TP_RELATORIO"/>
		</xsl:variable>
		<!-- ************* Variaveis locais **************-->

		<xsl:variable name="periodoInicial">01/01/</xsl:variable>

		<!-- xsl:variable name="periodoFinal"><xsl:value-of select="rdi/Cabecalho/CabecalhoRow/DT_FINAL_COMPL"/></xsl:variable -->

          <!-- xsl:if test="rve/ListaDocumentacaoComplementar!='' and $tipoRelatorio = 'RVE_LIGHT'" -->
		   <!-- fo:block><fo:leader leader-pattern="space" /></fo:block -->
		   <xsl:apply-templates select="rdi/ArquivosComplementaresSolicitados"/>
		  <!-- /xsl:if -->

<!-- 
Caso de Uso	Item RDI	Descrio
UC217-1	-	Cabealho, presente em todas as pginas.
UC217-2	1	Dados Cadastrais
UC217-3	2	Demonstrativos contbeis: Arquivo Livro Geral (TCE_4111)
UC217-4	3	Demonstrativos contbeis: Folha de pagamento e Cadastro de Funcionrios (TCE_4810 e TCE 4820)
UC217-5	4	Demonstrativos contbeis: Sistema de arrecadao Municipal (TCE_4010)
UC217-6	5	Registros de Vantagens, Descontos e Totalizadores (TCE_4960)
UC217-99	-	Assinaturas dos responsveis
-->
		  <!-- xsl:variable name="select_PD">
		  	<xsl:for-each select="ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow">
		  		<if test="TIPO='PD' and SOLICITADO='S'">true</if>
		  	</xsl:for-each>
		  </xsl:variable>
		  <xsl:variable name="select_FP">
		  	<xsl:for-each select="rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow">
		  		<if test="TIPO='FP'">
		  			<if test="SOLICITADO='S'">1</if>
		  		</if>
		  	</xsl:for-each>
		  </xsl:variable>
		  <xsl:variable name="select_LD">
		  	<xsl:for-each select="rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow">
		  		<if test="TIPO='LD' and SOLICITADO='S'">1</if>
		  	</xsl:for-each>
		  </xsl:variable>
		  <xsl:variable name="select_RP">
		  	<xsl:for-each select="rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow">
		  		<if test="TIPO='RP' and SOLICITADO='S'">1</if>
		  	</xsl:for-each>
		  </xsl:variable>
		  <xsl:variable name="select_RP">
		  	<xsl:if test="rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow/TIPO='RP' and rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow/SOLICITADO='S'">1</xsl:if>
		  </xsl:variable>
		  <xsl:variable name="select_FP">
		  	<xsl:if test="rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow/TIPO='FP' and rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow/SOLICITADO='S'">1</xsl:if>
		  </xsl:variable-->

		  <xsl:variable name="select_LD">
		  	<xsl:if test="rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='LD' and SOLICITADO='S']">1</xsl:if>
		  </xsl:variable>
		  <xsl:variable name="select_FP">
		  	<xsl:if test="rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='FP' and SOLICITADO='S']">1</xsl:if>
		  </xsl:variable>
		  <xsl:variable name="select_RP">
		  	<xsl:if test="rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='RP' and SOLICITADO='S']">1</xsl:if>
		  </xsl:variable>

		  <!-- fo:block>FP: <xsl:value-of select="$select_FP"/>; LD: <xsl:value-of select="$select_LD"/>; RP: <xsl:value-of select="$select_RP"/></fo:block -->
		  
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [1] - INICIO xxxxxxxxxxx-->
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block xsl:use-attribute-sets="titFCinza" id="RDI_1_0">1. Informa&#231;&#245;es da Entidade </fo:block>
		  
		  <!--#### UC074-02 -->
		  <xsl:if test="rdi/IdentificacaoAdministrador!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rdi/IdentificacaoAdministrador"/>
		  </xsl:if>
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [1] - FIM xxxxxxxxxxx-->
        	
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [2] - INICIO xxxxxxxxxxx-->
		  <xsl:if test="rdi/LivroDiarioGeral and $select_LD=1">
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block xsl:use-attribute-sets="titFCinza" id="RDI_2_0">2. Demonstrativos contbeis: Arquivo Livro Dirio Geral (TCE_4111) </fo:block>

			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
	   		  <xsl:apply-templates select="rdi/LivroDiarioGeral"/>
		  </xsl:if>
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [2] - FIM xxxxxxxxxxx-->

		  <!--xxxxxxxxxxx ITEM PRINCIPAL [3] - INICIO xxxxxxxxxxx-->
		  <xsl:if test="rdi/FolhaPagamento and $select_FP=1">
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block xsl:use-attribute-sets="titFCinza" id="RDI_3_0">3. Resumos: Folha de Pagamento, Cadastro de Funcionrios/Beneficirios e Registros de Vantagens, Descontos e Totalizadores </fo:block>

			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <xsl:apply-templates select="rdi/FolhaPagamento"/>
		  </xsl:if>
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [3] - FIM xxxxxxxxxxx-->

	      <!--xxxxxxxxxxx ITEM PRINCIPAL [4] - INICIO xxxxxxxxxxx-->
		  <xsl:if test="rdi/ReceitaPublica and $select_RP=1">
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block xsl:use-attribute-sets="titFCinza" id="RDI_4_0">4. Demonstrativos contbeis: Sistema de arrecadao Municipal (TCE_4010) </fo:block>
	
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <xsl:apply-templates select="rdi/ReceitaPublica"/>
		  </xsl:if>
                  
				<fo:block><fo:leader leader-pattern="space" /></fo:block>
				<fo:block><fo:leader leader-pattern="space" /></fo:block>
				<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_5_0">5. Avisos Exibidos na Verifica&#231;&#227;o dos Arquivos Texto</fo:block>
				<xsl:if test="rdi/ErrosAvisos!=''">
					<fo:block><fo:leader leader-pattern="space" /></fo:block>
					<xsl:apply-templates select="rdi/ErrosAvisos"/>
				</xsl:if>
				<xsl:if test="rdi/ErrosAvisosJustificativas!=''">
					<fo:block><fo:leader leader-pattern="space" /></fo:block>
					<xsl:apply-templates select="rdi/ErrosAvisosJustificativas"/>
				</xsl:if>
   
                  <xsl:if test="rdi/ObservacoesEntidade!=''">
                   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
	  	   <xsl:apply-templates select="rdi/ObservacoesEntidade"/>
		  </xsl:if>
                  
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [4] - FIM xxxxxxxxxxx-->

		  <!--xxxxxxxxxxx ITEM PRINCIPAL [5] - INICIO xxxxxxxxxxx-->
		  <!-- FOI passado para junto da folha conforme bug gm 4421
                  <xsl:if test="rdi/VantagemDescontoTotal and $select_FP=1">
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block xsl:use-attribute-sets="titFCinza" id="RDI_5_0">5. Registros de Vantagens, Descontos e Totalizadores (TCE_4960) </fo:block>
	
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <xsl:apply-templates select="rdi/VantagemDescontoTotal"/>
		  </xsl:if> -->
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [5] - FIM xxxxxxxxxxx-->

		  <!-- QUEBRA DE PAGINA -->
		  <fo:block break-after="page"/>

		  <!--=========== MENSAGEM ============-->
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  			<fo:table-column column-number="1"/>
  
  			<fo:table-body>
   				<fo:table-row>
					<fo:table-cell padding-left="50pt">
						<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt" id="RVE_7_1">
		  					CERTIFICAMOS, com base nos registros constantes na Entidade, a consist&#234;ncia das informa&#231;&#245;es apresentadas neste relat&#243;rio com as
	 	  				</fo:block>
    				</fo:table-cell>
   				</fo:table-row>
   				<fo:table-row>
					<fo:table-cell>
				  		<fo:block xsl:use-attribute-sets="txtLeft">
							enviadas ao TCE.
				  		</fo:block> -->
            					 <!-- texto do Gian
				  		<fo:block xsl:use-attribute-sets="txtLeft">
							fornecidas em meio magn&#233;tico, &#243;tico ou eletr&#244;nico enviadas ao TCE. (Instru&#231;&#227;o Normativa n&#186; 15/2000).
				  		</fo:block> -->
				              <!--### texto da Fernanda ###-->
				              <!-- Entidades 6404 E,O,T 
				        		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='E' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='O' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='T'">
				                <fo:block xsl:use-attribute-sets="txtLeft">
				                fornecidas em meio magn&#233;tico, &#243;tico ou eletr&#244;nico enviadas ao TCE. (Instru&#231;&#227;o Normativa n&#186; 01/02).
				                </fo:block>
				              </xsl:if> -->
				              <!-- Entidades 4320 P,C,A,F,S 
				        		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S'">
				                <fo:block xsl:use-attribute-sets="txtLeft">
				                fornecidas em meio magn&#233;tico, &#243;tico ou eletr&#244;nico enviadas ao TCE.
				                </fo:block>
				              </xsl:if> -->
				              <!--### fim texto da Fernanda ###-->
    				</fo:table-cell>
   				</fo:table-row> 
   				<fo:table-row>
					<fo:table-cell>
				  		<fo:block xsl:use-attribute-sets="txtLeft"/>
    				</fo:table-cell>
   				</fo:table-row> 
  			</fo:table-body>
 		  </fo:table>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <!--=========== MENSAGEM ============-->
 
	  	  <!--#### UC074-51 -->
		  <xsl:if test="rdi/Assinaturas!=''">
 		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rdi/Assinaturas"/>
		  </xsl:if>
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [7] - FIM xxxxxxxxxxx-->

		  <fo:block id="last-page"/>

        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </fo:root>
</xsl:template>

<!--
##########################
#### CABECALHO
##########################
-->
<xsl:template match="Cabecalho">
 <xsl:variable name="periodoFinal"><xsl:value-of select="substring(CabecalhoRow/DT_FINAL_COMPL, 9, 2)"/>/<xsl:value-of select="substring(CabecalhoRow/DT_FINAL_COMPL, 6, 2)"/>/</xsl:variable>
  
 <xsl:variable name="tipoRelatorio">
	<xsl:value-of select="CabecalhoRow/TP_RELATORIO"/>
 </xsl:variable>
  
 <!-- xsl:variable name="isCamaraIntegrada">
    <xsl:choose>
    	<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
    	<xsl:otherwise>N</xsl:otherwise>
    </xsl:choose>
 </xsl:variable -->
 <!-- USAR VARIAVEL DOCUMENTO SO PCDI -->
 <xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao"/> 
 <xsl:variable name="data" select="substring($dataHora, 1, 10)"/>
 <xsl:variable name="horario" select="substring($dataHora, 12, 8)"/>
 <xsl:variable name="dia" select="substring($data, 9, 2)"/>
 <xsl:variable name="mes" select="substring($data, 6, 2)"/>
 <xsl:variable name="ano" select="substring($data, 1, 4)"/>
 <xsl:variable name="hora" select="substring($horario, 1, 2)"/>
 <xsl:variable name="minuto" select="substring($horario, 4, 2)"/>
 <xsl:variable name="segundo" select="substring($horario, 7, 2)"/>
 
 <fo:block>
   <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	<fo:table-column column-width="42pt"/>
	<fo:table-column column-width="442pt"/>
	<fo:table-column column-width="72pt"/>
	
	<fo:table-body>
	 
	 <fo:table-row>
	  <fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt"><fo:block/>
	 </fo:table-cell>
    </fo:table-row>

	<fo:table-row>
	 <fo:table-cell padding-bottom="3pt" >
	  <fo:block>
		<fo:external-graphic src="{concat($PATH_IMAGENS,'Brasao.jpg')}"/>
	  </fo:block>
	 </fo:table-cell>

	 <fo:table-cell >
	  <fo:block padding-bottom="1pt">
		<fo:table table-layout="fixed">
			<fo:table-column column-width="300pt"/>
			<fo:table-column column-width="112pt"/>
				
			<fo:table-body>
			  <fo:table-row>
				<fo:table-cell padding-left="15pt" padding-top="1pt" >
				  <fo:block xsl:use-attribute-sets="txtLeft">ESTADO DO RIO GRANDE DO SUL</fo:block>
				</fo:table-cell>
			   </fo:table-row>

				<fo:table-row>
					<fo:table-cell padding-left="15pt" >
						<fo:block text-align="left" xsl:use-attribute-sets="txtLeft">
							<xsl:text>TRIBUNAL DE CONTAS DO ESTADO</xsl:text>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell padding-left="15pt" number-columns-spanned="0" >
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SIAPC - Sistema de Informa&#231;&#245;es para Auditoria e Presta&#231;&#227;o de Contas</fo:block>
					</fo:table-cell>
				<!-- BARCODE -->
				<fo:table-cell number-rows-spanned="3" text-align="center">
			<fo:block>
                     
                            <fo:instream-foreign-object>
                              <barcode:barcode 
                                xmlns:barcode="http://barcode4j.krysalis.org/ns"
                                message="{document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-rdi}">
                                <barcode:code128>
                                  <barcode:height>15mm</barcode:height>
                                </barcode:code128>
                              </barcode:barcode>
                            </fo:instream-foreign-object>
                                   
                                   
			</fo:block >
				</fo:table-cell>
				<!-- BARCODE -->
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell number-columns-spanned="2" padding-left="90pt">
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
							Programa Autenticador de Dados - PAD Vers&#227;o:
							<xsl:value-of select="CabecalhoRow/VERSAO_PAD"/>
							<xsl:value-of select="java:br.gov.rs.tce.pad.util.VersaoUtils.getVersaoTestId()"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell padding-left="40pt" number-columns-spanned="0" >                                        
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="normal">Relat&#243;rio de Dados e Informaes - RDI - Solicita&#231;&#227;o Formal</fo:block>
					</fo:table-cell>
				</fo:table-row>
			  </fo:table-body>
			</fo:table>
		  </fo:block>
		</fo:table-cell>

		<fo:table-cell padding-top="5pt" text-align="right">
		  <!-- <fo:block>
		    <fo:table text-align="center" table-layout="fixed">
		      <fo:table-column column-width="35pt"/>
		      <fo:table-column column-width="35pt"/>
		      
		      <fo:table-body>
		        <fo:table-row>
		          <fo:table-cell number-columns-spanned="2" border-style="solid" border-width="0.25pt" space-before="0pt" space-after="0pt">
		            <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="center">Para uso do</fo:block>
		            <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="center">Tribunal de Contas</fo:block>
		          </fo:table-cell>
		        </fo:table-row>
		        <fo:table-row>
		          <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
		            <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="left">Fl.</fo:block>
		            <fo:block xsl:use-attribute-sets="txtQuadroTce"/>
		          </fo:table-cell>
		          <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
		            <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="left">Rubrica</fo:block>
		            <fo:block xsl:use-attribute-sets="txtQuadroTce"/>
		          </fo:table-cell>
		        </fo:table-row>
		      </fo:table-body>
        </fo:table>
		 </fo:block> -->
		 <fo:block>
		   <fo:external-graphic src="{concat($PATH_IMAGENS,'tce_2025.jpg')}" width="42pt"/>
		 </fo:block>
		 <fo:block xsl:use-attribute-sets="txtRightShort">
       		<xsl:value-of select="$dia"/>/<xsl:value-of select="$mes"/>/<xsl:value-of select="$ano"/> - <xsl:value-of select="$hora"/>:<xsl:value-of select="$minuto"/>:<xsl:value-of select="$segundo"/>
		 </fo:block>     
		</fo:table-cell>
	   </fo:table-row>
			   
	 <fo:table-row>
	  <fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
	   <fo:block>
	    <fo:table text-align="center" width="556pt" table-layout="fixed">
			<fo:table-column column-width="281pt"/>
			<fo:table-column column-width="90pt"/>
			<fo:table-column column-width="90pt"/>
                        <fo:table-column column-width="95pt"/>
						
			<fo:table-body>
			 <fo:table-row>
			  <fo:table-cell padding-left="60pt">
    		   <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CabecalhoRow/NOME"/></fo:block>
			  </fo:table-cell>
                          <fo:table-cell padding-left="5pt">
			   <fo:block xsl:use-attribute-sets="txtLeft">ORGO N: <xsl:value-of select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//codigo-entidade"/></fo:block>
		  	  </fo:table-cell>
			  <fo:table-cell padding-left="5pt">
			   <fo:block xsl:use-attribute-sets="txtLeft">CNPJ: <xsl:value-of select="CabecalhoRow/CNPJ"/></fo:block>
		  	  </fo:table-cell>
			  <fo:table-cell>
			   <fo:block xsl:use-attribute-sets="txtRight">
			 	01/01/<xsl:value-of select="CabecalhoRow/ANO_EXERCICIO"/> a <xsl:value-of select="$periodoFinal"/><xsl:value-of select="CabecalhoRow/ANO_EXERCICIO"/>
			   </fo:block>
			  </fo:table-cell>
		     </fo:table-row>
			</fo:table-body>
		</fo:table>
	  </fo:block>
	</fo:table-cell>
   </fo:table-row>

	  </fo:table-body>
	 </fo:table>
    </fo:block>
</xsl:template>
<!-- #### FIM - CABE&#199;ALHO ####-->


<xsl:template match="ArquivosComplementaresSolicitados">
	<fo:block>
		<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="120pt"/>
		<fo:table-column column-width="30pt"/>
		<fo:table-column column-width="30pt"/>
		<fo:table-column column-width="60pt"/>
		<fo:table-column column-width="60pt"/>
		<fo:table-body>
		 
			<fo:table-row>
				<fo:table-cell padding-left="10pt">
					<fo:block xsl:use-attribute-sets="titNegrito" text-align="left" id="RVE_0_1"><xsl:text>Neste RDI est&#227;o inclu&#237;dos:</xsl:text></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtCenter"><xsl:text>Sim</xsl:text></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtCenter"><xsl:text>N&#227;o</xsl:text></fo:block>
				</fo:table-cell>
			</fo:table-row>	

		 <xsl:for-each select="ArquivosComplementaresSolicitadosRow">	
			
			<xsl:variable name="checkSim">
				<xsl:if test="SOLICITADO='S'">check.jpg</xsl:if>
				<xsl:if test="SOLICITADO='N'">uncheck.jpg</xsl:if>
			</xsl:variable>
			<xsl:variable name="checkNao">
				<xsl:if test="SOLICITADO='S'">uncheck.jpg</xsl:if>
				<xsl:if test="SOLICITADO='N'">check.jpg</xsl:if>
			</xsl:variable>
	
			<fo:table-row>
				<fo:table-cell padding-left="20pt">
					<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_TIPO"/></fo:block>
				</fo:table-cell>					
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS, $checkSim)}"/></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS, $checkNao)}"/></fo:block>
				</fo:table-cell>
				<!-- <xsl:if test="SOLICITADO='S'">
					<xsl:variable name="formatter" select="java:java.text.SimpleDateFormat.new('yyyy-MM-dd')" />
					<xsl:variable name="data" select="java:parse($formatter, DT_SOLICITACAO)"/>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>Solicitao Formal N: </xsl:text>
						<xsl:value-of select="NR_SOLICITACAO"/>	</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:text>Data: </xsl:text>
						<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd/MM/yyyy'), $data)"/>
						</fo:block>
					</fo:table-cell>
				</xsl:if> -->
			 </fo:table-row>
			
           </xsl:for-each>  

         </fo:table-body>
       </fo:table>
	</fo:block>
</xsl:template>

<!--
#############################################
#### UC074-02
############################################# 
-->
<xsl:template match="IdentificacaoAdministrador">
 <!-- ************* Variaveis locais **************-->
 <!-- xsl:variable name="isCamaraIntegrada">
	<xsl:choose>
		<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
		<xsl:otherwise>N</xsl:otherwise>
	</xsl:choose>
 </xsl:variable -->  

 <xsl:variable name="presidenteCamara">
 	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'C'"><xsl:value-of select="IdentificacaoAdministradorRow/NOME_RESPONSAVEL"/></xsl:if>
 	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'P' and ../DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'"><xsl:value-of select="IdentificacaoAdministradorRow/NOME_PRESIDENTE_CAM"/></xsl:if>
 </xsl:variable>

 <xsl:variable name="tpEntrega">
 	<xsl:if test="IdentificacaoAdministradorRow/TP_ENTREGA = 'S'">Semestral</xsl:if>
	<xsl:if test="IdentificacaoAdministradorRow/TP_ENTREGA = 'Q'">Quadrimestral</xsl:if>
 </xsl:variable>
 
 <!-- xsl:variable name="periodoFinal"><xsl:value-of select="/rdi/Cabecalho/CabecalhoRow/DT_FINAL_COMPL"/></xsl:variable -->
 <xsl:variable name="periodoFinal"><xsl:value-of select="substring(/rdi/Cabecalho/CabecalhoRow/DT_FINAL_COMPL, 9, 2)"/>/<xsl:value-of select="substring(/rdi/Cabecalho/CabecalhoRow/DT_FINAL_COMPL, 6, 2)"/>/</xsl:variable>
 
 
 <!-- xsl:variable name="periodoFinal">
  <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 1">
  	<xsl:if test="(../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   	<xsl:if test="(../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
  </xsl:if>
  <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
  <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
  <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
  <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
  <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
 </xsl:variable-->
 <!-- ************* Variaveis locais **************-->

	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_1">1.1 Dados Cadastrais da Administra&#231;&#227;o Atual</fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	<fo:block xsl:use-attribute-sets="txtLeft">CNPJ: <xsl:value-of select="IdentificacaoAdministradorRow/CNPJ"/></fo:block>
	
	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="278pt"/>
		<fo:table-column column-width="278pt"/>
	<fo:table-body>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">Per&#237;odo: 01/01/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> a <xsl:value-of select="$periodoFinal"/><xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/></fo:block>
			</fo:table-cell>	
			<fo:table-cell>
			</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
	</fo:table>	
	
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A' 
	              or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='E'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='O'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='T'
	              or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S'">
		<fo:block xsl:use-attribute-sets="txtLeft">Munic&#237;pio: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_MUNICIPIO"/></fo:block>
	</xsl:if>  

	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
		<fo:block xsl:use-attribute-sets="txtLeft">Prefeitura: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		<fo:block xsl:use-attribute-sets="txtLeft">C&#226;mara: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A'">
		<fo:block xsl:use-attribute-sets="txtLeft">Autarquia: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F' or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='T'">
		<fo:block xsl:use-attribute-sets="txtLeft">Funda&#231;&#227;o: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='E'">
		<fo:block xsl:use-attribute-sets="txtLeft">Empresa: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='O' or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S'">
		<fo:block xsl:use-attribute-sets="txtLeft">Cons&#243;rcio: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	
	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="278pt"/>
		<fo:table-column column-width="48pt"/>
		<fo:table-column column-width="120pt"/>
		<fo:table-column column-width="110pt"/>

	<fo:table-body>
	<fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Logradouro: <xsl:value-of select="IdentificacaoAdministradorRow/LOGRADOURO"/></fo:block>	
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">nr: <xsl:value-of select="IdentificacaoAdministradorRow/NR"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">compl: <xsl:value-of select="IdentificacaoAdministradorRow/COMPL"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Telefone: <xsl:value-of select="IdentificacaoAdministradorRow/TELEFONE"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
	</fo:table>	

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="278pt"/>
		<fo:table-column column-width="278pt"/>
	<fo:table-body>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">HomePage: <xsl:value-of select="IdentificacaoAdministradorRow/HOMEPAGE"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">E-Mail: <xsl:value-of select="IdentificacaoAdministradorRow/EMAIL"/></fo:block>
			</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
	</fo:table>	
		
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
		<fo:block xsl:use-attribute-sets="txtLeft">Prefeito Municipal: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_RESPONSAVEL"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A'
	              or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='E'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='O'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='T'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S'">
		<fo:block xsl:use-attribute-sets="txtLeft">Respons&#225;vel: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_RESPONSAVEL"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		<fo:block xsl:use-attribute-sets="txtLeft">Presidente da C&#226;mara Municipal: <xsl:value-of select="$presidenteCamara"/></fo:block>
	</xsl:if>

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="278pt"/>
		<fo:table-column column-width="278pt"/>
	<fo:table-body>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">Contabilista: <xsl:value-of select="IdentificacaoAdministradorRow/CONTABILISTA"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#250;mero do CRC: <xsl:value-of select="IdentificacaoAdministradorRow/CRC"/></fo:block>
			</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
	</fo:table>	
	
	<fo:block><fo:leader leader-pattern="space" /></fo:block>
</xsl:template>
<!-- #### FIM - UC074-02 ####-->

<!--
#############################################
#### UC217-3
############################################# 
-->
<xsl:template match="LivroDiarioGeral">

	<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_2_1">2.1 Arquivo Livro Dirio Geral</fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="400pt"/>
		<fo:table-column column-width="78pt"/>
                <fo:table-column column-width="78pt"/>

            <!--Cabealho da Tabela-->
			<fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="bordas">
                                            <fo:block xsl:use-attribute-sets="titNegrito">
                                            </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="2">
                                            <fo:block xsl:use-attribute-sets="titNegrito">
                                                SOMA TOTAL DOS VALORES
                                            </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
                                                        Especificaes
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegrito">
							DBITO
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="titNegrito">
							CRDITO
						</fo:block>
					</fo:table-cell>
				</fo:table-row>	
                                
                <!--Impresso da Linha Disponibilidades - CTA_DISP.TXT -->
                                <xsl:if test="(../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C' and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='E' and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='O' and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='T')">
                                    <fo:table-row>
                                            <fo:table-cell xsl:use-attribute-sets="bordas">
                                                    <fo:block xsl:use-attribute-sets="txtLeft">
                                                            Disponibilidades - CTA_DISP.TXT
                                                    </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell xsl:use-attribute-sets="bordas">
                                                    <fo:block xsl:use-attribute-sets="txtRight">
                                                            <xsl:value-of select="format-number(LivroDiarioGeralSomasDebitoDisp/LivroDiarioGeralSomasDebitoDispRow/SOMA_VALOR, '#.##0,00')"/>
                                                    </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell xsl:use-attribute-sets="bordasUltColuna" >
                                                    <fo:block xsl:use-attribute-sets="txtRight">
                                                            <xsl:value-of select="format-number(LivroDiarioGeralSomasCreditoDisp/LivroDiarioGeralSomasCreditoDispRow/SOMA_VALOR, '#.##0,00')"/>
                                                    </fo:block>
                                            </fo:table-cell>
                                    </fo:table-row>
                                    
                                    <!--Impresso da Linha Demais Contas -->
                                    <fo:table-row>
                                        <fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtLeft">
                                                        Demais Contas
                                                </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number((sum(LivroDiarioGeralSomasDebito/LivroDiarioGeralSomasDebitoRow/SOMA_VALOR) - sum(LivroDiarioGeralSomasDebitoDisp/LivroDiarioGeralSomasDebitoDispRow/SOMA_VALOR)), '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="bordasUltColuna" >
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number((sum(LivroDiarioGeralSomasCredito/LivroDiarioGeralSomasCreditoRow/SOMA_VALOR) - sum(LivroDiarioGeralSomasCreditoDisp/LivroDiarioGeralSomasCreditoDispRow/SOMA_VALOR)), '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:if>
                                
            	<!--Impresso das Linhas de crdito e dbito -->
                                <fo:table-row>
                                        <fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtLeft">
                                                        Totais
                                                </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number(LivroDiarioGeralSomasDebito/LivroDiarioGeralSomasDebitoRow/SOMA_VALOR, '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="bordasUltColuna" >
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number(LivroDiarioGeralSomasCredito/LivroDiarioGeralSomasCreditoRow/SOMA_VALOR, '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                </fo:table-row>

            	<!--Impresso do nmero de linhas processadas -->
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero Total dos Registros que compem o arquivo (Campo Finalizador)
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(LivroDiarioGeralNumLinhas/LivroDiarioGeralNumLinhasRow/NUM_REGISTROS, '###.###.##0')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
			</fo:table-body>
	</fo:table>
							
</xsl:template>
	

<!--
#############################################
#### UC217-4
############################################# 
-->
<xsl:template match="FolhaPagamento">

	<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_3_1">3.1 Resumo Mensal da Folha de Pagamento</fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	<!--fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="400pt"/>
		<fo:table-column column-width="156pt"/>

			<fo:table-body>	
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
    						TCE_4810.TXT - Geral
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Detalhamento
						</fo:block>
					</fo:table-cell>
				</fo:table-row>			 						

				<xsl:for-each select="FolhaPagamentoSomasPorIdOperacao/FolhaPagamentoSomasPorIdOperacaoRow">
					<xsl:variable name="Descricao">
						<xsl:choose>
							<xsl:when test="IDENTIFICACAO_OPERACAO='V'">Soma total dos valores dos registros classificados como Vantagem (V)</xsl:when>
							<xsl:when test="IDENTIFICACAO_OPERACAO='D'">Soma total dos valores dos registros classificados como Desconto (D)</xsl:when>
							<xsl:when test="IDENTIFICACAO_OPERACAO='T'">Soma total dos valores dos registros classificados como Totalizador (T)</xsl:when>
							<xsl:when test="IDENTIFICACAO_OPERACAO='O'">Soma total dos valores dos registros classificados como Outros (O)</xsl:when>
							<xsl:otherwise><xsl:value-of select="IDENTIFICACAO_OPERACAO"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
				
					<fo:table-row>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtLeft">
								<xsl:value-of select="$Descricao"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(TOTAL_VALOR, '#.##0,00')"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:for-each>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero Total dos Registros que compem o arquivo (Campo Finalizador)
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(FolhaPagamentoNumLinhas/FolhaPagamentoNumLinhasRow/NUM_REGISTROS, '###.###.##0')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
			</fo:table-body>
	</fo:table-->

	<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_3_1_1">3.1.1 TCE_4810.TXT - Valores Mensais Agrupados pela Data de Competncia</fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block>

	<!--fo:block><fo:leader leader-pattern="space"/></fo:block-->
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="69pt"/>
		<fo:table-column column-width="70pt"/>
		<fo:table-column column-width="104pt"/>
		<fo:table-column column-width="104pt"/>
		<fo:table-column column-width="104pt"/>
		<fo:table-column column-width="104pt"/>
		<fo:table-column column-width="104pt"/>
		<!--fo:table-column column-width="70pt"/-->

            <!--Cabealho da Tabela-->
                <fo:table-body>	
                        <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="6">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            TCE_4810.TXT - Valores Mensais Agrupados pela Data de Competncia
                                        </fo:block>
                                </fo:table-cell>
                        </fo:table-row>

                        <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="bordas" number-rows-spanned="2">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            Ano
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordas" number-rows-spanned="2">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            Ms
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordasDireita1pt" number-columns-spanned="3">
                                        <fo:block xsl:use-attribute-sets="titNegrito">
                                            Soma total dos valores dos registros
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-rows-spanned="2">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            Nmero Total de Registros que compem o arquivo
                                        </fo:block>
                                </fo:table-cell>
                        </fo:table-row>

                        <fo:table-row>
                        
                                <fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            Vantagem
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            Desconto
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            Lquido
                                        </fo:block>
                                </fo:table-cell>
                                <!-- fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            Outros
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordasDireita1pt">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                            Totalizador
                                        </fo:block>
                                </fo:table-cell-->
                               
                        </fo:table-row>

        <!--Impresso das Linhas de ... -->                                                                     
                        <xsl:for-each select="FolhaPagamentoSomasPorIdOperacaoEMes/FolhaPagamentoSomasPorIdOperacaoEMesRow">
                                <xsl:variable name="MesExtenso">
                                        <xsl:choose>
                                                <xsl:when test="MES=1">Janeiro</xsl:when>
                                                <xsl:when test="MES=2">Fevereiro</xsl:when>
                                                <xsl:when test="MES=3">Maro</xsl:when>
                                                <xsl:when test="MES=4">Abril</xsl:when>
                                                <xsl:when test="MES=5">Maio</xsl:when>
                                                <xsl:when test="MES=6">Junho</xsl:when>
                                                <xsl:when test="MES=7">Julho</xsl:when>
                                                <xsl:when test="MES=8">Agosto</xsl:when>
                                                <xsl:when test="MES=9">Setembro</xsl:when>
                                                <xsl:when test="MES=10">Outubro</xsl:when>
                                                <xsl:when test="MES=11">Novembro</xsl:when>
                                                <xsl:when test="MES=12">Dezembro</xsl:when>
                                                <xsl:otherwise><xsl:value-of select="MES"/></xsl:otherwise>
                                        </xsl:choose>
                                </xsl:variable>

                                <fo:table-row>
                                      <xsl:variable name="anoAnterior" select="preceding-sibling::FolhaPagamentoSomasPorIdOperacaoEMesRow[1]/ANO"/>
                                       <xsl:choose>
                                             <xsl:when test="position()=1 or ANO!=$anoAnterior">
                                              <fo:table-cell xsl:use-attribute-sets="bordas2">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="ANO"/>
                                                </fo:block>
                                             </fo:table-cell>
                                             </xsl:when>
                                             <xsl:otherwise>
                                                <fo:table-cell xsl:use-attribute-sets="bordas3">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                </fo:block>
                                             </fo:table-cell>
                                            </xsl:otherwise>
                                       </xsl:choose>
                                       
                                        <fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtLeft">
                                                        <xsl:value-of select="$MesExtenso"/>
                                                </fo:block>
                                        </fo:table-cell>
                                         <fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number(VLR_V, '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number(VLR_D, '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                         <fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number(VLR_V - VLR_D, '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                        <!-- fo:table-cell xsl:use-attribute-sets="bordas">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number(VLR_O, '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="bordasDireita1pt">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number(VLR_T, '#.##0,00')"/>
                                                </fo:block>
                                        </fo:table-cell-->
                                        
                                        <fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
                                                <fo:block xsl:use-attribute-sets="txtRight">
                                                        <xsl:value-of select="format-number(NUM_REGISTROS, '#.##0,#')"/>
                                                </fo:block>
                                        </fo:table-cell>
                                </fo:table-row>
                             
                        </xsl:for-each>
                        
                        <!-- TODO: colocar somatrios na ltima linha? -->
                        <fo:table-row>
                                <!-- fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                        </fo:block>
                                </fo:table-cell-->
                                <fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
                                        <fo:block xsl:use-attribute-sets="titNegritoLeft">
                                                Totais
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoRight">
                                                <xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorIdOperacaoEMes//VLR_V), '#.##0,00')"/>
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoRight">
                                                <xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorIdOperacaoEMes//VLR_D), '#.##0,00')"/>
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoRight">
                                                <xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorIdOperacaoEMes//VLR_V) - sum(FolhaPagamentoSomasPorIdOperacaoEMes//VLR_D), '#.##0,00')"/>
                                        </fo:block>
                                </fo:table-cell>
                                <!-- fo:table-cell xsl:use-attribute-sets="bordas">
                                        <fo:block xsl:use-attribute-sets="titNegritoRight">
                                                <xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorIdOperacaoEMes//VLR_O), '#.##0,00')"/>
                                        </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="bordasDireita1pt">
                                        <fo:block xsl:use-attribute-sets="titNegritoRight">
                                                <xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorIdOperacaoEMes//VLR_T), '#.##0,00')"/>
                                        </fo:block>
                                </fo:table-cell-->
                                <fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
                                        <fo:block xsl:use-attribute-sets="titNegritoRight">
                                                <xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorIdOperacaoEMes//NUM_REGISTROS), '#.##0,#')"/>
                                        </fo:block>
                                </fo:table-cell>
                        </fo:table-row>
                </fo:table-body>
	</fo:table>

	<!-- ********** -->

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_3_1_2">3.1.2 TCE_4810.TXT e PAGTO_POS.TXT - Valores Mensais Agrupados pela Data do Pagamento</fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block>

	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="69pt"/>
		<fo:table-column column-width="70pt"/>
		<fo:table-column column-width="104pt"/>
		<fo:table-column column-width="104pt"/>
		<fo:table-column column-width="104pt"/>
		<fo:table-column column-width="104pt"/>

		<fo:table-body>
			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="6">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						TCE_4810.TXT e PAGTO_POS.TXT - Valores Mensais Agrupados pela Data do Pagamento
					</fo:block>
				</fo:table-cell>
			</fo:table-row>

			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Ano
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Ms
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Banco
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Agncia
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Conta
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Valor Pago
					</fo:block>
				</fo:table-cell>
			</fo:table-row>

			<xsl:for-each select="FolhaPagamentoSomasPorContaBancariaEDataPagamento/FolhaPagamentoSomasPorContaBancariaEDataPagamentoRow">
				<xsl:variable name="MesExtenso">
					<xsl:choose>
						<xsl:when test="MES=1">Janeiro</xsl:when>
						<xsl:when test="MES=2">Fevereiro</xsl:when>
						<xsl:when test="MES=3">Maro</xsl:when>
						<xsl:when test="MES=4">Abril</xsl:when>
						<xsl:when test="MES=5">Maio</xsl:when>
						<xsl:when test="MES=6">Junho</xsl:when>
						<xsl:when test="MES=7">Julho</xsl:when>
						<xsl:when test="MES=8">Agosto</xsl:when>
						<xsl:when test="MES=9">Setembro</xsl:when>
						<xsl:when test="MES=10">Outubro</xsl:when>
						<xsl:when test="MES=11">Novembro</xsl:when>
						<xsl:when test="MES=12">Dezembro</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="MES" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:variable name="anoLinhaAnterior" select="preceding-sibling::FolhaPagamentoSomasPorContaBancariaEDataPagamentoRow[1]/ANO" />
				<xsl:variable name="mesLinhaAnterior" select="preceding-sibling::FolhaPagamentoSomasPorContaBancariaEDataPagamentoRow[1]/MES" />
				<xsl:variable name="mesLinhaProxima" select="following-sibling::FolhaPagamentoSomasPorContaBancariaEDataPagamentoRow[1]/MES" />
				
				<xsl:variable name="anoLinha" select="ANO" />
				<xsl:variable name="mesLinha" select="MES" />
				
				<fo:table-row>
					<xsl:choose>
						<xsl:when test="position()=1 or ANO!=$anoLinhaAnterior">
							<fo:table-cell xsl:use-attribute-sets="bordas2">
								<fo:block xsl:use-attribute-sets="txtRight">
									<xsl:value-of select="ANO" />
								</fo:block>
							</fo:table-cell>
						</xsl:when>
						<xsl:otherwise>
							<fo:table-cell xsl:use-attribute-sets="bordas3">
								<fo:block xsl:use-attribute-sets="txtRight">
								</fo:block>
							</fo:table-cell>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="position()=1 or MES!=$mesLinhaAnterior">
							<fo:table-cell xsl:use-attribute-sets="bordas2">
								<fo:block xsl:use-attribute-sets="txtLeft">
									<xsl:value-of select="$MesExtenso" />
								</fo:block>
							</fo:table-cell>
						</xsl:when>
						<xsl:otherwise>
							<fo:table-cell xsl:use-attribute-sets="bordas3">
								<fo:block xsl:use-attribute-sets="txtLeft">
								</fo:block>
							</fo:table-cell>
						</xsl:otherwise>
					</xsl:choose>

					<fo:table-cell xsl:use-attribute-sets="bordas2">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="COD_BANCO" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas2">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="COD_AGENCIA" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas2">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="COD_CONTA_CORRENTE" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(VLR_TT, '#.##0,00')" />
						</fo:block>
					</fo:table-cell>
					
				</fo:table-row>
				
				<xsl:choose>
					<xsl:when test="position()=last() or MES != $mesLinhaProxima">
						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="bordas3">
								<fo:block xsl:use-attribute-sets="txtRight">
								</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="bordas3">
								<fo:block xsl:use-attribute-sets="txtRight">
								</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="bordas2" number-columns-spanned="3">
								<fo:block xsl:use-attribute-sets="titNegritoLeft">
									Total
								</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
								<fo:block xsl:use-attribute-sets="titNegritoRight">
									<xsl:value-of select="format-number(sum(../FolhaPagamentoSomasPorContaBancariaEDataPagamentoRow[ANO = $anoLinha and MES = $mesLinha]/VLR_TT), '#.##0,00')" />
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>
				
			</xsl:for-each>

			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Total
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
					<fo:block xsl:use-attribute-sets="titNegritoRight">
						<xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorContaBancariaEDataPagamento//VLR_TT), '#.##0,00')" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			
		</fo:table-body>
		
	</fo:table>

	<!-- ********** -->

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_3_1_3">3.1.3 TCE_4810.TXT e PAGTO_POS.TXT - Valores Mensais Agrupados pela Data de Competncia com os respectivos pagamentos</fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block>

	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="69pt"/>
		<fo:table-column column-width="70pt"/>
		<fo:table-column column-width="138pt"/>
		<fo:table-column column-width="138pt"/>
		<fo:table-column column-width="138pt"/>

		<fo:table-body>
			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						TCE_4810.TXT e PAGTO_POS.TXT - Valores Mensais Agrupados pela Data de Competncia com os respectivos pagamentos
					</fo:block>
				</fo:table-cell>
			</fo:table-row>

			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Ano Competncia
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Ms Competncia
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Lquido
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Valor Pago
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Saldo em Aberto
					</fo:block>
				</fo:table-cell>
			</fo:table-row>

			<xsl:for-each select="FolhaPagamentoSomasPorDataCompetenciaComPagamentos/FolhaPagamentoSomasPorDataCompetenciaComPagamentosRow">
				<xsl:variable name="MesExtenso">
					<xsl:choose>
						<xsl:when test="MES=1">Janeiro</xsl:when>
						<xsl:when test="MES=2">Fevereiro</xsl:when>
						<xsl:when test="MES=3">Maro</xsl:when>
						<xsl:when test="MES=4">Abril</xsl:when>
						<xsl:when test="MES=5">Maio</xsl:when>
						<xsl:when test="MES=6">Junho</xsl:when>
						<xsl:when test="MES=7">Julho</xsl:when>
						<xsl:when test="MES=8">Agosto</xsl:when>
						<xsl:when test="MES=9">Setembro</xsl:when>
						<xsl:when test="MES=10">Outubro</xsl:when>
						<xsl:when test="MES=11">Novembro</xsl:when>
						<xsl:when test="MES=12">Dezembro</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="MES" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:variable name="anoLinhaAnterior" select="preceding-sibling::FolhaPagamentoSomasPorDataCompetenciaComPagamentos[1]/ANO" />
				
				<fo:table-row>
					<xsl:choose>
						<xsl:when test="position()=1 or ANO!=$anoLinhaAnterior">
							<fo:table-cell xsl:use-attribute-sets="bordas2">
								<fo:block xsl:use-attribute-sets="txtRight">
									<xsl:value-of select="ANO" />
								</fo:block>
							</fo:table-cell>
						</xsl:when>
						<xsl:otherwise>
							<fo:table-cell xsl:use-attribute-sets="bordas3">
								<fo:block xsl:use-attribute-sets="txtRight">
								</fo:block>
							</fo:table-cell>
						</xsl:otherwise>
					</xsl:choose>
					
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft">
							<xsl:value-of select="$MesExtenso" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(VLR_LIQUIDO, '#.##0,00')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(VLR_PAGO, '#.##0,00')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(VLR_SALDO_EM_ABERTO, '#.##0,00')" />
						</fo:block>
					</fo:table-cell>
					
				</fo:table-row>
			</xsl:for-each>

			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
					<fo:block xsl:use-attribute-sets="titNegritoLeft">
						Total
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoRight">
						<xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorDataCompetenciaComPagamentos//VLR_LIQUIDO), '#.##0,00')" />
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titNegritoRight">
						<xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorDataCompetenciaComPagamentos//VLR_PAGO), '#.##0,00')" />
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
					<fo:block xsl:use-attribute-sets="titNegritoRight">
						<xsl:value-of select="format-number(sum(FolhaPagamentoSomasPorDataCompetenciaComPagamentos//VLR_SALDO_EM_ABERTO), '#.##0,00')" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			
		</fo:table-body>
		
	</fo:table>

	<!-- ********** -->

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_3_2">3.2 Resumo do Cadastro de Funcionrios/Beneficirios</fo:block>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="400pt"/>
		<fo:table-column column-width="156pt"/>

            <!--Cabealho da Tabela-->
			<fo:table-body>	
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
    						TCE_4820.TXT - Geral
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Detalhamento
						</fo:block>
					</fo:table-cell>
				</fo:table-row>			 						

            	<!--Impresso do nm,ero de linhas processadas -->
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero Total dos Registros que compem o arquivo (Campo Finalizador)
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(CadastroFuncionariosNumLinhas/CadastroFuncionariosNumLinhasRow/NUM_REGISTROS, '###.###.##0')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
			</fo:table-body>
	</fo:table>

 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="30pt"/>
		<fo:table-column column-width="370pt"/>
		<fo:table-column column-width="156pt"/>

            <!--Cabealho da Tabela-->
			<fo:table-body>	
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
    						TCE_4820.TXT - Agrupado por matrculas ativas
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Detalhamento
						</fo:block>
					</fo:table-cell>
				</fo:table-row>			 						

            	<!--Impresso do nmero de matriculas distintas -->
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero de matrculas distintas
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(CadastroFuncionariosSomaFuncionarios/CadastroFuncionariosSomaFuncionariosRow/NUM_FUNCIONARIOS, '###.###.##0')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="3">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero de matrculas por SITUAO
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

            	<!--Impresso das Linhas de ... -->
				<xsl:for-each select="CadastroFuncionariosSomasPorSituacao/CadastroFuncionariosSomasPorSituacaoRow">
					<xsl:variable name="Descricao">
						<xsl:choose>
							<xsl:when test="SITUACAO=1">01 - Ativo</xsl:when>
							<xsl:when test="SITUACAO=2">02 - Aposentado</xsl:when>
							<xsl:when test="SITUACAO=3">03 - Pensionista (Penso por Falecimento de Funcionrio Ativo/Aposentado)</xsl:when>
							<xsl:when test="SITUACAO=4">04 - Pensionista (Demais Casos)</xsl:when>
							<xsl:when test="SITUACAO=99">99 - Outros</xsl:when>
							<xsl:otherwise><xsl:value-of select="SITUACAO"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
				
					<fo:table-row>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna"/>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtLeft">
								<xsl:value-of select="$Descricao"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(NUM_SITUACAO, '###.###.##0')"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:for-each>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="3">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero de matrculas por REGIME JURDICO
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<!--Impresso das Linhas de ... -->
				<xsl:for-each select="CadastroFuncionariosSomasPorRegimeJuridico/CadastroFuncionariosSomasPorRegimeJuridicoRow">
					<xsl:variable name="Descricao">
						<xsl:choose>
							<xsl:when test="REGIME_JURIDICO='E'">E - Estatutrio</xsl:when>
							<xsl:when test="REGIME_JURIDICO='C'">C - Celetista</xsl:when>
							<xsl:when test="REGIME_JURIDICO='O'">O - Outros</xsl:when>
							<xsl:otherwise><xsl:value-of select="REGIME_JURIDICO"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
				
					<fo:table-row>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna"/>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtLeft">
								<xsl:value-of select="$Descricao"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(NUM_REGIME, '###.###.##0')"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:for-each>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="3">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero de matrculas por NATUREZA DO CARGO
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<!--Impresso das Linhas de ... -->
				<xsl:for-each select="CadastroFuncionariosSomasPorNaturezaCargo/CadastroFuncionariosSomasPorNaturezaCargoRow">
					<xsl:variable name="Descricao">
						<xsl:choose>
							<xsl:when test="NATUREZA_CARGO='A'">A - Agente Poltico</xsl:when>
							<xsl:when test="NATUREZA_CARGO='C'">C - Comissionado</xsl:when>
							<xsl:when test="NATUREZA_CARGO='E'">E - Efetivo</xsl:when>
							<xsl:when test="NATUREZA_CARGO='S'">S - Estagirio</xsl:when>
							<xsl:when test="NATUREZA_CARGO='T'">T - Temporrio</xsl:when>
							<xsl:when test="NATUREZA_CARGO='U'">U - Conselheiro Tutelar</xsl:when>
							<xsl:when test="NATUREZA_CARGO='O'">O - Outros</xsl:when>
							<xsl:otherwise><xsl:value-of select="NATUREZA_CARGO"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
				
					<fo:table-row>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna"/>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtLeft">
								<xsl:value-of select="$Descricao"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(NUM_NATUREZA, '###.###.##0')"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:for-each>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="3">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero de matrculas por REGIME PREVIDENCIRIO
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<!--Impresso das Linhas de ... -->
				<xsl:for-each select="CadastroFuncionariosSomasPorRegimePrevidenciario/CadastroFuncionariosSomasPorRegimePrevidenciarioRow">
					<xsl:variable name="Descricao">
						<xsl:choose>
							<xsl:when test="REGIME_PREVIDENCIARIO=1">1 - RPPS</xsl:when>
							<xsl:when test="REGIME_PREVIDENCIARIO=2">2 - RGPS</xsl:when>
							<xsl:when test="REGIME_PREVIDENCIARIO=99">99 - Outros</xsl:when>
							<xsl:otherwise><xsl:value-of select="REGIME_PREVIDENCIARIO"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
				
					<fo:table-row>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna"/>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtLeft">
								<xsl:value-of select="$Descricao"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(NUM_PREV, '###.###.##0')"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:for-each>
				
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna" number-columns-spanned="3">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero de matrculas por CEDIDO/ADIDO
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<xsl:for-each select="CadastroFuncionariosSomasPorCedencia/CadastroFuncionariosSomasPorCedenciaRow">
					<xsl:variable name="Descricao">
						<xsl:choose>
							<xsl:when test="CEDIDO_ADIDO='A'">A - Adido</xsl:when>
							<xsl:when test="CEDIDO_ADIDO='C'">C - Cedido</xsl:when>
							<xsl:when test="CEDIDO_ADIDO='X'">X - No se aplica</xsl:when>
							<xsl:otherwise><xsl:value-of select="CEDIDO_ADIDO"/></xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="ONUS_ORIGEM='S'"> (Com nus para a origem)</xsl:when>
							<xsl:when test="ONUS_ORIGEM='N'"> (Sem nus para a origem)</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
				
					<fo:table-row>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna"/>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtLeft">
								<xsl:value-of select="$Descricao"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(CONTA, '###.###.##0')"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:for-each>

			</fo:table-body>
	</fo:table>
        
        <fo:block><fo:leader leader-pattern="space"/></fo:block>
        <fo:block xsl:use-attribute-sets="titFCinza" id="RDI_3_3">3.3 Resumo de Registro de Vantagens, Descontos e Totalizadores</fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="400pt"/>
		<fo:table-column column-width="156pt"/>

            <!--Cabealho da Tabela-->
			<fo:table-body>	
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
                                                        TCE_4960.TXT
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Detalhamento
						</fo:block>
					</fo:table-cell>
				</fo:table-row>			 						

            	<!--Impresso do nmero de linhas processadas -->
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero Total dos Registros que compem o arquivo (Campo Totalizador)
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(VantagemDescontoTotalNumLinhas/VantagemDescontoTotalNumLinhasRow/NUM_REGISTROS, '###.###.##0')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
			</fo:table-body>
	</fo:table>

							
</xsl:template>

<!--
#############################################
#### UC217-5
############################################# 
-->
<xsl:template match="ReceitaPublica">

	<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_4_1">4.1 Sistema de Arrecadao Municipal</fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="310pt"/>
		<fo:table-column column-width="82pt"/>
		<fo:table-column column-width="82pt"/>
		<fo:table-column column-width="82pt"/>

            <!--Cabealho da Tabela-->
			<fo:table-body>	
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
    						Tipo Operao
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Soma Valor Original
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Soma Valores Adicionais (*)
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Soma Valor da Operao
						</fo:block>
					</fo:table-cell>
				</fo:table-row>			 						

            	<!--Impresso das Linhas de ... -->
				<xsl:for-each select="ReceitaPublicaSomasPorTipoOperacao/ReceitaPublicaSomasPorTipoOperacaoRow">
					<xsl:variable name="Descricao">
						<xsl:choose>
							<xsl:when test="TP_OPERACAO=1">01-Cadastro Inicial</xsl:when>
							<xsl:when test="TP_OPERACAO=2">02-Recebimento em Espcie</xsl:when>
							<xsl:when test="TP_OPERACAO=3">03-Cancelamento</xsl:when>
							<xsl:when test="TP_OPERACAO=4">04-Dvida Ativa</xsl:when>
							<xsl:when test="TP_OPERACAO=98">98-Outros Recebimentos</xsl:when>
							<xsl:when test="TP_OPERACAO=99">99-Outras Baixas</xsl:when>
							<xsl:otherwise><xsl:value-of select="TP_OPERACAO"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
				
					<fo:table-row>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtLeft">
								<xsl:value-of select="$Descricao"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(SOMA_VL_ORIG, '#.##0,00')"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(SOMA_VL_ADIC, '#.##0,00')"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="format-number(SOMA_VL_OPER, '#.##0,00')"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:for-each>

            	<!--Impresso dos totais -->
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Total
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(sum(ReceitaPublicaSomasPorTipoOperacao//SOMA_VL_ORIG), '#.##0,00')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(sum(ReceitaPublicaSomasPorTipoOperacao//SOMA_VL_ADIC), '#.##0,00')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(sum(ReceitaPublicaSomasPorTipoOperacao//SOMA_VL_OPER), '#.##0,00')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
			</fo:table-body>
	</fo:table>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
 	<fo:block>* Valor de Multa, Juros, Atualizao Monetria, Descontos, etc.</fo:block>

 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="400pt"/>
		<fo:table-column column-width="156pt"/>

            <!--Cabealho da Tabela-->
			<fo:table-body>	
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
    						TCE_4010.TXT - Especificaes
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Detalhamento
						</fo:block>
					</fo:table-cell>
				</fo:table-row>			 						

            	<!--Impresso do nm,ero de linhas processadas -->
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero Total dos Registros que compem o arquivo (Campo Finalizador)
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(ReceitaPublicaNumLinhas/ReceitaPublicaNumLinhasRow/NUM_REGISTROS, '###.###.##0')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
			</fo:table-body>
	</fo:table>
							
</xsl:template>

<!--
#############################################
#### UC217-6
############################################# 
-->
<!--<xsl:template match="VantagemDescontoTotal">

	<fo:block xsl:use-attribute-sets="titFCinza" id="RDI_5_1">5.1 TCE_4960.TXT</fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" width="556pt">
		<fo:table-column column-width="400pt"/>
		<fo:table-column column-width="156pt"/>

			<fo:table-body>	
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
    						Especificaes
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="titNegritoLeft">
							Detalhamento
						</fo:block>
					</fo:table-cell>
				</fo:table-row>			 						

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Nmero Total dos Registros que compem o arquivo (Campo Finalizador)
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:value-of select="format-number(VantagemDescontoTotalNumLinhas/VantagemDescontoTotalNumLinhasRow/NUM_REGISTROS, '###.###.##0')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
			</fo:table-body>
	</fo:table>
							
</xsl:template> -->


<xsl:template match="ErrosAvisos">
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RDI_5_1">
	  <xsl:text>5.1 Avisos Exibidos </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="80pt"/>
	  <fo:table-column column-number="2" column-width="55pt"/>
	  <fo:table-column column-number="3" column-width="28pt"/>
	  <fo:table-column column-number="4" column-width="33pt"/>
	  <fo:table-column column-number="5" column-width="35pt"/>
	  <fo:table-column column-number="6" column-width="325pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Nome do Arquivo </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">C&#243;d. de Erro </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Linha </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Campo </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Status </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

	  <fo:table-body>
	   <xsl:for-each select="ErrosAvisosRow[NOME_ARQUIVO!='']">
		<fo:table-row>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="NOME_ARQUIVO"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="CD_ERRO"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="LINHA"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="CAMPO"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:if test="STATUS='E'">ERRO</xsl:if>
		   <xsl:if test="STATUS='J'">JUSTIF.</xsl:if>
		   <xsl:if test="STATUS='W'">AVISO</xsl:if>
		   <xsl:if test="STATUS='A'">ALERTA</xsl:if>
		   <xsl:if test="STATUS='I'">INFO</xsl:if>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeftShort2">
		   <xsl:value-of select="DESCRICAO"/>
		  </fo:block>
		 </fo:table-cell>
		</fo:table-row>
	   </xsl:for-each>
	 </fo:table-body>
	</fo:table>
</xsl:template>
    
<xsl:template match="ErrosAvisosJustificativas">
    <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
       <fo:table-column column-number="1"/>
       <fo:table-body>
       <fo:table-row>
            <fo:table-cell>
         <fo:block xsl:use-attribute-sets="titFCinza" id="RDI_4_2">
              <xsl:text>5.2 Avisos Justificados pela Entidade </xsl:text>
             </fo:block>
        </fo:table-cell>
       </fo:table-row>
      </fo:table-body>
     </fo:table>
         <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
         <fo:table-column column-number="1" column-width="256pt"/>
         <fo:table-column column-number="2" column-width="300pt"/>

          <fo:table-body>
           <xsl:for-each select="ErrosAvisosJustificativasRow">
                <fo:table-row>
                        <fo:table-cell number-columns-spanned="2">
                                <fo:block xsl:use-attribute-sets="txtLeft">
                                        <fo:inline font-weight="bold" padding-right="3pt">Descrio: </fo:inline>
                                        <xsl:value-of select="NOME_PLANILHA"/>
                                </fo:block>
                        </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                        <fo:table-cell number-columns-spanned="2">
                                <fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
                                        <fo:inline font-weight="bold" padding-right="3pt">Justificativa: </fo:inline>
                                        <xsl:value-of select="TEXTO"/>
                                </fo:block>
                        </fo:table-cell>
                </fo:table-row>
           </xsl:for-each>
          </fo:table-body>
         </fo:table>        
</xsl:template>

<xsl:template match="ObservacoesEntidade">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_7_0">
	  <xsl:text>6. Observa&#231;&#245;es da Entidade para o TCE-RS </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-body>
   	<fo:table-row>
		<fo:table-cell border-width="0.5pt" number-columns-spanned="5" padding-left="10pt">
     		<fo:block xsl:use-attribute-sets="txtLeft">
				Qualquer diverg&#234;ncia verificada neste relat&#243;rio ou observa&#231;&#227;o que a Entidade julgar relevante dever&#227;o ser informadas neste item.
	 		</fo:block>
    	</fo:table-cell>
   	</fo:table-row>
   	<fo:table-row>
		<fo:table-cell border-width="0.5pt" number-columns-spanned="5">
			<fo:block><fo:leader leader-pattern="space"/></fo:block>
    	</fo:table-cell>
   	</fo:table-row>
   	<xsl:for-each select="ObservacoesEntidadeRow">
   	<fo:table-row>
   		<fo:table-cell border-width="0.5pt" number-columns-spanned="5" padding-left="5pt">
      		<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:value-of select="RESPOSTA"/>
			</fo:block>
     	</fo:table-cell>
    </fo:table-row>
   	</xsl:for-each>
  </fo:table-body>
 </fo:table>
</xsl:template>
<!--
#############################################
#### UC074-51
############################################# 
-->	
<xsl:template match="Assinaturas">
<!-- ************* Variaveis locais **************--> 
 <xsl:variable name="administrador">
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">Prefeito Municipal</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">Presidente da C&#226;mara Municipal</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P' and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">Respons&#225;vel</xsl:if>
 </xsl:variable>
 
 <!-- USAR VARIAVEL DOCUMENTO SO PCDI -->
 <xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao"/>
 <xsl:variable name="data" select="substring($dataHora, 1, 10)"/>
 <xsl:variable name="dia" select="substring($data, 9, 2)"/>
 <xsl:variable name="mes" select="substring($data, 6, 2)"/>
 <xsl:variable name="ano" select="substring($data, 1, 4)"/>
 <xsl:variable name="mesNome">
 	<xsl:if test="$mes='01'">Janeiro</xsl:if>
    <xsl:if test="$mes='02'">Fevereiro</xsl:if>
    <xsl:if test="$mes='03'">Mar&#231;o</xsl:if>
    <xsl:if test="$mes='04'">Abril</xsl:if>
    <xsl:if test="$mes='05'">Maio</xsl:if>
    <xsl:if test="$mes='06'">Junho</xsl:if>
    <xsl:if test="$mes='07'">Julho</xsl:if>
    <xsl:if test="$mes='08'">Agosto</xsl:if>
    <xsl:if test="$mes='09'">Setembro</xsl:if>
    <xsl:if test="$mes='10'">Outubro</xsl:if>
    <xsl:if test="$mes='11'">Novembro</xsl:if>
    <xsl:if test="$mes='12'">Dezembro</xsl:if>
 </xsl:variable>  

<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="270pt"/>
  <fo:table-column column-number="2" column-width="16pt"/>
  <fo:table-column column-number="3" column-width="270pt"/>


  <fo:table-body>
   <!--<xsl:for-each select="AssinaturasRow">-->
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" number-columns-spanned="3">
	 <fo:block xsl:use-attribute-sets="txtCenter">
	  <!--<xsl:value-of select="AssinaturasRow/NOME_MUNICIPIO"/>, <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('d'), java:java.util.Date.new())"/> de <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('MMMM'), java:java.util.Date.new())"/> de <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('yyyy'), java:java.util.Date.new())"/>-->
    <xsl:value-of select="AssinaturasRow/NOME_MUNICIPIO"/>, <xsl:value-of select="$dia"/> de <xsl:value-of select="$mesNome"/> de <xsl:value-of select="$ano"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
		<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="AssinaturasRow/RESP_CTRL_INTERNO"/></fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pelo Controle Interno</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" ><fo:block xsl:use-attribute-sets="txtRight"></fo:block></fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
		<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="AssinaturasRow/ADMINISTRADOR"/></fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="$administrador"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <!--
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
		<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pela Administra&#231;&#227;o Financeira:<xsl:value-of select="InformacoesRow/NOME_REPRESENTANTE"/></fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="AssinaturasRow/RESP_ADMIN_FINAN"/></fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" ><fo:block xsl:use-attribute-sets="txtRight"></fo:block></fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
		<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pelo Controle Interno:</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="AssinaturasRow/RESP_CTRL_INTERNO"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   -->
   <!-- fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" number-columns-spanned="3">
		<fo:block xsl:use-attribute-sets="txtLeft">Respons&#225;vel pelo preenchimento do PAD e gera&#231;&#227;o das informa&#231;&#245;es: <xsl:value-of select="AssinaturasRow/RESPONSAVEL_PAD"/></fo:block>
		<fo:block xsl:use-attribute-sets="txtLeft">Cargo: <xsl:value-of select="AssinaturasRow/CARGO_RESP_PAD"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <!- -</xsl:for-each>-->
  </fo:table-body>	
 </fo:table>	



 <fo:table width="555pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="174pt"/>
  <fo:table-column column-number="2" column-width="16pt"/>
  <fo:table-column column-number="3" column-width="174pt"/>
  <fo:table-column column-number="4" column-width="16pt"/>
  <fo:table-column column-number="5" column-width="174pt"/>


  <fo:table-body>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>

   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>

   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
		<xsl:if test="/rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='LD' and SOLICITADO='S']">
			<fo:block xsl:use-attribute-sets="txtCenter">____________________________________</fo:block>
			<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="/rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='LD']/NOME_RESPONSAVEL_ENTIDADE"/></fo:block>
			<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pelo Livro Di&#225;rio Geral</fo:block>
		</xsl:if>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" ><fo:block xsl:use-attribute-sets="txtRight"></fo:block></fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
		<xsl:if test="/rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='FP' and SOLICITADO='S']">
			<fo:block xsl:use-attribute-sets="txtCenter">____________________________________</fo:block>
			<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="/rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='FP']/NOME_RESPONSAVEL_ENTIDADE"/></fo:block>
			<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pela Folha de Pagamento</fo:block>
		</xsl:if>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" ><fo:block xsl:use-attribute-sets="txtRight"></fo:block></fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
		<xsl:if test="/rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='RP' and SOLICITADO='S']">
			<fo:block xsl:use-attribute-sets="txtCenter">____________________________________</fo:block>
			<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="/rdi/ArquivosComplementaresSolicitados/ArquivosComplementaresSolicitadosRow[TIPO='RP']/NOME_RESPONSAVEL_ENTIDADE"/></fo:block>
			<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pela Arrecadao Municipal</fo:block>
		</xsl:if>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    

   </fo:table-row>
  </fo:table-body>	
 </fo:table>	


</xsl:template>
<!-- #### FIM - UC074-51 ####-->

</xsl:stylesheet>
