/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pool;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Properties;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.pool.AgeHistogram;
import oracle.jbo.pool.RecentlyUsedLinkedList;
import oracle.jbo.pool.RecentlyUsedLinkedListElement;
import oracle.jbo.pool.ResourceInfo;
import oracle.jbo.pool.ResourcePoolException;
import oracle.jbo.pool.ResourcePoolListener;
import oracle.jbo.pool.ResourcePoolLogger;
import oracle.jbo.pool.ResourcePoolManager;
import oracle.jbo.pool.ResourcePoolStatistics;

public abstract class ResourcePool {
    protected final Integer mLock;
    transient HashMap mResourceInfo;
    private transient RecentlyUsedLinkedList mAvailableList;
    private transient HashMap mResourceInfosIndex;
    private transient int mResourceIndex;
    private transient int mResourceCount;
    private transient int mGuards;
    protected transient ResourcePoolLogger mLogger;
    private transient ArrayList mPoolListeners;
    private transient HashMap mRemoveList;
    private transient boolean mIsInitialized;
    private transient Thread mInitializerThread;
    private transient boolean mInitializerCreated;
    private static final String POOL_INITIALIZER_THREAD_NAME = "jbo.poolinitializer";
    private static final String WAS_REMOVED = "jbo.was_removed";
    public static final long WAIT_TIME_INCREMENT = 1000L;
    public static final long MAX_WAIT_TIME = 10000L;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mLock = new Integer(0);
        this.mResourceInfo = new HashMap(10);
        this.mAvailableList = new RecentlyUsedLinkedList();
        this.mResourceInfosIndex = new HashMap(10);
        this.mResourceIndex = -1;
        this.mResourceCount = 0;
        this.mGuards = 0;
        this.mPoolListeners = new ArrayList(10);
        this.mRemoveList = new HashMap();
        this.mIsInitialized = false;
        this.mInitializerThread = null;
        this.mInitializerCreated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties properties) {
        Integer n = this.mLock;
        synchronized (n) {
            if (!this.mIsInitialized) {
                if (this.mAvailableList == null) {
                    this.mAvailableList = new RecentlyUsedLinkedList();
                }
                if (this.mResourceInfosIndex == null) {
                    this.mResourceInfosIndex = new HashMap(10);
                }
                if (this.mResourceInfo == null) {
                    this.mResourceInfo = new HashMap(10);
                }
                if (this.mResourceCount < 0) {
                    this.mResourceCount = 0;
                }
                if (this.mPoolListeners == null) {
                    this.mPoolListeners = new ArrayList(10);
                }
                if (this.mRemoveList == null) {
                    this.mRemoveList = new HashMap();
                }
                if (this.mLogger == null) {
                    this.mLogger = this.createPoolLogger();
                    this.addPoolListener(this.mLogger);
                }
                if (properties != null) {
                    this.createInitializer(properties);
                }
                this.mIsInitialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createInitializer(Properties properties) {
        Integer n = this.mLock;
        synchronized (n) {
            if (this.getInitPoolSize() > 0 && !this.mInitializerCreated) {
                Initializer initializer = new Initializer(properties);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread thread = (Thread)AccessController.doPrivileged(new 1(this, initializer, classLoader));
                thread.setPriority(2);
                thread.setDaemon(true);
                this.setInitializer(thread);
                thread.start();
            }
        }
    }

    public String getName() {
        return null;
    }

    public Thread getInitializer() {
        return this.mInitializerThread;
    }

    private void setInitializer(Thread thread) {
        this.mInitializerThread = thread;
        this.mInitializerCreated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceCount() {
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = this.mResourceCount;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object useResource(Properties properties) {
        Object object = null;
        boolean bl = false;
        boolean bl2 = true;
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = this.getMaxPoolSize();
            bl2 = this.isUseExclusive();
            if (bl2) {
                object = this.seekMRUAvailableResource(null);
                if (object == null) {
                    object = this.allocateResource();
                } else {
                    this.setAvailable(object, false);
                }
            } else {
                ++this.mResourceIndex;
                if (this.mResourceIndex >= n2) {
                    this.mResourceIndex = 0;
                }
                int n3 = this.mResourceIndex;
                ResourceInfo resourceInfo = (ResourceInfo)this.mResourceInfosIndex.get((Object)new Integer(n3));
                while (!(resourceInfo != null && this.isAvailable(resourceInfo.getRefObject()) || this.getResourceCount() < n2)) {
                    Object var12_10;
                    try {
                        try {
                            ++this.mGuards;
                            this.mLock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            var12_10 = null;
                            --this.mGuards;
                        }
                        var12_10 = null;
                        --this.mGuards;
                    }
                    catch (Throwable throwable) {
                        var12_10 = null;
                        --this.mGuards;
                        throw throwable;
                    }
                    resourceInfo = (ResourceInfo)this.mResourceInfosIndex.get((Object)new Integer(n3));
                }
                if (this.getResourceCount() < n2) {
                    object = this.allocateResource();
                } else {
                    object = resourceInfo.getRefObject();
                    if ((resourceInfo.mState & 2) > 0 && (resourceInfo.mState & 0x40) == 0) {
                        this.setAvailable(object, false);
                        bl = true;
                    }
                }
            }
        }
        if (object == null) {
            try {
                object = this.createResource(properties);
                if (!bl2) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.logPoolEvent((byte)9);
                throw new JboException(throwable);
            }
        }
        if (bl) {
            this.prepareSharedResource(object, properties);
        }
        Integer n4 = this.mLock;
        synchronized (n4) {
            this.incrementRefCount(object);
            if (!bl2) {
                this.setState(object, (byte)66, properties);
            }
        }
        this.logPoolEvent((byte)3);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementRefCount(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            ResourceInfo resourceInfo = this.getResourceInfo(object);
            resourceInfo.incrementRefCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementRefCount(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            ResourceInfo resourceInfo = this.getResourceInfo(object);
            resourceInfo.decrementRefCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRefCount(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = this.getResourceInfo(object).getRefCount();
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResource(Object object, Properties properties) {
        byte by = -1;
        Integer n = this.mLock;
        synchronized (n) {
            ResourceInfo resourceInfo = this.getResourceInfo(object);
            if (resourceInfo.getRefCount() == 1 && (resourceInfo.mState & 2) > 0 && (resourceInfo.mState & 0x40) > 0) {
                by = 2;
                this.setAvailable(object, false);
            }
            this.decrementRefCount(object);
            long l = System.currentTimeMillis() - (long)this.getTimeToLive();
            if (resourceInfo.mCreationTimeMillis < l) {
                by = 8;
                this.setAvailable(object, false);
            }
            if (by < 0) {
                this.setAvailable(object, true);
            }
        }
        if (by >= 0) {
            this.setState(object, by, properties);
        }
        this.logPoolEvent((byte)2);
    }

    protected void logPoolEvent(byte by) {
        ResourcePoolListener resourcePoolListener = null;
        int n = 0;
        while (n < this.mPoolListeners.size()) {
            resourcePoolListener = (ResourcePoolListener)this.mPoolListeners.get(n);
            resourcePoolListener.handleEvent(by);
            ++n;
        }
    }

    public void dumpPoolStatistics(PrintWriter printWriter) {
        this.mLogger.dumpPoolStatistics(printWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void computeResourceAgeHistogram(AgeHistogram var1_1) {
        var2_2 = null;
        var6_3 = this.mLock;
        synchronized (var6_3) {
            var2_2 = ((HashMap)this.mResourceInfo.clone()).values().iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var6_3
            if (true) ** GOTO lbl24
        }
        do {
            var3_4 = (ResourceInfo)var2_2.next();
            var4_5 = false;
            var5_6 = var1_1.mAges.length - 1;
            while (var5_6 >= 0) {
                if (var3_4.getLastUpdate().before(var1_1.mAges[var5_6])) {
                    v1 = var5_6 + 1;
                    var1_1.mBuckets[v1] = var1_1.mBuckets[v1] + 1;
                    var4_5 = true;
                    break;
                }
                --var5_6;
            }
            if (var4_5) continue;
            var1_1.mBuckets[0] = var1_1.mBuckets[0] + 1;
lbl24:
            // 3 sources

        } while (var2_2.hasNext());
    }

    public ResourcePoolStatistics getResourcePoolStatistics() {
        return this.mLogger.getResourcePoolStatistics();
    }

    public Object getSyncLock() {
        return this.mLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createResource(Properties properties) {
        Diagnostic.println("Creating a new pool resource");
        long l = System.currentTimeMillis();
        Object object = null;
        try {
            object = this.instantiateResource(properties);
        }
        catch (Throwable throwable) {
            Integer n = this.mLock;
            synchronized (n) {
                --this.mResourceCount;
            }
            throw new JboException(throwable);
        }
        long l2 = System.currentTimeMillis();
        ResourceInfo resourceInfo = new ResourceInfo(object);
        resourceInfo.mTimeToCreateMillis = l2 - l;
        resourceInfo.mCreationTimeMillis = l2;
        Integer n = this.mLock;
        synchronized (n) {
            resourceInfo.mIndex = new Integer(this.mResourceInfo.size());
            this.mResourceInfo.put(object, (Object)resourceInfo);
            this.mResourceInfosIndex.put((Object)resourceInfo.mIndex, (Object)resourceInfo);
            if (this.mGuards > 0) {
                this.mLock.notifyAll();
            }
        }
        this.logPoolEvent((byte)0);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableResourceCount() {
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = this.mAvailableList.getSize();
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList removeResources() {
        ArrayList arrayList = null;
        Integer n = this.mLock;
        synchronized (n) {
            arrayList = new ArrayList(((HashMap)this.mResourceInfo.clone()).values());
            this.mResourceInfo.clear();
            this.mResourceInfosIndex.clear();
            this.mAvailableList.reset();
            this.mResourceCount = 0;
            if (this.mGuards > 0) {
                this.mLock.notifyAll();
            }
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.logPoolEvent((byte)1);
            arrayList2.add(((ResourceInfo)arrayList.get(n2)).getRefObject());
            ++n2;
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            if (this.mResourceInfo.get(object) == null) {
                if (this.mResourceCount < this.getMaxPoolSize()) {
                    ++this.mResourceCount;
                    ResourceInfo resourceInfo = new ResourceInfo(object);
                    resourceInfo.mIndex = new Integer(this.mResourceInfo.size());
                    this.mResourceInfo.put(object, (Object)resourceInfo);
                    this.mResourceInfosIndex.put((Object)resourceInfo.mIndex, (Object)resourceInfo);
                    this.setAvailable(object);
                } else {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = ResourcePool.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new JboException(clazz, "26067", null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRemoveList(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            this.mRemoveList.put(object, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromRemoveList(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            this.mRemoveList.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemoveList() {
        HashMap hashMap = null;
        Integer n = this.mLock;
        synchronized (n) {
            hashMap = (HashMap)this.mRemoveList.clone();
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.removeResourceInternal(iterator.next());
        }
    }

    protected boolean canFinalizeResource(Object object) {
        return this.getRefCount(object) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeResourceInternal(Object object) {
        Object object2 = null;
        Integer n = this.mLock;
        synchronized (n) {
            if (this.getResourceInfo(object) == null) {
                boolean bl = false;
                return bl;
            }
            Diagnostic.ASSERT((this.getState(object) & 8) > 0, "ILLEGAL STATE:  STATE NOT STATE_DESTROYED IN REMOVERESOURCEINTERNAL");
            if (!this.canFinalizeResource(object)) {
                this.addToRemoveList(object);
                boolean bl = false;
                return bl;
            }
            object2 = this.getResourceDetails(object);
            this.beforeResourceFinalized(object);
            ResourceInfo resourceInfo = (ResourceInfo)this.mResourceInfo.remove(object);
            if (resourceInfo != null) {
                resourceInfo.getRefObject();
                this.mAvailableList.removeElement(resourceInfo);
                this.mResourceInfosIndex.remove((Object)resourceInfo.mIndex);
                if (this.mGuards > 0) {
                    this.mLock.notifyAll();
                }
            }
            this.removeFromRemoveList(object);
        }
        this.finalizeResource(object, object2);
        return true;
    }

    public Object removeResource(Object object) {
        Properties properties = new Properties();
        this.setState(object, (byte)8, properties);
        return properties.get(WAS_REMOVED) != null ? object : null;
    }

    public void wakeup() {
        this.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeup(ResourcePoolManager resourcePoolManager) {
        this.wakeup();
        Integer n = this.mLock;
        synchronized (n) {
            if (this.removeFromManager()) {
                resourcePoolManager.removeResourcePool(this.getResourcePoolKey());
            }
        }
    }

    protected boolean removeFromManager() {
        return this.mResourceCount == 0;
    }

    protected abstract Object getResourcePoolKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object seekLRUAvailableResource(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            Object object2 = null;
            if (object == null) {
                RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = this.mAvailableList.getLRUElement();
                if (recentlyUsedLinkedListElement != null) {
                    object2 = recentlyUsedLinkedListElement.getRefObject();
                }
            } else {
                RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = (RecentlyUsedLinkedListElement)this.mResourceInfo.get(object);
                if (recentlyUsedLinkedListElement != null && (recentlyUsedLinkedListElement = recentlyUsedLinkedListElement.getLessRecentlyUsedElement()) != null) {
                    object2 = recentlyUsedLinkedListElement.getRefObject();
                }
            }
            Object object3 = object2;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object seekMRUAvailableResource(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            Object object2 = null;
            if (object == null) {
                RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = this.mAvailableList.getMRUElement();
                if (recentlyUsedLinkedListElement != null) {
                    object2 = recentlyUsedLinkedListElement.getRefObject();
                }
            } else {
                RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = (RecentlyUsedLinkedListElement)this.mResourceInfo.get(object);
                if (recentlyUsedLinkedListElement != null && (recentlyUsedLinkedListElement = recentlyUsedLinkedListElement.getMoreRecentlyUsedElement()) != null) {
                    object2 = recentlyUsedLinkedListElement.getRefObject();
                }
            }
            Object object3 = object2;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getTimeToCreateMillis(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            ResourceInfo resourceInfo = this.getResourceInfo(object);
            long l = resourceInfo.mTimeToCreateMillis;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCreationTimeMillis(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            ResourceInfo resourceInfo = this.getResourceInfo(object);
            long l = resourceInfo.mCreationTimeMillis;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAvailable(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            byte by = this.getState(object);
            boolean bl = (by & 2) > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAvailable(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            if ((this.getState(object) & 1) == 0) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ResourcePool.class$("oracle.jbo.CSMessageBundle");
                }
                throw new ResourcePoolException(clazz, "28101", null);
            }
            this.setAvailable(object, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte getState(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            byte by = this.getResourceInfo((Object)object).mState;
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setState(Object object, byte by, Properties properties) {
        boolean bl;
        Integer n = this.mLock;
        synchronized (n) {
            ResourceInfo resourceInfo = this.getResourceInfo(object);
            byte by2 = resourceInfo.mState;
            byte by3 = (byte)(by & 0x1F);
            byte by4 = (byte)(by2 & 0x1F);
            if (by4 == 8) {
                boolean bl2 = false;
                return bl2;
            }
            if (by4 != by3) {
                switch (by3) {
                    case 2: {
                        if ((by & 0x40) == 0) {
                            by = (byte)(by | 0x20);
                        }
                        this.mAvailableList.touchElement(resourceInfo);
                        if (this.mGuards <= 0) break;
                        this.mLock.notifyAll();
                        break;
                    }
                    case 8: {
                        --this.mResourceCount;
                        if (resourceInfo != null) {
                            this.logPoolEvent((byte)1);
                        }
                    }
                    case 4: {
                        this.mAvailableList.removeElement(resourceInfo);
                    }
                }
            }
            if (resourceInfo != null) {
                resourceInfo.mState = by;
            }
            if (by != by2) {
                this.resourceStateChanged(object, by, by2);
            }
        }
        if ((by & 8) != 0 && (bl = this.removeResourceInternal(object)) && properties != null) {
            properties.put(WAS_REMOVED, WAS_REMOVED);
        }
        return true;
    }

    protected void resourceStateChanged(Object object, byte by, byte by2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAvailable(Object object, boolean bl) {
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = 4;
            if (bl) {
                n2 = this.getResourceInfo(object).getRefCount() > 0 ? 66 : 2;
            }
            this.setState(object, (byte)n2, null);
        }
    }

    protected void prepareSharedResource(Object object, Properties properties) {
    }

    protected void finalizeResource(Object object, Object object2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object allocateResource() {
        Integer n = this.mLock;
        synchronized (n) {
            Object object = null;
            if (this.getResourceCount() < this.getMaxPoolSize()) {
                ++this.mResourceCount;
            } else {
                long l = this.getMaxWaitTime();
                long l2 = 0L;
                ++this.mGuards;
                Diagnostic.println("Waiting for a resource to be returned to the pool...");
                int n2 = this.getMaxPoolSize();
                while (this.getAvailableResourceCount() == 0 || this.getResourceCount() == n2) {
                    if (l2 < l) {
                        try {
                            this.mLock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        --this.mGuards;
                        Diagnostic.println("Pool wait time was exceeded");
                        this.logPoolEvent((byte)9);
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = ResourcePool.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new ResourcePoolException(clazz, "28102", new Object[]{this.getName()});
                    }
                    l2 += 1000L;
                }
                --this.mGuards;
                if (this.getAvailableResourceCount() > 0) {
                    object = this.seekMRUAvailableResource(null);
                    this.setAvailable(object, false);
                }
            }
            Object object2 = object;
            return object2;
        }
    }

    protected Object getResourceDetails(Object object) {
        return null;
    }

    protected void beforeResourceFinalized(Object object) {
    }

    public abstract Object instantiateResource(Properties var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getResource(int n) {
        Object object = null;
        Integer n2 = this.mLock;
        synchronized (n2) {
            ResourceInfo resourceInfo = (ResourceInfo)this.mResourceInfosIndex.get((Object)new Integer(n));
            if (resourceInfo != null) {
                object = resourceInfo.getRefObject();
            }
            Object object2 = object;
            return object2;
        }
    }

    protected int getMinAvailableSize() {
        return Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.pDefault);
    }

    protected int getMaxAvailableSize() {
        return Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.pDefault);
    }

    protected int getMaxInactiveAge() {
        return Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.pDefault);
    }

    protected int getTimeToLive() {
        return Integer.parseInt(PropertyMetadata.ENV_AMPOOL_TIME_TO_LIVE.pDefault);
    }

    protected int getInitPoolSize() {
        return Integer.parseInt(PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.pDefault);
    }

    protected int getMaxPoolSize() {
        return Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.pDefault);
    }

    protected long getMaxWaitTime() {
        return 10000L;
    }

    protected boolean isUseExclusive() {
        return true;
    }

    protected ResourcePoolLogger createPoolLogger() {
        return new ResourcePoolLogger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceInfo getResourceInfo(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            ResourceInfo resourceInfo = (ResourceInfo)this.mResourceInfo.get(object);
            if (resourceInfo == null) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ResourcePool.class$("oracle.jbo.CSMessageBundle");
                }
                throw new ResourcePoolException(clazz, "28103", null);
            }
            ResourceInfo resourceInfo2 = resourceInfo;
            return resourceInfo2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gc() {
        ArrayList arrayList = new ArrayList();
        Object object = null;
        Integer n = this.mLock;
        synchronized (n) {
            if (this.getResourceCount() > 0) {
                int n2 = this.getMinAvailableSize();
                int n3 = this.getMaxAvailableSize();
                long l = this.getMaxInactiveAge();
                long l2 = System.currentTimeMillis() - (long)this.getTimeToLive();
                Date date = new Date(System.currentTimeMillis() - l);
                ResourceInfo resourceInfo = (ResourceInfo)this.mResourceInfo.get(this.seekLRUAvailableResource(null));
                while (resourceInfo != null && this.getAvailableResourceCount() > n2) {
                    object = null;
                    if (resourceInfo.getLastUpdate().after(date)) break;
                    object = resourceInfo.getRefObject();
                    resourceInfo = (ResourceInfo)this.mResourceInfo.get(this.seekMRUAvailableResource(object));
                    this.prepareForGCRemove(arrayList, object);
                }
                resourceInfo = (ResourceInfo)this.mResourceInfo.get(this.seekLRUAvailableResource(null));
                while (resourceInfo != null && this.getAvailableResourceCount() > n3) {
                    object = resourceInfo.getRefObject();
                    resourceInfo = (ResourceInfo)this.mResourceInfo.get(this.seekMRUAvailableResource(object));
                    this.prepareForGCRemove(arrayList, object);
                }
                resourceInfo = (ResourceInfo)this.mResourceInfo.get(this.seekLRUAvailableResource(null));
                boolean bl = false;
                while (resourceInfo != null) {
                    if (resourceInfo.mCreationTimeMillis < l2) {
                        bl = true;
                    }
                    object = resourceInfo.getRefObject();
                    resourceInfo = (ResourceInfo)this.mResourceInfo.get(this.seekMRUAvailableResource(object));
                    if (bl) {
                        this.prepareForGCRemove(arrayList, object);
                    }
                    bl = false;
                }
            }
        }
        int n4 = arrayList.size();
        int n5 = 0;
        while (n5 < n4) {
            object = arrayList.get(n5);
            this.setState(object, (byte)8, null);
            ++n5;
        }
        this.processRemoveList();
    }

    protected void prepareForGCRemove(ArrayList arrayList, Object object) {
        this.setState(object, (byte)4, null);
        arrayList.add(object);
    }

    private void addPoolListener(ResourcePoolListener resourcePoolListener) {
        this.mPoolListeners.add((Object)resourcePoolListener);
    }

    private boolean removePoolListener(ResourcePoolListener resourcePoolListener) {
        return this.mPoolListeners.remove((Object)resourcePoolListener);
    }

    public ResourcePool() {
        this.$init$();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    implements PrivilegedAction {
        private final /* synthetic */ Runnable v$runnable;
        private final /* synthetic */ ClassLoader v$currentLoader;
        final /* synthetic */ ResourcePool this$0;

        public Object run() {
            Thread thread = new Thread(this.v$runnable, ResourcePool.POOL_INITIALIZER_THREAD_NAME);
            thread.setContextClassLoader(this.v$currentLoader);
            return thread;
        }

        public /* synthetic */ 1(ResourcePool resourcePool, Runnable runnable, ClassLoader classLoader) {
            this.v$currentLoader = classLoader;
            this.v$runnable = runnable;
            this.this$0 = resourcePool;
        }
    }

    public class Initializer
    implements Runnable {
        private final Properties mProperties;

        Initializer(Properties properties) {
            this.mProperties = properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n = ResourcePool.this.getInitPoolSize();
                int n2 = ResourcePool.this.getMaxPoolSize();
                int n3 = 0;
                while (n3 < n) {
                    Integer n4 = ResourcePool.this.mLock;
                    synchronized (n4) {
                        int n5 = ResourcePool.this.getResourceCount();
                        if (n5 >= n || n5 >= n2) {
                            break;
                        }
                        ResourcePool resourcePool = ResourcePool.this;
                        resourcePool.mResourceCount = resourcePool.mResourceCount + 1;
                    }
                    Object object = null;
                    try {
                        Diagnostic.println("Pool initializer is creating a new pool resource");
                        object = ResourcePool.this.createResource(this.mProperties);
                        Integer n6 = ResourcePool.this.mLock;
                        synchronized (n6) {
                            ResourcePool.this.setAvailable(object);
                        }
                    }
                    catch (Exception exception) {
                        Diagnostic.printStackTrace(exception);
                    }
                    ++n3;
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                ResourcePool.this.setInitializer(null);
                throw throwable;
            }
            ResourcePool.this.setInitializer(null);
        }
    }
}

