/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom.xml;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.InputStream;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.mom.xml.XMLContext;

public class XMLContextImpl
implements XMLContext {
    private static final int NAMES_SIZE = 10;
    private static final int ENV_SIZE = 10;
    Hashtable mEnv;
    HashMap mNames;

    private /* synthetic */ void $init$() {
        this.mEnv = null;
        this.mNames = new HashMap(10);
    }

    public XMLContextImpl(Hashtable hashtable) {
        this.$init$();
        if (hashtable != null) {
            this.mEnv = (Hashtable)hashtable.clone();
        }
    }

    public Object lookup(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException("Empty name.");
        }
        return this.getMetaDataStream(JboNameUtil.getDocumentName(string));
    }

    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.lookup(name.toString());
    }

    public void bind(String string, Object object) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mNames.get((Object)string) != null) {
            throw new NameAlreadyBoundException(string + " already bound.");
        }
        this.mNames.put((Object)string, object);
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.bind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        this.mNames.put((Object)string, object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.rebind(name.toString(), object);
    }

    public void unbind(String string) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        this.mNames.remove((Object)string);
    }

    public void unbind(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.unbind(name.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        Object object = null;
        object = this.mNames.get((Object)string);
        if (object == null) {
            throw new NameNotFoundException(string + " not bound.");
        }
        if (this.mNames.get((Object)string2) != null) {
            throw new NameAlreadyBoundException(string2 + " already bound.");
        }
        this.mNames.remove((Object)string);
        this.mNames.put((Object)string2, object);
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name == null || name2 == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.rename(name.toString(), name2.toString());
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string == null) {
            throw new InvalidNameException("Empty name.");
        }
        if (string.equals("")) {
            return new NameList(this.mNames.keySet().iterator(), true);
        }
        return new NameList(string, true);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string == null) {
            throw new InvalidNameException("Empty name.");
        }
        if (string.equals("")) {
            return new NameList(this.mNames.keySet().iterator(), false);
        }
        return new NameList(string, false);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String string) throws NamingException {
        this.unbind(string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Subcontext not supported.");
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String string) throws NamingException {
        throw new OperationNotSupportedException("getNameParser not supported.");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.getNameParser(name.toString());
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mEnv == null) {
            this.mEnv = new Hashtable(10);
        }
        return this.mEnv.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mEnv == null) {
            return null;
        }
        return this.mEnv.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.mEnv == null) {
            throw new NamingException("Null Environment");
        }
        return this.mEnv;
    }

    public void close() throws NamingException {
        this.mEnv = null;
        this.mNames = null;
    }

    public InputStream getMetaDataStream(String string) {
        return JBOClass.getResourceAsStream(string);
    }

    public String getNameInNamespace() throws NamingException {
        return null;
    }

    public class NameList
    implements NamingEnumeration {
        Iterator names;
        boolean isNameClassPair;

        NameList(String string, boolean bl) {
            ArrayList arrayList = new ArrayList(1);
            if (XMLContextImpl.this.mNames.get((Object)string) != null) {
                arrayList.add((Object)string);
            }
            this.names = arrayList.iterator();
            this.isNameClassPair = bl;
        }

        NameList(Iterator iterator, boolean bl) {
            this.names = iterator;
            this.isNameClassPair = bl;
        }

        public boolean hasMoreElements() {
            return this.names.hasNext();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String string = (String)this.names.next();
            if (this.isNameClassPair) {
                return new NameClassPair(string, XMLContextImpl.this.mNames.get((Object)string).getClass().getName());
            }
            return new Binding(string, XMLContextImpl.this.mNames.get((Object)string));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            this.names = null;
        }
    }
}

