/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.util.Hashtable;
import oracle.jbo.common.DiagnosticFactory;
import oracle.jbo.common.MOMProperties;
import oracle.jbo.common.Owner;
import oracle.jbo.common.PropertyContext;
import oracle.jbo.common.PropertyMetadata;

public class PropertyDefaultContext
implements PropertyContext {
    public static final String NAME = "Default";
    private static PropertyDefaultContext theInstance = null;
    private static Hashtable s_overriddenProperties = new Hashtable(10);

    private PropertyDefaultContext() {
    }

    public static PropertyDefaultContext getInstance() {
        if (theInstance == null) {
            theInstance = new PropertyDefaultContext();
        }
        return theInstance;
    }

    public static Hashtable getOverriddenProperties() {
        return s_overriddenProperties;
    }

    public static void main(String[] stringArray) {
    }

    public Object getDirect(String string) {
        PropertyMetadata propertyMetadata = PropertyMetadata.findByName(string);
        if (propertyMetadata.getOwner().id == Owner.MOM.id) {
            return MOMProperties.getProperty(string, null);
        }
        if (propertyMetadata.getOwner().id == Owner.DIAGNOSTIC.id) {
            return DiagnosticFactory.getProperty(string);
        }
        throw new RuntimeException("Error: cannot get non-static property: " + string);
    }

    public Object getRecursive(String string) {
        return this.getDirect(string);
    }

    public void setDirect(String string, Object object) {
        boolean bl = false;
        PropertyMetadata propertyMetadata = PropertyMetadata.findByName(string);
        String string2 = object.toString();
        if (propertyMetadata.getOwner().id == Owner.MOM.id) {
            MOMProperties.setProperty(string, string2);
            bl = true;
        }
        if (propertyMetadata.getOwner().id == Owner.DIAGNOSTIC.id) {
            DiagnosticFactory.setProperty(string, string2);
            bl = true;
        }
        if (!bl) {
            throw new RuntimeException("Error: cannot set non-static property: " + string);
        }
        s_overriddenProperties.put(string, string2);
    }

    public void setRecursive(String string, Object object, String string2) {
        throw new RuntimeException("Top context cannot set recursive");
    }

    public PropertyContext getParent() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String string) {
        throw new RuntimeException("Top context cannot have name set");
    }

    public void setParent(PropertyContext propertyContext) {
        throw new RuntimeException("Top context cannot have parent set");
    }
}

