/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import java.io.IOException;
import java.io.InputStream;
import oracle.jbo.JboException;
import oracle.jbo.Transaction;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.RowImpl;
import oracle.jbo.domain.DomainOwnerInterface;

public class LobDomainInputStream
extends InputStream {
    ApplicationModuleImpl am;
    int rsId;
    int rowId;
    String attrId;
    Object[] args;

    public LobDomainInputStream(Transaction transaction, DomainOwnerInterface domainOwnerInterface, String string) {
        this.am = (ApplicationModuleImpl)transaction;
        RowImpl rowImpl = (RowImpl)domainOwnerInterface;
        this.rsId = rowImpl.getRSIId();
        this.rowId = (Integer)rowImpl.getHandle();
        this.attrId = string;
    }

    public int read() throws IOException {
        throw new JboException("UnImplemented");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new JboException(new NullPointerException());
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new JboException(new IndexOutOfBoundsException());
        }
        if (n2 == 0) {
            return 0;
        }
        byte[] byArray2 = (byte[])this.am.readLob(this.rsId, this.rowId, this.attrId, 0, n2);
        if (byArray2 != null) {
            int n3 = byArray2.length <= byArray.length ? byArray2.length : byArray.length;
            System.arraycopy(byArray2, 0, byArray, n, n3);
            return n3;
        }
        return -1;
    }

    public void close() throws IOException {
        this.am.closeLob(this.rsId, this.rowId, this.attrId, true, false);
        super.close();
    }
}

