/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import oracle.bali.ewt.worker.AbstractWorker;
import oracle.bali.ewt.worker.EventThreadWorkerQueue;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.WorkerQueue;
import oracle.bali.ewt.worker.WorkerStatusListener;
import oracle.bali.ewt.worker.WorkerUtils;

public class DeferringWorkerStatus
implements WorkerStatusListener {
    static final int __ACTION_PREPARED = 0;
    static final int __ACTION_PRERUN = 1;
    static final int __ACTION_SUCCEEDED = 2;
    static final int __ACTION_FAILED = 3;
    private WorkerStatusListener _deferredListener = null;
    private WorkerQueue _deferredQueue = null;

    public DeferringWorkerStatus(WorkerStatusListener workerStatusListener) {
        this(workerStatusListener, EventThreadWorkerQueue.getEventThreadWorkerQueue());
    }

    public DeferringWorkerStatus(WorkerStatusListener workerStatusListener, WorkerQueue workerQueue) {
        if (workerStatusListener == null || workerQueue == null) {
            throw new IllegalArgumentException();
        }
        this._deferredListener = workerStatusListener;
        this._deferredQueue = workerQueue;
    }

    public void workerPrepared(InvocationContext invocationContext) {
        if (this._deferredQueue.isInWorkerQueueThread()) {
            this._deferredListener.workerPrepared(invocationContext);
        } else {
            this._defer(invocationContext, 0);
        }
    }

    public void workerPrerun(InvocationContext invocationContext) {
        if (this._deferredQueue.isInWorkerQueueThread()) {
            this._deferredListener.workerPrerun(invocationContext);
        } else {
            this._defer(invocationContext, 1);
        }
    }

    public void workerSucceeded(InvocationContext invocationContext) {
        if (this._deferredQueue.isInWorkerQueueThread()) {
            this._deferredListener.workerSucceeded(invocationContext);
        } else {
            this._defer(invocationContext, 2);
        }
    }

    public void workerFailed(InvocationContext invocationContext) {
        if (this._deferredQueue.isInWorkerQueueThread()) {
            this._deferredListener.workerFailed(invocationContext);
        } else {
            this._defer(invocationContext, 3);
        }
    }

    private void _defer(InvocationContext invocationContext, int n) {
        this._deferredQueue.invokeLater(new DeferredStatusWorker(invocationContext, n), WorkerUtils.createMinimalParameterDictionary(), null);
    }

    private class DeferredStatusWorker
    extends AbstractWorker {
        private InvocationContext _invokeContext;
        private int _action = -1;

        public DeferredStatusWorker(InvocationContext invocationContext, int n) {
            this._invokeContext = invocationContext;
            this._action = n;
            this.setWorkerQueue(DeferringWorkerStatus.this._deferredQueue);
        }

        public Object runWorker(InvocationContext invocationContext) throws Throwable {
            switch (this._action) {
                case 0: {
                    DeferringWorkerStatus.this._deferredListener.workerPrepared(this._invokeContext);
                    break;
                }
                case 1: {
                    DeferringWorkerStatus.this._deferredListener.workerPrerun(this._invokeContext);
                    break;
                }
                case 2: {
                    DeferringWorkerStatus.this._deferredListener.workerSucceeded(this._invokeContext);
                    break;
                }
                case 3: {
                    DeferringWorkerStatus.this._deferredListener.workerFailed(this._invokeContext);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return null;
        }
    }
}

