/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTWizardUI;
import oracle.bali.ewt.layout.NamelessCardLayout;
import oracle.bali.ewt.wizard.AccessibleLWComponent;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardPage;

public class Wizard
extends BaseWizard {
    private AccessibleLWComponent _pageContainer;
    private boolean _mustFinish = true;

    public void setMustFinish(boolean bl) {
        this._mustFinish = bl;
        this.enableButtons();
    }

    public boolean getMustFinish() {
        return this._mustFinish;
    }

    public synchronized WizardPage addPage(WizardPage wizardPage, WizardPage wizardPage2) {
        Component component = wizardPage.getContent();
        component.setVisible(false);
        this._pageContainer.add(component);
        return super.addPage(wizardPage, wizardPage2);
    }

    public synchronized void removePage(WizardPage wizardPage) {
        this._pageContainer.remove(wizardPage.getContent());
        super.removePage(wizardPage);
    }

    public synchronized void removeAllPages() {
        this._pageContainer.removeAll();
        super.removeAllPages();
    }

    public void dispose() {
        super.dispose();
        this._pageContainer = null;
    }

    protected void setSelectedPage(WizardPage wizardPage) {
        super.setSelectedPage(wizardPage);
        if (wizardPage != null) {
            NamelessCardLayout.flipToComponent(wizardPage.getContent());
        }
    }

    protected void pagePropertyChange(WizardPage wizardPage, PropertyChangeEvent propertyChangeEvent) {
        super.pagePropertyChange(wizardPage, propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("content")) {
            this._pageContainer.remove((Component)propertyChangeEvent.getOldValue());
            this._pageContainer.add((Component)propertyChangeEvent.getNewValue());
            this.revalidate();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this._pageContainer == null) {
            this._pageContainer = new AccessibleLWComponent();
            this._pageContainer.setLayout(NamelessCardLayout.getLayoutManager());
            this._pageContainer.setOpaque(Boolean.TRUE.equals(UIManager.get("EWTWizardPanels.opaque")));
            this.add((Component)this._pageContainer, "Center");
        }
        ((EWTWizardUI)this.ui).updateContentUI(this._pageContainer);
    }
}

