/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import java.awt.Component;
import javax.accessibility.AccessibleContext;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.collection.Range;
import oracle.bali.share.util.IntegerUtils;

class NumericSpinBuddy
extends NumberTextField
implements SpinBuddy {
    private Range _range;

    public NumericSpinBuddy() {
        this.setDecimal(false);
    }

    public void updateUI() {
        super.updateUI();
        this.setBorder(null);
        this.setOpaque(true);
        this.setForeground(null);
        this.setBackground(null);
    }

    public void setValue(Object object) {
        if (!object.equals(this.getNumber())) {
            this.__setValue(object);
        }
    }

    public void setRange(Range range) {
        this.setSigned(range.getLowerLimit() < 0);
        int n = this._digits(range.getLowerLimit());
        int n2 = this._digits(range.getUpperLimit());
        this.setColumns(Math.max(n, n2));
        this._range = range;
    }

    protected boolean validateNumber(Number number) {
        Range range = this._range;
        if (range == null) {
            return true;
        }
        int n = number.intValue();
        return (n >= 0 || n >= range.getLowerLimit()) && (n <= 0 || n <= range.getUpperLimit());
    }

    void __setValue(Object object) {
        this.setNumber((Number)object);
        if (this.hasFocus()) {
            this.selectAll();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNumericSpinBuddy();
        }
        return this.accessibleContext;
    }

    Range __getRange() {
        return this._range;
    }

    private int _digits(int n) {
        int n2;
        if (n < 0) {
            n = -n;
            n2 = 1;
        } else {
            n2 = 0;
        }
        do {
            ++n2;
        } while ((n /= 10) > 0);
        return n2;
    }

    protected class AccessibleNumericSpinBuddy
    extends NumberTextField.AccessibleNumberTextField {
        protected AccessibleNumericSpinBuddy() {
            super(NumericSpinBuddy.this);
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            return string == null ? ((Component.AccessibleAWTComponent)this).getAccessibleParent().getAccessibleContext().getAccessibleName() : string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            return string == null ? ((Component.AccessibleAWTComponent)this).getAccessibleParent().getAccessibleContext().getAccessibleDescription() : string;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (NumericSpinBuddy.this.__getRange().inRange(number.intValue())) {
                NumericSpinBuddy.this.setValue(number);
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger((int)NumericSpinBuddy.this.__getRange().getLowerLimit());
        }

        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger((int)NumericSpinBuddy.this.__getRange().getUpperLimit());
        }

        public int getCaretPosition() {
            return this.getSelectionStart();
        }
    }
}

