/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

public class ImagePainter
extends AbstractPainter {
    public static final int DONT_SCALE = 0;
    public static final int PRESERVE_ASPECT_RATIO = 1;
    public static final int SCALE_TO_FIT = 2;
    private Object _dataKey;
    private int _scalingMode;
    private boolean _progressive;

    public ImagePainter() {
        this(PaintContext.IMAGE_KEY, 2);
    }

    public ImagePainter(int n) {
        this(PaintContext.IMAGE_KEY, n);
    }

    public ImagePainter(Object object) {
        this(object, 2);
    }

    public ImagePainter(Object object, int n) {
        this._dataKey = object;
        this._scalingMode = n;
    }

    public void setProgressiveLoading(boolean bl) {
        this._progressive = bl;
    }

    public boolean getProgressiveLoading() {
        return this._progressive;
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        Dimension dimension = this._getNewSize(paintContext, n, n2);
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        Image image = this.getImageData(paintContext);
        if (image != null && (this._progressive && ImageUtils.isImageLoaded(image) || !this._progressive && ImageUtils.loadImage(image))) {
            ImageObserver imageObserver = paintContext.getImageObserver();
            return new Dimension(image.getWidth(imageObserver), image.getHeight(imageObserver));
        }
        return new Dimension(0, 0);
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Image image = this.getImageData(paintContext);
        if (image != null) {
            Dimension dimension = this._getNewSize(paintContext, n3, n4);
            if (dimension != null) {
                n3 = dimension.width;
                n4 = dimension.height;
            }
            graphics.drawImage(image, n, n2, n3, n4, paintContext.getImageObserver());
        }
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return this._scalingMode != 0 ? 128 : 0;
    }

    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }

    protected Image getImageData(PaintContext paintContext) {
        return (Image)this.getData(paintContext);
    }

    protected Object getDataKey() {
        return this._dataKey;
    }

    protected Object getData(PaintContext paintContext) {
        Object object = super.getData(paintContext);
        if (object instanceof Image) {
            return object;
        }
        return null;
    }

    private Dimension _getNewSize(PaintContext paintContext, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (this._scalingMode == 2) {
            return null;
        }
        Image image = this.getImageData(paintContext);
        if (image != null) {
            if (this.getProgressiveLoading() ? !ImageUtils.isImageLoaded(image) : !ImageUtils.loadImage(image)) {
                return null;
            }
            ImageObserver imageObserver = paintContext.getImageObserver();
            n3 = image.getWidth(imageObserver);
            n4 = image.getHeight(imageObserver);
            if (this._scalingMode == 1) {
                float f = (float)n / (float)n3;
                float f2 = (float)n2 / (float)n4;
                if (f < f2) {
                    n3 = n;
                    n4 = (int)((float)n4 * f);
                } else {
                    n3 = (int)((float)n3 * f2);
                    n4 = n2;
                }
            }
        }
        if (n3 == n && n4 == n2) {
            return null;
        }
        return new Dimension(n3, n4);
    }
}

