/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleButtonPainter
extends AbstractBorderPainter {
    private static final int[] _sBGOffsets = new int[]{1, 2, 2, 3, 5, 8};
    private static final int _TOP = 3;
    private static final int _BOTTOM = 4;
    private static final int _LEFT = 3;
    private static final int _RIGHT = 3;
    private static final int _ARMED_SHIFT = 1;
    private static final int _EXTRA_CURVE_WIDTH = 5;
    private static final ImmInsets[] _INSETS_ARRAY = new ImmInsets[]{new ImmInsets(3, 3, 4, 3), new ImmInsets(4, 3, 3, 3), new ImmInsets(3, 3, 4, 8), new ImmInsets(4, 3, 3, 8), new ImmInsets(3, 8, 4, 3), new ImmInsets(4, 8, 3, 3), new ImmInsets(3, 8, 4, 8), new ImmInsets(4, 8, 3, 8)};
    private static final ImmInsets _THIN_INSETS = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets _THIN_ARMED_INSETS = new ImmInsets(3, 2, 1, 2);
    private boolean _hasLeftCurve;
    private boolean _hasRightCurve;
    private boolean _useThinBorder;
    private boolean _isToolBarButton;
    private boolean _hasMouseOverBorder;
    private boolean _isToggleButton;

    public OracleButtonPainter() {
    }

    public OracleButtonPainter(Painter painter) {
        super(painter);
    }

    public OracleButtonPainter(Painter painter, boolean bl, boolean bl2, boolean bl3) {
        this(painter, bl, bl2, bl3, false);
    }

    public OracleButtonPainter(Painter painter, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(painter);
        this._useThinBorder = bl;
        this._isToolBarButton = bl2;
        this._hasMouseOverBorder = bl3;
        this._isToggleButton = bl4;
    }

    public OracleButtonPainter(Painter painter, boolean bl, boolean bl2) {
        this(painter, bl, bl2, Boolean.FALSE);
    }

    public OracleButtonPainter(Painter painter, boolean bl, boolean bl2, Boolean bl3) {
        super(painter);
        this._hasLeftCurve = bl;
        this._hasRightCurve = bl2;
        this._isToggleButton = bl3;
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        boolean bl;
        boolean bl2 = bl = (paintContext.getPaintState() & 2) != 0;
        if (this._useThinBorder) {
            return bl ? _THIN_ARMED_INSETS : _THIN_INSETS;
        }
        int n = 0;
        if (this._hasLeftCurve(paintContext)) {
            n += 4;
        }
        if (this._hasRightCurve(paintContext)) {
            n += 2;
        }
        if (bl) {
            ++n;
        }
        return _INSETS_ARRAY[n];
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        Color color7;
        Color color8;
        boolean bl;
        int n5 = paintContext.getPaintState();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color9 = graphics.getColor();
        int n6 = n2 + n4 - 1;
        int n7 = n + n3 - 1;
        Color color10 = uIDefaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        boolean bl2 = (n5 & 1) != 0;
        boolean bl3 = (n5 & 4) != 0;
        boolean bl4 = (n5 & 2) != 0;
        boolean bl5 = bl = (n5 & 8) != 0;
        if ((n5 & 0x80) != 0 && !this._isToolBarButton && !bl3) {
            graphics.setColor(bl3 ? color10 : Color.black);
            int n8 = bl4 ? n2 + 1 : n6 - 1;
            int n9 = n + 1;
            int n10 = n7 - 1;
            if (this._hasLeftCurve(paintContext)) {
                this._drawDefaultCurve(graphics, (n9 += 6) - 1, n2, n6, 1);
            } else {
                graphics.drawLine(n, n2 + 1, n, n6 - 1);
                graphics.drawLine(n + 1, n8, n + 1, n8);
            }
            if (this._hasRightCurve(paintContext)) {
                this._drawDefaultCurve(graphics, (n10 -= 6) + 1, n2, n6, -1);
            } else {
                graphics.drawLine(n7, n2 + 1, n7, n6 - 1);
                graphics.drawLine(n7 - 1, n8, n7 - 1, n8);
            }
            graphics.drawLine(n9, n2, n10, n2);
            graphics.drawLine(n9, n6, n10, n6);
        }
        ++n;
        ++n2;
        --n6;
        --n7;
        Color color11 = paintContext.getPaintBackground();
        if (bl3) {
            color8 = color10;
            color7 = color10;
            color6 = color10;
            color5 = color10;
            color4 = color10;
            color3 = color10;
            color2 = color10;
            color = color10;
        } else {
            Color color12;
            String string = this._isToggleButton ? "ToggleButton.lightBorder" : "Button.lightBorder";
            color8 = color12 = uIDefaults.getColor(string);
            color = uIDefaults.getColor(ColorScheme.NORMAL_INTENSITY);
            color7 = color12;
            color5 = color12;
            color6 = color12;
            color4 = color;
            color3 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
            String string2 = this._isToggleButton ? "ToggleButton.darkBorder" : "Button.darkBorder";
            Color color13 = uIDefaults.getColor(string2);
            color2 = bl2 ? color : color13;
            if (bl4 || bl) {
                if (!bl2 && bl4 && this._isToolBarButton) {
                    color11 = color;
                }
                color8 = color;
                color5 = uIDefaults.getColor(ColorScheme.CONTROL_SHADOW_VERY_LIGHT);
                color6 = color;
                color4 = color12;
                color3 = color12;
                color7 = color13;
                color2 = color12;
            }
        }
        if ((paintContext.getPaintState() & 0x100) != 0) {
            color11 = null;
        }
        if (!this._isToolBarButton && !this._hasMouseOverBorder || bl4 || bl || this._hasMouseOverBorder && !bl2 && (n5 & 0x10) != 0) {
            if (this._hasLeftCurve(paintContext)) {
                OracleButtonPainter.drawSideCurve(graphics, color7, color6, color6, color4, color2, color11, n += 5, n2, n6, 1);
            } else {
                this._drawLeftSide(graphics, color8, color7, color5, color3, color, color11, n, n2, n6);
            }
            if (this._hasRightCurve(paintContext)) {
                OracleButtonPainter.drawSideCurve(graphics, color6, color4, color2, color2, color2, color11, n7 -= 5, n2, n6, -1);
            } else {
                this._drawRightSide(graphics, color2, color5, color3, color, color11, n7, n2, n6);
            }
            graphics.setColor(color7);
            graphics.drawLine(n + 2, n2, n7 - 2, n2);
            graphics.setColor(color2);
            graphics.drawLine(n + 2, n6, n7 - 2, n6);
        }
        if (color11 != null) {
            graphics.setColor(color11);
            graphics.drawLine(n += 2, (n2 += 2) - 1, n7 -= 2, n2 - 1);
            graphics.drawLine(n, (n6 -= 2) + 1, n7, n6 + 1);
            int n11 = bl4 ? n2 : n6;
            graphics.drawLine(n, n11, n7, n11);
            if (bl4 && this._isToolBarButton) {
                graphics.fillRect(n, n2, n7 - n + 1, n6 - n2 + 1);
            }
        }
        graphics.setColor(color9);
    }

    public Painter getContentPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Painter painter2 = super.getContentPainterAt(paintContext, n, n2, n3, n4, painter);
        if (painter == this && painter2 != null || painter2 == null && n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
            painter2 = this;
        }
        return painter2;
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        int n = super.getRepaintFlags(paintContext) | 1 | 4 | 2 | 0x40 | 0x400 | 0x80;
        if (this._hasMouseOverBorder) {
            n |= 0x10;
        }
        return n;
    }

    private void _drawDefaultCurve(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n - n4;
        int n6 = n5 - n4 * 3;
        int n7 = n6 - n4;
        int n8 = n7 - n4;
        graphics.drawLine(n, n2 + 1, n, n2 + 1);
        graphics.drawLine(n5, n2 + 1, n6, n2 + 4);
        graphics.drawLine(n6, n2 + 5, n7, n2 + 6);
        graphics.drawLine(n7, n2 + 7, n7, n2 + 8);
        graphics.drawLine(n8, n2 + 9, n8, n3 - 9);
        graphics.drawLine(n7, n3 - 7, n7, n3 - 8);
        graphics.drawLine(n6, n3 - 5, n7, n3 - 6);
        graphics.drawLine(n5, n3 - 1, n6, n3 - 4);
        graphics.drawLine(n, n3 - 1, n, n3 - 1);
    }

    public static void drawSideCurve(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, int n, int n2, int n3, int n4) {
        int n5 = n + n4;
        int n6 = n - n4;
        int n7 = n6 - n4;
        int n8 = n7 - n4;
        int n9 = n8 - n4;
        int n10 = n9 - n4;
        graphics.setColor(color);
        graphics.drawLine(n5, n2, n5, n2);
        graphics.drawLine(n6, n2 + 1, n, n2 + 1);
        graphics.drawLine(n7, n2 + 2, n7, n2 + 2);
        graphics.drawLine(n8, n2 + 3, n8, n2 + 3);
        graphics.setColor(color2);
        graphics.drawLine(n8, n2 + 4, n8, n2 + 4);
        graphics.drawLine(n9, n2 + 5, n9, n2 + 7);
        graphics.setColor(color3);
        graphics.drawLine(n10, n2 + 8, n10, n3 - 8);
        graphics.drawLine(n9, n3 - 5, n9, n3 - 7);
        graphics.drawLine(n8, n3 - 4, n8, n3 - 4);
        graphics.setColor(color4);
        graphics.drawLine(n8, n3 - 3, n8, n3 - 3);
        graphics.drawLine(n7, n3 - 2, n7, n3 - 2);
        graphics.drawLine(n6, n3 - 1, n, n3 - 1);
        graphics.setColor(color5);
        graphics.drawLine(n5, n3, n5, n3);
        if (color6 != null) {
            graphics.setColor(color6);
            int[] nArray = _sBGOffsets;
            int n11 = _sBGOffsets.length;
            n4 = -n4;
            n -= n4;
            int n12 = 0;
            while (n12 < n11) {
                int n13 = nArray[n12];
                graphics.drawLine(n, n2 + n13, n, n3 - n13);
                n += n4;
                ++n12;
            }
        }
    }

    private void _drawLeftSide(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, int n, int n2, int n3) {
        graphics.setColor(color);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2, n + 1, n2);
        graphics.drawLine(n, n2 + 1, n, n3 - 2);
        graphics.setColor(color3);
        graphics.drawLine(n, n3 - 1, n, n3 - 1);
        graphics.setColor(color5);
        graphics.drawLine(n + 1, n3 - 1, n + 1, n3 - 1);
        graphics.setColor(color4);
        graphics.drawLine(n + 1, n3, n + 1, n3);
        if (color6 != null) {
            graphics.setColor(color6);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n3 - 2);
        }
    }

    private void _drawRightSide(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, int n, int n2, int n3) {
        graphics.setColor(color);
        graphics.drawLine(n, n2 + 2, n, n3 - 1);
        graphics.drawLine(n - 1, n3, n - 1, n3);
        graphics.setColor(color3);
        graphics.drawLine(n, n2 + 1, n, n2 + 1);
        graphics.drawLine(n - 1, n3 - 1, n - 1, n3 - 1);
        graphics.setColor(color4);
        graphics.drawLine(n - 1, n2 + 1, n - 1, n2 + 1);
        graphics.setColor(color2);
        graphics.drawLine(n - 1, n2, n - 1, n2);
        if (color5 != null) {
            graphics.setColor(color5);
            graphics.drawLine(n - 1, n2 + 2, n - 1, n3 - 2);
        }
    }

    private boolean _hasLeftCurve(PaintContext paintContext) {
        Object object;
        boolean bl = this._hasLeftCurve;
        JComponent jComponent = paintContext.getComponent();
        if (jComponent instanceof JComponent && (object = jComponent.getClientProperty(PushButton.LEFTMOST_BUTTON_KEY)) instanceof Boolean) {
            bl = (Boolean)object;
        }
        return bl;
    }

    private boolean _hasRightCurve(PaintContext paintContext) {
        Object object;
        boolean bl = this._hasRightCurve;
        JComponent jComponent = paintContext.getComponent();
        if (jComponent instanceof JComponent && (object = jComponent.getClientProperty(PushButton.RIGHTMOST_BUTTON_KEY)) instanceof Boolean) {
            bl = (Boolean)object;
        }
        return bl;
    }
}

