/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.ewt.dnd.Autoscroll;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragTracker;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.InvalidDnDOperationException;

public class DropTargetContext {
    private DropTarget _dropTarget;
    private int _actions;
    private Transferable _transferable;
    private transient Rectangle _autoscrollArea;
    private transient Scroller _scroller;
    private static final int _AUTOSCROLL_SCHEDULE_TIME = 100;

    DropTargetContext(DropTarget dropTarget) {
        this._dropTarget = dropTarget;
        this._actions = dropTarget.getDefaultActions();
    }

    public DropTarget getDropTarget() {
        return this._dropTarget;
    }

    public Component getComponent() {
        return this.getDropTarget().getComponent();
    }

    protected void setTargetActions(int n) {
        this._actions = n & 0x40000003;
    }

    protected int getTargetActions() {
        return this._actions;
    }

    public void dropComplete(boolean bl) throws InvalidDnDOperationException {
        DragSource.getCurrentDragSourceContext().setDragSuccess(bl);
    }

    protected void acceptDrag(int n) {
    }

    protected void rejectDrag() {
    }

    protected void acceptDrop(int n) {
        DragSource.getCurrentDragSourceContext().setDragOperation(n);
    }

    protected void rejectDrop() {
        DragSource.getCurrentDragSourceContext().setDragSuccess(false);
    }

    protected DataFlavor[] getCurrentDataFlavors() {
        return this.getTransferable().getTransferDataFlavors();
    }

    protected boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.getTransferable().isDataFlavorSupported(dataFlavor);
    }

    protected synchronized Transferable getTransferable() throws InvalidDnDOperationException {
        if (this._transferable == null) {
            this._transferable = DragSource.getCurrentDragSourceContext().getTransferable();
        }
        return this._transferable;
    }

    void _initializeAutoscrolling(Point point) {
        Component component = this.getComponent();
        if (component == null || !(component instanceof Autoscroll)) {
            return;
        }
        Insets insets = ((Autoscroll)((Object)component)).getAutoscrollInsets();
        Rectangle rectangle = new Rectangle();
        DropTargetContext.computeVisibleRect(component, rectangle);
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        this._autoscrollArea = rectangle;
        this._updateAutoscroll(point);
    }

    void _updateAutoscroll(Point point) {
        Rectangle rectangle = this._autoscrollArea;
        Component component = this.getComponent();
        if (rectangle == null || !(component instanceof Autoscroll)) {
            return;
        }
        point.x += component.getX();
        point.y += component.getY();
        if (point.x < rectangle.x || point.x > rectangle.x + rectangle.width - 1 || point.y < rectangle.y || point.y > rectangle.y + rectangle.height - 1) {
            this._getScroller(true).start(point.x, point.y);
        } else {
            this._terminateAutoscroll();
        }
    }

    void _clearAutoscroll() {
        this._autoscrollArea = null;
        this._terminateAutoscroll();
    }

    private void _terminateAutoscroll() {
        Scroller scroller = this._getScroller(false);
        if (scroller != null) {
            scroller.cancel();
        }
    }

    private synchronized Scroller _getScroller(boolean bl) {
        Scroller scroller = this._scroller;
        if (bl && scroller == null) {
            this._scroller = scroller = new Scroller();
        }
        return scroller;
    }

    private static final void computeVisibleRect(Component component, Rectangle rectangle) {
        Container container = component.getParent();
        Rectangle rectangle2 = component.getBounds();
        if (container == null || container instanceof Window || container instanceof Applet) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
        } else {
            DropTargetContext.computeVisibleRect(container, rectangle);
            rectangle.x -= rectangle2.x;
            rectangle.y -= rectangle2.y;
            SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
        }
    }

    private class Scroller
    implements ActionListener {
        private int _x;
        private int _y;
        private boolean _up;
        private boolean _running;
        private Timer _timer;

        private Scroller() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            DropTarget dropTarget = DropTargetContext.this.getDropTarget();
            Point point = null;
            Scroller scroller = this;
            synchronized (scroller) {
                if (this._running) {
                    if (dropTarget != null) {
                        this._schedule(100);
                    }
                    bl = true;
                    point = new Point(this._x, this._y);
                }
            }
            if (bl && dropTarget != null) {
                DragTracker.eraseFeedback();
                ((Autoscroll)((Object)dropTarget.getComponent())).autoscroll(point);
                DragTracker.drawFeedback();
            }
        }

        public synchronized void cancel() {
            if (this._running) {
                this._running = false;
                if (this._timer != null) {
                    this._timer.stop();
                }
            }
        }

        public synchronized void start(int n, int n2) {
            this._x = n;
            this._y = n2;
            if (!this._running) {
                this._schedule(100);
            }
        }

        private synchronized void _schedule(int n) {
            this._running = true;
            if (this._timer == null) {
                this._timer = new Timer(n, this);
                this._timer.setRepeats(false);
            } else {
                this._timer.setDelay(n);
            }
            this._timer.start();
        }
    }
}

