/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.math.BigInteger;
import java.util.ArrayList;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoPrimaryKeyException;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.OperationData;

public class UpdateOperation
extends AbstractBatchOperation {
    UpdateOperation() {
    }

    public OperationData getOperationData(ITableMetaData metaData, BigInteger ignoreMapping, IDatabaseConnection connection) throws DataSetException {
        String columnName;
        Column column;
        int i;
        Column[] columns = metaData.getColumns();
        Column[] primaryKeys = metaData.getPrimaryKeys();
        if (primaryKeys.length == 0) {
            throw new NoPrimaryKeyException(metaData.getTableName());
        }
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("update ");
        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
        boolean firstSet = true;
        ArrayList<Column> columnList = new ArrayList<Column>(columns.length);
        sqlBuffer.append(" set ");
        for (i = 0; i < columns.length; ++i) {
            column = columns[i];
            if (DataSetUtils.getColumn(column.getColumnName(), primaryKeys) != null) continue;
            if (!firstSet) {
                sqlBuffer.append(", ");
            }
            firstSet = false;
            columnName = this.getQualifiedName(null, column.getColumnName(), connection);
            sqlBuffer.append(columnName);
            sqlBuffer.append(" = ?");
            columnList.add(column);
        }
        sqlBuffer.append(" where ");
        for (i = 0; i < primaryKeys.length; ++i) {
            column = primaryKeys[i];
            if (i > 0) {
                sqlBuffer.append(" and ");
            }
            columnName = this.getQualifiedName(null, column.getColumnName(), connection);
            sqlBuffer.append(columnName);
            sqlBuffer.append(" = ?");
            columnList.add(column);
        }
        return new OperationData(sqlBuffer.toString(), columnList.toArray(new Column[0]));
    }
}

