/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.lang.reflect.Constructor;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.LocaleContext;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.DateConvertor;
import oracle.jbo.uicli.jui.JUFormattedFieldVerifier;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.jbo.uicli.jui.JUTextFieldBinding;
import oracle.jbo.uicli.jui.NumericConvertor;

public class JUFormattedTextFieldBinding
extends JUTextFieldBinding {
    private Convertor mConvertor;
    private JFormattedTextField.AbstractFormatterFactory mFormatterFactory;

    public JUFormattedTextFieldBinding(JFormattedTextField jFormattedTextField, JUIteratorBinding jUIteratorBinding, JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, String string) {
        this(jFormattedTextField, jUIteratorBinding, abstractFormatterFactory, string, null);
    }

    public JUFormattedTextFieldBinding(JFormattedTextField jFormattedTextField, JUIteratorBinding jUIteratorBinding, MaskFormatter maskFormatter, String string) {
        this(jFormattedTextField, jUIteratorBinding, new DefaultFormatterFactory(maskFormatter), string, null);
        maskFormatter.setValueContainsLiteralCharacters(false);
    }

    public JUFormattedTextFieldBinding(JFormattedTextField jFormattedTextField, JUIteratorBinding jUIteratorBinding, DefaultFormatter defaultFormatter, String string) {
        this(jFormattedTextField, jUIteratorBinding, new DefaultFormatterFactory(defaultFormatter), string, null);
    }

    public JUFormattedTextFieldBinding(JFormattedTextField jFormattedTextField, JUIteratorBinding jUIteratorBinding, DateFormatter dateFormatter, String string) {
        this(jFormattedTextField, jUIteratorBinding, new DefaultFormatterFactory(dateFormatter), string, new DateConvertor());
    }

    public JUFormattedTextFieldBinding(JFormattedTextField jFormattedTextField, JUIteratorBinding jUIteratorBinding, JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, String string, Convertor convertor) {
        super(jFormattedTextField, jUIteratorBinding, string);
        this.init(jFormattedTextField, abstractFormatterFactory, convertor);
    }

    private void init(JFormattedTextField jFormattedTextField, JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, Convertor convertor) {
        this.setFormatterFactory(abstractFormatterFactory);
        this.setConvertor(convertor);
        this.setControl(jFormattedTextField);
    }

    protected void setConvertor(Convertor convertor) {
        this.mConvertor = convertor;
    }

    protected Convertor getConvertor() {
        return this.mConvertor;
    }

    protected void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory) {
        this.mFormatterFactory = abstractFormatterFactory;
    }

    protected JFormattedTextField.AbstractFormatterFactory getFormatterFactory() {
        return this.mFormatterFactory;
    }

    protected void registerVerifier(JFormattedTextField jFormattedTextField) {
        jFormattedTextField.setInputVerifier(new JUFormattedFieldVerifier(this.isMandatoryAttribute()));
    }

    private boolean isMandatoryAttribute() {
        String[] stringArray = this.getAttributeNames();
        if (stringArray == null || stringArray.length <= 0) {
            return false;
        }
        String string = stringArray[0];
        AttributeDef attributeDef = this.findAttributeDef(string);
        if (attributeDef == null) {
            return false;
        }
        return attributeDef.isMandatory();
    }

    public Object getValueAt(int n) {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getControl();
        Convertor convertor = this.getConvertor();
        if (convertor != null) {
            return convertor.objectToDomain(this.getLatestValue(jFormattedTextField));
        }
        return this.getLatestValue(jFormattedTextField);
    }

    public void setValueAt(Object object, int n) {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getControl();
        if (jFormattedTextField == null) {
            return;
        }
        if (object == null) {
            jFormattedTextField.setValue(null);
            return;
        }
        Convertor convertor = this.getConvertor();
        if (convertor != null) {
            jFormattedTextField.setValue(convertor.domainToObject(object));
        } else {
            jFormattedTextField.setValue(object);
        }
    }

    private Object getLatestValue(JFormattedTextField jFormattedTextField) {
        try {
            jFormattedTextField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return jFormattedTextField.getValue();
    }

    public static Document createAttributeBinding(JUFormBinding jUFormBinding, JFormattedTextField jFormattedTextField, MaskFormatter maskFormatter, String string, String string2, String string3, String string4) {
        maskFormatter.setValueContainsLiteralCharacters(false);
        return JUFormattedTextFieldBinding.createAttributeBinding(jUFormBinding, jFormattedTextField, maskFormatter, null, string, string2, string3, string4);
    }

    public static Document createAttributeBinding(JUFormBinding jUFormBinding, JFormattedTextField jFormattedTextField, NumberFormatter numberFormatter, String string, String string2, String string3, String string4) {
        return JUFormattedTextFieldBinding.createAttributeBinding(jUFormBinding, jFormattedTextField, numberFormatter, (Convertor)new NumericConvertor(), string, string2, string3, string4);
    }

    public static Document createAttributeBinding(JUFormBinding jUFormBinding, JFormattedTextField jFormattedTextField, DateFormatter dateFormatter, String string, String string2, String string3, String string4) {
        return JUFormattedTextFieldBinding.createAttributeBinding(jUFormBinding, jFormattedTextField, dateFormatter, (Convertor)new DateConvertor(), string, string2, string3, string4);
    }

    public static Document createAttributeBinding(JUFormBinding jUFormBinding, JFormattedTextField jFormattedTextField, JFormattedTextField.AbstractFormatter abstractFormatter, Convertor convertor, String string, String string2, String string3, String string4) {
        return JUFormattedTextFieldBinding.createAttributeBinding(jUFormBinding, jFormattedTextField, new DefaultFormatterFactory(abstractFormatter), convertor, string, string2, string3, string4);
    }

    public static Document createAttributeBinding(JUFormBinding jUFormBinding, JFormattedTextField jFormattedTextField, JFormattedTextField.AbstractFormatter abstractFormatter, JFormattedTextField.AbstractFormatter abstractFormatter2, JFormattedTextField.AbstractFormatter abstractFormatter3, JFormattedTextField.AbstractFormatter abstractFormatter4, String string, String string2, String string3, String string4) {
        DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(abstractFormatter, abstractFormatter2, abstractFormatter3, abstractFormatter4);
        return JUFormattedTextFieldBinding.createAttributeBinding(jUFormBinding, jFormattedTextField, defaultFormatterFactory, string, string2, string3, string4);
    }

    public static Document createAttributeBinding(JUFormBinding jUFormBinding, JFormattedTextField jFormattedTextField, JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, String string, String string2, String string3, String string4) {
        return JUFormattedTextFieldBinding.createAttributeBinding(jUFormBinding, jFormattedTextField, abstractFormatterFactory, null, string, string2, string3, string4);
    }

    public static Document createAttributeBinding(JUFormBinding jUFormBinding, JFormattedTextField jFormattedTextField, JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, Convertor convertor, String string, String string2, String string3, String string4) {
        if (!JUIUtil.inDesignTime()) {
            JUFormattedTextFieldBinding jUFormattedTextFieldBinding = new JUFormattedTextFieldBinding(jFormattedTextField, jUFormBinding.getRowIterBinding(string, string2, string3), abstractFormatterFactory, string4);
            jUFormattedTextFieldBinding.setConvertor(convertor);
            jUFormattedTextFieldBinding.refreshControl();
            return jUFormattedTextFieldBinding.getModelImpl(null);
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJTextFieldBinding");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n];
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length == 1) {
                    Object[] objectArray = new Object[]{String.valueOf(string) + "." + string4};
                    Object obj = constructor.newInstance(objectArray);
                    Document document = (Document)obj;
                    return document;
                }
                ++n;
            }
            Document document = null;
            return document;
        }
        catch (Exception exception) {
            Document document = null;
            return document;
        }
    }

    public void setControl(Object object) {
        Object object2;
        super.setControl(object);
        if (object != null) {
            object2 = (JFormattedTextField)object;
            ((JFormattedTextField)object2).setFormatterFactory(this.mFormatterFactory);
            this.registerVerifier((JFormattedTextField)object2);
        }
        if ((object2 = this.getConvertor()) != null && object != null) {
            object2.updateFormatHint(this.getFormatString(super.getAttributeNames()[0]));
        }
    }

    String getFormatString(String string) {
        AttributeDef attributeDef = this.findAttributeDef(string);
        String string2 = null;
        if (attributeDef != null) {
            LocaleContext localeContext;
            AttributeHints attributeHints = attributeDef.getUIHelper();
            ApplicationModule applicationModule = this.getApplicationModule();
            if (applicationModule != null && attributeHints.hasFormatInformation(localeContext = applicationModule.getSession().getLocaleContext())) {
                string2 = attributeHints.getFormat(localeContext);
            }
        }
        return string2;
    }

    interface Convertor {
        public void updateFormatHint(String var1);

        public Object domainToObject(Object var1);

        public Object objectToDomain(Object var1);
    }
}

