/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.statemanager;

import java.io.Serializable;
import java.security.SecureRandom;

public class UUID
implements Serializable {
    static final long serialVersionUID = 9008807960891297392L;
    private static volatile SecureRandom mGenerator = null;
    private final long mMSB;
    private final long mLSB;
    private transient String mStringValue;

    private UUID() {
        if (mGenerator == null) {
            mGenerator = new SecureRandom();
        }
        byte[] byArray = new byte[16];
        mGenerator.nextBytes(byArray);
        byArray[8] = (byte)(byArray[8] & 0xBF);
        byArray[8] = (byte)(byArray[8] | 0x80);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        long l = 0L;
        int n = 0;
        while (n < 8) {
            l = l << 8 | (long)(byArray[n] & 0xFF);
            ++n;
        }
        long l2 = 0L;
        int n2 = 8;
        while (n2 < 16) {
            l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
            ++n2;
        }
        this.mMSB = l;
        this.mLSB = l2;
    }

    private UUID(long l, long l2) {
        this.mMSB = l;
        this.mLSB = l2;
    }

    public String toString() {
        if (this.mStringValue == null) {
            StringBuffer stringBuffer = new StringBuffer(132);
            stringBuffer.append(UUID.digits(this.mMSB >> 32, 8));
            stringBuffer.append('-');
            stringBuffer.append(UUID.digits(this.mMSB >> 16, 4));
            stringBuffer.append('-');
            stringBuffer.append(UUID.digits(this.mMSB, 4));
            stringBuffer.append('-');
            stringBuffer.append(UUID.digits(this.mLSB >> 48, 4));
            stringBuffer.append('-');
            stringBuffer.append(UUID.digits(this.mLSB, 12));
            this.mStringValue = stringBuffer.toString();
        }
        return this.mStringValue;
    }

    private static String digits(long l, int n) {
        long l2 = 1L << n * 4;
        return Long.toHexString(l2 | l & l2 - 1L).substring(1);
    }

    public boolean equals(Object object) {
        return object instanceof UUID && ((UUID)object).mMSB == this.mMSB && ((UUID)object).mLSB == this.mLSB;
    }

    public int hashCode() {
        return (int)this.mLSB >> 32;
    }

    public static Object generateUUID() {
        return new UUID();
    }

    public static Object generateUUID(String string) {
        long l = 0L;
        l = Long.parseLong(string.substring(0, 8), 16) << 32;
        l |= Long.parseLong(string.substring(9, 13), 16) << 16;
        long l2 = 0L;
        l2 = Long.parseLong(string.substring(19, 23), 16) << 48;
        return new UUID(l |= Long.parseLong(string.substring(14, 18), 16), l2 |= Long.parseLong(string.substring(24, 36), 16));
    }
}

