/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.adf.model.BindingContext;
import oracle.adf.model.DataControl;
import oracle.adf.model.DataControlFactory;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.AdapterContext;
import oracle.adf.model.adapter.AdapterDCService;
import oracle.adf.model.adapter.AdapterDataControlDef;
import oracle.adf.share.logging.ADFLogger;
import oracle.jbo.JboException;
import oracle.jbo.common.JBOClass;
import org.w3c.dom.Node;

public class DataControlFactoryImpl
implements DataControlFactory {
    public static final String ID = "id";
    public static final String DEFINITION = "Definition";
    private static final String DEF_PARAM = "dc_def_params";
    private ADFLogger mDbgLog;

    private /* synthetic */ void $init$() {
        this.mDbgLog = AdapterContext.getDefaultContext().getLogger();
    }

    public DataControlFactoryImpl() {
        this.$init$();
    }

    public DataControl createSession(BindingContext bindingContext, Node node, Map map) {
        this.mDbgLog.entering(this.getClass().getName(), "createSession");
        this.mDbgLog.fine("Creating new data control definition from the node.");
        AdapterDataControlDef adapterDataControlDef = new AdapterDataControlDef();
        adapterDataControlDef.retrieveFromNode(node);
        String string = adapterDataControlDef.getName();
        if (string == null) {
            string = (String)adapterDataControlDef.get(ID);
        }
        DataControl dataControl = this.createSession(bindingContext, string, map, adapterDataControlDef);
        this.mDbgLog.exiting(this.getClass().getName(), "createSession");
        return dataControl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataControl createSession(BindingContext bindingContext, String string, Map map, Map map2) {
        DataControl dataControl;
        try {
            try {
                DataControl dataControl2;
                this.mDbgLog.entering(this.getClass().getName(), "createSession");
                String string2 = (String)map2.get(DEFINITION);
                String string3 = (String)map2.get("ImplDef");
                Node node = (Node)map2.get("Source");
                this.mDbgLog.fine("Loading definition.");
                Object t = JBOClass.forName(string3).newInstance();
                if (!(t instanceof AbstractDefinition)) {
                    this.mDbgLog.severe("ImplDef defined for the data control is not according to the specification. It must be a subclass of oracle.adf.model.adapter.AbstractDefinition.");
                    throw new Exception("ImplDef is not a subclass of oracle.adf.model.adapter.AbstractAdapter.");
                }
                if (map2 instanceof AdapterDataControlDef) {
                    HashMap hashMap = ((AdapterDataControlDef)map2).getParameters();
                    map.putAll(hashMap);
                } else {
                    map.putAll(map2);
                }
                AdapterContext adapterContext = new AdapterContext(bindingContext);
                AbstractDefinition abstractDefinition = (AbstractDefinition)t;
                abstractDefinition.setName(string);
                abstractDefinition.setAdapterContext(adapterContext);
                abstractDefinition.loadFromMetadata(node, map);
                this.mDbgLog.fine("Creating data control.");
                oracle.binding.DataControl dataControl3 = abstractDefinition.createDataControl();
                this.mDbgLog.fine("Creating adapter data control.");
                dataControl = dataControl2 = this.createDataControl(string, string2, dataControl3, abstractDefinition);
                Object var17_15 = null;
            }
            catch (Exception exception) {
                this.mDbgLog.log(Level.SEVERE, "Exception: ", (Throwable)exception);
                throw new JboException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            this.mDbgLog.exiting(this.getClass().getName(), "createSession");
            throw throwable;
        }
        this.mDbgLog.exiting(this.getClass().getName(), "createSession");
        return dataControl;
    }

    protected DataControl createDataControl(String string, String string2, Object object, AbstractDefinition abstractDefinition) {
        return new AdapterDCService(string, string2, object, abstractDefinition);
    }
}

