/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.IndividualRefresh;
import oracle.dms.instrument.MetricDescriptor;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Refresh;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.IllegalOperation;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.spy.TreeNode;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;

public class Metric
extends TreeNode {
    public static final int UNIT_LEN = 99;
    private static final String ILLEGAL_OPER = "ILLEGAL_OPER5";
    private MetricDescriptor _descptor = null;
    private String _units;
    private Sensor _sensor;
    private byte _index;

    public Metric(String string, String string2, String string3, Sensor sensor, boolean bl, byte by, byte by2) {
        super(sensor.getParent(), string, string2, bl);
        if (string3 == null) {
            throw new IllegalOperation(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), string, string2, string3, sensor}));
        }
        this._units = bl ? DMSUtil.sanitize(string3, 99, true, false) : string3;
        this._sensor = sensor;
        this._index = by2;
        SensorDescriptor sensorDescriptor = sensor.getDescriptor();
        if (sensorDescriptor != null) {
            this._descptor = sensorDescriptor.getMetricDescriptor(this._name);
            if (this._descptor == null) {
                this._descptor = new MetricDescriptor(this._name, this._units, by);
                sensorDescriptor.addMetricDescriptor(this._descptor);
                NounDescriptor nounDescriptor = this._parent.getDescriptor();
                if (nounDescriptor != null) {
                    nounDescriptor.setLastUpdateTime(System.currentTimeMillis());
                }
            }
        }
    }

    public Object getValue() {
        return this.getValue(true);
    }

    Object getValue(boolean bl) {
        Object object = null;
        if (bl) {
            this.refresh(null);
        }
        try {
            StatisticsProducer.sampleVal.occurred();
            object = this._sensor.getValue(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = new ErrorObject("N/A");
        }
        return object;
    }

    public MetricDescriptor getDescriptor() {
        return this._descptor;
    }

    void refresh(Vector vector) {
        Refresh refresh = this._sensor.getRefresh();
        if (refresh != null) {
            if (refresh instanceof IndividualRefresh) {
                ((IndividualRefresh)refresh).refresh(this._sensor);
            } else if (refresh instanceof GroupRefresh) {
                if (vector == null) {
                    ((GroupRefresh)refresh).refresh();
                } else if (!vector.contains(refresh)) {
                    vector.addElement(refresh);
                    ((GroupRefresh)refresh).refresh();
                }
            }
        }
    }

    public static Object[] getValues(Metric[] metricArray) {
        Vector vector = new Vector();
        Object[] objectArray = new Object[metricArray.length];
        for (int i = metricArray.length - 1; i >= 0; --i) {
            Object object;
            Metric metric = metricArray[i];
            metric.refresh(vector);
            StatisticsProducer.sampleVal.occurred();
            objectArray[i] = object = metric._sensor.getValue(metric);
        }
        return objectArray;
    }

    public String getUnits() {
        return this._units;
    }

    public Sensor getSensor() {
        return this._sensor;
    }

    public byte getIndex() {
        return this._index;
    }
}

