/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class AnyValue
extends Value {
    private Object _value = null;
    private double _min = Double.MAX_VALUE;
    private double _max = Double.MIN_VALUE;

    public void update(int n) {
        Integer n2 = new Integer(n);
        double d = n;
        this.setNumber(n2, d);
        this._initialized = true;
    }

    public void update(double d) {
        Double d2 = new Double(d);
        double d3 = d;
        this.setNumber(d2, d3);
        this._initialized = true;
    }

    public void update(long l) {
        Long l2 = new Long(l);
        double d = l;
        this.setNumber(l2, d);
        this._initialized = true;
    }

    public void update(Object object) {
        this._value = object;
        this._initialized = true;
    }

    public void increment(int n) {
        if (!this.isInitialized()) {
            return;
        }
        int n2 = ((Number)this._value).intValue() + n;
        double d = n2;
        Integer n3 = new Integer(n2);
        this.setNumber(n3, d);
    }

    public void increment(double d) {
        if (!this.isInitialized()) {
            return;
        }
        double d2 = ((Number)this._value).doubleValue() + d;
        Double d3 = new Double(d2);
        this.setNumber(d3, d2);
    }

    public void increment(long l) {
        if (!this.isInitialized()) {
            return;
        }
        long l2 = ((Number)this._value).longValue() + l;
        Long l3 = new Long(l2);
        double d = l2;
        this.setNumber(l3, d);
    }

    private void setNumber(Number number, double d) {
        this._value = number;
        if (this.MIN && d < this._min) {
            this._min = d;
        }
        if (this.MAX && d > this._max) {
            this._max = d;
        }
    }

    void initMinMax() {
        if (this._initialized && this._value instanceof Number) {
            double d = ((Number)this._value).doubleValue();
            if (this.MIN && this._min > d) {
                this._min = d;
            }
            if (this.MAX && this._max < d) {
                this._max = d;
            }
        }
    }

    public void reset() {
        super.reset();
        if (this._value != null && this._value instanceof Number) {
            if (this.MIN) {
                this._min = ((Number)this._value).doubleValue();
            }
            if (this.MAX) {
                this._max = ((Number)this._value).doubleValue();
            }
        }
    }

    public Object getValue() {
        return this._value;
    }

    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Double.MAX_VALUE) {
            return new Double(this._min);
        }
        return new Double(0.0);
    }

    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Double.MIN_VALUE) {
            return new Double(this._max);
        }
        return new Double(0.0);
    }
}

