/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;

public class TextFormatter
implements LogFormatter {
    public static int SHORT = 1;
    public static int FULL = 2;
    private static final String LSEP = System.getProperty("line.separator");
    private int m_style;
    private Date m_date = new Date(0L);
    private Calendar m_calendar = new GregorianCalendar();
    private String[] m_shortMonths = new DateFormatSymbols().getShortMonths();

    public TextFormatter() {
        this(SHORT);
    }

    public TextFormatter(int n) {
        this.m_style = n;
    }

    public String format(LogMessage logMessage) {
        if (this.m_style == SHORT) {
            return this.format_short(logMessage);
        }
        return this.format_full(logMessage);
    }

    private String format_short(LogMessage logMessage) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        this.writeTimestamp(logMessage.getTimestamp(), stringBuffer);
        stringBuffer.append("] [");
        stringBuffer.append(logMessage.getComponentId());
        stringBuffer.append("] [");
        MessageType messageType = logMessage.getMessageType();
        stringBuffer.append(messageType.toString());
        if (logMessage.getMessageLevel() > 1 && messageType != MessageType.UNKNOWN) {
            stringBuffer.append(":");
            stringBuffer.append(logMessage.getMessageLevel());
        }
        stringBuffer.append("] ");
        if (logMessage.getModuleId() != null) {
            stringBuffer.append("[");
            stringBuffer.append(logMessage.getModuleId());
            stringBuffer.append("] ");
        }
        if (logMessage.getExecContextId() != null) {
            stringBuffer.append("[ecid: ");
            stringBuffer.append(logMessage.getExecContextId().getUniqueId());
            stringBuffer.append(",");
            stringBuffer.append(logMessage.getExecContextId().getSequenceNumber());
            stringBuffer.append("] ");
        }
        stringBuffer.append(logMessage.getMessageText());
        if (logMessage.getSupplDetail() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(logMessage.getSupplDetail());
        }
        stringBuffer.append(LSEP);
        return stringBuffer.toString();
    }

    private String format_full(LogMessage logMessage) {
        LogMessage.MessageArgument[] messageArgumentArray;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("[");
        this.writeTimestamp(logMessage.getTimestamp(), stringBuffer);
        stringBuffer.append("] ");
        stringBuffer.append("[");
        stringBuffer.append(logMessage.getComponentId());
        stringBuffer.append("] [");
        MessageType messageType = logMessage.getMessageType();
        stringBuffer.append(messageType.toString());
        if (logMessage.getMessageLevel() > 1 && messageType != MessageType.UNKNOWN) {
            stringBuffer.append(":");
            stringBuffer.append(logMessage.getMessageLevel());
        }
        if (logMessage.getMessageId() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(logMessage.getMessageId());
        }
        stringBuffer.append("] ");
        if (logMessage.getModuleId() != null) {
            stringBuffer.append("[");
            stringBuffer.append(logMessage.getModuleId());
            stringBuffer.append("] ");
        }
        if (logMessage.getOrganizationId() != null) {
            stringBuffer.append("[org: ");
            stringBuffer.append(logMessage.getOrganizationId());
            stringBuffer.append("] ");
        }
        if (logMessage.getInstanceId() != null) {
            stringBuffer.append("[instanceId: ");
            stringBuffer.append(logMessage.getInstanceId());
            stringBuffer.append("] ");
        }
        if (logMessage.getHostingClientId() != null) {
            stringBuffer.append("[hostingClientId: ");
            stringBuffer.append(logMessage.getHostingClientId());
            stringBuffer.append("] ");
        }
        if (logMessage.getMessageGroup() != null) {
            stringBuffer.append("[group: ");
            stringBuffer.append(logMessage.getMessageGroup());
            stringBuffer.append("] ");
        }
        if (logMessage.getHostId() != null) {
            stringBuffer.append("[host: ");
            stringBuffer.append(logMessage.getHostId());
            stringBuffer.append("] ");
        }
        if (logMessage.getHostNwAddr() != null) {
            stringBuffer.append("[nwaddr: ");
            stringBuffer.append(logMessage.getHostNwAddr());
            stringBuffer.append("] ");
        }
        if (logMessage.getProcessId() != null) {
            stringBuffer.append("[pid: ");
            stringBuffer.append(logMessage.getProcessId());
            stringBuffer.append("] ");
        }
        if (logMessage.getThreadId() != null) {
            stringBuffer.append("[tid: ");
            stringBuffer.append(logMessage.getThreadId());
            stringBuffer.append("] ");
        }
        if (logMessage.getUserId() != null) {
            stringBuffer.append("[userId: ");
            stringBuffer.append(logMessage.getUserId());
            stringBuffer.append("] ");
        }
        if (logMessage.getSupplAttrs() != null && (messageArgumentArray = logMessage.getSupplAttrs()) != null && !messageArgumentArray.isEmpty()) {
            Iterator iterator = messageArgumentArray.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append("[");
                stringBuffer.append(string);
                stringBuffer.append(": ");
                Object v = messageArgumentArray.get(string);
                if (v != null) {
                    stringBuffer.append(v.toString());
                }
                stringBuffer.append("] ");
            }
        }
        if (logMessage.getUpstreamCompId() != null) {
            stringBuffer.append("[upstreamComp: ");
            stringBuffer.append(logMessage.getUpstreamCompId());
            stringBuffer.append("] ");
        }
        if (logMessage.getDownstreamCompId() != null) {
            stringBuffer.append("[downstreamComp: ");
            stringBuffer.append(logMessage.getDownstreamCompId());
            stringBuffer.append("] ");
        }
        if (logMessage.getExecContextId() != null) {
            stringBuffer.append("[ecid: ");
            stringBuffer.append(logMessage.getExecContextId().getUniqueId());
            stringBuffer.append(",");
            stringBuffer.append(logMessage.getExecContextId().getSequenceNumber());
            stringBuffer.append("] ");
        }
        if (logMessage.getErrorInstanceId() != null) {
            stringBuffer.append("[errid: ");
            stringBuffer.append(logMessage.getErrorInstanceId().getUniqueId());
            stringBuffer.append(",");
            stringBuffer.append(logMessage.getErrorInstanceId().getSequenceNumber());
            stringBuffer.append("] ");
        }
        if (logMessage.getDetailLocation() != null) {
            stringBuffer.append("[detailLoc: ");
            stringBuffer.append(logMessage.getDetailLocation());
            stringBuffer.append("] ");
        }
        if (logMessage.getMessageArgs() != null) {
            messageArgumentArray = logMessage.getMessageArgs();
            for (int i = 0; i < messageArgumentArray.length; ++i) {
                if (messageArgumentArray[i].getName() != null) {
                    stringBuffer.append(messageArgumentArray[i].getName());
                    stringBuffer.append("=");
                }
                stringBuffer.append(messageArgumentArray[i].getValue());
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(logMessage.getMessageText());
        if (logMessage.getSupplDetail() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(logMessage.getSupplDetail());
        }
        stringBuffer.append(LSEP);
        return stringBuffer.toString();
    }

    public String header() {
        return null;
    }

    public String tail() {
        return null;
    }

    private void writeTimestamp(long l, StringBuffer stringBuffer) {
        this.m_date.setTime(l);
        this.m_calendar.setTime(this.m_date);
        int n = this.m_calendar.get(5);
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append("/");
        stringBuffer.append(this.m_shortMonths[this.m_calendar.get(2)]);
        stringBuffer.append("/");
        stringBuffer.append(this.m_calendar.get(1));
        n = this.m_calendar.get(11);
        stringBuffer.append(n < 10 ? ":0" : ":");
        stringBuffer.append(n);
        n = this.m_calendar.get(12);
        stringBuffer.append(n < 10 ? ":0" : ":");
        stringBuffer.append(n);
        n = this.m_calendar.get(13);
        stringBuffer.append(n < 10 ? ":0" : ":");
        stringBuffer.append(n);
        n = this.m_calendar.get(14);
        stringBuffer.append(n < 10 ? ".00" : (n < 100 ? ".0" : "."));
        stringBuffer.append(n);
        int n2 = (this.m_calendar.get(15) + this.m_calendar.get(16)) / 1000;
        if (n2 < 0) {
            stringBuffer.append(" -");
            n2 = -n2;
        } else {
            stringBuffer.append(" +");
        }
        n = n2 / 3600;
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        n = (n2 - n * 3600) / 60;
        stringBuffer.append(n < 10 ? "0" : "");
        stringBuffer.append(n);
    }
}

