/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.io.PrintStream;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ADFConsoleHandler
extends StreamHandler {
    private PrintStream output;

    public ADFConsoleHandler(PrintStream printStream, Formatter formatter) {
        super(printStream, formatter);
        this.output = printStream;
    }

    public synchronized void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            string = this.getFormatter().format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        this.output.print(string);
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (this.output == null) {
            return false;
        }
        return super.isLoggable(logRecord);
    }

    public synchronized void flush() {
    }

    private synchronized void flushAndClose() throws SecurityException {
        this.output = null;
    }

    public synchronized void close() throws SecurityException {
        this.flushAndClose();
    }
}

