/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBType;

public class DBItem
implements Cloneable {
    public byte[] byte_value;
    public InputStream stream_value;
    public int data_size;
    public int original_size;
    public int max_out_size;
    public boolean is_null;
    public char[] char_value;
    public int char_size;

    public DBItem() {
    }

    public DBItem(int n) {
        this.reinitialize(n);
    }

    public byte[] StringToBytes(String string, int n) throws SQLException {
        return null;
    }

    public void allocBuffer() {
        if (this.byte_value != null && this.byte_value.length == this.max_out_size) {
            return;
        }
        this.allocBuffer(this.max_out_size);
    }

    void allocBuffer(int n) {
        if (this.byte_value == null || this.byte_value.length < n) {
            this.byte_value = new byte[n];
        }
    }

    public void clear() {
        this.is_null = false;
        this.byte_value = null;
        this.char_value = null;
        this.stream_value = null;
        this.data_size = 0;
        this.char_size = 0;
        this.original_size = 0;
    }

    public DBItem clone(DBType dBType, DBAccess dBAccess) {
        DBItem dBItem = dBAccess.createDBItem(dBType);
        dBItem.is_null = this.is_null;
        dBItem.byte_value = (byte[])(this.byte_value != null ? new byte[this.byte_value.length] : null);
        dBItem.char_value = null;
        dBItem.stream_value = null;
        dBItem.data_size = this.data_size;
        dBItem.char_size = this.char_size;
        dBItem.original_size = this.original_size;
        dBItem.max_out_size = this.max_out_size;
        return dBItem;
    }

    public void defineStreamData(InputStream inputStream) {
        this.data_size = 0;
        this.stream_value = inputStream;
    }

    public byte[] getBytes() {
        return this.byte_value;
    }

    public int getBytesLength() {
        if (this.byte_value == null) {
            return 0;
        }
        return this.byte_value.length;
    }

    public char[] getChars(short s) throws SQLException {
        return null;
    }

    public void reinitialize(int n) {
        this.is_null = false;
        this.byte_value = null;
        this.char_value = null;
        this.stream_value = null;
        this.data_size = 0;
        this.char_size = 0;
        this.original_size = 0;
        this.max_out_size = n;
    }

    public void setArrayData(boolean bl, String string, int n) throws SQLException {
        this.is_null = bl;
        if (string != null) {
            this.byte_value = this.StringToBytes(string, n);
            this.data_size = this.byte_value.length;
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    public void setArrayData(boolean bl, byte[] byArray) throws SQLException {
        this.is_null = bl;
        if (byArray != null) {
            this.data_size = byArray.length;
            this.byte_value = byArray;
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    public void setNull() {
        this.is_null = true;
        this.data_size = 0;
        this.char_size = 0;
        this.allocBuffer(0);
    }

    public void setStreamData(boolean bl, int n, InputStream inputStream) {
        this.is_null = bl;
        this.stream_value = inputStream;
        this.data_size = n;
        this.max_out_size = n;
    }
}

