/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageFilter;
import java.net.URL;
import java.util.Hashtable;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.graphics.TransparencyFilter;
import oracle.help.common.log.Logger;

public class ImageLoader {
    private static ImageLoader _defaultImageLoader = null;
    private static Hashtable _imageCache = new Hashtable();
    private static Image _frameIconImage = null;

    public static final ImageLoader getDefaultImageLoader() {
        if (_defaultImageLoader == null) {
            _defaultImageLoader = new ImageLoader();
        }
        return _defaultImageLoader;
    }

    public static final void setDefaultImageLoader(ImageLoader imageLoader) {
        _defaultImageLoader = imageLoader;
    }

    public static final Image loadImage(Class clazz, String string) {
        URL uRL = null;
        try {
            uRL = clazz.getResource(string);
        }
        catch (Exception exception) {
            uRL = null;
        }
        return ImageLoader.loadImage(uRL);
    }

    public static final Image loadImage(URL uRL) {
        String string;
        Image image = null;
        if (uRL != null && (image = (Image)_imageCache.get(string = uRL.toExternalForm())) == null) {
            try {
                image = ImageLoader.getDefaultImageLoader().loadImageImpl(uRL);
            }
            catch (Exception exception) {
                Logger.getDefaultLogger().log("Error encountered when loading an icon: ");
                Logger.getDefaultLogger().errorUnexpectedException(exception);
                image = null;
            }
            if (image != null) {
                _imageCache.put(string, image);
            }
        }
        return image;
    }

    public static final Image getIconImage() {
        return _frameIconImage;
    }

    public static final void setIconImage(Image image) {
        _frameIconImage = image;
    }

    protected Image loadImageImpl(URL uRL) {
        Image image = null;
        if (uRL != null) {
            try {
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                if (image != null) {
                    ImageUtils.loadImage((Image)image);
                }
            }
            catch (Exception exception) {
                Logger.getDefaultLogger().log("Error encountered when loading an icon: ");
                Logger.getDefaultLogger().errorUnexpectedException(exception);
                image = null;
            }
            if (image != null) {
                TransparencyFilter transparencyFilter = new TransparencyFilter(new Color(255, 153, 0));
                image = ImageUtils.createFilteredImage((Image)image, (ImageFilter)transparencyFilter);
            }
        }
        return image;
    }
}

