/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.PipeError;
import oracle.xml.pipeline.controller.PipelineConstants;
import oracle.xml.pipeline.controller.PipelineDoc;
import oracle.xml.pipeline.controller.PipelineErrorHandler;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.pipeline.controller.SyncQueue;
import oracle.xml.pipeline.controller.Util;
import oracle.xml.util.FastVector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PipelineProcessor
implements PipelineConstants {
    private PipelineDoc pipeDoc;
    private String xmlBase = new String("");
    private Process targetProcess;
    private String targetName;
    private PipeError pipeError;
    private int executionMode = 2;
    SyncQueue availQ;
    Thread threads;
    int threadCount = 2;
    Hashtable attrs;
    Hashtable procDefs;
    boolean force = false;
    FastVector availInputs = new FastVector();
    Hashtable processList = new Hashtable();

    public void setPipelineDoc(PipelineDoc pipelineDoc) {
        this.pipeDoc = pipelineDoc;
    }

    public void setThreads(int n) {
        this.threadCount = n;
    }

    int getThreadCount() {
        return this.threadCount;
    }

    public void setErrorHandler(PipelineErrorHandler pipelineErrorHandler) {
        this.pipeError = new PipeError();
        this.pipeError.setErrorHandler(pipelineErrorHandler);
    }

    public void setExecutionMode(int n) {
        if (n != 2) {
            this.threadCount = 1;
        }
        this.executionMode = n;
    }

    public int getExecutionMode() {
        return this.executionMode;
    }

    public void setAttribute(String string, Object object) {
        if (this.attrs == null) {
            this.attrs = new Hashtable();
        }
        this.attrs.put(string, object);
    }

    Object getAttribute(String string) {
        if (this.attrs == null) {
            return null;
        }
        return this.attrs.get(string);
    }

    public void addProcessDef(String string, String string2) {
        if (this.procDefs == null) {
            this.procDefs = new Hashtable();
        }
        this.procDefs.put(string, string2);
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean isForceSpecified() {
        return this.force;
    }

    private XMLElement locateTargetProcess() throws PipelineException {
        String string;
        Object object;
        Element element;
        NodeList nodeList = this.pipeDoc.getDocument().getElementsByTagName("param");
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength() && !bl; ++i) {
            element = (Element)nodeList.item(i);
            if (!element.hasAttributes() || !((String)(object = element.getAttribute("name"))).equals("target")) continue;
            this.targetName = element.getAttribute("select");
            if (this.targetName == "") {
                Node node = element.getFirstChild();
                if (node == null) {
                    this.pipeError.error(30008, 17);
                } else if (node.getNodeType() != 3) {
                    this.pipeError.error(30008, 17);
                }
                this.targetName = node.getNodeValue();
            }
            bl = true;
            this.targetName = (String)this.resolveAttribute(this.targetName);
        }
        if (!bl) {
            this.pipeError.error(30008, 17);
        }
        XMLElement xMLElement = null;
        element = null;
        object = this.pipeDoc.getDocument().getElementsByTagName("output");
        for (int i = 0; i < object.getLength() && ((string = (String)this.resolveAttribute((xMLElement = (XMLElement)object.item(i)).getAttribute("label"))).compareTo(this.targetName) != 0 || (element = (XMLElement)xMLElement.getParentNode()) == null); ++i) {
        }
        if (element == null) {
            this.pipeError.error(30013, 17, new String[]{this.targetName});
        }
        return element;
    }

    public void executePipeline() throws MalformedURLException, PipelineException, InterruptedException {
        switch (this.executionMode) {
            case 0: {
                break;
            }
            case 1: {
                this.createDependencyTree();
                if (this.force || !this.upToDateTarget()) {
                    this.executeProcesses();
                    break;
                }
                this.pipeError.info(30017, new String[0]);
                break;
            }
            case 2: {
                this.createDependencyTree();
                if (this.force || !this.upToDateTarget()) {
                    this.executeThreads();
                    break;
                }
                this.pipeError.info(30017, new String[0]);
            }
        }
    }

    private Process createProcess(XMLElement xMLElement) throws PipelineException, MalformedURLException {
        String string = this.getProcDef(xMLElement);
        if (string == null) {
            this.pipeError.setProcessId(xMLElement.getAttribute("id"));
            this.pipeError.error(30010, 17, new String[]{xMLElement.getAttribute("type")});
        }
        Process process = this.createProcess(string, xMLElement.getAttribute("id"));
        process.init(xMLElement, this, this.pipeError);
        return process;
    }

    private void createDependencyTree() throws PipelineException, MalformedURLException {
        this.targetProcess = this.createProcess(this.locateTargetProcess());
        this.buildTree(this.targetProcess);
        this.availQ = new SyncQueue();
        this.determineOutputXMLTypes(this.targetProcess);
    }

    private void buildTree(Process process) throws PipelineException, MalformedURLException {
        process.setDependents();
        Enumeration enumeration = process.getPrevProcesses();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.buildTree((Process)this.processList.get(string));
        }
    }

    private void determineOutputXMLTypes(Process process) throws PipelineException {
        Object object;
        Enumeration enumeration;
        process.determineOutputXMLType();
        if (!this.force && (enumeration = process.getInputs()) != null) {
            while (enumeration.hasMoreElements()) {
                object = (Input)enumeration.nextElement();
                if (!((Input)object).isAvailable()) continue;
                this.availInputs.addElement(object);
            }
        }
        if ((enumeration = process.getPrevProcesses()) == null) {
            this.availQ.add(process);
            return;
        }
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.determineOutputXMLTypes((Process)this.processList.get(object));
        }
    }

    private boolean upToDateTarget() {
        URLConnection uRLConnection = null;
        URLConnection uRLConnection2 = null;
        URL uRL = null;
        URL uRL2 = null;
        try {
            uRL = Util.createURL(this.targetName);
            uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            return false;
        }
        int n = this.availInputs.size();
        for (int i = 0; i < n; ++i) {
            File file;
            try {
                uRL2 = Util.createURL(((Input)this.availInputs.elementAt(i)).getLabel());
                uRLConnection2 = uRL2.openConnection();
                uRLConnection2.setDoInput(true);
                uRLConnection2.getInputStream();
            }
            catch (IOException iOException) {
                return false;
            }
            long l = uRLConnection.getLastModified();
            long l2 = uRLConnection2.getLastModified();
            if (l <= 0L && uRL.getProtocol().compareTo("file") == 0) {
                file = new File(uRL.getFile());
                l = file.lastModified();
            }
            if (l2 <= 0L && uRL2.getProtocol().compareTo("file") == 0) {
                file = new File(uRL2.getFile());
                l2 = file.lastModified();
            }
            if (l == 0L || l2 == 0L) {
                return false;
            }
            if (l >= l2) continue;
            return false;
        }
        return true;
    }

    private void executeProcesses() {
        this.processList.put(this.targetProcess.getId(), this.targetProcess);
        do {
            Enumeration enumeration = this.processList.elements();
            Process process = null;
            while (this.availQ.getCount() > 0 && this.targetProcess.getProcessStatus() != 1) {
                process = (Process)this.availQ.getNext();
                if (process != null && process.isRunnable()) {
                    process.run();
                }
                if (process.getProcessStatus() != 3) continue;
                return;
            }
        } while (this.targetProcess.getProcessStatus() != 1);
    }

    private void executeThreads() throws InterruptedException {
        while (this.availQ.getCount() > 0 || this.targetProcess.getProcessStatus() != 1 && this.targetProcess.getProcessStatus() != 3) {
            Process process = (Process)this.availQ.getNext();
            if (process != null && process.isRunnable()) {
                Thread thread = new Thread((Runnable)process, process.getId());
                thread.start();
                continue;
            }
            Thread.yield();
        }
    }

    PipelineDoc getPipeDoc() {
        return this.pipeDoc;
    }

    void putProcessOnQueue(Process process) throws PipelineException {
        this.availQ.add(process);
    }

    void stopPipeline() {
        this.targetProcess.setProcessStatus((short)1);
    }

    String getProcDef(XMLElement xMLElement) {
        Document document = xMLElement.getOwnerDocument();
        NodeList nodeList = document.getElementsByTagName("processdef");
        String string = xMLElement.getAttribute("type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (string.compareTo(((Element)nodeList.item(i)).getAttribute("name")) != 0) continue;
            return ((Element)nodeList.item(i)).getAttribute("definition");
        }
        if (this.procDefs == null) {
            return null;
        }
        String string2 = (String)this.procDefs.get(string);
        return string2;
    }

    Object resolveAttribute(String string) throws PipelineException {
        String string2;
        Object object = string;
        if (string.startsWith("$") && (object = this.getAttribute(string2 = string.substring(1))) == null) {
            this.pipeError.error(30015, 17, new String[]{string});
        }
        return object;
    }

    Process createProcess(String string, String string2) throws PipelineException {
        Process process = null;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            process = (Process)clazz.newInstance();
        }
        catch (Exception exception) {
            this.pipeError.setProcessId(string2);
            this.pipeError.error(30016, 17, exception);
        }
        return process;
    }
}

