/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.PipeDocElement;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.PipelineProcessor;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.pipeline.controller.Util;

public class Output
extends PipeDocElement {
    private Result result;
    private DOMResult domRes;
    private SAXResult saxRes;
    private StreamResult streamRes;
    private boolean resultCreated = false;
    private boolean dependent = false;
    private Process[] nextProcess;
    private int nextProcessCount = 0;
    final int MAX_NEXT_PROCESSES = 5;
    boolean[] properties;
    private int xmlType = -1;

    Output(XMLElement xMLElement, PipelineProcessor pipelineProcessor) throws PipelineException {
        this.setId(xMLElement.getAttribute("id"));
        this.setName(xMLElement.getAttribute("name"));
        this.setLabel((String)pipelineProcessor.resolveAttribute(xMLElement.getAttribute("label")));
        this.nextProcess = new Process[5];
        this.properties = new boolean[11];
    }

    Result getResult() {
        return this.result;
    }

    DOMResult getDOMResult() {
        return this.domRes;
    }

    SAXResult getSAXResult() {
        return this.saxRes;
    }

    StreamResult getStreamResult() {
        return this.streamRes;
    }

    void setResult(Result result) {
        this.result = result;
        if (result instanceof DOMResult) {
            this.domRes = (DOMResult)result;
        } else if (result instanceof SAXResult) {
            this.saxRes = (SAXResult)result;
        } else {
            this.streamRes = (StreamResult)result;
        }
    }

    void cleanup() throws IOException {
        if (this.resultCreated) {
            Closeable closeable = ((StreamResult)this.result).getOutputStream();
            if (closeable != null) {
                closeable.flush();
                closeable.close();
            } else {
                closeable = ((StreamResult)this.result).getWriter();
                if (closeable != null) {
                    ((Writer)closeable).close();
                }
            }
        }
    }

    OutputStream createStream() throws FileNotFoundException, IOException {
        URL uRL = Util.createURL(this.getLabel());
        OutputStream outputStream = Util.createOutStream(uRL);
        this.result = new StreamResult(outputStream);
        this.resultCreated = true;
        return outputStream;
    }

    Writer createWriter() throws FileNotFoundException, IOException {
        URL uRL = Util.createURL(this.getLabel());
        Writer writer = Util.createWriter(uRL);
        this.result = new StreamResult(writer);
        this.resultCreated = true;
        return writer;
    }

    void setNextProcess(Process process) {
        this.nextProcess[this.nextProcessCount++] = process;
    }

    Process getNextProcess(int n) {
        return this.nextProcess[n];
    }

    Input getMatchingInput(int n) {
        Process process = this.nextProcess[n];
        Enumeration enumeration = process.getInputs();
        while (enumeration.hasMoreElements()) {
            Input input = (Input)enumeration.nextElement();
            if (input.getLabel().compareTo(this.getLabel()) != 0) continue;
            return input;
        }
        return null;
    }

    Process[] getNextProcesses() {
        return this.nextProcess;
    }

    int getNextProcessCount() {
        return this.nextProcessCount;
    }

    public void supportType(int n) {
        this.properties[n] = true;
    }

    boolean supportsType(int n) {
        return this.properties[n];
    }

    void setXMLType(int n) {
        this.xmlType = n;
    }

    public boolean isXMLType(int n) {
        return n == this.xmlType;
    }
}

