/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;
import oracle.bali.ewt.button.PopupButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;

public class InsertButton
extends PopupButton
implements ActionListener,
FocusListener {
    protected Vector m_Vector = new Vector();
    protected boolean m_insertAdded;
    protected JComboBox m_jComboBox;
    protected MyBasicComboPopup m_basicComboPopup;
    protected String m_selectedItem;
    protected int m_selectedIndex = -1;
    protected int m_maximumRowCount = 4;
    protected ActionListener m_actionListener;
    protected boolean m_bSuperCalled;
    protected ActionListener m_editAction;
    protected int m_saveVerticalScrollbarWidth;
    public static final int DEFAULT_TYPE = 0;
    public static final int S_TYPE = 1;
    public static final int R_TYPE = 2;
    private KeyListener m_keyListener;
    private ResourceBundle rBundle;
    private int m_type;
    private int m_maxPopupHeight;

    public InsertButton() {
        super((Icon)new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.util.gui.InsertButton"), (String)"images/PopupButtonArrow.gif")));
        this.updateResourceBundle(null);
        this._setPreferredSize();
        this.setEnabled(false);
        this.setType(this.m_type);
    }

    public InsertButton(Object[] objectArray) {
        super((Icon)new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.util.gui.InsertButton"), (String)"images/PopupButtonArrow.gif")));
        this.m_bSuperCalled = true;
        this.updateResourceBundle(null);
        this._setPreferredSize();
        this.setEnabled(true);
        this.setType(this.m_type);
        if (this.m_Vector != null) {
            this.m_Vector.removeAllElements();
        }
        this.m_jComboBox = new JComboBox();
        int n = 0;
        while (n < objectArray.length) {
            this.m_jComboBox.addItem(objectArray[n]);
            this.m_Vector.addElement((String)objectArray[n]);
            ++n;
        }
        n = this.m_Vector.size();
        if (n > this.m_maximumRowCount) {
            n = this.m_maximumRowCount;
            this._saveVerticalScrollbarWidth();
        }
        this.m_jComboBox.setMaximumRowCount(n);
        this.m_jComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertButton.this.m_selectedIndex = InsertButton.this.m_jComboBox.getSelectedIndex();
                InsertButton.this.m_selectedItem = (String)InsertButton.this.m_jComboBox.getSelectedItem();
                InsertButton.this.notifyActionListeners();
                InsertButton.this.m_basicComboPopup.setVisible(false);
            }
        };
        this.m_jComboBox.addActionListener(this.m_actionListener);
        this.m_basicComboPopup = new MyBasicComboPopup(this.m_jComboBox);
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            this.m_basicComboPopup.setBorder(UIManager.getBorder("Button.border"));
        }
        this.setMaximumRowCount(n);
        this.setMaxPopupHeight();
        this.setPopupMenu(this.m_basicComboPopup);
        this.addActionListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                InsertButton.this.internalKeyPressed(keyEvent);
            }
        });
        this.addFocusListener(this);
    }

    private void setMaxPopupHeight() {
        if (this.m_Vector != null) {
            this.setMaximumRowCount(this.m_Vector.size());
            this.m_maxPopupHeight = this.m_basicComboPopup.getPreferredSize().height;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            if (!focusEvent.isTemporary() && this.m_basicComboPopup.isVisible()) {
                this.m_basicComboPopup.setVisible(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (actionEvent.getSource() == this) {
            n = this.getPreferredSize().width;
            n2 = this.m_basicComboPopup.getPreferredSize().width;
            n3 = n - n2;
            if (this.isShowing()) {
                Component component = SwingUtilities.getRoot((Component)((Object)this));
                Point point = SwingUtilities.convertPoint((Component)((Object)this), this.getLocation(), component);
                int n4 = component.getSize().height - (point.y + this.getPreferredSize().height);
                if (this.m_maxPopupHeight > n4) {
                    this.m_basicComboPopup.setPreferredSize(new Dimension(this.m_basicComboPopup.getPreferredSize().width, n4));
                } else {
                    this.m_basicComboPopup.setPreferredSize(new Dimension(this.m_basicComboPopup.getPreferredSize().width, this.m_maxPopupHeight));
                }
                this.m_basicComboPopup.show((Component)((Object)this), n3, this.getPreferredSize().height);
            }
            if (!this.m_basicComboPopup.isVisible()) {
                this.m_selectedItem = null;
                this.m_selectedIndex = -1;
            }
        }
    }

    public void setType(int n) {
        this.m_type = n;
        String string = this.m_type == 0 ? "Insert" : (this.m_type == 1 ? "Insert-S" : (this.m_type == 2 ? "Insert-R" : "Insert"));
        String string2 = this.rBundle.getString(string);
        this.setText(StringUtils.stripMnemonic((String)string2));
        this.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.setHorizontalTextPosition(2);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this._setPreferredSize();
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.m_jComboBox.setModel(comboBoxModel);
    }

    public String getSelectedItem() {
        String string = this.m_selectedItem;
        this.m_selectedItem = null;
        return string;
    }

    public int getSelectedIndex() {
        int n = this.m_selectedIndex;
        this.m_selectedIndex = -1;
        return n;
    }

    public void setItems(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel<Object>(objectArray));
        this.setType(this.m_type);
        this.setEnabled(true);
    }

    public void notifyActionListeners() {
        EventListener[] eventListenerArray = this.getListeners(Class.forName("java.awt.event.ActionListener"));
        int n = 0;
        while (n < eventListenerArray.length) {
            ActionListener actionListener = (ActionListener)eventListenerArray[n];
            ActionEvent actionEvent = new ActionEvent(this, this.m_selectedIndex, this.m_selectedItem);
            actionListener.actionPerformed(actionEvent);
            ++n;
        }
    }

    public void setMaximumRowCount(int n) {
        this.m_maximumRowCount = n;
        if (this.m_jComboBox != null) {
            this.m_basicComboPopup.setMaximumRowCount(this.m_maximumRowCount);
        }
    }

    protected void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
    }

    private void _setPreferredSize() {
        String string = this.rBundle.getString("Insert-R");
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        int n = this.getToolkit().getFontMetrics(jLabel.getFont()).stringWidth(jLabel.getText());
        int n2 = this.getIcon().getIconWidth();
        this.setPreferredSize(new Dimension(n + n2 + 40, 26));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    private void _saveVerticalScrollbarWidth() {
        int n;
        JScrollBar jScrollBar = new JScrollBar();
        if (this.m_Vector != null && (n = this.m_Vector.size()) > this.m_maximumRowCount) {
            this.m_saveVerticalScrollbarWidth = jScrollBar.getPreferredSize().width;
        }
    }

    private void internalKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && this.m_basicComboPopup.isVisible()) {
            this.m_basicComboPopup.setVisible(false);
            keyEvent.consume();
        }
        if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 39) {
            if (this.m_basicComboPopup.isVisible() && this.m_jComboBox.getSelectedIndex() < this.m_jComboBox.getItemCount() - 1) {
                this.m_jComboBox.removeActionListener(this.m_actionListener);
                this.m_jComboBox.setSelectedIndex(this.m_jComboBox.getSelectedIndex() + 1);
                this.m_jComboBox.addActionListener(this.m_actionListener);
            }
        } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37) {
            if (this.m_basicComboPopup.isVisible() && this.m_jComboBox.getSelectedIndex() != 0) {
                this.m_jComboBox.removeActionListener(this.m_actionListener);
                this.m_jComboBox.setSelectedIndex(this.m_jComboBox.getSelectedIndex() - 1);
                this.m_jComboBox.addActionListener(this.m_actionListener);
            }
        } else if (keyEvent.getKeyCode() == 10 && this.m_basicComboPopup.isVisible()) {
            this.m_selectedIndex = this.m_jComboBox.getSelectedIndex();
            this.m_selectedItem = (String)this.m_jComboBox.getSelectedItem();
            this.notifyActionListeners();
        }
    }

    public class MyBasicComboPopup
    extends BasicComboPopup {
        JComboBox comboBox;
        int m_basicComboPopupHeight;
        int m_basicComboPopupWidth;

        public MyBasicComboPopup(JComboBox jComboBox) {
            super(jComboBox);
            this.comboBox = jComboBox;
            this.m_basicComboPopupHeight = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        }

        public void setMaximumRowCount(int n) {
            this.comboBox.setMaximumRowCount(n);
            this.m_basicComboPopupHeight = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                this.m_basicComboPopupHeight += 4;
            }
            if (this.m_basicComboPopupWidth == 0) {
                this.m_basicComboPopupWidth = InsertButton.this.m_basicComboPopup.getPreferredSize().width + InsertButton.this.m_saveVerticalScrollbarWidth;
            }
            InsertButton.this.m_basicComboPopup.setPreferredSize(new Dimension(this.m_basicComboPopupWidth, this.m_basicComboPopupHeight + 2));
        }
    }
}

