/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dss.util.FocusUtility;
import oracle.dss.util.dimensionList.DefaultListCellEditor;
import oracle.dss.util.dimensionList.DefaultListDataModel;
import oracle.dss.util.dimensionList.DefaultListSelection;
import oracle.dss.util.dimensionList.DimListCellEditor;
import oracle.dss.util.dimensionList.DimListCellEditorEvent;
import oracle.dss.util.dimensionList.DimListCellEditorListener;
import oracle.dss.util.dimensionList.DimListCellRenderer;
import oracle.dss.util.dimensionList.DimListDataItem;
import oracle.dss.util.dimensionList.DimListDataModel;
import oracle.dss.util.dimensionList.DimensionListEvent;
import oracle.dss.util.dimensionList.DimensionListListener;
import oracle.dss.util.dimensionList.DimensionUtil;
import oracle.dss.util.dimensionList.DragList;

public class DimensionList
extends DragList
implements DimListCellEditorListener,
ListDataListener,
ListSelectionListener,
Serializable {
    public static final int BELOW_PARENT = 0;
    public static final int ABOVE_PARENT = 1;
    public static final int AUTOKEY_NONE = 0;
    public static final int AUTOKEY_FIRSTCHAR = 1;
    public static final int AUTOKEY_ANYCHAR = 2;
    public static final int DRILLSTATE_NOT_DRILLABLE = 0;
    public static final int DRILLSTATE_DRILLABLE = 1;
    public static final int DRILLSTATE_IS_DRILLED = 2;
    private static final int DRILL_GAP = 5;
    boolean m_matchCase;
    private int m_autoKeyAction = 0;
    private DimListCellEditor mCellEditor;
    private String m_cellPrototype = new String("RSTLNEy");
    private DefDimListCellRenderer m_cellRenderer;
    private boolean m_contextIconVisible = true;
    private DefaultListDataModel m_dataModel;
    private boolean m_editable;
    private boolean m_iconShow = true;
    private DefaultListSelection m_selectionModel;
    private boolean m_tooltipsEnabled = true;
    private transient boolean m_constructed = true;
    private transient Icon m_blankIcon;
    private transient Icon m_closedIcon;
    private transient Icon m_collapsedIcon;
    private transient long m_dragEndIndex = -1L;
    private transient long m_dragStartIndex = -1L;
    private transient DimensionUtil m_du = new DimensionUtil();
    private transient int m_editIndex = -1;
    private transient DefaultListCellEditor m_editor;
    private transient Icon m_expandedIcon;
    private transient Vector m_listeners;
    private transient Vector m_listlisteners;
    private transient Icon m_nodeIcon;
    private transient Icon m_openedIcon;
    private int m_iconWidth;
    private transient int m_tabPosition;
    private transient int m_cellHeightPadValue;
    protected int m_debugLevel;
    private boolean m_blnFromMouseEvent;

    public DimensionList() {
        this.init();
        this.addListSelectionListener(this);
    }

    public synchronized void addDimensionListListener(DimensionListListener dimensionListListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(dimensionListListener)) {
            this.m_listeners.addElement(dimensionListListener);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.m_cellRenderer = null;
        this.init();
        this.enableEvents(60L);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void clearSelection() {
        DimListDataModel dimListDataModel;
        boolean bl = false;
        ListModel listModel = this.getModel();
        if (listModel instanceof DimListDataModel && (dimListDataModel = (DimListDataModel)listModel) != null) {
            int n = this.getSelectedIndex();
            DimensionListEvent dimensionListEvent = new DimensionListEvent(this, 7, n);
            this.notifyDimensionListListener(dimensionListEvent);
            if (!dimensionListEvent.isConsumed()) {
                super.clearSelection();
                this.notifyDimensionListListener(new DimensionListEvent(this, 8, -1));
                bl = true;
            }
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.init();
    }

    public void DimListCellEditorAction(DimListCellEditorEvent dimListCellEditorEvent) {
        if (dimListCellEditorEvent.getId() != DimListCellEditorEvent.START) {
            if (dimListCellEditorEvent.getId() == DimListCellEditorEvent.ACCEPT) {
                int n = this.mCellEditor.getIndex();
                DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
                DimListDataItem dimListDataItem = (DimListDataItem)dimListDataModel.elementAt(n);
                dimListDataItem.setText(this.mCellEditor.getText());
                dimListDataModel.setElementAt(dimListDataItem, n);
                this.repaint();
            }
            this.mCellEditor.removeEditListener(this);
            this.remove((Component)((Object)this.mCellEditor));
            this.requestFocus();
        }
    }

    public boolean doExpandAll() {
        DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
        if (dimListDataModel != null) {
            int n = this.getSelectedIndex();
            DimensionListEvent dimensionListEvent = new DimensionListEvent(this, 3, n);
            this.notifyDimensionListListener(dimensionListEvent);
            if (!dimensionListEvent.isConsumed()) {
                this.clearSelection();
                dimListDataModel.expandAll();
                this.setSelectedIndex(n);
                this.notifyDimensionListListener(new DimensionListEvent(this, 4, 0));
                return true;
            }
        }
        return false;
    }

    public boolean doCollapseAll() {
        DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
        if (dimListDataModel != null) {
            int n = this.getSelectedIndex();
            DimensionListEvent dimensionListEvent = new DimensionListEvent(this, 1, n);
            this.notifyDimensionListListener(dimensionListEvent);
            if (!dimensionListEvent.isConsumed()) {
                this.clearSelection();
                dimListDataModel.collapseAll();
                this.setSelectedIndex(0);
                this.notifyDimensionListListener(new DimensionListEvent(this, 2, 0));
            }
            return true;
        }
        return false;
    }

    public boolean doDrill(int n) {
        DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
        if (dimListDataModel != null) {
            DimensionListEvent dimensionListEvent = new DimensionListEvent(this, 5, n);
            this.notifyDimensionListListener(dimensionListEvent);
            if (!dimensionListEvent.isConsumed()) {
                DimListDataItem dimListDataItem = (DimListDataItem)dimListDataModel.elementAt(n);
                if (dimListDataItem == null) {
                    return false;
                }
                int n2 = dimListDataItem.getDrillState();
                if (n2 != 0) {
                    int n3 = (n2 & 2) > 0 ? -1 : 0;
                    n3 = (n2 & 1) > 0 ? 1 : n3;
                    this.clearSelection();
                    DimensionList.setParentWindowCursor((Component)this, 3);
                    dimListDataModel.drill(n, n3);
                    DimensionList.setParentWindowCursor((Component)this, 0);
                    this.setSelectedIndex(n);
                    AccessibleContext accessibleContext = this.getAccessibleContext();
                    if (accessibleContext != null) {
                        accessibleContext.firePropertyChange("AccessibleActiveDescendant", null, accessibleContext.getAccessibleChild(n));
                    }
                    this.notifyDimensionListListener(new DimensionListEvent(this, 6, 0));
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doEdit(int n) {
        DimListDataItem dimListDataItem;
        ListModel listModel;
        boolean bl = false;
        if (this.getEditable() && (listModel = this.getModel()) != null && listModel instanceof DimListDataModel && (dimListDataItem = (DimListDataItem)((DimListDataModel)listModel).elementAt(n)) != null) {
            Rectangle rectangle = this.getCellBounds(n, n);
            if (this.mCellEditor != null) {
                this.remove((Component)((Object)this.mCellEditor));
                this.mCellEditor.removeEditListener(this);
                this.mCellEditor.addEditListener(this);
                this.add((Component)((Object)this.mCellEditor));
                this.mCellEditor.startEdit(this, dimListDataItem.getText(), n, rectangle);
                bl = true;
            }
        }
        return bl;
    }

    public int doFind(String string, int n, int n2, boolean bl) {
        int n3 = -1;
        DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
        if (dimListDataModel != null) {
            String string2 = "";
            if (string != null) {
                string2 = string.trim();
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n3 = dimListDataModel.find(string2, n, n2)) > -1) {
                this.ensureIndexIsVisible(n3);
                this.setSelectedIndex(n3);
            }
        }
        return n3;
    }

    public void doGoBottom() {
        int n = this.getFirstVisibleIndex();
        int n2 = this.getLastVisibleIndex();
        int n3 = this.getSelectedIndex();
        int n4 = n2 - n + 1;
        int n5 = this.getCount();
        if (n5 > 0) {
            --n5;
        }
        if (n2 < n5 - n4) {
            this.ensureIndexIsVisible(n5);
        }
        if (n3 != n5) {
            this.setSelectedIndex(n5);
        }
        this.ensureIndexIsVisible(n5);
    }

    public void doGoTop() {
        int n = this.getFirstVisibleIndex();
        int n2 = this.getLastVisibleIndex();
        int n3 = this.getSelectedIndex();
        int n4 = n2 - n + 1;
        if (n != 0 && n4 < this.getCount()) {
            this.ensureIndexIsVisible(n4);
        }
        if (n3 != n) {
            this.setSelectedIndex(0);
        }
        this.ensureIndexIsVisible(0);
    }

    public int doKeySearch(int n) {
        int n2 = -1;
        if (this.m_autoKeyAction > 0) {
            byte[] byArray = new byte[1];
            int n3 = 0;
            int n4 = this.m_matchCase ? n3 & 0xFFFFFF7F : 128;
            byArray[0] = (byte)n;
            n2 = this.doFind(new String(byArray), n3 |= n4, this.getSelectedIndex(), false);
        }
        return n2;
    }

    public void doLineDown() {
        int n = this.getSelectedIndex();
        int n2 = this.getCount();
        if (n2 > 0) {
            --n2;
        }
        if (n < n2) {
            this.setSelectedIndex(++n);
            this.ensureIndexIsVisible(n);
        }
    }

    public void doLineUp() {
        int n = this.getSelectedIndex();
        if (n > 0) {
            this.setSelectedIndex(--n);
            this.ensureIndexIsVisible(n);
        }
    }

    public void doPageDown() {
        int n = this.getFirstVisibleIndex();
        int n2 = this.getLastVisibleIndex();
        int n3 = this.getSelectedIndex();
        int n4 = n2 - n + 1;
        int n5 = this.getCount();
        if (n5 > 0) {
            --n5;
        }
        if (n2 > n5 || n2 == -1) {
            n2 = n5;
        }
        if (n3 != n2) {
            this.setSelectedIndex(n2);
        } else if (n2 < n5) {
            if ((n2 += n4 - 1) > n5) {
                n2 = n5;
            }
            this.setSelectedIndex(n2);
            n = n2 - (n4 - 1);
            if (n < 0) {
                n = 0;
            }
            this.ensureIndexIsVisible(n);
        }
        this.ensureIndexIsVisible(n2);
    }

    public void doPageUp() {
        int n = this.getFirstVisibleIndex();
        int n2 = this.getLastVisibleIndex();
        int n3 = this.getSelectedIndex();
        int n4 = n2 - n + 1;
        if (n3 != n) {
            this.setSelectedIndex(n);
        } else if (n > 0) {
            n = n > n4 ? (n -= n4 - 1) : 0;
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n + n4 + 1);
        }
        this.ensureIndexIsVisible(n);
    }

    public int getAutoKeyAction() {
        return this.m_autoKeyAction;
    }

    public DimListCellEditor getCellEditor() {
        return this.mCellEditor;
    }

    public int getTabPosition() {
        return this.m_tabPosition;
    }

    public void setTabPosition(int n) {
        this.m_tabPosition = n;
    }

    public int getCellHeightPadValue() {
        return this.m_cellHeightPadValue;
    }

    public void setCellHeightPadValue(int n) {
        if (n >= 0) {
            this.m_cellHeightPadValue = n;
            this.repaint();
        }
    }

    public Icon getClosedIcon() {
        return this.m_closedIcon;
    }

    public Icon getCollapsedIcon() {
        return this.m_collapsedIcon;
    }

    public boolean getContextIconVisible() {
        return this.m_contextIconVisible;
    }

    public int getCount() {
        DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
        if (dimListDataModel != null) {
            return dimListDataModel.size();
        }
        return 0;
    }

    public boolean getEditable() {
        return this.m_editable;
    }

    public int getEditIndex() {
        return this.m_editIndex;
    }

    public long getEndIndex() {
        return this.m_dragEndIndex;
    }

    public Icon getExpandedIcon() {
        return this.m_expandedIcon;
    }

    public int getFirstVisibleIndex() {
        return super.getFirstVisibleIndex();
    }

    public Icon getNodeIcon() {
        return this.m_nodeIcon;
    }

    public Icon getOpenedIcon() {
        return this.m_openedIcon;
    }

    public long getStartIndex() {
        return this.m_dragStartIndex;
    }

    public boolean getToolTipsEnabled() {
        return this.m_tooltipsEnabled;
    }

    public int getWidthHeuristic() {
        return this.getFixedCellWidth();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public boolean isContextIconVisible() {
        return this.getContextIconVisible();
    }

    public boolean isIconVisible() {
        return this.m_iconShow;
    }

    public boolean isToolTipsEnabled() {
        return this.getToolTipsEnabled();
    }

    public synchronized void removeDimensionListListener(DimensionListListener dimensionListListener) {
        if (this.m_listeners != null && !this.m_listeners.contains(dimensionListListener)) {
            this.m_listeners.removeElement(dimensionListListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void setAutoKeyAction(int n) {
        if (n < 0 || n > 2) {
            System.out.println("setAutoKeyAction(): parameter out-of-range");
        } else if (n != this.m_autoKeyAction) {
            int n2 = this.m_autoKeyAction;
            this.m_autoKeyAction = n;
            this.firePropertyChange("AutoKeyAction", n2, this.m_autoKeyAction);
        }
    }

    public synchronized void setCellEditor(DimListCellEditor dimListCellEditor) {
        if (dimListCellEditor != null) {
            DimListCellEditor dimListCellEditor2 = this.mCellEditor;
            this.mCellEditor = dimListCellEditor;
            this.firePropertyChange("CellEditor", dimListCellEditor2, this.mCellEditor);
        }
    }

    public synchronized void setClosedIcon(Icon icon) {
        Icon icon2 = this.m_closedIcon;
        if (icon == null) {
            try {
                this.m_closedIcon = new ImageIcon(this.m_du.getImageResource("images/folder-c.gif", true));
            }
            catch (Exception exception) {
                System.out.println("DimensionList.setClosedIcon() - exception obtaining closed icon");
                exception.printStackTrace();
            }
        } else {
            this.m_closedIcon = icon;
        }
        if (icon2 != this.m_closedIcon) {
            this.firePropertyChange("ClosedIcon", icon2, this.m_closedIcon);
        }
    }

    public synchronized void setCollapsedIcon(Icon icon) {
        Icon icon2 = this.m_collapsedIcon;
        if (icon == null) {
            try {
                Icon icon3 = (Icon)UIManager.get("Tree.collapsedIcon");
                this.m_collapsedIcon = icon3 != null ? icon3 : new ImageIcon(this.m_du.getImageResource("images/collapse.gif", true));
            }
            catch (Exception exception) {
                System.out.println("DimensionList.setCollapsedIcon() - exception obtaining collapsed icon");
                exception.printStackTrace();
            }
        } else {
            this.m_collapsedIcon = icon;
        }
        if (icon2 != this.m_collapsedIcon) {
            this.firePropertyChange("CollapsedIcon", icon2, this.m_collapsedIcon);
        }
    }

    public synchronized void setContextIconVisible(boolean bl) {
        if (bl != this.m_contextIconVisible) {
            boolean bl2 = this.m_contextIconVisible;
            this.m_contextIconVisible = bl;
            this.repaint();
            this.firePropertyChange("ContextIconVisible", bl2, this.m_contextIconVisible);
        }
    }

    public synchronized void setEditable(boolean bl) {
        if (bl != this.m_editable) {
            boolean bl2 = this.m_editable;
            this.m_editable = bl;
            this.firePropertyChange("Editable", bl2, this.m_editable);
        }
    }

    public synchronized void setEditIndex(int n) {
        if (n != this.m_editIndex) {
            int n2 = this.m_editIndex;
            this.m_editIndex = n;
            this.firePropertyChange("EditIndex", n2, this.m_editIndex);
        }
    }

    public synchronized void setExpandedIcon(Icon icon) {
        Icon icon2 = this.m_expandedIcon;
        if (icon == null) {
            try {
                Icon icon3 = (Icon)UIManager.get("Tree.expandedIcon");
                this.m_expandedIcon = icon3 != null ? icon3 : new ImageIcon(this.m_du.getImageResource("images/expand.gif", true));
            }
            catch (Exception exception) {
                System.out.println("DimensionList.setExpandedIcon() - exception obtaining expanded icon");
                exception.printStackTrace();
            }
        } else {
            this.m_expandedIcon = icon;
        }
        if (icon2 != this.m_expandedIcon) {
            this.firePropertyChange("ExpandedIcon", icon2, this.m_expandedIcon);
        }
    }

    public void setFirstVisibleIndex(int n) {
        int n2 = this.getCount();
        if (n2 > 0 && n < n2) {
            int n3;
            int n4 = 0;
            --n2;
            this.ensureIndexIsVisible(n);
            while ((n3 = this.getFirstVisibleIndex()) != n) {
                int n5 = this.getLastVisibleIndex();
                if (n5 == -1 || n5 >= n2) break;
                if (++n4 > 200) {
                    System.out.println(String.valueOf(String.valueOf("warning: looping in setFirstVisibleIndex() index=")) + n + ", first=" + n3 + ", last=" + n5 + ", count=" + (n2 + 1));
                    break;
                }
                this.ensureIndexIsVisible(n5 + 1);
            }
            this.ensureIndexIsVisible(n);
        }
    }

    public synchronized void setIconVisible(boolean bl) {
        if (bl != this.m_iconShow) {
            boolean bl2 = this.m_iconShow;
            this.m_iconShow = bl;
            this.repaint();
            this.firePropertyChange("IconVisible", bl2, this.m_iconShow);
        }
    }

    public synchronized void setModel(DimListDataModel dimListDataModel) {
        super.setModel(dimListDataModel);
        if (this.m_dataModel != null) {
            this.m_dataModel.removeListDataListener(this);
        }
        this.init();
        if (dimListDataModel != null) {
            dimListDataModel.addListDataListener(this);
        }
        this.notifyDimensionListListener(new DimensionListEvent(this, 0, 0));
    }

    public synchronized void setNodeIcon(Icon icon) {
        Icon icon2 = this.m_nodeIcon;
        if (icon == null) {
            try {
                this.m_nodeIcon = new ImageIcon(this.m_du.getImageResource("images/point.gif", true));
            }
            catch (Exception exception) {
                System.out.println("DimensionList.setNodeIcon() - exception obtaining node icon");
                exception.printStackTrace();
            }
        } else {
            this.m_nodeIcon = icon;
        }
        if (icon2 != this.m_nodeIcon) {
            this.firePropertyChange("NodeIcon", icon2, this.m_nodeIcon);
        }
    }

    public synchronized void setOpenedIcon(Icon icon) {
        Icon icon2 = this.m_openedIcon;
        if (icon == null) {
            try {
                this.m_openedIcon = new ImageIcon(this.m_du.getImageResource("images/folder-o.gif", true));
            }
            catch (Exception exception) {
                System.out.println("DimensionList.setOpenedIcon() - exception obtaining opened icon");
                exception.printStackTrace();
            }
        } else {
            this.m_openedIcon = icon;
        }
        if (icon2 != this.m_openedIcon) {
            this.firePropertyChange("OpenedIcon", icon2, this.m_openedIcon);
        }
    }

    public synchronized void setToolTipsEnabled(boolean bl) {
        if (bl != this.m_tooltipsEnabled) {
            boolean bl2 = this.m_tooltipsEnabled;
            this.m_tooltipsEnabled = bl;
            this.firePropertyChange("ToolTipsEnabled", bl2, this.m_tooltipsEnabled);
        }
    }

    public synchronized void setWidthHeuristic(int n) {
        int n2 = this.getFixedCellWidth();
        if (n2 < n) {
            this.setFixedCellWidth(n);
            this.firePropertyChange("WidthHeuristic", n2, n);
        }
    }

    public void updateUI() {
        super.updateUI();
        this.init();
        if (this.m_cellRenderer != null) {
            this.m_cellRenderer.updateUI();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.notifyDimensionListListener(new DimensionListEvent(this, 10, listSelectionEvent.getLastIndex()));
        } else {
            this.notifyDimensionListListener(new DimensionListEvent(this, 9, listSelectionEvent.getFirstIndex()));
        }
    }

    protected void init() {
        Object object;
        ListModel listModel;
        if (!this.m_constructed) {
            return;
        }
        if (this.getExpandedIcon() == null) {
            this.setExpandedIcon(null);
        }
        if (this.getCollapsedIcon() == null) {
            this.setCollapsedIcon(null);
        }
        if (this.getOpenedIcon() == null) {
            this.setOpenedIcon(null);
        }
        if (this.getClosedIcon() == null) {
            this.setClosedIcon(null);
        }
        if (this.getNodeIcon() == null) {
            this.setNodeIcon(null);
        }
        try {
            this.m_blankIcon = new ImageIcon(this.m_du.getImageResource("images/blank.gif", true));
        }
        catch (Exception exception) {
            System.out.println("DimensionList.init() warning: blank.gif icon not loaded");
        }
        if (this.m_cellRenderer == null) {
            this.m_cellRenderer = new DefDimListCellRenderer();
            this.setCellRenderer(this.m_cellRenderer);
        }
        if (this.m_selectionModel == null) {
            this.m_selectionModel = new DefaultListSelection();
            this.m_selectionModel.setSelectionMode(this.getSelectionMode());
            this.setSelectionModel(this.m_selectionModel);
        }
        if ((listModel = this.getModel()) != null && listModel instanceof DimListDataModel) {
            object = (DimListDataModel)listModel;
            this.m_cellRenderer.setShowHierarchical(object.isHierarchical());
        }
        object = null;
        this.m_iconWidth = 0;
        object = this.m_expandedIcon;
        if (object != null && object.getIconWidth() > this.m_iconWidth) {
            this.m_iconWidth = object.getIconWidth();
        }
        if ((object = this.m_collapsedIcon) != null && object.getIconWidth() > this.m_iconWidth) {
            this.m_iconWidth = object.getIconWidth();
        }
        if (this.getContextIconVisible()) {
            object = this.m_openedIcon;
            if (object != null && object.getIconWidth() > this.m_iconWidth) {
                this.m_iconWidth = object.getIconWidth();
            }
            if ((object = this.m_closedIcon) != null && object.getIconWidth() > this.m_iconWidth) {
                this.m_iconWidth = object.getIconWidth();
            }
            if ((object = this.m_nodeIcon) != null && object.getIconWidth() > this.m_iconWidth) {
                this.m_iconWidth = object.getIconWidth();
            }
        }
        this.setCellEditor(null);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (!this.m_blnFromMouseEvent && focusEvent.getID() == 1004) {
            FocusUtility.setFocusToFirstSelectedRow(this, focusEvent);
            this.ensureIndexIsVisible(this.getLeadSelectionIndex());
        }
    }

    protected boolean dragCancel(long l) {
        if (this.m_debugLevel > 0) {
            System.out.println("DimensionList.dragCancel");
        }
        DimensionListEvent dimensionListEvent = new DimensionListEvent((Object)this, 13, l, null);
        this.notifyDimensionListListener(dimensionListEvent);
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
        return true;
    }

    protected boolean dragEnd(long l, long l2) {
        DimListDataModel dimListDataModel;
        ListModel listModel;
        boolean bl = false;
        if (this.m_debugLevel > 0) {
            System.out.println("DimensionList.dragEnd");
        }
        if ((listModel = this.getModel()) != null && listModel instanceof DimListDataModel && (dimListDataModel = (DimListDataModel)listModel).isDropTarget(l2, null) && l != l2) {
            DimensionListEvent dimensionListEvent = new DimensionListEvent(this, 12, l, l2, null);
            this.notifyDimensionListListener(dimensionListEvent);
            if (dimensionListEvent.isConsumed()) {
                this.notifyDimensionListListener(new DimensionListEvent(this, 13, 0));
            } else {
                dimListDataModel.moveElement((int)l, (int)l2);
                this.setCursor(Cursor.getDefaultCursor());
                this.repaint();
                bl = true;
            }
        }
        return bl;
    }

    protected boolean dragStart(long l) {
        DimListDataModel dimListDataModel;
        boolean bl = false;
        if (this.m_debugLevel > 0) {
            System.out.println("DimensionList.dragStart");
        }
        if (this.isManualSortGuiEnabled() && (dimListDataModel = (DimListDataModel)this.getModel()) != null && dimListDataModel.isDragable(l)) {
            DimensionListEvent dimensionListEvent = new DimensionListEvent((Object)this, 11, l, null);
            this.notifyDimensionListListener(dimensionListEvent);
            if (dimensionListEvent.isConsumed()) {
                this.notifyDimensionListListener(new DimensionListEvent(this, 13, 0));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.repaint();
                bl = true;
            }
        }
        return bl;
    }

    protected void notifyDimensionListListener(DimensionListEvent dimensionListEvent) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector vector;
            DimensionList dimensionList = this;
            synchronized (dimensionList) {
                try {
                    vector = (Vector)this.m_listeners.clone();
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    throw throwable;
                }
            }
            int n = vector.size();
            DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
            if (dimensionListEvent.getDataModel() == null) {
                dimensionListEvent.setDataModel(dimListDataModel);
            }
            switch (dimensionListEvent.getId()) {
                case 0: {
                    int n2 = 0;
                    while (n2 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n2);
                        dimensionListListener.dimensionChanged(dimensionListEvent);
                        ++n2;
                    }
                    break;
                }
                case 1: {
                    int n3 = 0;
                    while (n3 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n3);
                        dimensionListListener.dimensionCollapsing(dimensionListEvent);
                        ++n3;
                    }
                    break;
                }
                case 2: {
                    int n4 = 0;
                    while (n4 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n4);
                        dimensionListListener.dimensionCollapsed(dimensionListEvent);
                        ++n4;
                    }
                    break;
                }
                case 3: {
                    int n5 = 0;
                    while (n5 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n5);
                        dimensionListListener.dimensionExpanding(dimensionListEvent);
                        ++n5;
                    }
                    break;
                }
                case 4: {
                    int n6 = 0;
                    while (n6 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n6);
                        dimensionListListener.dimensionExpanded(dimensionListEvent);
                        ++n6;
                    }
                    break;
                }
                case 5: {
                    int n7 = 0;
                    while (n7 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n7);
                        dimensionListListener.dimensionDrilling(dimensionListEvent);
                        ++n7;
                    }
                    break;
                }
                case 6: {
                    int n8 = 0;
                    while (n8 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n8);
                        dimensionListListener.dimensionDrilled(dimensionListEvent);
                        ++n8;
                    }
                    break;
                }
                case 7: {
                    int n9 = 0;
                    while (n9 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n9);
                        dimensionListListener.dimensionClearing(dimensionListEvent);
                        ++n9;
                    }
                    break;
                }
                case 8: {
                    int n10 = 0;
                    while (n10 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n10);
                        dimensionListListener.dimensionCleared(dimensionListEvent);
                        ++n10;
                    }
                    break;
                }
                case 9: {
                    int n11 = 0;
                    while (n11 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n11);
                        dimensionListListener.dimensionSelecting(dimensionListEvent);
                        ++n11;
                    }
                    break;
                }
                case 10: {
                    int n12 = 0;
                    while (n12 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n12);
                        dimensionListListener.dimensionSelected(dimensionListEvent);
                        ++n12;
                    }
                    break;
                }
                case 11: {
                    int n13 = 0;
                    while (n13 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n13);
                        dimensionListListener.dimensionDragStart(dimensionListEvent);
                        ++n13;
                    }
                    break;
                }
                case 12: {
                    int n14 = 0;
                    while (n14 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n14);
                        dimensionListListener.dimensionDragEnd(dimensionListEvent);
                        ++n14;
                    }
                    break;
                }
                case 13: {
                    int n15 = 0;
                    while (n15 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n15);
                        dimensionListListener.dimensionDragCancel(dimensionListEvent);
                        ++n15;
                    }
                    break;
                }
                case 14: {
                    int n16 = 0;
                    while (n16 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n16);
                        dimensionListListener.dimensionPrefixIconSelecting(dimensionListEvent);
                        ++n16;
                    }
                    break;
                }
                case 15: {
                    int n17 = 0;
                    while (n17 < n && !dimensionListEvent.isConsumed()) {
                        DimensionListListener dimensionListListener = (DimensionListListener)vector.elementAt(n17);
                        dimensionListListener.dimensionPrefixIconSelected(dimensionListEvent);
                        ++n17;
                    }
                    break;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.isEnabled() && mouseEvent.getID() == 503) {
            this.handleMouseMoved(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private boolean inBounds(int n, MouseEvent mouseEvent) {
        if (n >= 0) {
            Rectangle rectangle = this.getCellBounds(this.getFirstVisibleIndex(), this.getLastVisibleIndex());
            if (rectangle != null) {
                return mouseEvent.getY() <= rectangle.height;
            }
            return true;
        }
        return false;
    }

    protected void handleMouseMoved(MouseEvent mouseEvent) {
        int n = this.locationToIndex(mouseEvent.getPoint());
        ListModel listModel = this.getModel();
        if (listModel != null && listModel instanceof DimListDataModel) {
            DimListDataModel dimListDataModel = (DimListDataModel)listModel;
            if (this.inBounds(n, mouseEvent)) {
                DimListDataItem dimListDataItem = (DimListDataItem)dimListDataModel.elementAt(n);
                if (dimListDataItem != null) {
                    this.setToolTipText(dimListDataItem.getDescription());
                }
            } else {
                this.setToolTipText(null);
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.m_blnFromMouseEvent = true;
        if (this.isEnabled()) {
            int n = mouseEvent.getID();
            if (n == 501) {
                this.handleMousePressed(mouseEvent);
            } else if (n == 502) {
                this.handleMouseReleased(mouseEvent);
            } else if (n == 500) {
                this.handleMouseClicked(mouseEvent);
            }
            super.processMouseEvent(mouseEvent);
        }
        this.m_blnFromMouseEvent = false;
    }

    protected void handleMousePressed(MouseEvent mouseEvent) {
        this.m_dragStartIndex = this.locationToIndex(mouseEvent.getPoint());
    }

    protected void handleMouseReleased(MouseEvent mouseEvent) {
        DimensionList dimensionList = this;
        synchronized (dimensionList) {
            try {
                this.m_dragEndIndex = this.locationToIndex(mouseEvent.getPoint());
                if (this.isManualSortGuiEnabled() && !this.inSelection(mouseEvent) && this.m_dragEndIndex != this.m_dragStartIndex) {
                    Rectangle rectangle = this.getCellBounds((int)this.m_dragEndIndex, (int)this.m_dragEndIndex);
                    if (rectangle != null) {
                        boolean bl;
                        boolean bl2 = bl = mouseEvent.getY() % rectangle.height > rectangle.height / 2;
                        if (bl) {
                            this.m_dragEndIndex += (long)1;
                        }
                    }
                    if (this.m_dragEndIndex == (long)-1 && mouseEvent.getY() > 0 && (double)mouseEvent.getY() < this.getSize().getHeight()) {
                        this.m_dragEndIndex = this.getModel().getSize();
                    }
                    if (this.m_dragEndIndex != (long)-1) {
                        this.dragEnd(this.m_dragStartIndex, this.m_dragEndIndex);
                    }
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    protected void handleMouseClicked(MouseEvent mouseEvent) {
        DimListDataItem dimListDataItem;
        boolean bl;
        int n = mouseEvent.getClickCount();
        Point point = mouseEvent.getPoint();
        int n2 = this.locationToIndex(point);
        ListModel listModel = this.getModel();
        DimListCellRenderer dimListCellRenderer = (DimListCellRenderer)this.getCellRenderer();
        boolean bl2 = bl = (mouseEvent.getModifiers() & 0x10) == 16;
        if (listModel != null && listModel instanceof DimListDataModel && dimListCellRenderer != null && (dimListDataItem = (DimListDataItem)((DimListDataModel)listModel).elementAt(n2)) != null) {
            if (bl) {
                boolean bl3;
                if (dimListDataItem.getDrillState() != 0 && ((bl3 = dimListCellRenderer.isDrillIconHit(dimListDataItem, point)) || n == 2 && !bl3)) {
                    this.doDrill(n2);
                }
                if (bl3 = dimListCellRenderer.isPrefixIconHit(dimListDataItem, point)) {
                    DimensionListEvent dimensionListEvent = new DimensionListEvent(this, 15, n2);
                    this.notifyDimensionListListener(dimensionListEvent);
                }
            }
            if (n == 2) {
                this.setSelectedIndex(n2);
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        int n = keyEvent.getID();
        if (n == 401) {
            this.handleKeyPressed(keyEvent);
        } else if (n == 400) {
            this.handleKeyTyped(keyEvent);
        }
    }

    protected void handleKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown() && (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == ' ' || c >= 'A' && c <= 'Z')) {
            this.doKeySearch(c);
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getKeyCode() == 27) {
            this.dragCancel(this.m_dragStartIndex);
        } else if (n == 32) {
            if (keyEvent.isControlDown()) {
                this.addSelectionInterval(this.getSelectedIndex(), this.getSelectedIndex());
            }
        } else if (n == 39 || n == 37) {
            if (keyEvent.isControlDown()) {
                if (n == 39) {
                    int n2 = this.getSelectedIndex();
                    this.doExpandAll();
                    this.setSelectedIndex(n2);
                } else if (n == 37) {
                    this.doCollapseAll();
                }
            } else {
                DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
                if (dimListDataModel != null) {
                    int n3 = this.getSelectedIndex();
                    DimListDataItem dimListDataItem = (DimListDataItem)dimListDataModel.elementAt(n3);
                    int n4 = dimListDataItem.getDrillState();
                    if (dimListDataItem != null && n4 != 0) {
                        boolean bl;
                        boolean bl2 = bl = (n4 & 2) > 0;
                        if (bl && n == 37) {
                            this.doDrill(n3);
                        } else if (!bl && n == 39) {
                            this.doDrill(n3);
                        }
                    }
                }
            }
        }
    }

    private static void setParentWindowCursor(Component component, Cursor cursor) {
        Window window = SwingUtilities.windowForComponent(component);
        if (window != null) {
            window.setCursor(cursor);
        }
    }

    private static void setParentWindowCursor(Component component, int n) {
        DimensionList.setParentWindowCursor(component, Cursor.getPredefinedCursor(n));
    }

    static /* synthetic */ int access$6000071() {
        return 5;
    }

    class DefDimListCellRenderer
    extends JLabel
    implements DimListCellRenderer,
    Serializable {
        private transient boolean m_added;
        private transient int m_level = -1;
        private transient int m_state;
        private transient String m_meta = "";
        private transient boolean m_selected;
        private transient Color m_forenorm = Color.black;
        private transient Color m_backnorm = Color.white;
        private transient Color m_background;
        private transient Color m_foresel = Color.white;
        private transient Color m_backsel = Color.blue;
        private transient Color m_lineColor = Color.lightGray;
        private int m_ascent;
        private int m_indentUnit = 12;
        private boolean m_showHierarchical = true;
        private boolean m_blnContextIconVisible = true;
        private Border m_noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private transient String m_prefix = "";
        private transient int m_position;
        private transient int m_padValue;
        private transient Icon m_stepIcon;
        private transient Icon m_prefixIcon;
        private transient int m_prefixIconWidth;
        private transient Icon m_icoOpened;
        private transient Icon m_icoClosed;

        public DefDimListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.m_noFocusBorder);
            this.init();
        }

        public void addNotify() {
            super.addNotify();
            this.m_added = true;
            this.init();
        }

        public void updateUI() {
            super.updateUI();
            this.init();
        }

        public void setShowHierarchical(boolean bl) {
            this.m_showHierarchical = bl;
        }

        public boolean getShowHierarchical() {
            return this.m_showHierarchical;
        }

        public void setIndentUnit(int n) {
            if (n > -1) {
                this.m_indentUnit = n;
                this.repaint();
            }
        }

        public int getIndentUnit() {
            return this.m_indentUnit;
        }

        public boolean isPrefixIconHit(DimListDataItem dimListDataItem, Point point) {
            return dimListDataItem != null && this.m_prefixIcon != null && point.x >= 0 && point.x < this.m_prefixIcon.getIconWidth();
        }

        public boolean isDrillIconHit(DimListDataItem dimListDataItem, Point point) {
            if (dimListDataItem != null) {
                Icon icon;
                int n;
                int n2 = 0;
                if (this.m_showHierarchical && (n = dimListDataItem.getLevel()) > -1) {
                    n2 = n * this.getIndentUnit() + this.m_position;
                }
                int n3 = ((icon = this.getIcon()) != null ? icon.getIconWidth() : 0) + n2;
                if (point.x >= n2 - DimensionList.access$6000071() && point.x < n3 + DimensionList.access$6000071()) {
                    return true;
                }
            }
            return false;
        }

        public int getTextXOffset(Object object) {
            int n = 0;
            if (this.m_showHierarchical) {
                DimListDataItem dimListDataItem = (DimListDataItem)object;
                int n2 = dimListDataItem.getLevel();
                if (n2 > -1) {
                    Icon icon = this.getIcon();
                    n += n2 * this.getIndentUnit();
                    n += this.getIconTextGap() * 4;
                    if (icon != null) {
                        n += icon.getIconWidth() * 2;
                        n += this.getIconTextGap();
                    }
                } else {
                    n += this.getIconTextGap();
                }
            }
            return n;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            int n2 = -1;
            int n3 = 0;
            String string = "";
            String string2 = "";
            Icon icon = null;
            Icon icon2 = null;
            Object var12_12 = null;
            Object var13_13 = null;
            String string3 = "";
            if (object instanceof String) {
                string = (String)object;
                n2 = -1;
                n3 = 0;
            } else {
                object2 = (DimListDataItem)object;
                if (object2 != null) {
                    string = object2.getText();
                    n2 = object2.getLevel();
                    n3 = object2.getDrillState();
                    string2 = object2.getMetaInfo();
                    string3 = object2.getPrefix();
                    icon = object2.getDataIcon();
                    icon2 = object2.getPrefixIcon();
                    this.m_blnContextIconVisible = object2.isContextIconVisible();
                    this.m_icoOpened = object2.getOpenedIcon();
                    this.m_icoClosed = object2.getClosedIcon();
                }
            }
            this.setText(string);
            object2 = "";
            if (this.m_showHierarchical) {
                this.setIcon(n3 == 2 ? DimensionList.this.m_expandedIcon : (n3 == 1 ? DimensionList.this.m_collapsedIcon : DimensionList.this.m_blankIcon));
                this.m_level = n2;
                if (n3 == 1) {
                    object2 = AccessibleState.COLLAPSED.toDisplayString();
                } else if (n3 == 2) {
                    object2 = AccessibleState.EXPANDED.toDisplayString();
                }
            } else {
                this.m_level = -1;
            }
            if (this.getAccessibleContext() != null) {
                this.getAccessibleContext().setAccessibleName(String.valueOf(string3) + " " + string + " " + (String)object2);
            }
            this.m_state = n3;
            this.m_meta = string2;
            this.m_selected = bl;
            this.m_prefix = string3;
            this.m_stepIcon = icon;
            this.m_prefixIcon = icon2;
            if (icon2 != null) {
                this.m_prefixIconWidth = icon2.getIconWidth() + this.getIconTextGap();
            }
            if (bl) {
                this.m_background = this.m_backsel;
                this.setForeground(this.m_foresel);
            } else {
                this.m_background = this.m_backnorm;
                this.setForeground(this.m_forenorm);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : this.m_noFocusBorder);
            if (jList != null && jList instanceof DimensionList) {
                Dimension dimension = this.getPreferredSize();
                this.m_position = ((DimensionList)jList).getTabPosition();
                this.m_padValue = ((DimensionList)jList).getCellHeightPadValue();
                DimensionList.this.setFixedCellHeight(dimension.height + this.m_padValue);
                ((DimensionList)jList).setWidthHeuristic(dimension.width);
            }
            return this;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            this.paintEx(graphics, dimension);
        }

        private void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
            Insets insets = this.getInsets();
            if (this.isEnabled()) {
                graphics.setColor(this.m_background);
            }
            int n5 = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(string);
            graphics.fillRect(n, insets.top, n5, n3);
            if (this.isEnabled()) {
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(this.m_forenorm);
            }
            graphics.drawString(string, n, n4);
        }

        private void paintEx(Graphics graphics, Dimension dimension) {
            int n;
            Icon icon = this.getIcon();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Insets insets = this.getInsets();
            boolean bl = false;
            n5 = insets.left;
            if (this.m_prefix != null) {
                if (this.m_prefixIcon != null) {
                    this.m_prefixIcon.paintIcon(this, graphics, n5, (dimension.height - this.m_padValue - this.m_prefixIcon.getIconHeight()) / 2);
                    n5 += this.m_prefixIconWidth;
                }
                if (this.m_prefix != "") {
                    this.drawText(graphics, this.m_prefix, n5, this.m_position - n5, dimension.height - insets.bottom - insets.top, this.m_ascent);
                    n = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(this.m_prefix);
                    n5 += n;
                }
                n5 = Math.max(n5, insets.left + this.m_position);
            }
            if (this.m_showHierarchical && icon != null) {
                n2 = icon.getIconWidth();
                n3 = icon.getIconHeight();
            }
            n4 = this.getIndentUnit();
            if (this.m_level > 0) {
                n5 += this.m_level * n4;
            }
            if (this.m_showHierarchical) {
                if (DimensionList.this.isIconVisible()) {
                    if (icon != null) {
                        n = (dimension.height - this.m_padValue - n3) / 2;
                        int n6 = 0;
                        int n7 = n6 = n2 > n4 ? n5 + (n2 - n4) / 2 : n5 + (n4 - n2) / 2;
                        if (this.m_level > 1 || this.m_state != 0) {
                            icon.paintIcon(this, graphics, n6, n);
                        }
                    }
                    if (this.m_level > 1 || this.m_state != 0) {
                        n5 += n4;
                    }
                    bl = true;
                }
                if (DimensionList.this.isContextIconVisible() && this.m_blnContextIconVisible) {
                    if (this.m_stepIcon != null) {
                        this.m_stepIcon.paintIcon(this, graphics, n5, (dimension.height - this.m_padValue - this.m_stepIcon.getIconHeight()) / 2);
                    } else if (this.m_state == 1) {
                        if (this.m_icoClosed != null) {
                            this.m_icoClosed.paintIcon(this, graphics, n5, (dimension.height - this.m_padValue - this.m_icoClosed.getIconHeight()) / 2);
                        } else if (DimensionList.this.m_closedIcon != null) {
                            DimensionList.this.m_closedIcon.paintIcon(this, graphics, n5, (dimension.height - this.m_padValue - DimensionList.this.m_closedIcon.getIconHeight()) / 2);
                        }
                    } else if (this.m_state == 2) {
                        if (this.m_icoOpened != null) {
                            this.m_icoOpened.paintIcon(this, graphics, n5, (dimension.height - this.m_padValue - this.m_icoOpened.getIconHeight()) / 2);
                        } else if (DimensionList.this.m_openedIcon != null) {
                            DimensionList.this.m_openedIcon.paintIcon(this, graphics, n5, (dimension.height - this.m_padValue - DimensionList.this.m_openedIcon.getIconHeight()) / 2);
                        }
                    } else if (this.m_state == 0 && DimensionList.this.m_nodeIcon != null) {
                        DimensionList.this.m_nodeIcon.paintIcon(this, graphics, n5, (dimension.height - this.m_padValue - DimensionList.this.m_nodeIcon.getIconHeight()) / 2);
                    }
                    n5 += n4;
                    bl = true;
                }
                if (bl) {
                    n5 += this.getIconTextGap();
                }
            }
            this.drawText(graphics, this.getText(), n5, dimension.width - this.m_position - insets.right, dimension.height - insets.bottom, this.m_ascent);
        }

        public Dimension getPreferredSize() {
            int n;
            int n2 = 0;
            int n3 = 0;
            Insets insets = this.getInsets();
            boolean bl = false;
            n3 = insets.left;
            if (this.m_prefix != null) {
                if (this.m_prefixIcon != null) {
                    n3 += this.m_prefixIconWidth;
                }
                if (this.m_prefix != "") {
                    n = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(this.m_prefix);
                    n3 += n;
                }
                n3 = Math.max(n3, insets.left + this.m_position);
            }
            n2 = this.getIndentUnit();
            if (this.m_level > 0) {
                n3 += this.m_level * n2;
            }
            if (this.m_showHierarchical) {
                if (DimensionList.this.isIconVisible()) {
                    if (this.m_level != 1 || this.m_state != 0) {
                        n3 += n2;
                    }
                    bl = true;
                }
                if (DimensionList.this.isContextIconVisible() && this.m_blnContextIconVisible) {
                    n3 += n2;
                    bl = true;
                }
                if (bl) {
                    n3 += this.getIconTextGap();
                }
            }
            n = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(this.getText());
            return new Dimension(n3 += n, (int)super.getPreferredSize().getHeight());
        }

        private void drawHierarchyRelationships(Graphics graphics, int n, int n2, int n3) {
            int n4;
            if (this.m_meta != null && (n4 = this.m_meta.length()) > 0) {
                int n5 = n2 + (n4 + 1) * n - n / 2;
                int n6 = n3 / 2;
                int n7 = n / 2;
                graphics.setColor(this.m_lineColor);
                int n8 = 0;
                while (n8 < n4) {
                    char c = this.m_meta.charAt(n8);
                    if (n8 == 0) {
                        if (c == '0') {
                            graphics.drawLine(n5, 0, n5, n3);
                            graphics.drawLine(n5, n6, n5 + n7, n6);
                        } else {
                            graphics.drawLine(n5, 0, n5, n6);
                            graphics.drawLine(n5, n6, n5 + n7, n6);
                        }
                    } else if (c == '0') {
                        graphics.drawLine(n5, 0, n5, n3);
                    }
                    n5 -= n;
                    ++n8;
                }
            }
        }

        private void init() {
            FontMetrics fontMetrics;
            Font font = this.getFont();
            if (font != null && (fontMetrics = this.getFontMetrics(font)) != null && this.m_added) {
                int n = fontMetrics.stringWidth("X");
                if (n < DimensionList.this.m_iconWidth) {
                    n = DimensionList.this.m_iconWidth;
                }
                this.setIndentUnit(n);
                this.m_ascent = fontMetrics.getAscent();
                DimensionList.this.setFixedCellHeight(fontMetrics.getHeight() + this.m_padValue);
            }
            this.m_forenorm = UIManager.getColor("List.foreground");
            this.m_backnorm = UIManager.getColor("List.background");
            this.m_foresel = UIManager.getColor("List.selectionForeground");
            this.m_backsel = UIManager.getColor("List.selectionBackground");
            this.m_lineColor = Color.lightGray;
        }
    }
}

