/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.VectorClone;
import oracle.dss.util.xml.PropertyNode;

public class Utility {
    public static final int START_UNDERLINE = 2;
    public static final int SPACE_UNDERLINE = 2;
    public static final char SC_TRUE = '1';
    public static final char SC_FALSE = '0';

    public static Vector cloneVector(Vector vector) throws CloneNotSupportedException {
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e != null) {
                if (!(e instanceof VectorClone)) continue;
                vector2.addElement(((VectorClone)e).clone());
                continue;
            }
            vector2.addElement(e);
        }
        return vector2;
    }

    public static Hashtable cloneHashtable(Hashtable hashtable) throws CloneNotSupportedException {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            VectorClone vectorClone = (VectorClone)hashtable.get(k);
            hashtable2.put(k, vectorClone.clone());
        }
        return hashtable2;
    }

    public static boolean compareHashtables(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == null && hashtable2 == null) {
            return true;
        }
        if (hashtable == null || hashtable2 == null) {
            return false;
        }
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object v;
            Object k;
            Object k2 = enumeration.nextElement();
            if (!Utility.compareObj(k2, k = enumeration2.nextElement())) {
                return false;
            }
            Object v2 = hashtable.get(k2);
            if (Utility.compareObj(v2, v = hashtable2.get(k))) continue;
            return false;
        }
        return true;
    }

    public static Object[][] arraycopy(Object[][] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int[] nArray = new int[]{objectArray.length, 5};
        Object[][] objectArray2 = (Object[][])Array.newInstance(objectArray.getClass().getComponentType().getComponentType(), nArray);
        Object var3_3 = null;
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = Utility.arraycopy(objectArray[n]);
            ++n;
        }
        return objectArray2;
    }

    public static Object[] arraycopy(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray.length);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static Object[] copyVectorToArray(Vector vector) {
        return Utility.copyVectorToArray(vector, null);
    }

    public static Object[] copyVectorToArray(Vector vector, Class clazz) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        Object object = null;
        while (enumeration.hasMoreElements() && object == null) {
            object = enumeration.nextElement();
        }
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            clazz = object.getClass();
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, vector.size());
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Vector copyArrayToVector(Object[] objectArray) {
        if (objectArray == null) {
            return new Vector();
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    public static boolean compareVectors(Vector vector, Vector vector2) {
        if (vector == vector2) {
            return true;
        }
        if (vector == null || vector2 == null) {
            return false;
        }
        if (vector.size() != vector2.size()) {
            return false;
        }
        Object object = null;
        Object var3_3 = null;
        int n = 0;
        while (n < vector.size()) {
            object = vector.elementAt(n);
            var3_3 = vector2.elementAt(n);
            if (object == null) {
                if (var3_3 != null) {
                    return false;
                }
            } else if (!object.equals(var3_3)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean compareLists(String[] stringArray, String[] stringArray2) {
        if (stringArray == stringArray2) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2].equals(stringArray[n])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            bl = false;
            ++n;
        }
        return true;
    }

    public static boolean compareListsExact(String[] stringArray, String[] stringArray2) {
        if (stringArray == stringArray2) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String[] flattenArray(String[][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += stringArray[n2].length;
            ++n2;
        }
        String[] stringArray2 = new String[n];
        n = 0;
        n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = 0;
            while (n3 < stringArray[n2].length) {
                stringArray2[n++] = stringArray[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return stringArray2;
    }

    public static String arrayToString(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        if (object.getClass().isArray()) {
            String string = "{";
            int n = Array.getLength(object);
            int n2 = 0;
            while (n2 < n - 1) {
                object2 = Array.get(object, n2);
                string = object2.getClass().isArray() ? String.valueOf(string) + Utility.arrayToString(object2) + "," : String.valueOf(string) + object2 + ",";
                ++n2;
            }
            if (n > 0) {
                object2 = Array.get(object, n - 1);
                string = object2.getClass().isArray() ? String.valueOf(string) + Utility.arrayToString(object2) : String.valueOf(string) + object2;
            }
            string = String.valueOf(string) + "}";
            return string;
        }
        return object.toString();
    }

    public static String ObjectToString(Object object) {
        int n = 0;
        String string = new String();
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            int n2 = 0;
            while (n2 < byArray.length) {
                n = byArray[n2];
                if (n < 0) {
                    n += 256;
                } else if (n >= 0 && n < 16) {
                    string = String.valueOf(string) + "0";
                }
                string = String.valueOf(string) + Integer.toHexString(n);
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return string;
    }

    public static Object StringToObject(String string) {
        int n = 0;
        byte[] byArray = new byte[string.length() / 2];
        Object object = null;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = Integer.parseInt(string.substring(n2, n2 + 2), 16);
            Integer n4 = new Integer(n3);
            byArray[n] = n4.byteValue();
            n2 += 2;
            ++n;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return object;
    }

    public static Object instantiateClass(String string, Class[] classArray, Object[] objectArray, ErrorHandler errorHandler) {
        Object var4_4;
        block11: {
            var4_4 = null;
            Class<?> clazz = null;
            if (string != null) {
                block9: {
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (errorHandler == null) break block9;
                        errorHandler.error(classNotFoundException, "Utility", "instantiateClass");
                    }
                }
                if (clazz != null && classArray != null) {
                    Constructor<?> constructor;
                    block10: {
                        constructor = null;
                        try {
                            constructor = clazz.getConstructor(classArray);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (errorHandler == null) break block10;
                            errorHandler.error(noSuchMethodException, "Utility", "instantiateClass");
                        }
                    }
                    if (constructor != null && objectArray != null) {
                        try {
                            var4_4 = constructor.newInstance(objectArray);
                        }
                        catch (Exception exception) {
                            if (errorHandler == null) break block11;
                            errorHandler.error(exception, "Utility", "instantiateClass");
                        }
                    }
                }
            }
        }
        return var4_4;
    }

    public static boolean contains(Vector vector, Vector vector2) {
        if (vector.size() < vector2.size()) {
            return false;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            if (vector.contains(enumeration.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static boolean compareObj(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        if (object2 != null) {
            return object2.equals(object);
        }
        return true;
    }

    public static int compareXMLVersions(String string, String string2) {
        int[] nArray = Utility._convertXMLVersionToIntArray(string);
        int[] nArray2 = Utility._convertXMLVersionToIntArray(string2);
        int n = 0;
        while (n < nArray.length) {
            if (nArray2.length < n + 1) {
                return 1;
            }
            if (nArray[n] < nArray2[n]) {
                return -1;
            }
            if (nArray[n] > nArray2[n]) {
                return 1;
            }
            ++n;
        }
        if (nArray.length == nArray2.length) {
            return 0;
        }
        return -1;
    }

    private static int[] _convertXMLVersionToIntArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = null;
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            Integer n3 = null;
            try {
                n3 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = new Integer(0);
            }
            nArray[n2++] = n3;
        }
        return nArray;
    }

    public static String escapeStateString(String string, char[] cArray, char[] cArray2, char c) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n3 = 0;
        while (n3 < n) {
            char c2 = string.charAt(n3);
            boolean bl = false;
            if (c2 == c) {
                stringBuffer.append(c);
                stringBuffer.append(0);
                bl = true;
            } else {
                int n4 = 0;
                while (n4 < n2) {
                    if (c2 == cArray[n4]) {
                        stringBuffer.append(c);
                        stringBuffer.append(n4 + 1);
                        bl = true;
                        break;
                    }
                    if (cArray2 != null && c2 == cArray2[n4]) {
                        stringBuffer.append(cArray[n4]);
                        bl = true;
                        break;
                    }
                    ++n4;
                }
            }
            if (!bl) {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String unescapeStateString(String string, char[] cArray, char[] cArray2, char c) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = cArray.length;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n);
        while (n3 < n) {
            int n4;
            char c2 = string.charAt(n3);
            if (c2 == c && ++n3 < n) {
                char c3 = string.charAt(n3);
                if (Character.isDigit(c3)) {
                    n4 = Character.digit(c3, 10);
                    if (n4 == 0) {
                        stringBuffer.append(c);
                    } else if (n4 <= n2) {
                        stringBuffer.append(cArray[n4 - 1]);
                    }
                }
            } else {
                n4 = 0;
                if (cArray2 != null) {
                    int n5 = 0;
                    while (n5 < n2) {
                        if (c2 == cArray[n5]) {
                            stringBuffer.append(cArray2[n5]);
                            n4 = 1;
                            break;
                        }
                        ++n5;
                    }
                }
                if (n4 == 0) {
                    stringBuffer.append(c2);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (string == null) {
            return null;
        }
        try {
            clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = Class.forName(string);
        }
        return clazz;
    }

    public static char getBooleanAsChar(boolean bl) {
        return bl ? (char)'1' : '0';
    }

    public static boolean getValueAsBoolean(PropertyNode propertyNode) {
        return propertyNode.getValueAsCharacter() == '1';
    }
}

