/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.ColorPinObj;

public class ColorPinStripeObj {
    private Vector m_Pins = new Vector(2, 3);

    public ColorPinStripeObj() {
        ColorObj colorObj = new ColorObj(0.0, 0.0, 0.0, 1.0);
        ColorObj colorObj2 = new ColorObj(0.0, 0.0, 1.0, 1.0);
        ColorPinObj colorPinObj = new ColorPinObj(0.0, colorObj, colorObj2);
        this.m_Pins.addElement(colorPinObj);
        colorObj = new ColorObj(0.0, 0.0, 0.0, 1.0);
        colorPinObj = new ColorPinObj(1.0, colorObj, colorObj2);
        this.m_Pins.addElement(colorPinObj);
    }

    public void copy(ColorPinStripeObj colorPinStripeObj) {
        this.m_Pins.removeAllElements();
        int n = 0;
        while (n < colorPinStripeObj.m_Pins.size()) {
            ColorPinObj colorPinObj = (ColorPinObj)colorPinStripeObj.m_Pins.elementAt(n);
            ColorPinObj colorPinObj2 = new ColorPinObj();
            colorPinObj2.copy(colorPinObj);
            this.m_Pins.addElement(colorPinObj2);
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorPinStripeObj)) {
            return false;
        }
        ColorPinStripeObj colorPinStripeObj = (ColorPinStripeObj)object;
        boolean bl = this.m_Pins.size() == colorPinStripeObj.m_Pins.size();
        int n = 0;
        while (n < this.m_Pins.size() && bl) {
            ColorPinObj colorPinObj;
            ColorPinObj colorPinObj2 = (ColorPinObj)this.m_Pins.elementAt(n);
            if (!colorPinObj2.equals(colorPinObj = (ColorPinObj)colorPinStripeObj.m_Pins.elementAt(n))) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public int findClosestPin(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new AssertionException(0.0, 1.0, d);
        }
        double d2 = 1.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_Pins.size()) {
            ColorPinObj colorPinObj = (ColorPinObj)this.m_Pins.elementAt(n2);
            if (Math.abs(colorPinObj.getPosition() - d) < d2) {
                d2 = Math.abs(colorPinObj.getPosition() - d);
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public void getColorAt(double d, ColorObj colorObj) {
        if (d < 0.0 || d > 1.0) {
            throw new AssertionException(0.0, 1.0, d);
        }
        d = (double)((int)(100.0 * d)) / 100.0;
        int n = this.m_Pins.size();
        int n2 = 0;
        while (n2 < n - 1) {
            ColorPinObj colorPinObj = (ColorPinObj)this.m_Pins.elementAt(n2);
            ColorPinObj colorPinObj2 = (ColorPinObj)this.m_Pins.elementAt(n2 + 1);
            if (d >= colorPinObj.getPosition() && d <= colorPinObj2.getPosition()) {
                double d2 = (d - colorPinObj.getPosition()) / (colorPinObj2.getPosition() - colorPinObj.getPosition());
                colorObj.setRed(colorPinObj.getRightColor().getRed() + d2 * (colorPinObj2.getLeftColor().getRed() - colorPinObj.getRightColor().getRed()));
                colorObj.setGreen(colorPinObj.getRightColor().getGreen() + d2 * (colorPinObj2.getLeftColor().getGreen() - colorPinObj.getRightColor().getGreen()));
                colorObj.setBlue(colorPinObj.getRightColor().getBlue() + d2 * (colorPinObj2.getLeftColor().getBlue() - colorPinObj.getRightColor().getBlue()));
                colorObj.setAlpha(colorPinObj.getRightColor().getAlpha() + d2 * (colorPinObj2.getLeftColor().getAlpha() - colorPinObj.getRightColor().getAlpha()));
                return;
            }
            ++n2;
        }
        colorObj.setColor(0, 0, 0, 0);
    }

    public void insertPin(double d, ColorObj colorObj, ColorObj colorObj2) {
        if (d < 0.0 || d > 1.0) {
            throw new AssertionException(0.0, 1.0, d);
        }
        int n = this.findClosestPin(d);
        ColorPinObj colorPinObj = (ColorPinObj)this.m_Pins.elementAt(n);
        if (Math.abs(colorPinObj.getPosition() - d) < 0.001) {
            colorPinObj.setColor(colorObj, colorObj2);
        } else {
            ColorPinObj colorPinObj2 = new ColorPinObj(d, colorObj, colorObj2);
            if (colorPinObj.getPosition() > d) {
                this.m_Pins.insertElementAt(colorPinObj2, n);
            } else {
                this.m_Pins.insertElementAt(colorPinObj2, n + 1);
            }
        }
    }
}

