/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.IdentObj;

public class Zoom
implements Serializable {
    protected Perspective m_Perspective;
    protected Point m_ptStartZoomRect;
    protected Rectangle m_OldZoomRect;

    public Zoom(Perspective perspective) {
        this.m_Perspective = perspective;
    }

    public void mouseDraggedZoom(MouseEvent mouseEvent, IdentObj identObj, Graphics graphics) {
        boolean bl;
        Rectangle rectangle = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getFrameRect(false));
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        } else if (point.x > rectangle.x + rectangle.width) {
            point.x = rectangle.x + rectangle.width;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        } else if (point.y > rectangle.y + rectangle.height) {
            point.y = rectangle.y + rectangle.height;
        }
        int n = Math.min(point.x, this.m_ptStartZoomRect.x);
        int n2 = Math.min(point.y, this.m_ptStartZoomRect.y);
        int n3 = Math.abs(point.x - this.m_ptStartZoomRect.x);
        int n4 = Math.abs(point.y - this.m_ptStartZoomRect.y);
        boolean bl2 = this.m_Perspective.getZoomDirection() == 2;
        boolean bl3 = bl = this.m_Perspective.getZoomDirection() == 1;
        if (this.m_Perspective.isChartOrientHorz()) {
            bl2 = this.m_Perspective.getZoomDirection() == 1;
            boolean bl4 = bl = this.m_Perspective.getZoomDirection() == 2;
        }
        if (bl) {
            n2 = rectangle.y;
            n4 = rectangle.height;
        } else if (bl2) {
            n = rectangle.x;
            n3 = rectangle.width;
        }
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        graphics.setXORMode(Color.yellow);
        if (this.m_OldZoomRect != null) {
            graphics.drawRect(this.m_OldZoomRect.x, this.m_OldZoomRect.y, this.m_OldZoomRect.width, this.m_OldZoomRect.height);
        }
        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.setPaintMode();
        this.m_OldZoomRect = new Rectangle(n, n2, n3, n4);
    }

    public void mouseReleasedZoom(MouseEvent mouseEvent, Graphics graphics) {
        graphics.setXORMode(Color.yellow);
        if (this.m_OldZoomRect != null) {
            graphics.drawRect(this.m_OldZoomRect.x, this.m_OldZoomRect.y, this.m_OldZoomRect.width, this.m_OldZoomRect.height);
        }
        graphics.setPaintMode();
        if (this.m_OldZoomRect != null) {
            if (this.m_Perspective.getZoomDirection() == 1) {
                Point point = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getFrameDepthOffset());
            }
            this.m_Perspective.doZoomIn(this.m_Perspective.m_VC.destToVirt(this.m_OldZoomRect));
        } else {
            int n = mouseEvent.getClickCount() > 1 ? 0 : this.m_Perspective.getZoomIndex() - 1;
            this.m_Perspective.setZoomIndex(n);
        }
        this.m_OldZoomRect = null;
    }

    public void eraseZoomRect(Graphics graphics) {
        graphics.setXORMode(Color.yellow);
        if (this.m_OldZoomRect != null) {
            graphics.drawRect(this.m_OldZoomRect.x, this.m_OldZoomRect.y, this.m_OldZoomRect.width, this.m_OldZoomRect.height);
        }
        graphics.setPaintMode();
        this.m_OldZoomRect = null;
    }

    public boolean isRegionZoomable(JChart_Base jChart_Base, Point point) {
        boolean bl = false;
        if (!jChart_Base.m_gt.is3DType()) {
            Rectangle rectangle = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getFrameRect(false));
            bl = rectangle.contains(point);
        }
        return bl;
    }

    public void setStartZoomRectPoint(Point point) {
        this.m_ptStartZoomRect = point;
        this.m_OldZoomRect = null;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

